'
' Copyright (c) 2004
' by Peter Donker ( info@bring2mind.net )
'
' Permission is hereby granted to use and/or modify this software. It is not permitted to publish, distribute, 
' sublicense, and/or sell copies of the software in its original or modified form.
'
' THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED 
' TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
' THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF 
' CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
' DEALINGS IN THE SOFTWARE.
'
Imports DotNetNuke
Imports Bring2mind.DNN.Modules.IWork.Business

Namespace Bring2mind.DNN.Modules.IWork

 Public Class EditInvoice
  Inherits Bring2mind.DNN.Modules.IWork.PortalModulebase

#Region " Web Form Designer Generated Code "

  'This call is required by the Web Form Designer.
  <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()

  End Sub
  Protected WithEvents lblAccountName As System.Web.UI.WebControls.Label
  Protected WithEvents cmdUpdate As System.Web.UI.WebControls.LinkButton
  Protected WithEvents cmdCancel As System.Web.UI.WebControls.LinkButton
  Protected WithEvents cmdDelete As System.Web.UI.WebControls.LinkButton
  Protected WithEvents txtInvoiceCode As System.Web.UI.WebControls.TextBox
  Protected WithEvents Requiredfieldvalidator2 As System.Web.UI.WebControls.RequiredFieldValidator
  Protected WithEvents txtReference As System.Web.UI.WebControls.TextBox
  Protected WithEvents txtSubject As System.Web.UI.WebControls.TextBox
  Protected WithEvents txtCurrency As System.Web.UI.WebControls.TextBox
  Protected WithEvents txtTax As System.Web.UI.WebControls.TextBox
  Protected WithEvents chkPaid As System.Web.UI.WebControls.CheckBox
  Protected WithEvents lblTotal As System.Web.UI.WebControls.Label
  Protected WithEvents dgProducts As System.Web.UI.WebControls.DataGrid
  Protected WithEvents dgTasks As System.Web.UI.WebControls.DataGrid
  Protected WithEvents chkSent As System.Web.UI.WebControls.CheckBox
  Protected WithEvents lblSubTotal As System.Web.UI.WebControls.Label
  Protected WithEvents lblTax As System.Web.UI.WebControls.Label
  Protected WithEvents cmdUnlock As System.Web.UI.WebControls.LinkButton
  Protected WithEvents ddlProject As System.Web.UI.WebControls.DropDownList
  Protected WithEvents CompareValidator1 As System.Web.UI.WebControls.CompareValidator
  Protected WithEvents txtDateSent As System.Web.UI.WebControls.TextBox
  Protected WithEvents valDate2 As System.Web.UI.WebControls.CompareValidator
  Protected WithEvents txtDatePaid As System.Web.UI.WebControls.TextBox
  Protected WithEvents Comparevalidator2 As System.Web.UI.WebControls.CompareValidator
  Protected WithEvents imgDateSent As System.Web.UI.HtmlControls.HtmlImage
  Protected WithEvents imgDatePaid As System.Web.UI.HtmlControls.HtmlImage
  Protected WithEvents trDatePaid As System.Web.UI.HtmlControls.HtmlTableRow
  Protected WithEvents trDateSent As System.Web.UI.HtmlControls.HtmlTableRow

  'NOTE: The following placeholder declaration is required by the Web Form Designer.
  'Do not delete or move it.
  Private designerPlaceholderDeclaration As System.Object

  Private Sub Page_Init(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Init
   'CODEGEN: This method call is required by the Web Form Designer
   'Do not modify it using the code editor.
   InitializeComponent()
  End Sub

#End Region

  Dim InvoiceId As Integer = -1
  Dim AccountId As Integer = -1
  Private objProducts As New ProductsController
  Private objTasks As New TasksController
  Public SelectedTasks As String
  Public SelectedProducts As String
  Private SortProjectId As Integer = 0
  Private HasBeenLocked As Boolean

  Private Sub Page_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
   Dim objInvoices As New InvoicesController
   Dim objInvoice As New InvoicesInfo
   If Not Me.ViewState.Item("SortProjectId") Is Nothing Then
    SortProjectId = Me.ViewState.Item("SortProjectId")
   End If

   If Not (Request.Params("InvoiceId") Is Nothing) Then
    InvoiceId = Int32.Parse(Request.Params("InvoiceId"))
   Else
    InvoiceId = -1
   End If
   If Not (Request.Params("AccountId") Is Nothing) Then
    AccountId = Int32.Parse(Request.Params("AccountId"))
   Else
    AccountId = -1
   End If

   If Not Page.IsPostBack Then
    Dim objAccounts As New AccountsController
    If InvoiceId = -1 Then
     If AccountId = -1 Then
      UI.Skins.Skin.AddModuleMessage(Me, "No ID(s)", "You are trying to access a resource without supplying proper information in the URL.", UI.Skins.Controls.ModuleMessage.ModuleMessageType.YellowWarning)
      Exit Sub
     End If
    Else
     objInvoice = objInvoices.GetInvoices(InvoiceId)
     AccountId = objInvoice.AccountId
    End If

    'security check
    If Not Security.OK2View(AccountId) Then
     UI.Skins.Skin.AddModuleMessage(Me, "Unauthorized", "You are either not logged in correctly, or you do not have access to this resource. Please check your login status", UI.Skins.Controls.ModuleMessage.ModuleMessageType.YellowWarning)
     Exit Sub
    End If
    If Not Security.IsEmployee Then
     UI.Skins.Skin.AddModuleMessage(Me, "Unauthorized", "You are either not logged in correctly, or you do not have access to this resource. Please check your login status", UI.Skins.Controls.ModuleMessage.ModuleMessageType.YellowWarning)
     Exit Sub
    End If

    Dim objProjects As New ProjectsController
    With ddlProject
     .DataSource = objProjects.GetProjectsByAccounts(AccountId, False)
     .DataBind()
     .Items.Insert(0, New ListItem("<All Projects>", 0))
    End With

    imgDateSent.Attributes.Add("onclick", "popUpCalendar(this, " & txtDateSent.ClientID & ",'" & System.Globalization.CultureInfo.CurrentCulture.DateTimeFormat.ShortDatePattern & "');return false;")
    imgDatePaid.Attributes.Add("onclick", "popUpCalendar(this, " & txtDatePaid.ClientID & ",'" & System.Globalization.CultureInfo.CurrentCulture.DateTimeFormat.ShortDatePattern & "');return false;")
    imgDateSent.Src = IWorkPath & "ew_calendar.gif"
    imgDatePaid.Src = IWorkPath & "ew_calendar.gif"
    Dim objAccount As AccountsInfo = objAccounts.GetAccounts(AccountId, PortalId)
    Me.ViewState.Item("AccountId") = AccountId
    lblAccountName.Text = objAccount.AccountName
    Me.ViewState.Item("BillingRate") = objAccount.DefaultTariff
    cmdDelete.Attributes.Add("onClick", "javascript:return confirm('Are You Sure You Wish To Delete This Item ?');")
    If InvoiceId <> -1 Then
     If Not objInvoice Is Nothing Then
      'set screen
      HasBeenLocked = False
      If objInvoice.Sent Then
       txtCurrency.Enabled = False
       txtInvoiceCode.Enabled = False
       txtReference.Enabled = False
       txtSubject.Enabled = False
       txtTax.Enabled = False
       txtDateSent.Enabled = False
       chkSent.Enabled = False
       dgTasks.Enabled = False
       dgProducts.Enabled = False
       ddlProject.Enabled = False
       cmdUnlock.Visible = True
       HasBeenLocked = True
      End If
      txtCurrency.Text = objInvoice.Currency
      txtInvoiceCode.Text = objInvoice.InvoiceCode
      txtReference.Text = objInvoice.Reference
      txtSubject.Text = objInvoice.Subject
      txtTax.Text = objInvoice.VAT.ToString("0.0")
      If objInvoice.Sent Then
       txtDateSent.Text = objInvoice.DateSent.ToShortDateString
       'txtDateSent.Enabled = True
      Else
       trDateSent.Visible = False
       'txtDateSent.Visible = False
       'imgDateSent.Visible = False
      End If
      chkSent.Checked = objInvoice.Sent
      If objInvoice.Paid Then
       txtDatePaid.Text = objInvoice.DatePaid.ToShortDateString
       'txtDatePaid.Enabled = True
      Else
       trDatePaid.Visible = False
       'txtDatePaid.Enabled = False
       'imgDatePaid.Visible = False
      End If
      chkPaid.Checked = objInvoice.Paid
      Me.ViewState.Item("InvoiceId") = objInvoice.InvoiceId
      If Security.IsAdmin Then
       cmdDelete.Visible = True
      End If
     Else ' security violation attempt to access item not related to this Module
      UI.Skins.Skin.AddModuleMessage(Me, "Unauthorized", "You are either not logged in correctly, or you do not have access to this resource. Please check your login status", UI.Skins.Controls.ModuleMessage.ModuleMessageType.YellowWarning)
      Exit Sub
     End If
    Else 'new rec
     txtCurrency.Text = objAccount.DefaultCurrency
     txtTax.Text = "0.0"
     Me.ViewState.Item("InvoiceId") = -1
     trDateSent.Visible = False
     trDatePaid.Visible = False
     'txtDateSent.Enabled = False
     'imgDateSent.Visible = False
     'txtDatePaid.Enabled = False
     'imgDatePaid.Visible = False
    End If
    SetLists(SortProjectId)
    ReadCheckBoxes()
    Me.ViewState("SelectedTasks") = SelectedTasks
    Me.ViewState("SelectedProducts") = SelectedProducts
   Else
    'its a postback: we should preserve the state of the checkboxes
    If dgTasks.Enabled Then
     ReadCheckBoxes()
     Me.ViewState("SelectedTasks") = SelectedTasks
     Me.ViewState("SelectedProducts") = SelectedProducts
    Else
     SelectedTasks = Me.ViewState("SelectedTasks")
     SelectedProducts = Me.ViewState("SelectedProducts")
    End If
    SetLists(SortProjectId)
   End If
   Calculate()
  End Sub

  Private Sub ReadCheckBoxes()
   'if the form was disabled we can't get the checked values
   'If dgTasks.Enabled = False Then
   'HasBeenLocked = True
   'Exit Sub
   'End If
   'read values from form
   SelectedTasks = ""
   SelectedProducts = ""
   Dim dgi As DataGridItem, chkBox As CheckBox
   For Each dgi In dgTasks.Items
    chkBox = CType(dgi.FindControl("chkTask"), CheckBox)
    If chkBox.Checked Then
     SelectedTasks &= "[" & dgTasks.DataKeys(dgi.ItemIndex) & "]"
    End If
   Next
   For Each dgi In dgProducts.Items
    chkBox = CType(dgi.FindControl("chkProduct"), CheckBox)
    If chkBox.Checked Then
     SelectedProducts &= "[" & dgProducts.DataKeys(dgi.ItemIndex) & "]"
    End If
   Next
  End Sub

  Private Sub SetLists(Optional ByVal SortByProject As Integer = 0)
   AccountId = Me.ViewState.Item("AccountId")
   InvoiceId = Me.ViewState.Item("InvoiceId")
   Dim objTasks As New TasksController
   Dim objProducts As New ProductsController
   Dim dvTasks As New DataView(DotNetNuke.Common.Globals.ConvertDataReaderToDataTable(Bring2mind.DNN.Modules.IWork.Data.DataProvider.Instance().GetTasksByAccounts(AccountId, False)))
   If SortByProject = 0 Then
    dvTasks.RowFilter = "(InvoiceId = 0) OR (InvoiceId = " & InvoiceId.ToString & ")"
   Else
    dvTasks.RowFilter = "((InvoiceId = 0) OR (InvoiceId = " & InvoiceId.ToString & ")) AND (ProjectId = " & SortByProject.ToString & ")"
   End If
   dvTasks.Sort = "TaskDate"
   dgTasks.DataSource = dvTasks
   dgTasks.DataKeyField = "TaskId"
   dgTasks.DataBind()
   Dim dvProducts As New DataView(DotNetNuke.Common.Globals.ConvertDataReaderToDataTable(Bring2mind.DNN.Modules.IWork.Data.DataProvider.Instance().GetProductsByAccounts(AccountId, False)))
   If SortByProject = 0 Then
    dvProducts.RowFilter = "(InvoiceId = 0) OR (InvoiceId = " & InvoiceId.ToString & ")"
   Else
    dvProducts.RowFilter = "((InvoiceId = 0) OR (InvoiceId = " & InvoiceId.ToString & ")) AND (ProjectId = " & SortByProject.ToString & ")"
   End If
   dvProducts.Sort = "DateDelivered"
   dgProducts.DataSource = dvProducts
   dgProducts.DataBind()
  End Sub

  Private Sub cmdUpdate_Click(ByVal sender As Object, ByVal e As EventArgs) Handles cmdUpdate.Click
   AccountId = Me.ViewState.Item("AccountId")
   InvoiceId = Me.ViewState.Item("InvoiceId")

   Try
    ' Only Update if the Entered Data is Valid
    If Page.IsValid = True Then
     Dim objInvoice As New InvoicesInfo

     'bind text values to object
     With objInvoice
      'set values
      '      If dgTasks.Enabled Then
      .AccountId = AccountId
      .Currency = txtCurrency.Text
      .InvoiceCode = txtInvoiceCode.Text
      .Sent = chkSent.Checked
      If chkSent.Checked Then
       .DateSent = Convert.ToDateTime(txtDateSent.Text)
      End If
      .InvoiceId = InvoiceId
      .Reference = txtReference.Text
      .Subject = txtSubject.Text
      .Subtotal = CType(lblSubTotal.Text, Single)
      .Total = CType(lblTotal.Text, Single)
      .VAT = CType(txtTax.Text, Single)
      '     End If
      .Paid = chkPaid.Checked
      If chkPaid.Checked Then
       .DatePaid = Convert.ToDateTime(txtDatePaid.Text)
      End If
     End With

     Dim objInvoices As New InvoicesController
     If InvoiceId = -1 Then
      InvoiceId = objInvoices.AddInvoices(objInvoice)
     Else
      objInvoices.UpdateInvoices(objInvoice)
     End If

     'check checked items against data only if form was not locked
     If dgTasks.Enabled Then
      Dim objTasks As New TasksController
      Dim objTask As TasksInfo
      For Each objTask In objTasks.GetTasksByAccounts(AccountId, True)
       If objTask.InvoiceId = 0 Or objTask.InvoiceId = InvoiceId Then
        If InStr(SelectedTasks, "[" & objTask.TaskId.ToString & "]") > 0 Then
         objTask.InvoiceId = InvoiceId
        Else
         objTask.InvoiceId = 0
        End If
        objTasks.UpdateTasks(objTask)
       End If
      Next
      Dim objProducts As New ProductsController
      Dim objProduct As ProductsInfo
      For Each objProduct In objProducts.GetProductsByAccounts(AccountId, True)
       If objProduct.InvoiceId = 0 Or objProduct.InvoiceId = InvoiceId Then
        If InStr(SelectedProducts, "[" & objProduct.ProductsId.ToString & "]") > 0 Then
         objProduct.InvoiceId = InvoiceId
        Else
         objProduct.InvoiceId = 0
        End If
        objProducts.UpdateProducts(objProduct)
       End If
      Next
     End If

     ' Redirect back to the account page
     Response.Redirect(EditUrl("AccountId", AccountId.ToString, "ViewAccount"), True)

    End If
   Catch exc As Exception 'Module failed to load
    DotNetNuke.Services.Exceptions.ProcessModuleLoadException(Me, exc)
   End Try
  End Sub


  Private Sub cmdCancel_Click(ByVal sender As Object, ByVal e As EventArgs) Handles cmdCancel.Click
   Try
    Response.Redirect(DotNetNuke.Common.Globals.NavigateURL(), True)
   Catch exc As Exception 'Module failed to load
    DotNetNuke.Services.Exceptions.ProcessModuleLoadException(Me, exc)
   End Try
  End Sub

  Private Sub cmdDelete_Click(ByVal sender As Object, ByVal e As EventArgs) Handles cmdDelete.Click
   Try
    If Not InvoiceId = -1 Then
     Dim objInvoices As New InvoicesController
     objInvoices.DeleteInvoices(InvoiceId)
    End If

    ' Redirect back to the portal home page
    Response.Redirect(DotNetNuke.Common.Globals.NavigateURL(), True)
   Catch exc As Exception 'Module failed to load
    DotNetNuke.Services.Exceptions.ProcessModuleLoadException(Me, exc)
   End Try
  End Sub

  Public Sub Calculate()
   AccountId = Me.ViewState.Item("AccountId")
   InvoiceId = Me.ViewState.Item("InvoiceId")

   Dim subTotal As Single, Total As Single
   Dim taxRate As Single = 1 + (CType(txtTax.Text, Single) / 100)
   Dim objTasks As New TasksController
   Dim objTask As TasksInfo
   For Each objTask In objTasks.GetTasksByAccounts(AccountId, False)
    If objTask.InvoiceId = 0 Or objTask.InvoiceId = InvoiceId Then
     If InStr(SelectedTasks, "[" & objTask.TaskId.ToString & "]") > 0 Then
      subTotal += objTask.TaskTimeBilled * objTask.Tariff
      'objTask.InvoiceId = InvoiceId
     Else
      'objTask.InvoiceId = 0
     End If
     'objTasks.UpdateTasks(objTask)
    End If
   Next
   Dim objProducts As New ProductsController
   Dim objProduct As ProductsInfo
   For Each objProduct In objProducts.GetProductsByAccounts(AccountId, False)
    If objProduct.InvoiceId = 0 Or objProduct.InvoiceId = InvoiceId Then
     If InStr(SelectedProducts, "[" & objProduct.ProductsId.ToString & "]") > 0 Then
      subTotal += objProduct.PriceSell * objProduct.Quantity
      'objProduct.InvoiceId = InvoiceId
     Else
      'objProduct.InvoiceId = 0
     End If
     'objProducts.UpdateProducts(objProduct)
    End If
   Next

   lblSubTotal.Text = subTotal.ToString("0.00")
   'lblSubTotal.Text = "kiekeboe"
   Total = subTotal * taxRate
   lblTotal.Text = Total.ToString("0.00")
   lblTax.Text = (Total - subTotal).ToString("0.00")
  End Sub

  Private Sub chkPaid_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles chkPaid.CheckedChanged
   Dim chkBox As CheckBox = CType(sender, CheckBox)
   trDatePaid.Visible = chkBox.Checked
   'If chkBox.Checked Then   
   ' txtDatePaid.Enabled = True
   ' imgDatePaid.Visible = True
   'Else
   ' txtDatePaid.Enabled = False
   ' imgDatePaid.Visible = False
   'End If
  End Sub

  Private Sub chkSent_CheckedChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles chkSent.CheckedChanged
   Dim chkBox As CheckBox = CType(sender, CheckBox)
   trDateSent.Visible = chkBox.Checked
   'If chkBox.Checked Then
   ' txtDateSent.Enabled = True
   ' imgDateSent.Visible = True
   'Else
   ' txtDateSent.Enabled = False
   ' imgDateSent.Visible = False
   'End If
  End Sub

  Private Sub txtTax_TextChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles txtTax.TextChanged
   Dim subTotal As Single = CType(lblSubTotal.Text, Single)
   Dim Total As Single
   Dim taxRate As Single = 1 + (CType(txtTax.Text, Single) / 100)
   Total = subTotal * taxRate
   lblTotal.Text = Total.ToString("0.00")
   lblTax.Text = (Total - subTotal).ToString("0.00")
  End Sub

  Private Sub cmdUnlock_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles cmdUnlock.Click
   txtCurrency.Enabled = True
   txtInvoiceCode.Enabled = True
   txtReference.Enabled = True
   txtSubject.Enabled = True
   txtTax.Enabled = True
   txtDateSent.Enabled = True
   chkSent.Enabled = True
   dgTasks.Enabled = True
   dgProducts.Enabled = True
   ddlProject.Visible = True
   cmdUnlock.Visible = False
  End Sub

  Private Sub ddlProject_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles ddlProject.SelectedIndexChanged
   SetLists(ddlProject.SelectedValue)
   Me.ViewState.Item("SortProjectId") = ddlProject.SelectedValue
  End Sub

  Private Sub Page_PreRender(ByVal sender As Object, ByVal e As System.EventArgs) Handles MyBase.PreRender

   If Not Me.Page.IsClientScriptBlockRegistered("PopCalendar") Then
    Dim sr As New IO.StreamReader(Server.MapPath(IWorkPath & "popcalendar.js"))
    Dim CalScript As String = sr.ReadToEnd
    CalScript = CalScript.Replace("[IMAGEDIRECTORY]", IWorkPath)
    sr.Close()
    Page.RegisterClientScriptBlock("PopCalendar", "<script language='javascript'>" & CalScript & "</script>")
   End If

  End Sub
 End Class
End Namespace
