'
' Copyright (c) 2004
' by Peter Donker ( info@bring2mind.net )
'
' Permission is hereby granted to use and/or modify this software. It is not permitted to publish, distribute, 
' sublicense, and/or sell copies of the software in its original or modified form.
'
' THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED 
' TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
' THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF 
' CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
' DEALINGS IN THE SOFTWARE.
'
Imports DotNetNuke
Imports Bring2mind.DNN.Modules.IWork.Business

Namespace Bring2mind.DNN.Modules.IWork

 Public Class ListTasks
  Inherits Bring2mind.DNN.Modules.IWork.PortalModulebase

#Region " Web Form Designer Generated Code "

  'This call is required by the Web Form Designer.
  <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()

  End Sub
  Protected WithEvents lblAccountName As System.Web.UI.WebControls.Label
  Protected WithEvents dgTasks As System.Web.UI.WebControls.DataGrid
  Protected WithEvents hlBack As System.Web.UI.WebControls.HyperLink
  Protected WithEvents pnlTasks As System.Web.UI.WebControls.Panel

  'NOTE: The following placeholder declaration is required by the Web Form Designer.
  'Do not delete or move it.
  Private designerPlaceholderDeclaration As System.Object

  Private Sub Page_Init(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Init
   'CODEGEN: This method call is required by the Web Form Designer
   'Do not modify it using the code editor.
   InitializeComponent()
  End Sub

#End Region

  Dim AccountId As Integer = -1
  Dim ProjectId As Integer = -1
  Public IsAnEmployee As Boolean

  Private Sub Page_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

   ' Determine AccountId
   If Not (Request.Params("AccountId") Is Nothing) Then
    AccountId = Int32.Parse(Request.Params("AccountId"))
   Else
    AccountId = -1
   End If
   ' Determine ProjectId
   If Not (Request.Params("ProjectId") Is Nothing) Then
    ProjectId = Int32.Parse(Request.Params("ProjectId"))
   Else
    ProjectId = -1
   End If

   IsAnEmployee = Security.IsEmployee

   Dim dvTasks As DataView

   If Not Me.IsPostBack Then
    If ProjectId = -1 Then
     If AccountId = -1 Then
      If Security.IsAdmin Then
       lblAccountName.Text = "Services"
       hlBack.Text = "Back"
       hlBack.NavigateUrl = DotNetNuke.Common.Globals.NavigateURL()

       dvTasks = New DataView(DotNetNuke.Common.Globals.ConvertDataReaderToDataTable(Bring2mind.DNN.Modules.IWork.Data.DataProvider.Instance().GetTasksByPortal(PortalId, False)))
      Else
       UI.Skins.Skin.AddModuleMessage(Me, "Unauthorized", "You are either not logged in correctly, or you do not have access to this resource. Please check your login status", UI.Skins.Controls.ModuleMessage.ModuleMessageType.YellowWarning)
       Exit Sub
      End If
     Else 'we have no projectid but an accountid
      If Security.OK2View(AccountId) Then
       Dim objAccounts As New AccountsController
       Dim objAccount As AccountsInfo = objAccounts.GetAccounts(AccountId, PortalId)
       lblAccountName.Text = "Services for " & objAccount.AccountName
       hlBack.Text = "Back to " & objAccount.AccountName & " account"
       hlBack.NavigateUrl = EditUrl("AccountId", AccountId.ToString, "ViewAccount")

       dvTasks = New DataView(DotNetNuke.Common.Globals.ConvertDataReaderToDataTable(Bring2mind.DNN.Modules.IWork.Data.DataProvider.Instance().GetTasksByAccounts(AccountId, False)))
      Else
       UI.Skins.Skin.AddModuleMessage(Me, "Unauthorized", "You are either not logged in correctly, or you do not have access to this resource. Please check your login status", UI.Skins.Controls.ModuleMessage.ModuleMessageType.YellowWarning)
       Exit Sub
      End If
     End If
    Else 'we have a projectid
     Dim objProjects As New ProjectsController
     Dim objProject As ProjectsInfo = objProjects.GetProjects(ProjectId)

     AccountId = objProject.AccountId
     If Security.OK2View(AccountId) Then
      lblAccountName.Text = "Services for " & objProject.ProjectName
      hlBack.Text = "Back to project " & objProject.ProjectName
      hlBack.NavigateUrl = EditUrl("ProjectId", ProjectId.ToString, "ViewProject")

      dvTasks = New DataView(DotNetNuke.Common.Globals.ConvertDataReaderToDataTable(Bring2mind.DNN.Modules.IWork.Data.DataProvider.Instance().GetTasksByProjects(ProjectId, False)))
     Else
      UI.Skins.Skin.AddModuleMessage(Me, "Unauthorized", "You are either not logged in correctly, or you do not have access to this resource. Please check your login status", UI.Skins.Controls.ModuleMessage.ModuleMessageType.YellowWarning)
      Exit Sub
     End If
    End If
    Me.Session.Item("dv") = dvTasks
    BindGrids()
    IsAnEmployee = Security.IsEmployee
   End If
  End Sub

  Private Sub dgTasks_PageIndexChanged(ByVal source As Object, ByVal e As System.Web.UI.WebControls.DataGridPageChangedEventArgs) Handles dgTasks.PageIndexChanged
   dgTasks.CurrentPageIndex = e.NewPageIndex
   BindGrids()
  End Sub

  Private Sub BindGrids()
   Dim dv As DataView = CType(Me.Session.Item("dv"), DataView)
   dv.Sort = "TaskDate DESC"
   dgTasks.DataSource = dv
   dgTasks.DataBind()
  End Sub
 End Class

End Namespace
