'
' Copyright (c) 2004
' by Peter Donker ( info@bring2mind.net )
'
' Permission is hereby granted to use and/or modify this software. It is not permitted to publish, distribute, 
' sublicense, and/or sell copies of the software in its original or modified form.
'
' THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED 
' TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
' THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF 
' CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
' DEALINGS IN THE SOFTWARE.
'
Imports DotNetNuke
Imports DotNetNuke.Entities.Modules.Communications
Imports DotNetNuke.Services.Localization.Localization
Imports Bring2mind.DNN.Modules.IWork.Business

Namespace Bring2mind.DNN.Modules.IWork.Controls

 Public Class Project
  Inherits Bring2mind.DNN.Modules.IWork.PortalModuleBase
  Implements IModuleListener


#Region " Web Form Designer Generated Code "

  'This call is required by the Web Form Designer.
  <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()

  End Sub

  'NOTE: The following placeholder declaration is required by the Web Form Designer.
  'Do not delete or move it.
  Private designerPlaceholderDeclaration As System.Object

  Private Sub Page_Init(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Init
   'CODEGEN: This method call is required by the Web Form Designer
   'Do not modify it using the code editor.
   InitializeComponent()
   MyInitialize()
  End Sub

#End Region

#Region " Controls "
  Protected WithEvents lblSelectFirst As System.Web.UI.WebControls.Label
  Protected WithEvents lblProjectsTitle As System.Web.UI.WebControls.Label
  Protected WithEvents dgProjects As System.Web.UI.WebControls.DataGrid
  Protected WithEvents pnlProjects As System.Web.UI.WebControls.Panel
  Protected WithEvents cmdEdit As System.Web.UI.WebControls.HyperLink
  Protected WithEvents pnlProject As System.Web.UI.WebControls.Panel
  Protected WithEvents lblProjectName As System.Web.UI.WebControls.Label
  Protected WithEvents lblProjectTypeTitle As System.Web.UI.WebControls.Label
  Protected WithEvents lblProjectType As System.Web.UI.WebControls.Label
  Protected WithEvents lblDescriptionTitle As System.Web.UI.WebControls.Label
  Protected WithEvents lblDescription As System.Web.UI.WebControls.Label
#End Region

#Region " Page Events "
  Public Sub OnModuleCommunication(ByVal s As Object, ByVal e As DotNetNuke.Entities.Modules.Communications.ModuleCommunicationEventArgs) Implements DotNetNuke.Entities.Modules.Communications.IModuleListener.OnModuleCommunication

   If e.Target = "IWork" And e.Type = "Query" Then
    Me.Query = e.Value
   End If

  End Sub

  Private Sub MyInitialize()

  End Sub

  Private Sub Page_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

   If Not Page.IsPostBack Then

    If Me.Query.AccountId < 0 Then
     lblSelectFirst.Visible = True
     pnlProjects.Visible = False
     pnlProject.Visible = False
    Else
     If Me.Query.ProjectId < 0 Then
      pnlProject.Visible = False
      pnlProjects.Visible = True
      Dim objProjects As New ProjectsController
      dgProjects.DataSource = objProjects.GetProjectsByAccounts(Me.Query.AccountId, False)
      dgProjects.DataBind()
     Else
      pnlProject.Visible = False
      pnlProjects.Visible = True
      With Me.Query.RequestedProject
       lblProjectName.Text = .ProjectName
       lblProjectType.Text = .ProjectType
       lblDescription.Text = .Description
      End With
      cmdEdit.NavigateUrl = Me.Query.IWorkUrl(TabId, "EditProject", Me.Query.AccountId, Me.Query.ProjectId)
     End If
    End If

   End If

  End Sub

#End Region

 End Class

End Namespace
