'
' Copyright (c) 2004
' by Peter Donker ( info@bring2mind.net )
'
' Permission is hereby granted to use and/or modify this software. It is not permitted to publish, distribute, 
' sublicense, and/or sell copies of the software in its original or modified form.
'
' THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED 
' TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
' THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF 
' CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
' DEALINGS IN THE SOFTWARE.
'
Imports DotNetNuke
Imports Bring2mind.DNN.Modules.IWork.Business

Namespace Bring2mind.DNN.Modules.IWork

 Public Class ViewIssue
  Inherits Bring2mind.DNN.Modules.IWork.PortalModulebase

#Region " Web Form Designer Generated Code "

  'This call is required by the Web Form Designer.
  <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()

  End Sub
  Protected WithEvents lblHeading As System.Web.UI.WebControls.Label
  Protected WithEvents lblIssueHeading As System.Web.UI.WebControls.Label
  Protected WithEvents lblDate As System.Web.UI.WebControls.Label
  Protected WithEvents lblUrgency As System.Web.UI.WebControls.Label
  Protected WithEvents lblStatus As System.Web.UI.WebControls.Label
  Protected WithEvents lblDiscourse As System.Web.UI.WebControls.Label
  Protected WithEvents txtDiscourse As System.Web.UI.WebControls.TextBox
  Protected WithEvents cmdAdd As System.Web.UI.WebControls.LinkButton
  Protected WithEvents hlEdit As System.Web.UI.WebControls.HyperLink
  Protected WithEvents hlBack As System.Web.UI.WebControls.HyperLink
  Protected WithEvents pnlIssue As System.Web.UI.WebControls.Panel

  'NOTE: The following placeholder declaration is required by the Web Form Designer.
  'Do not delete or move it.
  Private designerPlaceholderDeclaration As System.Object

  Private Sub Page_Init(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Init
   'CODEGEN: This method call is required by the Web Form Designer
   'Do not modify it using the code editor.
   InitializeComponent()
  End Sub

#End Region

  Dim IssueId As Integer = -1
  Public IsAnEmployee As Boolean

  Private Sub Page_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

   If Not (Request.Params("IssueId") Is Nothing) Then
    IssueId = Int32.Parse(Request.Params("IssueId"))
   Else
    UI.Skins.Skin.AddModuleMessage(Me, "No ID(s)", "You are trying to access a resource without supplying proper information in the URL.", UI.Skins.Controls.ModuleMessage.ModuleMessageType.YellowWarning)
    Exit Sub
   End If

   Dim objIssues As New IssuesController
   Dim objIssue As IssuesInfo = objIssues.GetIssues(IssueId)
   Dim objProjects As New ProjectsController
   Dim objProject As New ProjectsInfo
   objProject = objProjects.GetProjects(objIssue.ProjectId)
   If Not Security.OK2View(objProject.AccountId) Then
    UI.Skins.Skin.AddModuleMessage(Me, "Unauthorized", "You are either not logged in correctly, or you do not have access to this resource. Please check your login status", UI.Skins.Controls.ModuleMessage.ModuleMessageType.YellowWarning)
    Exit Sub
   End If
   If Security.IsEmployee Then
    IsAnEmployee = True
    hlEdit.Visible = True
   Else
    IsAnEmployee = False
    hlEdit.Visible = False
   End If

   hlEdit.NavigateUrl = EditUrl("IssueId", IssueId.ToString, "EditIssue")
   hlBack.NavigateUrl = EditUrl("ProjectId", objIssue.ProjectId.ToString, "ViewProject")
   lblHeading.Text = objProject.ProjectName
   With objIssue
    lblIssueHeading.Text = .IssueHeading
    lblDate.Text = .IssueDate.ToString("MMM-dd")
    lblUrgency.Text = .IssueUrgency
    lblStatus.Text = IIf(.Resolved, "Resolved at " & .ResolvedDate.ToString("MMM-dd"), "Unresolved")
    lblDiscourse.Text = Replace(.Discourse, vbCrLf, "<br/>")
   End With
  End Sub

  Private Sub cmdAdd_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles cmdAdd.Click
   If txtDiscourse.Text = "" Then Exit Sub
   Dim objIssues As New IssuesController
   Dim objIssue As IssuesInfo = objIssues.GetIssues(IssueId)
   If objIssue Is Nothing Then
    Exit Sub
   End If
   'Dim objUsers As New UserController
   'Dim cu As UserInfo = objUsers.GetUser(PortalId, UserInfo.UserId)
   objIssue.Discourse &= vbCrLf & "<strong>" & UserInfo.FullName & " (" & Now.ToString("MMM-dd") & ")</strong>" & vbCrLf
   objIssue.Discourse &= txtDiscourse.Text & vbCrLf
   objIssues.UpdateIssues(objIssue)
   lblDiscourse.Text = Replace(objIssue.Discourse, vbCrLf, "<br/>")
   txtDiscourse.Text = ""
  End Sub
 End Class

End Namespace
