'
' Copyright (c) 2004
' by Peter Donker ( info@bring2mind.net )
'
' Permission is hereby granted to use and/or modify this software. It is not permitted to publish, distribute, 
' sublicense, and/or sell copies of the software in its original or modified form.
'
' THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED 
' TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
' THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF 
' CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
' DEALINGS IN THE SOFTWARE.
'
Imports DotNetNuke
Imports Bring2mind.DNN.Modules.IWork.Business

Namespace Bring2mind.DNN.Modules.IWork
 Public Module IWorkGlobals

  Public Function GetAString(ByVal aPossibleString As Object) As String
   If aPossibleString Is Nothing Then
    Return ""
   Else
    If aPossibleString Is DBNull.Value Then
     Return ""
    Else
     Return CType(aPossibleString, String)
    End If
   End If
  End Function

  Public Function GetADate(ByVal aPossibleDate As Object) As Date
   If aPossibleDate Is Nothing Then
    Return Now
   Else
    If aPossibleDate Is DBNull.Value Then
     Return Now
    Else
     Return CType(aPossibleDate, Date)
    End If
   End If
  End Function

  Public Function GetABoolean(ByVal aPossibleBoolean As Object) As Boolean
   If aPossibleBoolean Is Nothing Or aPossibleBoolean Is DBNull.Value Then
    Return False
   Else
    Return CType(aPossibleBoolean, Boolean)
   End If
  End Function

  Public Sub RecalcInvoice(ByVal InvoiceId)
   Dim Amount As Single = 0
   Dim objInvoices As New InvoicesController
   Dim objInvoice As InvoicesInfo = objInvoices.GetInvoices(InvoiceId)
   If objInvoice Is Nothing Then Exit Sub
   Dim objTasks As New TasksController
   Dim objTask As TasksInfo
   For Each objTask In objTasks.GetTasksByInvoices(InvoiceId, True)
    Amount += objTask.Tariff * objTask.TaskTimeBilled
   Next
   Dim objProducts As New ProductsController
   Dim objProduct As ProductsInfo
   For Each objProduct In objProducts.GetProductsByInvoices(InvoiceId, True)
    Amount += objProduct.Quantity * objProduct.PriceSell
   Next
   objInvoice.Subtotal = Amount
   Amount = Amount * (1 + (objInvoice.VAT / 100))
   objInvoice.Total = Amount
   objInvoices.UpdateInvoices(objInvoice)
  End Sub

  Public Function IsClientOfProject(ByVal ProjectId As Integer, ByVal PortalId As Integer, ByVal UserId As Integer) As Boolean

   Dim objProjects As New ProjectsController
   Dim objProject As ProjectsInfo = objProjects.GetProjects(ProjectId)
   If objProject Is Nothing Then Return False
   Dim ObjAccounts As New AccountsController
   Dim objAccount As AccountsInfo = ObjAccounts.GetAccounts(objProject.AccountId, PortalId)
   If objAccount Is Nothing Then Return False
   If objAccount.UserId = UserId Then 'regular client
    Return True
   ElseIf objAccount.BilledThrough > 0 Then
    Dim oA As AccountsInfo = ObjAccounts.GetAccounts(objAccount.BilledThrough, PortalId)
    If oA.UserId = UserId Then 'superclient
     Return True
    Else 'wrong client
     Return False
    End If
   Else 'wrong client
    Return False
   End If

  End Function
 End Module
End Namespace