﻿Imports System.Xml.Xsl

Public Class SimpleDownloadsSettings

#Region " Private Members "
 Private _moduleId As Integer = -1
 Private _filePath As String = ""
 Private _fileTypes As String = ""
 Private _allowOutside As Boolean = False
 Private _allowAllTypes As Boolean = False
#End Region

#Region " Constructors "
 Public Sub New(ByVal ModuleId As Integer)

  _moduleId = ModuleId

  Dim mc As New DotNetNuke.Entities.Modules.ModuleController
  Dim Settings As Hashtable = mc.GetModuleSettings(_moduleId)

  If Not Settings.Item("FilePath") Is Nothing Then
   FilePath = CType(Settings.Item("FilePath"), String)
  End If

  If Not Settings.Item("FileTypes") Is Nothing Then
   FileTypes = CType(Settings.Item("FileTypes"), String)
  End If

  If Not Settings.Item("AllowOutside") Is Nothing Then
   AllowOutside = CType(Settings.Item("AllowOutside"), Boolean)
  End If

  If Not Settings.Item("AllowAllTypes") Is Nothing Then
   AllowAllTypes = CType(Settings.Item("AllowAllTypes"), Boolean)
  End If

 End Sub
#End Region

#Region " Public Members "
 Public Sub SaveSettings()

  Dim objModules As New DotNetNuke.Entities.Modules.ModuleController
  objModules.UpdateModuleSetting(_moduleId, "FilePath", Me.FilePath)
  objModules.UpdateModuleSetting(_moduleId, "FileTypes", Me.FileTypes)
  objModules.UpdateModuleSetting(_moduleId, "AllowOutside", Me.AllowOutside.ToString)
  objModules.UpdateModuleSetting(_moduleId, "AllowAllTypes", Me.AllowAllTypes.ToString)

 End Sub
#End Region

#Region " Properties "
 Public Property FilePath() As String
  Get
   Return _filePath
  End Get
  Set(ByVal value As String)
   _filePath = value
  End Set
 End Property

 Public Property FileTypes() As String
  Get
   Return _fileTypes
  End Get
  Set(ByVal value As String)
   _fileTypes = value
  End Set
 End Property

 Public Property AllowOutside() As Boolean
  Get
   Return _allowOutside
  End Get
  Set(ByVal value As Boolean)
   _allowOutside = value
  End Set
 End Property

 Public Property AllowAllTypes() As Boolean
  Get
   Return _allowAllTypes
  End Get
  Set(ByVal value As Boolean)
   _allowAllTypes = value
  End Set
 End Property
#End Region

End Class
