﻿Imports DotNetNuke.Entities.Modules

Partial Public Class Download
 Inherits DotNetNuke.Framework.PageBase

 Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load

  Dim moduleId As Integer = Integer.Parse(Request.Params("mid"))
  Dim tabId As Integer = Integer.Parse(Request.Params("tabid"))
  Dim filePath As String = Request.Params("file")

  Dim canView As Boolean = False
  Dim dlModule As ModuleInfo = (New ModuleController).GetModule(moduleId, tabId, False)
  If dlModule.InheritViewPermissions Then
   canView = DotNetNuke.Security.Permissions.TabPermissionController.HasTabPermission("VIEW")
  Else
   canView = DotNetNuke.Security.Permissions.ModulePermissionController.HasModulePermission(DotNetNuke.Security.Permissions.ModulePermissionController.GetModulePermissions(moduleId, tabId), "VIEW")
  End If

  If Not canView Then
   Throw New Exception("No access to this resource. Check your login status.")
   Exit Sub
  End If

  Dim settings As New SimpleDownloadsSettings(moduleId)
  Dim srcPath As String = IO.Path.Combine(settings.FilePath, filePath)
  Dim fileName As String = IO.Path.GetFileName(srcPath)

  Dim mimeType As String = "application/unknown"
  Dim ext As String = IO.Path.GetExtension(srcPath)
  Try
   Dim regKey As Microsoft.Win32.RegistryKey = Microsoft.Win32.Registry.ClassesRoot.OpenSubKey(ext)
   If regKey IsNot Nothing And regKey.GetValue("Content Type") IsNot Nothing Then
    mimeType = regKey.GetValue("Content Type").ToString()
   End If
  Catch ex As Exception
  End Try

  If Request.Browser.Browser = "IE" Then
   Me.Response.AppendHeader("Content-Disposition", "attachment; filename=""" & Server.UrlEncode(fileName).Replace("+", "%20") & """")
  Else
   Me.Response.AppendHeader("Content-Disposition", "attachment; filename=""" & fileName & """")
  End If
  Me.Response.ContentType = mimeType

  Using src As New System.IO.FileStream(srcPath, System.IO.FileMode.Open, IO.FileAccess.Read, IO.FileShare.Delete)
   Const iBufferSize As Integer = 25000
   Dim bBuffer(iBufferSize) As Byte
   Dim iLengthOfReadChunk As Int32
   Do
    iLengthOfReadChunk = src.Read(bBuffer, 0, iBufferSize)
    Me.Response.OutputStream.Write(bBuffer, 0, iLengthOfReadChunk)
    If iLengthOfReadChunk < iBufferSize Then Exit Do
   Loop
  End Using

 End Sub

End Class