﻿Imports DotNetNuke.Services.Localization.Localization

Partial Public Class Settings
 Inherits DotNetNuke.Entities.Modules.ModuleSettingsBase

#Region " Event Handlers "
 Private Sub cmdTest_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles cmdTest.Click
  Try
   Dim d As New IO.DirectoryInfo(txtFilePath.Text.Trim)
   For Each f As IO.FileInfo In d.GetFiles("*.*")
    Dim lwt As Date = f.LastWriteTime
   Next
  Catch ex As Exception
   lblTest.Text = ex.Message
   Exit Sub
  End Try
  lblTest.Text = String.Format(GetString("Success", Me.LocalResourceFile), txtFilePath.Text)
 End Sub
#End Region

#Region " Overrides "
 Public Overrides Sub LoadSettings()

  Dim m As New SimpleDownloadsSettings(ModuleId)
  txtFilePath.Text = m.FilePath
  txtFileTypes.Text = m.FileTypes
  chkAllowOutside.Checked = m.AllowOutside
  chkAllowAllTypes.Checked = m.AllowAllTypes
  tblHost.Visible = Me.UserInfo.IsSuperUser

 End Sub

 Public Overrides Sub UpdateSettings()

  Dim m As New SimpleDownloadsSettings(ModuleId)
  m.FilePath = txtFilePath.Text.Trim
  m.FileTypes = txtFileTypes.Text.Trim.Replace(",", ";")
  If Me.UserInfo.IsSuperUser Then
   m.AllowOutside = chkAllowOutside.Checked
   m.AllowAllTypes = chkAllowAllTypes.Checked
  End If
  m.SaveSettings()
  Me.Cache.Remove("Settings4Module" & ModuleId.ToString)

 End Sub
#End Region

End Class