'
' Copyright (c) 2004-2005
' by Peter Donker ( info@bring2mind.net )
'
' Permission is hereby granted to use and/or modify this software for a single server. It is 
' NOT permitted to publish, distribute, sublicense, and/or sell copies of this software in its
' original or modified form. You are not allowed to remove this copyright notice. Please read the
' enclosed EULA for further details.
'
' THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING 
' BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
' NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
' DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
' OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OF THE SOFTWARE.
'
Public Class ModuleSettings

#Region " Private Members "
 Private _ModuleId As Integer = -1
 Private _QuestionnaireFile As String = ""
 Private _AllowMultiple As Boolean = False
 Private _SendResults As Boolean = False
 Private _SaveResults As Boolean = False
 Private _DestinationEmail As String = ""
 Private _SendAsXml As Boolean = False
 Private _SendAsAttachment As Boolean = False
 Private _ProcessingInstructions As String = ""
 Private _ResultsPublic As Boolean = False
 Private _ListXslt As String = ""
 Private _UploadPath As String = ""
 Private _UploadMapPath As String = ""
 Private _ResultsPath As String = ""
 Private _ResultsMapPath As String = ""
 Private _QuestionnaireFileFullName As String = ""
#End Region

#Region " Constructors "
 Friend Sub New(ByVal ModuleId As Integer)

  _ModuleId = ModuleId
  Dim mc As New DotNetNuke.Entities.Modules.ModuleController
  Dim mi As DotNetNuke.Entities.Modules.ModuleInfo = mc.GetModule(_ModuleId, -1)
  Dim Settings As Hashtable = mc.GetModuleSettings(_ModuleId)

  If Not Settings.Item("QuestionnaireFile") Is Nothing Then
   QuestionnaireFile = CType(Settings.Item("QuestionnaireFile"), String)
  End If

  If Not Settings.Item("AllowMultiple") Is Nothing Then
   AllowMultiple = CType(Settings.Item("AllowMultiple"), Boolean)
  End If

  If Not Settings.Item("SendResults") Is Nothing Then
   SendResults = CType(Settings.Item("SendResults"), Boolean)
  End If

  If Not Settings.Item("SaveResults") Is Nothing Then
   SaveResults = CType(Settings.Item("SaveResults"), Boolean)
  End If

  If Not Settings.Item("DestinationEmail") Is Nothing Then
   DestinationEmail = CType(Settings.Item("DestinationEmail"), String)
  End If

  If Not Settings.Item("SendAsXml") Is Nothing Then
   SendAsXml = CType(Settings.Item("SendAsXml"), Boolean)
  End If

  If Not Settings.Item("SendAsAttachment") Is Nothing Then
   SendAsAttachment = CType(Settings.Item("SendAsAttachment"), Boolean)
  End If

  If Not Settings.Item("ProcessingInstructions") Is Nothing Then
   ProcessingInstructions = CType(Settings.Item("ProcessingInstructions"), String)
  End If

  If Not Settings.Item("ResultsPublic") Is Nothing Then
   ResultsPublic = CType(Settings.Item("ResultsPublic"), Boolean)
  End If

  If Not Settings.Item("ListXslt") Is Nothing Then
   ListXslt = CType(Settings.Item("ListXslt"), String)
  End If

  'Dim ps As DotNetNuke.Entities.Portals.PortalSettings = DotNetNuke.Entities.Portals.PortalController.GetCurrentPortalSettings
  Dim pc As New DotNetNuke.Entities.Portals.PortalController
  Dim ps As DotNetNuke.Entities.Portals.PortalInfo = pc.GetPortal(mi.PortalID)

  '#If DEBUG Then
  '   Globals.SimpleLog("Module: " & ModuleId.ToString, "Portal " & mi.PortalID.ToString, "AppMapPath: " & DotNetNuke.Common.ApplicationMapPath, "HomeDir: " & ps.HomeDirectory)
  '#End If

  '_UploadMapPath = ps.HomeDirectoryMapPath & "Questionnaires\"
  _UploadMapPath = DotNetNuke.Common.ApplicationMapPath & "\" & ps.HomeDirectory.Replace("/", "\") & "\Questionnaires\"
  _UploadPath = DotNetNuke.Common.ResolveUrl("~/" & ps.HomeDirectory & "/Questionnaires/")
  If Not IO.Directory.Exists(_UploadMapPath) Then
   IO.Directory.CreateDirectory(_UploadMapPath)
  End If
  _ResultsPath = _UploadPath & "Results/"
  _ResultsMapPath = _UploadMapPath & "Results\"
  If Not IO.Directory.Exists(_ResultsMapPath) Then
   IO.Directory.CreateDirectory(_ResultsMapPath)
  End If
  _QuestionnaireFileFullName = _UploadMapPath & QuestionnaireFile

 End Sub
#End Region

#Region " Public Members "
 Friend Sub SaveSettings()

  Dim objModules As New DotNetNuke.Entities.Modules.ModuleController
  objModules.UpdateModuleSetting(_ModuleId, "QuestionnaireFile", Me.QuestionnaireFile.ToString)
  objModules.UpdateModuleSetting(_ModuleId, "AllowMultiple", Me.AllowMultiple.ToString)
  objModules.UpdateModuleSetting(_ModuleId, "SendResults", Me.SendResults.ToString)
  objModules.UpdateModuleSetting(_ModuleId, "SaveResults", Me.SaveResults.ToString)
  objModules.UpdateModuleSetting(_ModuleId, "DestinationEmail", Me.DestinationEmail.ToString)
  objModules.UpdateModuleSetting(_ModuleId, "SendAsXml", Me.SendAsXml.ToString)
  objModules.UpdateModuleSetting(_ModuleId, "SendAsAttachment", Me.SendAsAttachment.ToString)
  objModules.UpdateModuleSetting(_ModuleId, "ProcessingInstructions", Me.ProcessingInstructions.ToString)
  objModules.UpdateModuleSetting(_ModuleId, "ResultsPublic", Me.ResultsPublic.ToString)
  objModules.UpdateModuleSetting(_ModuleId, "ListXslt", Me.ListXslt.ToString)

 End Sub

 Public Function ResultsFile(ByRef OurQuestionnaire As QuestionnaireTemplate.questionnaireRow, ByVal MapPath As Boolean) As String
  If OurQuestionnaire.questionnaireid.IndexOf("-") > 0 AndAlso IsNumeric(Left(OurQuestionnaire.questionnaireid, OurQuestionnaire.questionnaireid.IndexOf("-"))) Then
   If MapPath Then
    Return ResultsMapPath & OurQuestionnaire.questionnaireid & ".resources"
   Else
    Return ResultsPath & OurQuestionnaire.questionnaireid & ".resources"
   End If
  Else
   If MapPath Then
    Return ResultsMapPath & _ModuleId.ToString & "-" & OurQuestionnaire.questionnaireid & ".resources"
   Else
    Return ResultsPath & _ModuleId.ToString & "-" & OurQuestionnaire.questionnaireid & ".resources"
   End If
  End If
 End Function
#End Region

#Region " Properties "
 Public Property QuestionnaireFile() As String
  Get
   Return _QuestionnaireFile
  End Get
  Set(ByVal Value As String)
   _QuestionnaireFile = Value
  End Set
 End Property

 Public Property AllowMultiple() As Boolean
  Get
   Return _AllowMultiple
  End Get
  Set(ByVal Value As Boolean)
   _AllowMultiple = Value
  End Set
 End Property

 Public Property SendResults() As Boolean
  Get
   Return _SendResults
  End Get
  Set(ByVal Value As Boolean)
   _SendResults = Value
  End Set
 End Property

 Public Property SaveResults() As Boolean
  Get
   Return _SaveResults
  End Get
  Set(ByVal Value As Boolean)
   _SaveResults = Value
  End Set
 End Property

 Public Property DestinationEmail() As String
  Get
   Return _DestinationEmail
  End Get
  Set(ByVal Value As String)
   _DestinationEmail = Value
  End Set
 End Property

 Public Property SendAsXml() As Boolean
  Get
   Return _SendAsXml
  End Get
  Set(ByVal Value As Boolean)
   _SendAsXml = Value
  End Set
 End Property

 Public Property SendAsAttachment() As Boolean
  Get
   Return _SendAsAttachment
  End Get
  Set(ByVal Value As Boolean)
   _SendAsAttachment = Value
  End Set
 End Property

 Public Property ProcessingInstructions() As String
  Get
   Return _ProcessingInstructions
  End Get
  Set(ByVal Value As String)
   _ProcessingInstructions = Value
  End Set
 End Property

 Public Property ResultsPublic() As Boolean
  Get
   Return _ResultsPublic
  End Get
  Set(ByVal Value As Boolean)
   _ResultsPublic = Value
  End Set
 End Property

 Public Property ListXslt() As String
  Get
   Return _ListXslt
  End Get
  Set(ByVal Value As String)
   _ListXslt = Value
  End Set
 End Property

 Friend ReadOnly Property UploadPath() As String
  Get
   Return _UploadPath
  End Get
 End Property

 Friend ReadOnly Property UploadMapPath() As String
  Get
   Return _UploadMapPath
  End Get
 End Property

 Friend ReadOnly Property ResultsPath() As String
  Get
   Return _ResultsPath
  End Get
 End Property

 Friend ReadOnly Property ResultsMapPath() As String
  Get
   Return _ResultsMapPath
  End Get
 End Property

 Friend ReadOnly Property QuestionnaireFileFullName() As String
  Get
   Return _QuestionnaireFileFullName
  End Get
 End Property

#End Region

End Class
