Imports System
Imports System.Data
Imports System.Xml
Imports System.Xml.Xsl
Imports DotNetNuke
Imports DotNetNuke.Services.Search

Public Class ModuleController
 Implements Entities.Modules.ISearchable
 Private Const MAX_DESCRIPTION_LENGTH As Integer = 100

#Region " Optional Interfaces: Search "
 Public Function GetSearchItems(ByVal ModInfo As DotNetNuke.Entities.Modules.ModuleInfo) As DotNetNuke.Services.Search.SearchItemInfoCollection Implements DotNetNuke.Entities.Modules.ISearchable.GetSearchItems

  Dim sic As New SearchItemInfoCollection

  Dim settings As New ModuleSettings(ModInfo.ModuleID)
  If Not settings.ResultsPublic Then
   Return sic
  End If

  Dim _questionnaire As New QuestionnaireTemplate
  _questionnaire.ReadXml(settings.QuestionnaireFileFullName, XmlReadMode.InferSchema)

  Dim _xmlResults As New XmlDocument
  _xmlResults.Load(settings.ResultsFile(_questionnaire.questionnaire.Rows(0), True))

  Dim q As QuestionnaireTemplate.questionRow
  For Each q In _questionnaire.question.Rows
   If Globals.GetABoolean(q.searchable) Then
    For Each xResponse As XmlNode In _xmlResults.DocumentElement.GetElementsByTagName("response")
     Dim content As String = xResponse.SelectSingleNode(q.id).InnerText
     Dim strDescription As String = DotNetNuke.Common.Utilities.HtmlUtils.Shorten(content, MAX_DESCRIPTION_LENGTH, "...")
     Dim si As New SearchItemInfo(ModInfo.ModuleTitle, strDescription, Nothing, Date.Parse(xResponse.SelectSingleNode("q_datetime").InnerText), ModInfo.ModuleID, Nothing, content, "DetailId=" & xResponse.SelectSingleNode("response_id").InnerText)
     sic.Add(si)
    Next
   End If
  Next

  Return sic

 End Function
#End Region

End Class
