﻿Imports DotNetNuke.Services.Exceptions

Imports Bring2mind.DNN.Modules.WebRequester.Business
Imports System.Net

Public Class Processor
 Inherits DotNetNuke.Services.Scheduling.SchedulerClient

 Public Sub New(ByVal objScheduleHistoryItem As DotNetNuke.Services.Scheduling.ScheduleHistoryItem)
  MyBase.new()
  Me.ScheduleHistoryItem = objScheduleHistoryItem
 End Sub

 Public Overrides Sub DoWork()

  Try

   Me.Progressing() ' Start

   Dim report As New StringBuilder

   Dim lastRuntime As Date = ModuleController.GetLastTime
   Dim newRuntime As Date = Now
   If lastRuntime = Date.MinValue Then
    Me.ScheduleHistoryItem.AddLogNote("First Run")
    Me.ScheduleHistoryItem.Succeeded = True
    Exit Sub
   End If

   Using ir As IDataReader = Data.DataProvider.Instance.GetModuleInstances("Bring2mind\WebRequester")
    Do While ir.Read
     Dim ModuleId As Integer = CInt(ir.Item("ModuleId"))
     Dim sp As New SqlProcessor
     sp.Parameters.Add("moduleid", ModuleId.ToString)
     sp.Parameters.Add("portalid", CInt(ir.Item("PortalId")).ToString)
     ' 2001-01-01 10:10:10
     sp.Parameters.Add("starttime", Left(lastRuntime.ToString("u"), 19))
     sp.Parameters.Add("endtime", Left(newRuntime.ToString("u"), 19))
     For Each wr As WebRequestInfo In WebRequestsController.GetWebRequestsByModule(ModuleId)
      Try
       Dim GoHead As Boolean = True
       Globals.SimpleLog("Running Request " & wr.WebRequestID.ToString)
       If wr.ConditionSQL.Trim <> "" Then
        Dim res As Integer = CInt(ModuleController.GetScalar(sp.ParametrizeCode(wr.ConditionSQL)))
        If res < 1 Then
         GoHead = False
        End If
        Globals.SimpleLog("Condition SQL returned " & res.ToString)
       End If
       If GoHead Then
        Dim sql As String = sp.ParametrizeCode(wr.RequestSQL)
        Globals.SimpleLog("Running " & sql.ToString)
        Dim dt As DataTable = ModuleController.GetRowSet(sql)
        Dim iCols As Integer = dt.Columns.Count
        For Each dr As DataRow In dt.Rows
         Dim url As String = ""
         Select Case iCols
          Case 1
           url = String.Format(wr.RequestUrl, dr.Item(0))
          Case 2
           url = String.Format(wr.RequestUrl, dr.Item(0), dr.Item(1))
          Case 3
           url = String.Format(wr.RequestUrl, dr.Item(0), dr.Item(1), dr.Item(2))
          Case 4
           url = String.Format(wr.RequestUrl, dr.Item(0), dr.Item(1), dr.Item(2), dr.Item(3))
          Case 5
           url = String.Format(wr.RequestUrl, dr.Item(0), dr.Item(1), dr.Item(2), dr.Item(3), dr.Item(4))
          Case 6
           url = String.Format(wr.RequestUrl, dr.Item(0), dr.Item(1), dr.Item(2), dr.Item(3), dr.Item(4), dr.Item(5))
          Case 7
           url = String.Format(wr.RequestUrl, dr.Item(0), dr.Item(1), dr.Item(2), dr.Item(3), dr.Item(4), dr.Item(5), dr.Item(6))
          Case 8
           url = String.Format(wr.RequestUrl, dr.Item(0), dr.Item(1), dr.Item(2), dr.Item(3), dr.Item(4), dr.Item(5), dr.Item(6), dr.Item(7))
          Case 9
           url = String.Format(wr.RequestUrl, dr.Item(0), dr.Item(1), dr.Item(2), dr.Item(3), dr.Item(4), dr.Item(5), dr.Item(6), dr.Item(7), dr.Item(8))
          Case Else
           url = String.Format(wr.RequestUrl, dr.Item(0), dr.Item(1), dr.Item(2), dr.Item(3), dr.Item(4), dr.Item(5), dr.Item(6), dr.Item(7), dr.Item(8), dr.Item(9))
         End Select

         Globals.SimpleLog("Calling " & url)

         ' make remote request
         Dim wreq As HttpWebRequest = CType(WebRequest.Create(url), HttpWebRequest)
         ' set proxy server
         If Convert.ToString(DotNetNuke.Common.HostSettings("ProxyServer")) <> "" Then
          wreq.Proxy = New WebProxy(Convert.ToString(DotNetNuke.Common.HostSettings("ProxyServer")), Convert.ToInt32(Convert.ToString(DotNetNuke.Common.HostSettings("ProxyPort"))))
          ' set the credentials for an authenticated proxy
          If Not Convert.ToString(DotNetNuke.Common.HostSettings("ProxyUsername")).Equals("") Then
           wreq.Proxy.Credentials = New NetworkCredential(Convert.ToString(DotNetNuke.Common.HostSettings("ProxyUsername")), Convert.ToString(DotNetNuke.Common.HostSettings("ProxyPassword")))
          End If
         End If
         wreq.Accept = "*/*"

         ' set the HTTP properties
         wreq.Timeout = 10000       ' 10 seconds

         ' read the response
         Dim resp As WebResponse = wreq.GetResponse()
         Using sr As IO.Stream = resp.GetResponseStream
          Using tr As New IO.StreamReader(sr)
           Dim t As String = tr.ReadToEnd
           Globals.SimpleLog("Response: ", Left(t, 1000))
          End Using
         End Using

         report.Append("Called: " & url)

        Next
       End If
      Catch ex As Exception
       report.Append(String.Format("Error running {0}: {1}. Stacktrace {2}", wr.WebRequestID, ex.Message, ex.StackTrace))
       Globals.SimpleLog("Error: ", ex.Message, ex.StackTrace)
      End Try
     Next
    Loop
   End Using

   ModuleController.SetNewTime(newRuntime)

   Me.ScheduleHistoryItem.AddLogNote(report.ToString)
   Me.ScheduleHistoryItem.Succeeded = True
  Catch ex As Exception
   Me.ScheduleHistoryItem.Succeeded = False
   Me.ScheduleHistoryItem.AddLogNote("Check failed: " & ex.Message & "(" & ex.StackTrace & ")")
   Me.Errored(ex)
   LogException(ex)
  End Try


 End Sub

End Class
