
Imports System
Imports System.Data
Imports System.Data.SqlClient
Imports Microsoft.ApplicationBlocks.Data

Namespace Data

 Public Class SqlDataProvider
  Inherits DataProvider

#Region " Private Members "

  Private Const ProviderType As String = "data"

  Private _providerConfiguration As DotNetNuke.Framework.Providers.ProviderConfiguration = DotNetNuke.Framework.Providers.ProviderConfiguration.GetProviderConfiguration(ProviderType)
  Private _connectionString As String
  Private _providerPath As String
  Private _objectQualifier As String
  Private _databaseOwner As String

#End Region

#Region " Constructors "

  Public Sub New()

   ' Read the configuration specific information for this provider
   Dim objProvider As DotNetNuke.Framework.Providers.Provider = CType(_providerConfiguration.Providers(_providerConfiguration.DefaultProvider), DotNetNuke.Framework.Providers.Provider)

   ' Read the attributes for this provider
   If objProvider.Attributes("connectionStringName") <> "" AndAlso _
   System.Configuration.ConfigurationSettings.AppSettings(objProvider.Attributes("connectionStringName")) <> "" Then
    _connectionString = System.Configuration.ConfigurationSettings.AppSettings(objProvider.Attributes("connectionStringName"))
   Else
    _connectionString = objProvider.Attributes("connectionString")
   End If

   _providerPath = objProvider.Attributes("providerPath")

   _objectQualifier = objProvider.Attributes("objectQualifier")
   If _objectQualifier <> "" And _objectQualifier.EndsWith("_") = False Then
    _objectQualifier += "_"
   End If

   _databaseOwner = objProvider.Attributes("databaseOwner")
   If _databaseOwner <> "" And _databaseOwner.EndsWith(".") = False Then
    _databaseOwner += "."
   End If

  End Sub

#End Region

#Region " Properties "

  Public ReadOnly Property ConnectionString() As String
   Get
    Return _connectionString
   End Get
  End Property

  Public ReadOnly Property ProviderPath() As String
   Get
    Return _providerPath
   End Get
  End Property

  Public ReadOnly Property ObjectQualifier() As String
   Get
    Return _objectQualifier
   End Get
  End Property

  Public ReadOnly Property DatabaseOwner() As String
   Get
    Return _databaseOwner
   End Get
  End Property

#End Region

#Region " General Methods "
  Public Overrides Function GetNull(ByVal Field As Object) As Object
   Return DotNetNuke.Common.Utilities.Null.GetNull(Field, DBNull.Value)
  End Function

  Private Function TransSql(ByVal sql As String) As String
   Return Regex.Replace(Regex.Replace(sql, "(?i){databaseowner}(?-i)", DatabaseOwner), "(?i){objectqualifier}(?-i)", ObjectQualifier)
  End Function
#End Region



#Region " WebRequests Methods "

  Public Overrides Function GetWebRequest(ByVal WebRequestID As Integer, ByVal ModuleId As Integer) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & "WebRequester_GetWebRequest", WebRequestID, ModuleId), IDataReader)
  End Function

  Public Overrides Function AddWebRequest(ByVal ConditionSQL As String, ByVal ModuleID As Integer, ByVal Order As Integer, ByVal RequestSQL As String, ByVal RequestUrl As String) As Integer
   Return CType(SqlHelper.ExecuteScalar(ConnectionString, DatabaseOwner & ObjectQualifier & "WebRequester_AddWebRequest", GetNull(ConditionSQL), ModuleID, GetNull(Order), GetNull(RequestSQL), GetNull(RequestUrl)), Integer)
  End Function

  Public Overrides Sub UpdateWebRequest(ByVal WebRequestID As Integer, ByVal ConditionSQL As String, ByVal ModuleID As Integer, ByVal Order As Integer, ByVal RequestSQL As String, ByVal RequestUrl As String)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & "WebRequester_UpdateWebRequest", WebRequestID, GetNull(ConditionSQL), ModuleID, GetNull(Order), GetNull(RequestSQL), GetNull(RequestUrl))
  End Sub

  Public Overrides Sub DeleteWebRequest(ByVal WebRequestID As Integer)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & "WebRequester_DeleteWebRequest", WebRequestID)
  End Sub

  Public Overrides Function GetWebRequestsByModule(ByVal ModuleID As Integer) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & "WebRequester_GetWebRequestsByModule", ModuleID), IDataReader)
  End Function

#End Region

#Region " Other Procedures "
  Public Overrides Function GetModuleInstances(ByVal DesktopModuleName As String) As IDataReader
   Dim sql As String = "SELECT t.PortalID, t.TabID, t.TabName, m.ModuleId, m.ModuleTitle, t.TabName+': '+m.ModuleTitle AS Description FROM " & DatabaseOwner & ObjectQualifier & "Modules m"
   sql &= " INNER JOIN " & DatabaseOwner & ObjectQualifier & "TabModules tm ON m.ModuleId=tm.ModuleId"
   sql &= " INNER JOIN " & DatabaseOwner & ObjectQualifier & "ModuleDefinitions md ON m.ModuleDefId=md.ModuleDefID"
   sql &= " INNER JOIN " & DatabaseOwner & ObjectQualifier & "DesktopModules dm ON md.DesktopModuleId=dm.DesktopModuleId"
   sql &= " INNER JOIN " & DatabaseOwner & ObjectQualifier & "Tabs t ON t.TabID=tm.TabID"
   sql &= " WHERE dm.ModuleName='" & DesktopModuleName & "'"
   Return DotNetNuke.Data.DataProvider.Instance.ExecuteSQL(sql)
  End Function

  Public Overrides Function GetRowSet(ByVal CommandText As String) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, CommandType.Text, TransSql(CommandText)), IDataReader)
  End Function

  Public Overrides Function GetScalar(ByVal CommandText As String) As Object
   Return SqlHelper.ExecuteScalar(ConnectionString, CommandType.Text, TransSql(CommandText))
  End Function
#End Region

 End Class

End Namespace
