﻿Imports System
Imports DotNetNuke.Services.Localization.Localization
Imports Bring2mind.DNN.Modules.WebRequester.Business

Partial Public Class WebRequester
 Inherits DotNetNuke.Entities.Modules.PortalModuleBase

#Region " Event Handlers "
 Private Sub Page_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

  If Not Me.IsPostBack Then

   Me.ViewState("SortExpression") = "Order"
   Me.ViewState("PageIndex") = 0

   cmdAdd.NavigateUrl = EditUrl("WebRequestID", "-1", "EditWebRequest")
   BindList()

  End If

 End Sub

 Public Sub WebRequestGridSort(ByVal source As Object, ByVal e As System.Web.UI.WebControls.DataGridSortCommandEventArgs)

  If Convert.ToString(Me.ViewState("SortExpression")) = e.SortExpression Then
   Me.ViewState("SortExpression") = e.SortExpression & " DESC"
  Else
   Me.ViewState("SortExpression") = e.SortExpression
  End If

  dgWebRequests.Controls.Clear()
  BindList()

 End Sub

 Public Sub WebRequestGridPageCommand(ByVal source As Object, ByVal e As System.Web.UI.WebControls.DataGridPageChangedEventArgs)

  Me.ViewState("PageIndex") = e.NewPageIndex
  dgWebRequests.Controls.Clear()
  BindList()

 End Sub
#End Region

#Region " Optional Interfaces "
#End Region

#Region " Private Methods "
 Private Sub BindList()
  DotNetNuke.Services.Localization.Localization.LocalizeDataGrid(dgWebRequests, Me.LocalResourceFile)

  Dim dv As New DataView(DotNetNuke.Common.ConvertDataReaderToDataTable(Data.DataProvider.Instance().GetWebRequestsByModule(ModuleId)))
  With dv
   .Sort = Convert.ToString(Me.ViewState("SortExpression"))
  End With

  With dgWebRequests
   .CurrentPageIndex = Convert.ToInt32(Me.ViewState("PageIndex"))
   .DataSource = dv
   .DataBind()
   If .AllowPaging Then
    If dv.Count <= .PageSize Then
     .AllowPaging = False
    Else
     .AllowPaging = True
    End If
   End If
  End With

 End Sub
#End Region

End Class