Imports System.Xml
Imports DotNetNuke.Common.Utilities.XmlUtils
Imports DotNetNuke.Common.Utilities
Imports System.Text
Imports System.Collections.Generic
Imports System.IO

Public Class ModuleController
 Implements DotNetNuke.Entities.Modules.IPortable
 Implements DotNetNuke.Entities.Modules.IUpgradeable

#Region " IPortable Implementation "
 Public Function ExportModule(ByVal ModuleID As Integer) As String Implements DotNetNuke.Entities.Modules.IPortable.ExportModule
  Dim sb As New StringBuilder()
  Dim settings As New XmlWriterSettings()
  settings.ConformanceLevel = ConformanceLevel.Fragment
  settings.OmitXmlDeclaration = True

  sb.Append("<WebRequester><Settings>")
  Dim moduleSettings As Hashtable
  Dim objModules As New DotNetNuke.Entities.Modules.ModuleController
  moduleSettings = objModules.GetModuleSettings(ModuleID)
  For Each name As String In moduleSettings.Keys
   sb.Append("<Setting Name=""" + name + """>")
   sb.Append("<Value>" + XMLEncode(moduleSettings(name).ToString) + "</Value>")
   sb.Append("</Setting>")
  Next
  sb.Append("</Settings>")

  ' content items go here

  sb.Append("</WebRequester>")
  Return sb.ToString()

 End Function

 Public Sub ImportModule(ByVal ModuleID As Integer, ByVal Content As String, ByVal Version As String, ByVal UserID As Integer) Implements DotNetNuke.Entities.Modules.IPortable.ImportModule

  Dim xmlDoc As New XmlDocument
  xmlDoc.LoadXml(Content)

  Dim objModules As New DotNetNuke.Entities.Modules.ModuleController
  For Each xSetting As XmlNode In xmlDoc.SelectNodes("WebRequester/Settings/Setting")
   Dim settingName As String = xSetting.Attributes("Name").InnerText
   Dim settingValue As String = xSetting.SelectSingleNode("Value").InnerText
   objModules.UpdateModuleSetting(ModuleID, settingName, settingValue)
  Next

  Using reader As XmlReader = XmlReader.Create(New StringReader(Content))

   If reader.Read() Then
    reader.ReadStartElement("WebRequester")
    'reader.ReadToFollowing("Feeds")
    'reader.Read()
    'If reader.ReadState <> ReadState.EndOfFile And reader.NodeType <> XmlNodeType.None And reader.LocalName <> "" Then
    ' Do
    '  reader.ReadStartElement("Feed")
    '  Dim Feed As New FeedInfo

    'Deserialize Feed
    '  Feed.ReadXml(reader)

    'initialize values of the new Feed to this module and this user
    '  Feed.FeedID = Null.NullInteger
    '  Feed.ModuleID = ModuleID

    'Save Feed
    '  FeedController.AddFeed(Feed)
    ' Loop While reader.ReadToNextSibling("Feed")
    'End If
   End If

   reader.Close()
  End Using


 End Sub
#End Region

#Region " IUpgradeable Implementation "
 Public Function UpgradeModule(ByVal Version As String) As String Implements DotNetNuke.Entities.Modules.IUpgradeable.UpgradeModule
  Dim strResults As String = ""
  Try
   Select Case Version
    Case "01.00.00"
   End Select
  Catch ex As Exception
   strResults += "Error: " & ex.Message & vbCrLf
   Try
    DotNetNuke.Services.Exceptions.LogException(ex)
   Catch
    ' ignore
   End Try
  End Try
  Return strResults
 End Function
#End Region

 Public Shared Sub SetNewTime(ByVal newTime As Date)
  DotNetNuke.Data.DataProvider.Instance.UpdateHostSetting(Globals.glbLastRunSettingName, newTime.ToString, False)
 End Sub

 Public Shared Function GetLastTime() As Date
  Dim res As Date = Date.MinValue
  Using ir As IDataReader = DotNetNuke.Data.DataProvider.Instance.GetHostSetting(Globals.glbLastRunSettingName)
   If ir IsNot Nothing Then
    While ir.Read
     res = CDate(ir.Item(0))
     Exit While
    End While
   End If
  End Using
  If res = Date.MinValue Then
   DotNetNuke.Data.DataProvider.Instance.AddHostSetting(Globals.glbLastRunSettingName, Now.ToString, False)
  End If
  Return res
 End Function

 Public Shared Function GetRowSet(ByVal CommandText As String) As DataTable

  Return DotNetNuke.Common.ConvertDataReaderToDataTable(Data.DataProvider.Instance().GetRowSet(CommandText))

 End Function

 Public Shared Function GetScalar(ByVal CommandText As String) As Object

  Return Data.DataProvider.Instance().GetScalar(CommandText)

 End Function

End Class

