﻿Imports System.IO

Public Class ZipStreamWrapper
 Inherits System.IO.Stream

 Private wrapped As System.IO.Stream

 Public Sub New(ByVal wrapped As Stream)
  Me.wrapped = wrapped
 End Sub

 Public Overrides ReadOnly Property CanRead() As Boolean
  Get
   Return wrapped.CanRead
  End Get
 End Property

 Public Overrides Sub Write(ByVal buffer() As Byte, ByVal offset As Integer, ByVal count As Integer)
  If buffer.Length = 0 Then Return
  wrapped.Write(buffer, offset, count)
 End Sub

 Public Overrides ReadOnly Property CanSeek() As Boolean
  Get
   Return wrapped.CanSeek
  End Get
 End Property

 Public Overrides ReadOnly Property CanWrite() As Boolean
  Get
   Return wrapped.CanWrite
  End Get
 End Property

 Public Overrides Sub Flush()
  wrapped.Flush()
 End Sub

 Public Overrides ReadOnly Property Length() As Long
  Get
   Return wrapped.Length
  End Get
 End Property

 Public Overrides Property Position() As Long
  Get
   Return wrapped.Position
  End Get
  Set(ByVal value As Long)
   wrapped.Position = value
  End Set
 End Property

 Public Overrides Function Read(ByVal buffer() As Byte, ByVal offset As Integer, ByVal count As Integer) As Integer
  Return wrapped.Read(buffer, offset, count)
 End Function

 Public Overrides Function Seek(ByVal offset As Long, ByVal origin As System.IO.SeekOrigin) As Long
  Return wrapped.Seek(offset, origin)
 End Function

 Public Overrides Sub SetLength(ByVal value As Long)
  wrapped.SetLength(value)
 End Sub
End Class
