﻿Imports System.Xml

Imports DotNetNuke.Common.Utilities
Imports DotNetNuke.Services.Localization.Localization
Imports DotNetNuke.Services.Mail
Imports DotNetNuke.Security.Membership
Imports DotNetNuke.Entities.Users
Imports ICSharpCode.SharpZipLib.Zip

Partial Public Class DNNSupport
 Inherits DotNetNuke.Entities.Modules.PortalModuleBase

 Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load

  cmdEndCalendar.NavigateUrl = DotNetNuke.Common.Utilities.Calendar.InvokePopupCal(txtEndDate)

  If Not Me.IsPostBack Then

   Dim sUsers As ArrayList = DotNetNuke.Security.Membership.MembershipProvider.Instance().GetUsers(Null.NullInteger, False, 0, 100, Nothing)
   ddUsername.DataSource = sUsers
   ddUsername.DataBind()
   ddUsername.Items.Insert(0, New ListItem(GetString("NewUser", Me.LocalResourceFile), ""))
   dlModules.DataSource = Data.DataProvider.Instance.GetModuleList(PortalId)
   dlModules.DataBind()

  End If

 End Sub

 Private Sub cmdRunSQL_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles cmdRunSQL.Click

  Dim xmlDoc As New XmlDocument
  xmlDoc.AppendChild(xmlDoc.CreateXmlDeclaration("1.0", Nothing, "yes"))
  Dim root As XmlNode = xmlDoc.CreateElement("SQL")
  xmlDoc.AppendChild(root)
  Common.RunQuery(root, "Result", "Row", txtRunSQL.Text)
  Me.Response.Clear()
  Me.Response.ContentType = "text/xml"
  If Request.Browser.Browser = "IE" Then
   Me.Response.AppendHeader("Content-Disposition", "attachment; filename=""DNNReport.Xml""")
  Else
   Me.Response.AppendHeader("Content-Disposition", "attachment; filename=""DNNReport.Xml""")
  End If
  Me.Response.Write(xmlDoc.OuterXml)
  Me.Response.Flush()
  Me.Response.End()

 End Sub

 Private Sub cmdMakeSysInfo_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles cmdMakeSysInfo.Click

  Dim rep As New XmlReport

  Me.Response.Clear()
  Me.Response.BufferOutput = False
  Me.Response.ContentType = "application/zip"
  If Request.Browser.Browser = "IE" Then
   Me.Response.AppendHeader("Content-Disposition", "attachment; filename=""DNNReport.zip""")
  Else
   Me.Response.AppendHeader("Content-Disposition", "attachment; filename=""DNNReport.zip""")
  End If
  Using objZipOutputStream As New ZipOutputStream(New ZipStreamWrapper(Me.Response.OutputStream))
   Dim objZipEntry As New ZipEntry("DNNReport.Xml")
   objZipOutputStream.PutNextEntry(objZipEntry)
   objZipOutputStream.SetLevel(9)
   rep.Save(objZipOutputStream)
  End Using
  Me.Response.Flush()
  Me.Response.End()

 End Sub

 Private Sub cmdCreate_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles cmdCreate.Click

  Dim report As String = GetString("Report", Me.LocalResourceFile)
  If txtLastname.Text.Trim = "" Or txtEmail.Text.Trim = "" Or (txtUsername.Text.Trim = "" And ddUsername.SelectedValue = "") Then
   report &= GetString("MissingInfo.Error", Me.LocalResourceFile)
   lblError.Text = report
   Exit Sub
  End If

  Dim user As UserInfo = Nothing
  Dim password As String = UserController.GeneratePassword
  If ddUsername.SelectedValue = "" Then
   user = New UserInfo
   With user
    .FirstName = txtFirstname.Text.Trim
    .LastName = txtLastname.Text.Trim
    .Username = txtUsername.Text.Trim
    .Email = txtEmail.Text.Trim
    .IsSuperUser = True
    .DisplayName = (.FirstName & " " & .LastName).Trim
    .Profile.FirstName = .FirstName
    .Profile.LastName = .LastName
    .Membership.Email = .Email
    .Membership.CreatedDate = Now
    .Membership.Approved = True
    .Membership.Username = .Username
    .Membership.Password = password
    .Membership.UpdatePassword = True
    If txtEndDate.Text.Trim = "" Then
     report &= GetString("NeedExpires.Error", Me.LocalResourceFile)
     lblError.Text = report
     Exit Sub
    End If
    .Profile.SetProfileProperty(Common.STR_Expires, Date.Parse(txtEndDate.Text.Trim).Date.ToString("u"))
   End With
   Dim createStatus As DotNetNuke.Security.Membership.UserCreateStatus = UserCreateStatus.AddUser
   createStatus = UserController.CreateUser(user)
   report &= createStatus.ToString & "<br />"
   report &= "Password: " & user.Membership.Password & "<br />"
  Else ' new user
   report &= "Retrieving: " & ddUsername.SelectedValue & "<br />"
   user = UserController.GetUserByName(Null.NullInteger, ddUsername.SelectedValue)
   If user IsNot Nothing Then
    If user.Profile.GetPropertyValue(Common.STR_Expires) IsNot Nothing Then
     ' assume that this is an account generated by this module and we can transfer it to the new person
     With user
      .FirstName = txtFirstname.Text.Trim
      .LastName = txtLastname.Text.Trim
      .Email = txtEmail.Text.Trim
      .DisplayName = (.FirstName & " " & .LastName).Trim
      .Profile.FirstName = .FirstName
      .Profile.LastName = .LastName
      .Membership.Email = .Email
      .Membership.CreatedDate = Now
      .Membership.Approved = True
      '.Membership.Password = password
      UserController.ChangePassword(user, Null.NullString, password)
      .Membership.UpdatePassword = True
      If Not txtEndDate.Text.Trim = "" Then
       .Profile.SetProfileProperty(Common.STR_Expires, Date.Parse(txtEndDate.Text.Trim).Date.ToString("u"))
      End If
     End With
    Else
     password = UserController.GetPassword(user, "")
    End If
    user.Membership.Approved = True
    UserController.UpdateUser(Null.NullInteger, user)
    user.Email = txtEmail.Text.Trim
    user.Membership.Email = user.Email ' non premanent changes to email to make sure the email is sent to the right email address
    If Mail.SendMail(user, MessageType.PasswordReminder, PortalSettings) <> String.Empty Then
     report &= GetString("SendMailError", Me.LocalResourceFile) & "<br />"
    End If
   End If
  End If
  If chkIncludePW.Checked Then
   Dim subject As String = GetString("Password.Subject", Me.LocalResourceFile)
   Dim body As String = String.Format(GetString("Password.Body", Me.LocalResourceFile), password)
   If Mail.SendMail(UserInfo.Email, txtEmail.Text.Trim, "", subject, body, "", "Text", "", "", "", "") <> String.Empty Then
    report &= GetString("SendMailError", Me.LocalResourceFile) & "<br />"
   Else
    report &= "Password Sent<br />"
   End If
  End If

  lblError.Text = report

 End Sub
End Class