
Imports System
Imports DotNetNuke

Namespace Data
 Public MustInherit Class DataProvider

#Region " Shared/Static Methods "

  ' singleton reference to the instantiated object 
  Private Shared objProvider As DataProvider = Nothing

  ' constructor
  Shared Sub New()
   CreateProvider()
  End Sub

  ' dynamically create provider
  Private Shared Sub CreateProvider()
   objProvider = CType(DotNetNuke.Framework.Reflection.CreateObject("data", "BugNET.DNN.Library.Data", ""), DataProvider)
  End Sub

  ' return the provider
  Public Shared Shadows Function Instance() As DataProvider
   Return objProvider
  End Function

#End Region

#Region " General Methods "
  Public MustOverride Function GetNull(ByVal Field As Object) As Object
#End Region


#Region " BugAttachment Methods "

  Public MustOverride Function GetBugAttachment(ByVal BugAttachmentID As Integer) As IDataReader

  Public MustOverride Function AddBugAttachment(ByVal BugID As Integer, ByVal Description As String, ByVal FileName As String, ByVal FileSize As Integer, ByVal Type As String, ByVal UploadedDate As Date, ByVal UploadedUsername As String) As Integer

  Public MustOverride Sub UpdateBugAttachment(ByVal BugAttachmentID As Integer, ByVal BugID As Integer, ByVal Description As String, ByVal FileName As String, ByVal FileSize As Integer, ByVal Type As String, ByVal UploadedDate As Date, ByVal UploadedUsername As String)

  Public MustOverride Sub DeleteBugAttachment(ByVal BugAttachmentID As Integer)


#End Region


#Region " BugComment Methods "

  Public MustOverride Function GetBugComment(ByVal BugCommentID As Integer) As IDataReader

  Public MustOverride Function AddBugComment(ByVal BugID As Integer, ByVal Comment As String, ByVal CreatedDate As Date, ByVal CreatedUsername As String) As Integer

  Public MustOverride Sub UpdateBugComment(ByVal BugCommentID As Integer, ByVal BugID As Integer, ByVal Comment As String, ByVal CreatedDate As Date, ByVal CreatedUsername As String)

  Public MustOverride Sub DeleteBugComment(ByVal BugCommentID As Integer)


#End Region


#Region " BugHistory Methods "

  Public MustOverride Function GetBugHistory(ByVal BugHistoryID As Integer) As IDataReader

  Public MustOverride Function AddBugHistory(ByVal BugID As Integer, ByVal CreatedDate As Date, ByVal CreatedUsername As String, ByVal FieldChanged As String, ByVal NewValue As String, ByVal OldValue As String) As Integer

  Public MustOverride Sub UpdateBugHistory(ByVal BugHistoryID As Integer, ByVal BugID As Integer, ByVal CreatedDate As Date, ByVal CreatedUsername As String, ByVal FieldChanged As String, ByVal NewValue As String, ByVal OldValue As String)

  Public MustOverride Sub DeleteBugHistory(ByVal BugHistoryID As Integer)


#End Region


#Region " BugNotification Methods "

  Public MustOverride Function GetBugNotification(ByVal BugNotificationID As Integer) As IDataReader

  Public MustOverride Function AddBugNotification(ByVal BugId As Integer, ByVal Username As String) As Integer

  Public MustOverride Sub DeleteBugNotification(ByVal BugId As Integer, ByVal Username As String)

#End Region


#Region " Bug Methods "

  Public MustOverride Function GetBug(ByVal BugID As Integer) As IDataReader

  Public MustOverride Function AddBug(ByVal AssignedToUsername As String, ByVal ComponentID As Integer, ByVal Description As String, ByVal DueDate As Date, ByVal Estimation As Decimal, ByVal FixedInVersionId As Integer, ByVal LastUpdate As Date, ByVal LastUpdateUsername As String, ByVal PriorityID As Integer, ByVal ProjectID As Integer, ByVal ReportedDate As Date, ByVal ReporterUsername As String, ByVal ResolutionID As Integer, ByVal StatusID As Integer, ByVal Summary As String, ByVal TypeID As Integer, ByVal VersionID As Integer, ByVal Visibility As Integer) As Integer

  Public MustOverride Sub UpdateBug(ByVal BugID As Integer, ByVal AssignedToUsername As String, ByVal ComponentID As Integer, ByVal Description As String, ByVal DueDate As Date, ByVal Estimation As Decimal, ByVal FixedInVersionId As Integer, ByVal LastUpdate As Date, ByVal LastUpdateUsername As String, ByVal PriorityID As Integer, ByVal ProjectID As Integer, ByVal ReportedDate As Date, ByVal ReporterUsername As String, ByVal ResolutionID As Integer, ByVal StatusID As Integer, ByVal Summary As String, ByVal TypeID As Integer, ByVal VersionID As Integer, ByVal Visibility As Integer)

  Public MustOverride Sub DeleteBug(ByVal BugID As Integer)

  Public MustOverride Function GetBugsByCriteria(ByVal projectId As Integer, ByVal componentId As Integer, ByVal versionId As Integer, ByVal priorityId As Integer, ByVal typeId As Integer, ByVal resolutionId As Integer, ByVal statusId As Integer, ByVal assignedToUserName As String, ByVal keywords As String, ByVal includeComments As Boolean, ByVal reporterUserName As String, ByVal fixedInVersionId As Integer) As IDataReader

#End Region


#Region " BugTimeEntry Methods "

  Public MustOverride Function GetBugTimeEntry(ByVal BugTimeEntryId As Integer) As IDataReader

  Public MustOverride Function AddBugTimeEntry(ByVal BugCommentId As Integer, ByVal BugId As Integer, ByVal CreatedUsername As String, ByVal Duration As Decimal, ByVal WorkDate As Date) As Integer

  Public MustOverride Sub UpdateBugTimeEntry(ByVal BugTimeEntryId As Integer, ByVal BugCommentId As Integer, ByVal BugId As Integer, ByVal CreatedUsername As String, ByVal Duration As Decimal, ByVal WorkDate As Date)

  Public MustOverride Sub DeleteBugTimeEntry(ByVal BugTimeEntryId As Integer)


#End Region


#Region " Component Methods "

  Public MustOverride Function GetComponent(ByVal ComponentID As Integer) As IDataReader

  Public MustOverride Function AddComponent(ByVal Name As String, ByVal ParentComponentID As Integer, ByVal ProjectID As Integer) As Integer

  Public MustOverride Sub UpdateComponent(ByVal ComponentID As Integer, ByVal Name As String, ByVal ParentComponentID As Integer, ByVal ProjectID As Integer)

  Public MustOverride Sub DeleteComponent(ByVal ComponentID As Integer)

  Public MustOverride Function FindComponentByName(ByVal Name As String) As IDataReader

  Public MustOverride Function GetComponentsByProject(ByVal ProjectID As Integer) As IDataReader

#End Region


#Region " Log Methods "

  Public MustOverride Function GetLog(ByVal Id As Integer) As IDataReader

  Public MustOverride Function AddLog(ByVal [Date] As Date, ByVal Exception As String, ByVal Level As String, ByVal Logger As String, ByVal Message As String, ByVal Thread As String, ByVal User As String) As Integer

  Public MustOverride Sub UpdateLog(ByVal Id As Integer, ByVal [Date] As Date, ByVal Exception As String, ByVal Level As String, ByVal Logger As String, ByVal Message As String, ByVal Thread As String, ByVal User As String)

  Public MustOverride Sub DeleteLog(ByVal Id As Integer)


#End Region


#Region " Permission Methods "

  Public MustOverride Function GetPermission(ByVal PermissionId As Integer) As IDataReader

  Public MustOverride Function AddPermission(ByVal Name As String, ByVal PermissionKey As String) As Integer

  Public MustOverride Sub UpdatePermission(ByVal PermissionId As Integer, ByVal Name As String, ByVal PermissionKey As String)

  Public MustOverride Sub DeletePermission(ByVal PermissionId As Integer)

  Public MustOverride Function FindPermissionByName(ByVal Name As String) As IDataReader


#End Region


#Region " Priority Methods "

  Public MustOverride Function GetPriority(ByVal PriorityID As Integer) As IDataReader

  Public MustOverride Function AddPriority(ByVal ImageUrl As String, ByVal Name As String) As Integer

  Public MustOverride Sub UpdatePriority(ByVal PriorityID As Integer, ByVal ImageUrl As String, ByVal Name As String)

  Public MustOverride Sub DeletePriority(ByVal PriorityID As Integer)

  Public MustOverride Function FindPriorityByName(ByVal Name As String) As IDataReader

  Public MustOverride Function GetPriorities() As IDataReader

#End Region


#Region " ProjectCustomField Methods "

  Public MustOverride Function GetProjectCustomField(ByVal CustomFieldId As Integer) As IDataReader

  Public MustOverride Function AddProjectCustomField(ByVal CustomFieldDataType As Integer, ByVal CustomFieldName As String, ByVal CustomFieldRequired As Boolean, ByVal CustomFieldTypeId As Integer, ByVal ProjectId As Integer) As Integer

  Public MustOverride Sub UpdateProjectCustomField(ByVal CustomFieldId As Integer, ByVal CustomFieldDataType As Integer, ByVal CustomFieldName As String, ByVal CustomFieldRequired As Boolean, ByVal CustomFieldTypeId As Integer, ByVal ProjectId As Integer)

  Public MustOverride Sub DeleteProjectCustomField(ByVal CustomFieldId As Integer)


#End Region


#Region " ProjectCustomFieldSelection Methods "

  Public MustOverride Function GetProjectCustomFieldSelection(ByVal CustomFieldSelectionId As Integer) As IDataReader

  Public MustOverride Function AddProjectCustomFieldSelection(ByVal CustomFieldId As Integer, ByVal CustomFieldSelectionName As String, ByVal CustomFieldSelectionSortOrder As Integer, ByVal CustomFieldSelectionValue As String) As Integer

  Public MustOverride Sub UpdateProjectCustomFieldSelection(ByVal CustomFieldSelectionId As Integer, ByVal CustomFieldId As Integer, ByVal CustomFieldSelectionName As String, ByVal CustomFieldSelectionSortOrder As Integer, ByVal CustomFieldSelectionValue As String)

  Public MustOverride Sub DeleteProjectCustomFieldSelection(ByVal CustomFieldSelectionId As Integer)


#End Region


#Region " ProjectCustomFieldType Methods "

  Public MustOverride Function GetProjectCustomFieldType(ByVal CustomFieldTypeId As Integer) As IDataReader

  Public MustOverride Function AddProjectCustomFieldType(ByVal CustomFieldTypeName As String) As Integer

  Public MustOverride Sub UpdateProjectCustomFieldType(ByVal CustomFieldTypeId As Integer, ByVal CustomFieldTypeName As String)

  Public MustOverride Sub DeleteProjectCustomFieldType(ByVal CustomFieldTypeId As Integer)


#End Region


#Region " ProjectCustomFieldValue Methods "

  Public MustOverride Function GetProjectCustomFieldValue(ByVal CustomFieldValueId As Integer) As IDataReader

  Public MustOverride Function AddProjectCustomFieldValue(ByVal BugId As Integer, ByVal CustomFieldId As Integer, ByVal CustomFieldValue As String) As Integer

  Public MustOverride Sub UpdateProjectCustomFieldValue(ByVal CustomFieldValueId As Integer, ByVal BugId As Integer, ByVal CustomFieldId As Integer, ByVal CustomFieldValue As String)

  Public MustOverride Sub DeleteProjectCustomFieldValue(ByVal CustomFieldValueId As Integer)


#End Region


#Region " ProjectMailBox Methods "

  Public MustOverride Function GetProjectMailBox(ByVal ProjectMailboxId As Integer) As IDataReader

  Public MustOverride Function AddProjectMailBox(ByVal AssignToUsername As String, ByVal IssueTypeId As Integer, ByVal MailBox As String, ByVal ProjectId As Integer) As Integer

  Public MustOverride Sub UpdateProjectMailBox(ByVal ProjectMailboxId As Integer, ByVal AssignToUsername As String, ByVal IssueTypeId As Integer, ByVal MailBox As String, ByVal ProjectId As Integer)

  Public MustOverride Sub DeleteProjectMailBox(ByVal ProjectMailboxId As Integer)


#End Region


#Region " Project Methods "

  Public MustOverride Function GetProjects() As IDataReader

  Public MustOverride Function GetProject(ByVal ProjectID As Integer) As IDataReader

  Public MustOverride Function AddProject(ByVal AccessType As Integer, ByVal Active As Integer, ByVal AllowAttachments As Boolean, ByVal Code As String, ByVal CreateDate As Date, ByVal CreatorUsername As String, ByVal Description As String, ByVal ManagerUsername As String, ByVal Name As String, ByVal UploadPath As String) As Integer

  Public MustOverride Sub UpdateProject(ByVal ProjectID As Integer, ByVal AccessType As Integer, ByVal Active As Integer, ByVal AllowAttachments As Boolean, ByVal Code As String, ByVal CreateDate As Date, ByVal CreatorUsername As String, ByVal Description As String, ByVal ManagerUsername As String, ByVal Name As String, ByVal UploadPath As String)

  Public MustOverride Sub DeleteProject(ByVal ProjectID As Integer)

  Public MustOverride Function FindProjectByCode(ByVal Code As String) As IDataReader

  Public MustOverride Function FindProjectByName(ByVal Name As String) As IDataReader


#End Region


#Region " RelatedBug Methods "

  Public MustOverride Function GetRelatedBug(ByVal RelatedBugID As Integer) As IDataReader

  Public MustOverride Function AddRelatedBug(ByVal BugID As Integer, ByVal LinkedBugID As Integer) As Integer

  Public MustOverride Sub UpdateRelatedBug(ByVal RelatedBugID As Integer, ByVal BugID As Integer, ByVal LinkedBugID As Integer)

  Public MustOverride Sub DeleteRelatedBug(ByVal RelatedBugID As Integer)


#End Region


#Region " Resolution Methods "

  Public MustOverride Function GetResolution(ByVal ResolutionID As Integer) As IDataReader

  Public MustOverride Function AddResolution(ByVal Name As String) As Integer

  Public MustOverride Sub UpdateResolution(ByVal ResolutionID As Integer, ByVal Name As String)

  Public MustOverride Sub DeleteResolution(ByVal ResolutionID As Integer)

  Public MustOverride Function FindResolutionByName(ByVal Name As String) As IDataReader

  Public MustOverride Function GetResolutions() As IDataReader

#End Region


#Region " RolePermission Methods "

  Public MustOverride Function GetRolePermission(ByVal RolePermissionId As Integer) As IDataReader

  Public MustOverride Function AddRolePermission(ByVal PermissionId As Integer, ByVal RoleId As Integer) As Integer

  Public MustOverride Sub UpdateRolePermission(ByVal RolePermissionId As Integer, ByVal PermissionId As Integer, ByVal RoleId As Integer)

  Public MustOverride Sub DeleteRolePermission(ByVal RolePermissionId As Integer)


#End Region


#Region " Role Methods "

  Public MustOverride Function GetRole(ByVal RoleId As Integer) As IDataReader

  Public MustOverride Function AddRole(ByVal AutoAssign As Boolean, ByVal Description As String, ByVal ProjectId As Integer, ByVal RoleName As String) As Integer

  Public MustOverride Sub UpdateRole(ByVal RoleId As Integer, ByVal AutoAssign As Boolean, ByVal Description As String, ByVal ProjectId As Integer, ByVal RoleName As String)

  Public MustOverride Sub DeleteRole(ByVal RoleId As Integer)


#End Region


#Region " Status Methods "

  Public MustOverride Function GetStatus(ByVal StatusID As Integer) As IDataReader

  Public MustOverride Function AddStatus(ByVal Name As String) As Integer

  Public MustOverride Sub UpdateStatus(ByVal StatusID As Integer, ByVal Name As String)

  Public MustOverride Sub DeleteStatus(ByVal StatusID As Integer)

  Public MustOverride Function FindStatusByName(ByVal Name As String) As IDataReader

  Public MustOverride Function GetStatuses() As IDataReader

#End Region


#Region " Type Methods "

  Public MustOverride Function GetBugType(ByVal TypeID As Integer) As IDataReader

  Public MustOverride Function AddType(ByVal ImageUrl As String, ByVal Name As String) As Integer

  Public MustOverride Sub UpdateType(ByVal TypeID As Integer, ByVal ImageUrl As String, ByVal Name As String)

  Public MustOverride Sub DeleteType(ByVal TypeID As Integer)

  Public MustOverride Function FindTypeByName(ByVal Name As String) As IDataReader

  Public MustOverride Function GetBugTypes() As IDataReader

#End Region


#Region " UserProject Methods "

  Public MustOverride Sub AddUserProject(ByVal UserName As String, ByVal ProjectId As Integer)
  Public MustOverride Sub DeleteUserProject(ByVal UserName As String, ByVal ProjectId As Integer)

#End Region


#Region " UserRole Methods "

  Public MustOverride Sub AddUserRole(ByVal UserName As String, ByVal RoleId As Integer)
  Public MustOverride Sub DeleteUserRole(ByVal UserName As String, ByVal RoleId As Integer)

#End Region


#Region " User Methods "

  Public MustOverride Function GetUser(ByVal UserName As String) As IDataReader
  Public MustOverride Function AddUser(ByVal IsAnonymous As Boolean, ByVal LastActivityDate As Date, ByVal MobileAlias As String, ByVal Username As String) As Integer
  Public MustOverride Sub UpdateUser(ByVal IsAnonymous As Boolean, ByVal LastActivityDate As Date, ByVal MobileAlias As String, ByVal Username As String)
  Public MustOverride Sub DeleteUser(ByVal UserName As String)
  Public MustOverride Function GetProjectMembers(ByVal ProjectId As Integer) As IDataReader

#End Region


#Region " Version Methods "

  Public MustOverride Function GetVersion(ByVal VersionID As Integer) As IDataReader

  Public MustOverride Function AddVersion(ByVal Name As String, ByVal ProjectID As Integer, ByVal SortOrder As Integer) As Integer

  Public MustOverride Sub UpdateVersion(ByVal VersionID As Integer, ByVal Name As String, ByVal ProjectID As Integer, ByVal SortOrder As Integer)

  Public MustOverride Sub DeleteVersion(ByVal VersionID As Integer)

  Public MustOverride Function FindVersionByName(ByVal Name As String) As IDataReader

  Public MustOverride Function GetVersionsByProject(ByVal ProjectID As Integer) As IDataReader

#End Region


 End Class

End Namespace
