
Imports System
Imports System.Data
Imports System.Xml
Imports System.Xml.Schema
Imports System.Xml.Serialization

Imports DotNetNuke
Imports DotNetNuke.Common.Utilities
Imports DotNetNuke.Entities.Modules
Imports DotNetNuke.Entities.Portals
Imports DotNetNuke.Services.Tokens

Imports System.Text

<Serializable(), XmlRoot("Bug")> _
Public Class BugInfo
 Implements IHydratable
 Implements IPropertyAccess
 Implements IXmlSerializable

 ' local property declarations
 Private _BugID As Integer = -1
 Private _AssignedToUserName As String = ""
 Private _ComponentID As Integer = -1
 Private _Description As String = ""
 Private _DueDate As Date = Nothing
 Private _Estimation As Decimal = 0
 Private _FixedInVersionId As Integer = -1
 Private _LastUpdate As Date = Now
 Private _LastUpdateUserName As String = ""
 Private _PriorityID As Integer = -1
 Private _ProjectID As Integer = -1
 Private _ReportedDate As Date = Now
 Private _ReporterUserName As String = ""
 Private _ResolutionID As Integer = -1
 Private _StatusID As Integer = -1
 Private _Summary As String = ""
 Private _TypeID As Integer = -1
 Private _VersionID As Integer = -1
 Private _Visibility As Integer = -1

 Private _ComponentName As String = ""
 Private _StatusName As String = ""
 Private _FixedInVersionName As String = ""
 'Private _PropertyName As String
 Private _ResolutionName As String = ""
 Private _ProjectName As String = ""
 Private _ProjectCode As String = ""
 Private _TypeName As String = ""
 Private _VersionName As String = ""
 'Private _dateCreated As Date
 Private _priorityName As String = ""


#Region " Constructors "
 Public Sub New()
 End Sub

 Public Sub New(ByVal BugID As Integer, ByVal AssignedToUserName As String, ByVal ComponentID As Integer, ByVal Description As String, ByVal DueDate As Date, ByVal Estimation As Decimal, ByVal FixedInVersionId As Integer, ByVal LastUpdate As Date, ByVal LastUpdateUserName As String, ByVal PriorityID As Integer, ByVal ProjectID As Integer, ByVal ReportedDate As Date, ByVal ReporterUserName As String, ByVal ResolutionID As Integer, ByVal StatusID As Integer, ByVal Summary As String, ByVal TypeID As Integer, ByVal VersionID As Integer, ByVal Visibility As Integer)
  Me.AssignedToUserName = AssignedToUserName
  Me.BugID = BugID
  Me.ComponentID = ComponentID
  Me.Description = Description
  Me.DueDate = DueDate
  Me.Estimation = Estimation
  Me.FixedInVersionId = FixedInVersionId
  Me.LastUpdate = LastUpdate
  Me.LastUpdateUserName = LastUpdateUserName
  Me.PriorityID = PriorityID
  Me.ProjectID = ProjectID
  Me.ReportedDate = ReportedDate
  Me.ReporterUserName = ReporterUserName
  Me.ResolutionID = ResolutionID
  Me.StatusID = StatusID
  Me.Summary = Summary
  Me.TypeID = TypeID
  Me.VersionID = VersionID
  Me.Visibility = Visibility
 End Sub
#End Region

#Region " Public Properties "
 Public Property VersionName() As String
  Get
   Return _VersionName
  End Get
  Set(ByVal value As String)
   _VersionName = value
  End Set
 End Property

 Public Property TypeName() As String
  Get
   Return _TypeName
  End Get
  Set(ByVal value As String)
   _TypeName = value
  End Set
 End Property

 Public Property ProjectCode() As String
  Get
   Return _ProjectCode
  End Get
  Set(ByVal value As String)
   _ProjectCode = value
  End Set
 End Property

 Public Property ProjectName() As String
  Get
   Return _ProjectName
  End Get
  Set(ByVal value As String)
   _ProjectName = value
  End Set
 End Property

 Public Property ResolutionName() As String
  Get
   Return _ResolutionName
  End Get
  Set(ByVal value As String)
   _ResolutionName = value
  End Set
 End Property

 'Public Property PropertyName() As String
 ' Get
 '  Return _PropertyName
 ' End Get
 ' Set(ByVal value As String)
 '  _PropertyName = value
 ' End Set
 'End Property

 Public Property FixedInVersionName() As String
  Get
   Return _FixedInVersionName
  End Get
  Set(ByVal value As String)
   _FixedInVersionName = value
  End Set
 End Property

 Public Property StatusName() As String
  Get
   Return _StatusName
  End Get
  Set(ByVal value As String)
   _StatusName = value
  End Set
 End Property


 Public Property ComponentName() As String
  Get
   Return _ComponentName
  End Get
  Set(ByVal value As String)
   _ComponentName = value
  End Set
 End Property

 Public Property BugID() As Integer
  Get
   Return _BugID
  End Get
  Set(ByVal Value As Integer)
   _BugID = Value
  End Set
 End Property

 Public Property AssignedToUserName() As String
  Get
   Return _AssignedToUserName
  End Get
  Set(ByVal Value As String)
   _AssignedToUserName = Value
  End Set
 End Property

 Public Property ComponentID() As Integer
  Get
   Return _ComponentID
  End Get
  Set(ByVal Value As Integer)
   _ComponentID = Value
  End Set
 End Property

 Public Property Description() As String
  Get
   Return _Description
  End Get
  Set(ByVal Value As String)
   _Description = Value
  End Set
 End Property

 Public Property DueDate() As Date
  Get
   Return _DueDate
  End Get
  Set(ByVal Value As Date)
   _DueDate = Value
  End Set
 End Property

 Public Property Estimation() As Decimal
  Get
   Return _Estimation
  End Get
  Set(ByVal Value As Decimal)
   _Estimation = Value
  End Set
 End Property

 Public Property FixedInVersionId() As Integer
  Get
   Return _FixedInVersionId
  End Get
  Set(ByVal Value As Integer)
   _FixedInVersionId = Value
  End Set
 End Property

 Public Property LastUpdate() As Date
  Get
   Return _LastUpdate
  End Get
  Set(ByVal Value As Date)
   _LastUpdate = Value
  End Set
 End Property

 Public Property LastUpdateUserName() As String
  Get
   Return _LastUpdateUserName
  End Get
  Set(ByVal Value As String)
   _LastUpdateUserName = Value
  End Set
 End Property

 Public Property PriorityID() As Integer
  Get
   Return _PriorityID
  End Get
  Set(ByVal Value As Integer)
   _PriorityID = Value
  End Set
 End Property

 Public Property ProjectID() As Integer
  Get
   Return _ProjectID
  End Get
  Set(ByVal Value As Integer)
   _ProjectID = Value
  End Set
 End Property

 Public Property ReportedDate() As Date
  Get
   Return _ReportedDate
  End Get
  Set(ByVal Value As Date)
   _ReportedDate = Value
  End Set
 End Property

 Public Property ReporterUserName() As String
  Get
   Return _ReporterUserName
  End Get
  Set(ByVal Value As String)
   _ReporterUserName = Value
  End Set
 End Property

 Public Property ResolutionID() As Integer
  Get
   Return _ResolutionID
  End Get
  Set(ByVal Value As Integer)
   _ResolutionID = Value
  End Set
 End Property

 Public Property StatusID() As Integer
  Get
   Return _StatusID
  End Get
  Set(ByVal Value As Integer)
   _StatusID = Value
  End Set
 End Property

 Public Property Summary() As String
  Get
   Return _Summary
  End Get
  Set(ByVal Value As String)
   _Summary = Value
  End Set
 End Property

 Public Property TypeID() As Integer
  Get
   Return _TypeID
  End Get
  Set(ByVal Value As Integer)
   _TypeID = Value
  End Set
 End Property

 Public Property VersionID() As Integer
  Get
   Return _VersionID
  End Get
  Set(ByVal Value As Integer)
   _VersionID = Value
  End Set
 End Property

 Public Property Visibility() As Integer
  Get
   Return _Visibility
  End Get
  Set(ByVal Value As Integer)
   _Visibility = Value
  End Set
 End Property

 Public ReadOnly Property FullId() As String
  Get
   Return (String.Concat(_ProjectCode, "-", _BugID.ToString))
  End Get
 End Property

 Public ReadOnly Property Title() As String
  Get
   Return FullId & ": " & Summary
  End Get
 End Property

 Public Property PriorityName() As String
  Get
   Return _priorityName
  End Get
  Set(ByVal value As String)
   _priorityName = value
  End Set
 End Property

 'Public Property DateCreated() As Date
 ' Get
 '  Return _dateCreated
 ' End Get
 ' Set(ByVal value As Date)
 '  _dateCreated = value
 ' End Set
 'End Property
#End Region

#Region " IHydratable Implementation "

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' Fill hydrates the object from a Datareader
 ''' </summary>
 ''' <remarks>The Fill method is used by the CBO method to hydrtae the object
 ''' rather than using the more expensive Refection  methods.</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub Fill(ByVal dr As IDataReader) Implements IHydratable.Fill

  AssignedToUserName = Convert.ToString(Null.SetNull(dr.Item("AssignedToUserName"), AssignedToUserName))
  BugID = Convert.ToInt32(Null.SetNull(dr.Item("BugID"), BugID))
  ComponentID = Convert.ToInt32(Null.SetNull(dr.Item("ComponentID"), ComponentID))
  Description = Convert.ToString(Null.SetNull(dr.Item("Description"), Description))
  DueDate = Convert.ToDateTime(Null.SetNull(dr.Item("DueDate"), DueDate))
  Estimation = Convert.ToDecimal(Null.SetNull(dr.Item("Estimation"), Estimation))
  FixedInVersionId = Convert.ToInt32(Null.SetNull(dr.Item("FixedInVersionId"), FixedInVersionId))
  LastUpdate = Convert.ToDateTime(Null.SetNull(dr.Item("LastUpdate"), LastUpdate))
  LastUpdateUserName = Convert.ToString(Null.SetNull(dr.Item("LastUpdateUserName"), LastUpdateUserName))
  PriorityID = Convert.ToInt32(Null.SetNull(dr.Item("PriorityID"), PriorityID))
  ProjectID = Convert.ToInt32(Null.SetNull(dr.Item("ProjectID"), ProjectID))
  ReportedDate = Convert.ToDateTime(Null.SetNull(dr.Item("ReportedDate"), ReportedDate))
  ReporterUserName = Convert.ToString(Null.SetNull(dr.Item("ReporterUserName"), ReporterUserName))
  ResolutionID = Convert.ToInt32(Null.SetNull(dr.Item("ResolutionID"), ResolutionID))
  StatusID = Convert.ToInt32(Null.SetNull(dr.Item("StatusID"), StatusID))
  Summary = Convert.ToString(Null.SetNull(dr.Item("Summary"), Summary))
  TypeID = Convert.ToInt32(Null.SetNull(dr.Item("TypeID"), TypeID))
  VersionID = Convert.ToInt32(Null.SetNull(dr.Item("VersionID"), VersionID))
  Visibility = Convert.ToInt32(Null.SetNull(dr.Item("Visibility"), Visibility))

  ComponentName = Convert.ToString(Null.SetNull(dr.Item("ComponentName"), ComponentName))
  StatusName = Convert.ToString(Null.SetNull(dr.Item("StatusName"), StatusName))
  FixedInVersionName = Convert.ToString(Null.SetNull(dr.Item("FixedInVersionName"), FixedInVersionName))
  'PropertyName = Convert.ToString(Null.SetNull(dr.Item("PropertyName"), PropertyName))
  ResolutionName = Convert.ToString(Null.SetNull(dr.Item("ResolutionName"), ResolutionName))
  ProjectName = Convert.ToString(Null.SetNull(dr.Item("ProjectName"), ProjectName))
  ProjectCode = Convert.ToString(Null.SetNull(dr.Item("ProjectCode"), ProjectCode))
  TypeName = Convert.ToString(Null.SetNull(dr.Item("TypeName"), TypeName))
  VersionName = Convert.ToString(Null.SetNull(dr.Item("VersionName"), VersionName))
  'DateCreated = Convert.ToDateTime(Null.SetNull(dr.Item("DateCreated"), DateCreated))
  PriorityName = Convert.ToString(Null.SetNull(dr.Item("PriorityName"), PriorityName))

  'ComponentName
  'StatusName
  'FixedInVersionName
  'PropertyName
  'ResolutionName
  'ProjectName
  'ProjectCode
  'TypeName
  'VersionName

 End Sub
 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' Gets and sets the Key ID
 ''' </summary>
 ''' <remarks>The KeyID property is part of the IHydratble interface.  It is used
 ''' as the key property when creating a Dictionary</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Property KeyID() As Integer Implements Entities.Modules.IHydratable.KeyID
  Get
   Return BugID
  End Get
  Set(ByVal value As Integer)
   BugID = value
  End Set
 End Property

#End Region

#Region " IPropertyAccess Implementation "

 Public Function GetProperty(ByVal strPropertyName As String, ByVal strFormat As String, ByVal formatProvider As System.Globalization.CultureInfo, ByVal AccessingUser As Entities.Users.UserInfo, ByVal AccessLevel As DotNetNuke.Services.Tokens.Scope, ByRef PropertyNotFound As Boolean) As String Implements DotNetNuke.Services.Tokens.IPropertyAccess.GetProperty
  Dim OutputFormat As String = String.Empty
  Dim portalSettings As PortalSettings = PortalController.GetCurrentPortalSettings()
  If strFormat = String.Empty Then
   OutputFormat = "D"
  Else
   OutputFormat = strFormat
  End If
  Select Case strPropertyName.ToLower
   Case "assignedtousername"
    Return PropertyAccess.FormatString(Me.AssignedToUserName, strFormat)
   Case "bugid"
    Return (Me.BugID.ToString(OutputFormat, formatProvider))
   Case "componentid"
    Return (Me.ComponentID.ToString(OutputFormat, formatProvider))
   Case "description"
    Return PropertyAccess.FormatString(Me.Description, strFormat)
   Case "duedate"
    Return (Me.DueDate.ToString(OutputFormat, formatProvider))
   Case "estimation"
    Return (Me.Estimation.ToString(OutputFormat, formatProvider))
   Case "fixedinversionid"
    Return (Me.FixedInVersionId.ToString(OutputFormat, formatProvider))
   Case "lastupdate"
    Return (Me.LastUpdate.ToString(OutputFormat, formatProvider))
   Case "lastupdateusername"
    Return PropertyAccess.FormatString(Me.LastUpdateUserName, strFormat)
   Case "priorityid"
    Return (Me.PriorityID.ToString(OutputFormat, formatProvider))
   Case "projectid"
    Return (Me.ProjectID.ToString(OutputFormat, formatProvider))
   Case "reporteddate"
    Return (Me.ReportedDate.ToString(OutputFormat, formatProvider))
   Case "reporterusername"
    Return PropertyAccess.FormatString(Me.ReporterUserName, strFormat)
   Case "resolutionid"
    Return (Me.ResolutionID.ToString(OutputFormat, formatProvider))
   Case "statusid"
    Return (Me.StatusID.ToString(OutputFormat, formatProvider))
   Case "summary"
    Return PropertyAccess.FormatString(Me.Summary, strFormat)
   Case "typeid"
    Return (Me.TypeID.ToString(OutputFormat, formatProvider))
   Case "versionid"
    Return (Me.VersionID.ToString(OutputFormat, formatProvider))
   Case "visibility"
    Return (Me.Visibility.ToString(OutputFormat, formatProvider))
   Case "componentname"
    Return PropertyAccess.FormatString(Me.ComponentName, strFormat)
   Case "statusname"
    Return PropertyAccess.FormatString(Me.StatusName, strFormat)
   Case "fixedinversionname"
    Return PropertyAccess.FormatString(Me.FixedInVersionName, strFormat)
    'Case "propertyname"
    ' Return PropertyAccess.FormatString(Me.PropertyName, strFormat)
   Case "resolutionname"
    Return PropertyAccess.FormatString(Me.ResolutionName, strFormat)
   Case "projectname"
    Return PropertyAccess.FormatString(Me.ProjectName, strFormat)
   Case "projectcode"
    Return PropertyAccess.FormatString(Me.ProjectCode, strFormat)
   Case "typename"
    Return PropertyAccess.FormatString(Me.TypeName, strFormat)
   Case "versionname"
    Return PropertyAccess.FormatString(Me.VersionName, strFormat)
    'Case "datecreated"
    ' Return (Me.DateCreated.ToString(OutputFormat, formatProvider))
   Case "priorityname"
    Return PropertyAccess.FormatString(Me.PriorityName, strFormat)
   Case Else
    PropertyNotFound = True
  End Select

  Return Null.NullString
 End Function

 Public ReadOnly Property Cacheability() As DotNetNuke.Services.Tokens.CacheLevel Implements DotNetNuke.Services.Tokens.IPropertyAccess.Cacheability
  Get
   Return CacheLevel.fullyCacheable
  End Get
 End Property

#End Region

#Region " IXmlSerializable Implementation "

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' GetSchema returns the XmlSchema for this class
 ''' </summary>
 ''' <remarks>GetSchema is implemented as a stub method as it is not required</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Function GetSchema() As XmlSchema Implements IXmlSerializable.GetSchema
  Return Nothing
 End Function

 Private Function readElement(ByVal reader As XmlReader, ByVal ElementName As String) As String
  If (Not reader.NodeType = XmlNodeType.Element) OrElse reader.Name <> ElementName Then
   reader.ReadToFollowing(ElementName)
  End If
  If reader.NodeType = XmlNodeType.Element Then
   Return reader.ReadElementContentAsString
  Else
   Return ""
  End If
 End Function

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' ReadXml fills the object (de-serializes it) from the XmlReader passed
 ''' </summary>
 ''' <remarks></remarks>
 ''' <param name="reader">The XmlReader that contains the xml for the object</param>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub ReadXml(ByVal reader As XmlReader) Implements IXmlSerializable.ReadXml
  Try

   readElement(reader, "AssignedToUserName")
   If Not Int32.TryParse(readElement(reader, "ComponentID"), ComponentID) Then
    ComponentID = Null.NullInteger
   End If
   Description = readElement(reader, "Description")
   If Not DateTime.TryParse(readElement(reader, "DueDate"), DueDate) Then
    DueDate = DateTime.MinValue
   End If
   Decimal.TryParse(readElement(reader, "Estimation"), Estimation)
   If Not Int32.TryParse(readElement(reader, "FixedInVersionId"), FixedInVersionId) Then
    FixedInVersionId = Null.NullInteger
   End If
   If Not DateTime.TryParse(readElement(reader, "LastUpdate"), LastUpdate) Then
    LastUpdate = DateTime.MinValue
   End If
   readElement(reader, "LastUpdateUserName")
   If Not Int32.TryParse(readElement(reader, "PriorityID"), PriorityID) Then
    PriorityID = Null.NullInteger
   End If
   If Not Int32.TryParse(readElement(reader, "ProjectID"), ProjectID) Then
    ProjectID = Null.NullInteger
   End If
   If Not DateTime.TryParse(readElement(reader, "ReportedDate"), ReportedDate) Then
    ReportedDate = DateTime.MinValue
   End If
   readElement(reader, "ReporterUserName")
   If Not Int32.TryParse(readElement(reader, "ResolutionID"), ResolutionID) Then
    ResolutionID = Null.NullInteger
   End If
   If Not Int32.TryParse(readElement(reader, "StatusID"), StatusID) Then
    StatusID = Null.NullInteger
   End If
   Summary = readElement(reader, "Summary")
   If Not Int32.TryParse(readElement(reader, "TypeID"), TypeID) Then
    TypeID = Null.NullInteger
   End If
   If Not Int32.TryParse(readElement(reader, "VersionID"), VersionID) Then
    VersionID = Null.NullInteger
   End If
   If Not Int32.TryParse(readElement(reader, "Visibility"), Visibility) Then
    Visibility = Null.NullInteger
   End If
   ComponentName = readElement(reader, "ComponentName")
   StatusName = readElement(reader, "StatusName")
   FixedInVersionName = readElement(reader, "FixedInVersionName")
   'PropertyName = readElement(reader, "PropertyName")
   ResolutionName = readElement(reader, "ResolutionName")
   ProjectName = readElement(reader, "ProjectName")
   ProjectCode = readElement(reader, "ProjectCode")
   TypeName = readElement(reader, "TypeName")
   VersionName = readElement(reader, "VersionName")
   'If Not DateTime.TryParse(readElement(reader, "DateCreated"), DateCreated) Then
   ' DateCreated = DateTime.MinValue
   'End If
   PriorityName = readElement(reader, "PriorityName")
  Catch ex As Exception
   ' log exception as DNN import routine does not do that
   DotNetNuke.Services.Exceptions.LogException(ex)
   ' re-raise exception to make sure import routine displays a visible error to the user
   Throw New Exception("An error occured during import of an Bug", ex)
  End Try

 End Sub

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' WriteXml converts the object to Xml (serializes it) and writes it using the XmlWriter passed
 ''' </summary>
 ''' <remarks></remarks>
 ''' <param name="writer">The XmlWriter that contains the xml for the object</param>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub WriteXml(ByVal writer As XmlWriter) Implements IXmlSerializable.WriteXml
  writer.WriteStartElement("Bug")
  writer.WriteElementString("BugID", BugID.ToString())
  writer.WriteElementString("AssignedToUserName", AssignedToUserName.ToString())
  writer.WriteElementString("ComponentID", ComponentID.ToString())
  writer.WriteElementString("Description", Description)
  writer.WriteElementString("DueDate", DueDate.ToString())
  writer.WriteElementString("Estimation", Estimation.ToString())
  writer.WriteElementString("FixedInVersionId", FixedInVersionId.ToString())
  writer.WriteElementString("LastUpdate", LastUpdate.ToString())
  writer.WriteElementString("LastUpdateUserName", LastUpdateUserName.ToString())
  writer.WriteElementString("PriorityID", PriorityID.ToString())
  writer.WriteElementString("ProjectID", ProjectID.ToString())
  writer.WriteElementString("ReportedDate", ReportedDate.ToString())
  writer.WriteElementString("ReporterUserName", ReporterUserName.ToString())
  writer.WriteElementString("ResolutionID", ResolutionID.ToString())
  writer.WriteElementString("StatusID", StatusID.ToString())
  writer.WriteElementString("Summary", Summary)
  writer.WriteElementString("TypeID", TypeID.ToString())
  writer.WriteElementString("VersionID", VersionID.ToString())
  writer.WriteElementString("Visibility", Visibility.ToString())
  writer.WriteElementString("ComponentName", ComponentName)
  writer.WriteElementString("StatusName", StatusName)
  writer.WriteElementString("FixedInVersionName", FixedInVersionName)
  'writer.WriteElementString("PropertyName", PropertyName)
  writer.WriteElementString("ResolutionName", ResolutionName)
  writer.WriteElementString("ProjectName", ProjectName)
  writer.WriteElementString("ProjectCode", ProjectCode)
  writer.WriteElementString("TypeName", TypeName)
  writer.WriteElementString("VersionName", VersionName)
  'writer.WriteElementString("DateCreated", DateCreated.ToString)
  writer.WriteElementString("PriorityName", PriorityName)
  writer.WriteEndElement()
 End Sub

#End Region

End Class

