Imports System
Imports System.Data
Imports System.Xml
Imports System.Xml.Schema
Imports System.Xml.Serialization
Imports System.Text

Imports DotNetNuke
Imports DotNetNuke.Common.Utilities
Imports DotNetNuke.Entities.Modules
Imports DotNetNuke.Entities.Portals
Imports DotNetNuke.Services.Tokens

Imports BugNET.DNN.Library.Data

#Region " BugAttachmentInfo "
<Serializable(), XmlRoot("BugAttachment")> _
Public Class BugAttachmentInfo
 Implements IHydratable
 Implements IPropertyAccess
 Implements IXmlSerializable

 ' local property declarations
 Private _BugAttachmentID As Integer
 Private _BugID As Integer
 Private _Description As String
 Private _FileName As String
 Private _FileSize As Integer
 Private _Type As String
 Private _UploadedDate As Date
 Private _UploadedUserName As String

#Region " Constructors "
 Public Sub New()
 End Sub

 Public Sub New(ByVal BugAttachmentID As Integer, ByVal BugID As Integer, ByVal Description As String, ByVal FileName As String, ByVal FileSize As Integer, ByVal Type As String, ByVal UploadedDate As Date, ByVal UploadedUserName As String)
  Me.BugAttachmentID = BugAttachmentID
  Me.BugID = BugID
  Me.Description = Description
  Me.FileName = FileName
  Me.FileSize = FileSize
  Me.Type = Type
  Me.UploadedDate = UploadedDate
  Me.UploadedUserName = UploadedUserName
 End Sub
#End Region

#Region " Public Properties "

 Public Property BugAttachmentID() As Integer
  Get
   Return _BugAttachmentID
  End Get
  Set(ByVal Value As Integer)
   _BugAttachmentID = Value
  End Set
 End Property

 Public Property BugID() As Integer
  Get
   Return _BugID
  End Get
  Set(ByVal Value As Integer)
   _BugID = Value
  End Set
 End Property

 Public Property Description() As String
  Get
   Return _Description
  End Get
  Set(ByVal Value As String)
   _Description = Value
  End Set
 End Property

 Public Property FileName() As String
  Get
   Return _FileName
  End Get
  Set(ByVal Value As String)
   _FileName = Value
  End Set
 End Property

 Public Property FileSize() As Integer
  Get
   Return _FileSize
  End Get
  Set(ByVal Value As Integer)
   _FileSize = Value
  End Set
 End Property

 Public Property Type() As String
  Get
   Return _Type
  End Get
  Set(ByVal Value As String)
   _Type = Value
  End Set
 End Property

 Public Property UploadedDate() As Date
  Get
   Return _UploadedDate
  End Get
  Set(ByVal Value As Date)
   _UploadedDate = Value
  End Set
 End Property

 Public Property UploadedUserName() As String
  Get
   Return _UploadedUserName
  End Get
  Set(ByVal Value As String)
   _UploadedUserName = Value
  End Set
 End Property

#End Region

#Region " IHydratable Implementation "

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' Fill hydrates the object from a Datareader
 ''' </summary>
 ''' <remarks>The Fill method is used by the CBO method to hydrtae the object
 ''' rather than using the more expensive Refection  methods.</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub Fill(ByVal dr As IDataReader) Implements IHydratable.Fill

  BugAttachmentID = Convert.ToInt32(Null.SetNull(dr.Item("BugAttachmentID"), BugAttachmentID))
  BugID = Convert.ToInt32(Null.SetNull(dr.Item("BugID"), BugID))
  Description = Convert.ToString(Null.SetNull(dr.Item("Description"), Description))
  FileName = Convert.ToString(Null.SetNull(dr.Item("FileName"), FileName))
  FileSize = Convert.ToInt32(Null.SetNull(dr.Item("FileSize"), FileSize))
  Type = Convert.ToString(Null.SetNull(dr.Item("Type"), Type))
  UploadedDate = Convert.ToDateTime(Null.SetNull(dr.Item("UploadedDate"), UploadedDate))
  UploadedUserName = Convert.ToString(Null.SetNull(dr.Item("UploadedUserName"), UploadedUserName))

 End Sub
 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' Gets and sets the Key ID
 ''' </summary>
 ''' <remarks>The KeyID property is part of the IHydratble interface.  It is used
 ''' as the key property when creating a Dictionary</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Property KeyID() As Integer Implements Entities.Modules.IHydratable.KeyID
  Get
   Return BugAttachmentID
  End Get
  Set(ByVal value As Integer)
   BugAttachmentID = value
  End Set
 End Property

#End Region

#Region " IPropertyAccess Implementation "

 Public Function GetProperty(ByVal strPropertyName As String, ByVal strFormat As String, ByVal formatProvider As System.Globalization.CultureInfo, ByVal AccessingUser As Entities.Users.UserInfo, ByVal AccessLevel As DotNetNuke.Services.Tokens.Scope, ByRef PropertyNotFound As Boolean) As String Implements DotNetNuke.Services.Tokens.IPropertyAccess.GetProperty
  Dim OutputFormat As String = String.Empty
  Dim portalSettings As PortalSettings = PortalController.GetCurrentPortalSettings()
  If strFormat = String.Empty Then
   OutputFormat = "D"
  Else
   OutputFormat = strFormat
  End If
  Select Case strPropertyName.ToLower
   Case "bugattachmentid"
    Return (Me.BugAttachmentID.ToString(OutputFormat, formatProvider))
   Case "bugid"
    Return (Me.BugID.ToString(OutputFormat, formatProvider))
   Case "description"
    Return PropertyAccess.FormatString(Me.Description, strFormat)
   Case "filename"
    Return PropertyAccess.FormatString(Me.FileName, strFormat)
   Case "filesize"
    Return (Me.FileSize.ToString(OutputFormat, formatProvider))
   Case "type"
    Return PropertyAccess.FormatString(Me.Type, strFormat)
   Case "uploadeddate"
    Return (Me.UploadedDate.ToString(OutputFormat, formatProvider))
   Case "uploadedUserName"
    Return PropertyAccess.FormatString(Me.UploadedUserName, strFormat)
   Case Else
    PropertyNotFound = True
  End Select

  Return Null.NullString
 End Function

 Public ReadOnly Property Cacheability() As DotNetNuke.Services.Tokens.CacheLevel Implements DotNetNuke.Services.Tokens.IPropertyAccess.Cacheability
  Get
   Return CacheLevel.fullyCacheable
  End Get
 End Property

#End Region

#Region " IXmlSerializable Implementation "

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' GetSchema returns the XmlSchema for this class
 ''' </summary>
 ''' <remarks>GetSchema is implemented as a stub method as it is not required</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Function GetSchema() As XmlSchema Implements IXmlSerializable.GetSchema
  Return Nothing
 End Function

 Private Function readElement(ByVal reader As XmlReader, ByVal ElementName As String) As String
  If (Not reader.NodeType = XmlNodeType.Element) OrElse reader.Name <> ElementName Then
   reader.ReadToFollowing(ElementName)
  End If
  If reader.NodeType = XmlNodeType.Element Then
   Return reader.ReadElementContentAsString
  Else
   Return ""
  End If
 End Function

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' ReadXml fills the object (de-serializes it) from the XmlReader passed
 ''' </summary>
 ''' <remarks></remarks>
 ''' <param name="reader">The XmlReader that contains the xml for the object</param>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub ReadXml(ByVal reader As XmlReader) Implements IXmlSerializable.ReadXml
  Try

   If Not Int32.TryParse(readElement(reader, "BugID"), BugID) Then
    BugID = Null.NullInteger
   End If
   Description = readElement(reader, "Description")
   FileName = readElement(reader, "FileName")
   If Not Int32.TryParse(readElement(reader, "FileSize"), FileSize) Then
    FileSize = Null.NullInteger
   End If
   Type = readElement(reader, "Type")
   If Not DateTime.TryParse(readElement(reader, "UploadedDate"), UploadedDate) Then
    UploadedDate = DateTime.MinValue
   End If
   readElement(reader, "UploadedUserName")
  Catch ex As Exception
   ' log exception as DNN import routine does not do that
   DotNetNuke.Services.Exceptions.LogException(ex)
   ' re-raise exception to make sure import routine displays a visible error to the user
   Throw New Exception("An error occured during import of an BugAttachment", ex)
  End Try

 End Sub

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' WriteXml converts the object to Xml (serializes it) and writes it using the XmlWriter passed
 ''' </summary>
 ''' <remarks></remarks>
 ''' <param name="writer">The XmlWriter that contains the xml for the object</param>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub WriteXml(ByVal writer As XmlWriter) Implements IXmlSerializable.WriteXml
  writer.WriteStartElement("BugAttachment")
  writer.WriteElementString("BugAttachmentID", BugAttachmentID.ToString())
  writer.WriteElementString("BugID", BugID.ToString())
  writer.WriteElementString("Description", Description)
  writer.WriteElementString("FileName", FileName)
  writer.WriteElementString("FileSize", FileSize.ToString())
  writer.WriteElementString("Type", Type)
  writer.WriteElementString("UploadedDate", UploadedDate.ToString())
  writer.WriteElementString("UploadedUserName", UploadedUserName.ToString())
  writer.WriteEndElement()
 End Sub

#End Region

#Region " ToXml Methods "
 Public Function ToXml() As String
  Return ToXml("BugAttachment")
 End Function

 Public Function ToXml(ByVal elementName As String) As String
  Dim xml As New StringBuilder
  xml.Append("<")
  xml.Append(elementName)
  'Add Attribute(xml, "BugAttachmentID", BugAttachmentID.ToString())
  'Add Attribute(xml, "BugID", BugID.ToString())
  'Add Attribute(xml, "Description", Description)
  'Add Attribute(xml, "FileName", FileName)
  'Add Attribute(xml, "FileSize", FileSize.ToString())
  'Add Attribute(xml, "Type", Type)
  'Add Attribute(xml, "UploadedDate", UploadedDate.ToString())
  'Add Attribute(xml, "UploadedUserName", UploadedUserName.ToString())
  xml.Append(" />")
  Return xml.ToString
 End Function
#End Region

End Class
#End Region

#Region " BugAttachmentsController "
Public Class BugAttachmentsController

 Public Shared Function GetBugAttachment(ByVal BugAttachmentID As Integer) As BugAttachmentInfo

  Return CType(CBO.FillObject(DataProvider.Instance().GetBugAttachment(BugAttachmentID), GetType(BugAttachmentInfo)), BugAttachmentInfo)

 End Function

 Public Shared Function AddBugAttachment(ByVal objBugAttachment As BugAttachmentInfo) As Integer

  Return CType(DataProvider.Instance().AddBugAttachment(objBugAttachment.BugID, objBugAttachment.Description, objBugAttachment.FileName, objBugAttachment.FileSize, objBugAttachment.Type, objBugAttachment.UploadedDate, objBugAttachment.UploadedUserName), Integer)

 End Function

 Public Shared Sub UpdateBugAttachment(ByVal objBugAttachment As BugAttachmentInfo)

  DataProvider.Instance().UpdateBugAttachment(objBugAttachment.BugAttachmentID, objBugAttachment.BugID, objBugAttachment.Description, objBugAttachment.FileName, objBugAttachment.FileSize, objBugAttachment.Type, objBugAttachment.UploadedDate, objBugAttachment.UploadedUserName)
	
 End Sub

 Public Shared Sub DeleteBugAttachment(ByVal BugAttachmentID As Integer)

  DataProvider.Instance().DeleteBugAttachment(BugAttachmentID)

 End Sub

End Class
#End Region


#Region " BugCommentInfo "
<Serializable(), XmlRoot("BugComment")> _
Public Class BugCommentInfo
 Implements IHydratable
 Implements IPropertyAccess
 Implements IXmlSerializable

 ' local property declarations
 Private _BugCommentID As Integer
 Private _BugID As Integer
 Private _Comment As String
 Private _CreatedDate As Date
 Private _CreatedUserName As String

#Region " Constructors "
 Public Sub New()
 End Sub

 Public Sub New(ByVal BugCommentID As Integer, ByVal BugID As Integer, ByVal Comment As String, ByVal CreatedDate As Date, ByVal CreatedUserName As String)
  Me.BugCommentID = BugCommentID
  Me.BugID = BugID
  Me.Comment = Comment
  Me.CreatedDate = CreatedDate
  Me.CreatedUserName = CreatedUserName
 End Sub
#End Region

#Region " Public Properties "

 Public Property BugCommentID() As Integer
  Get
   Return _BugCommentID
  End Get
  Set(ByVal Value As Integer)
   _BugCommentID = Value
  End Set
 End Property

 Public Property BugID() As Integer
  Get
   Return _BugID
  End Get
  Set(ByVal Value As Integer)
   _BugID = Value
  End Set
 End Property

 Public Property Comment() As String
  Get
   Return _Comment
  End Get
  Set(ByVal Value As String)
   _Comment = Value
  End Set
 End Property

 Public Property CreatedDate() As Date
  Get
   Return _CreatedDate
  End Get
  Set(ByVal Value As Date)
   _CreatedDate = Value
  End Set
 End Property

 Public Property CreatedUserName() As String
  Get
   Return _CreatedUserName
  End Get
  Set(ByVal Value As String)
   _CreatedUserName = Value
  End Set
 End Property

#End Region

#Region " IHydratable Implementation "

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' Fill hydrates the object from a Datareader
 ''' </summary>
 ''' <remarks>The Fill method is used by the CBO method to hydrtae the object
 ''' rather than using the more expensive Refection  methods.</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub Fill(ByVal dr As IDataReader) Implements IHydratable.Fill

  BugCommentID = Convert.ToInt32(Null.SetNull(dr.Item("BugCommentID"), BugCommentID))
  BugID = Convert.ToInt32(Null.SetNull(dr.Item("BugID"), BugID))
  Comment = Convert.ToString(Null.SetNull(dr.Item("Comment"), Comment))
  CreatedDate = Convert.ToDateTime(Null.SetNull(dr.Item("CreatedDate"), CreatedDate))
  CreatedUserName = Convert.ToString(Null.SetNull(dr.Item("CreatedUserName"), CreatedUserName))

 End Sub
 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' Gets and sets the Key ID
 ''' </summary>
 ''' <remarks>The KeyID property is part of the IHydratble interface.  It is used
 ''' as the key property when creating a Dictionary</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Property KeyID() As Integer Implements Entities.Modules.IHydratable.KeyID
  Get
   Return BugCommentID
  End Get
  Set(ByVal value As Integer)
   BugCommentID = value
  End Set
 End Property

#End Region

#Region " IPropertyAccess Implementation "

 Public Function GetProperty(ByVal strPropertyName As String, ByVal strFormat As String, ByVal formatProvider As System.Globalization.CultureInfo, ByVal AccessingUser As Entities.Users.UserInfo, ByVal AccessLevel As DotNetNuke.Services.Tokens.Scope, ByRef PropertyNotFound As Boolean) As String Implements DotNetNuke.Services.Tokens.IPropertyAccess.GetProperty
  Dim OutputFormat As String = String.Empty
  Dim portalSettings As PortalSettings = PortalController.GetCurrentPortalSettings()
  If strFormat = String.Empty Then
   OutputFormat = "D"
  Else
   OutputFormat = strFormat
  End If
  Select Case strPropertyName.ToLower
   Case "bugcommentid"
    Return (Me.BugCommentID.ToString(OutputFormat, formatProvider))
   Case "bugid"
    Return (Me.BugID.ToString(OutputFormat, formatProvider))
   Case "comment"
    Return PropertyAccess.FormatString(Me.Comment, strFormat)
   Case "createddate"
    Return (Me.CreatedDate.ToString(OutputFormat, formatProvider))
   Case "createdusername"
    Return PropertyAccess.FormatString(Me.CreatedUserName, strFormat)
   Case Else
    PropertyNotFound = True
  End Select

  Return Null.NullString
 End Function

 Public ReadOnly Property Cacheability() As DotNetNuke.Services.Tokens.CacheLevel Implements DotNetNuke.Services.Tokens.IPropertyAccess.Cacheability
  Get
   Return CacheLevel.fullyCacheable
  End Get
 End Property

#End Region

#Region " IXmlSerializable Implementation "

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' GetSchema returns the XmlSchema for this class
 ''' </summary>
 ''' <remarks>GetSchema is implemented as a stub method as it is not required</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Function GetSchema() As XmlSchema Implements IXmlSerializable.GetSchema
  Return Nothing
 End Function

 Private Function readElement(ByVal reader As XmlReader, ByVal ElementName As String) As String
  If (Not reader.NodeType = XmlNodeType.Element) OrElse reader.Name <> ElementName Then
   reader.ReadToFollowing(ElementName)
  End If
  If reader.NodeType = XmlNodeType.Element Then
   Return reader.ReadElementContentAsString
  Else
   Return ""
  End If
 End Function

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' ReadXml fills the object (de-serializes it) from the XmlReader passed
 ''' </summary>
 ''' <remarks></remarks>
 ''' <param name="reader">The XmlReader that contains the xml for the object</param>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub ReadXml(ByVal reader As XmlReader) Implements IXmlSerializable.ReadXml
  Try

   If Not Int32.TryParse(readElement(reader, "BugID"), BugID) Then
    BugID = Null.NullInteger
   End If
   Comment = readElement(reader, "Comment")
   If Not DateTime.TryParse(readElement(reader, "CreatedDate"), CreatedDate) Then
    CreatedDate = DateTime.MinValue
   End If
   readElement(reader, "CreatedUserName")
  Catch ex As Exception
   ' log exception as DNN import routine does not do that
   DotNetNuke.Services.Exceptions.LogException(ex)
   ' re-raise exception to make sure import routine displays a visible error to the user
   Throw New Exception("An error occured during import of an BugComment", ex)
  End Try

 End Sub

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' WriteXml converts the object to Xml (serializes it) and writes it using the XmlWriter passed
 ''' </summary>
 ''' <remarks></remarks>
 ''' <param name="writer">The XmlWriter that contains the xml for the object</param>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub WriteXml(ByVal writer As XmlWriter) Implements IXmlSerializable.WriteXml
  writer.WriteStartElement("BugComment")
  writer.WriteElementString("BugCommentID", BugCommentID.ToString())
  writer.WriteElementString("BugID", BugID.ToString())
  writer.WriteElementString("Comment", Comment)
  writer.WriteElementString("CreatedDate", CreatedDate.ToString())
  writer.WriteElementString("CreatedUserName", CreatedUserName.ToString())
  writer.WriteEndElement()
 End Sub

#End Region

#Region " ToXml Methods "
 Public Function ToXml() As String
  Return ToXml("BugComment")
 End Function

 Public Function ToXml(ByVal elementName As String) As String
  Dim xml As New StringBuilder
  xml.Append("<")
  xml.Append(elementName)
  'Add Attribute(xml, "BugCommentID", BugCommentID.ToString())
  'Add Attribute(xml, "BugID", BugID.ToString())
  'Add Attribute(xml, "Comment", Comment)
  'Add Attribute(xml, "CreatedDate", CreatedDate.ToString())
  'Add Attribute(xml, "CreatedUserName", CreatedUserName.ToString())
  xml.Append(" />")
  Return xml.ToString
 End Function
#End Region

End Class
#End Region

#Region " BugCommentsController "
Public Class BugCommentsController

 Public Shared Function GetBugComment(ByVal BugCommentID As Integer) As BugCommentInfo

  Return CType(CBO.FillObject(DataProvider.Instance().GetBugComment(BugCommentID), GetType(BugCommentInfo)), BugCommentInfo)

 End Function

 Public Shared Function AddBugComment(ByVal objBugComment As BugCommentInfo) As Integer

  Return CType(DataProvider.Instance().AddBugComment(objBugComment.BugID, objBugComment.Comment, objBugComment.CreatedDate, objBugComment.CreatedUserName), Integer)

 End Function

 Public Shared Sub UpdateBugComment(ByVal objBugComment As BugCommentInfo)

  DataProvider.Instance().UpdateBugComment(objBugComment.BugCommentID, objBugComment.BugID, objBugComment.Comment, objBugComment.CreatedDate, objBugComment.CreatedUserName)
	
 End Sub

 Public Shared Sub DeleteBugComment(ByVal BugCommentID As Integer)

  DataProvider.Instance().DeleteBugComment(BugCommentID)

 End Sub

End Class
#End Region


#Region " BugHistoryInfo "
<Serializable(), XmlRoot("BugHistory")> _
Public Class BugHistoryInfo
 Implements IHydratable
 Implements IPropertyAccess
 Implements IXmlSerializable

 ' local property declarations
 Private _BugHistoryID As Integer
 Private _BugID As Integer
 Private _CreatedDate As Date
 Private _CreatedUserName As String
 Private _FieldChanged As String
 Private _NewValue As String
 Private _OldValue As String

#Region " Constructors "
 Public Sub New()
 End Sub

 Public Sub New(ByVal BugHistoryID As Integer, ByVal BugID As Integer, ByVal CreatedDate As Date, ByVal CreatedUserName As String, ByVal FieldChanged As String, ByVal NewValue As String, ByVal OldValue As String)
  Me.BugHistoryID = BugHistoryID
  Me.BugID = BugID
  Me.CreatedDate = CreatedDate
  Me.CreatedUserName = CreatedUserName
  Me.FieldChanged = FieldChanged
  Me.NewValue = NewValue
  Me.OldValue = OldValue
 End Sub
#End Region

#Region " Public Properties "

 Public Property BugHistoryID() As Integer
  Get
   Return _BugHistoryID
  End Get
  Set(ByVal Value As Integer)
   _BugHistoryID = Value
  End Set
 End Property

 Public Property BugID() As Integer
  Get
   Return _BugID
  End Get
  Set(ByVal Value As Integer)
   _BugID = Value
  End Set
 End Property

 Public Property CreatedDate() As Date
  Get
   Return _CreatedDate
  End Get
  Set(ByVal Value As Date)
   _CreatedDate = Value
  End Set
 End Property

 Public Property CreatedUserName() As String
  Get
   Return _CreatedUserName
  End Get
  Set(ByVal Value As String)
   _CreatedUserName = Value
  End Set
 End Property

 Public Property FieldChanged() As String
  Get
   Return _FieldChanged
  End Get
  Set(ByVal Value As String)
   _FieldChanged = Value
  End Set
 End Property

 Public Property NewValue() As String
  Get
   Return _NewValue
  End Get
  Set(ByVal Value As String)
   _NewValue = Value
  End Set
 End Property

 Public Property OldValue() As String
  Get
   Return _OldValue
  End Get
  Set(ByVal Value As String)
   _OldValue = Value
  End Set
 End Property

#End Region

#Region " IHydratable Implementation "

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' Fill hydrates the object from a Datareader
 ''' </summary>
 ''' <remarks>The Fill method is used by the CBO method to hydrtae the object
 ''' rather than using the more expensive Refection  methods.</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub Fill(ByVal dr As IDataReader) Implements IHydratable.Fill

  BugHistoryID = Convert.ToInt32(Null.SetNull(dr.Item("BugHistoryID"), BugHistoryID))
  BugID = Convert.ToInt32(Null.SetNull(dr.Item("BugID"), BugID))
  CreatedDate = Convert.ToDateTime(Null.SetNull(dr.Item("CreatedDate"), CreatedDate))
  CreatedUserName = Convert.ToString(Null.SetNull(dr.Item("CreatedUserName"), CreatedUserName))
  FieldChanged = Convert.ToString(Null.SetNull(dr.Item("FieldChanged"), FieldChanged))
  NewValue = Convert.ToString(Null.SetNull(dr.Item("NewValue"), NewValue))
  OldValue = Convert.ToString(Null.SetNull(dr.Item("OldValue"), OldValue))

 End Sub
 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' Gets and sets the Key ID
 ''' </summary>
 ''' <remarks>The KeyID property is part of the IHydratble interface.  It is used
 ''' as the key property when creating a Dictionary</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Property KeyID() As Integer Implements Entities.Modules.IHydratable.KeyID
  Get
   Return BugHistoryID
  End Get
  Set(ByVal value As Integer)
   BugHistoryID = value
  End Set
 End Property

#End Region

#Region " IPropertyAccess Implementation "

 Public Function GetProperty(ByVal strPropertyName As String, ByVal strFormat As String, ByVal formatProvider As System.Globalization.CultureInfo, ByVal AccessingUser As Entities.Users.UserInfo, ByVal AccessLevel As DotNetNuke.Services.Tokens.Scope, ByRef PropertyNotFound As Boolean) As String Implements DotNetNuke.Services.Tokens.IPropertyAccess.GetProperty
  Dim OutputFormat As String = String.Empty
  Dim portalSettings As PortalSettings = PortalController.GetCurrentPortalSettings()
  If strFormat = String.Empty Then
   OutputFormat = "D"
  Else
   OutputFormat = strFormat
  End If
  Select Case strPropertyName.ToLower
   Case "bughistoryid"
    Return (Me.BugHistoryID.ToString(OutputFormat, formatProvider))
   Case "bugid"
    Return (Me.BugID.ToString(OutputFormat, formatProvider))
   Case "createddate"
    Return (Me.CreatedDate.ToString(OutputFormat, formatProvider))
   Case "createdusername"
    Return PropertyAccess.FormatString(Me.CreatedUserName, strFormat)
   Case "fieldchanged"
    Return PropertyAccess.FormatString(Me.FieldChanged, strFormat)
   Case "newvalue"
    Return PropertyAccess.FormatString(Me.NewValue, strFormat)
   Case "oldvalue"
    Return PropertyAccess.FormatString(Me.OldValue, strFormat)
   Case Else
    PropertyNotFound = True
  End Select

  Return Null.NullString
 End Function

 Public ReadOnly Property Cacheability() As DotNetNuke.Services.Tokens.CacheLevel Implements DotNetNuke.Services.Tokens.IPropertyAccess.Cacheability
  Get
   Return CacheLevel.fullyCacheable
  End Get
 End Property

#End Region

#Region " IXmlSerializable Implementation "

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' GetSchema returns the XmlSchema for this class
 ''' </summary>
 ''' <remarks>GetSchema is implemented as a stub method as it is not required</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Function GetSchema() As XmlSchema Implements IXmlSerializable.GetSchema
  Return Nothing
 End Function

 Private Function readElement(ByVal reader As XmlReader, ByVal ElementName As String) As String
  If (Not reader.NodeType = XmlNodeType.Element) OrElse reader.Name <> ElementName Then
   reader.ReadToFollowing(ElementName)
  End If
  If reader.NodeType = XmlNodeType.Element Then
   Return reader.ReadElementContentAsString
  Else
   Return ""
  End If
 End Function

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' ReadXml fills the object (de-serializes it) from the XmlReader passed
 ''' </summary>
 ''' <remarks></remarks>
 ''' <param name="reader">The XmlReader that contains the xml for the object</param>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub ReadXml(ByVal reader As XmlReader) Implements IXmlSerializable.ReadXml
  Try

   If Not Int32.TryParse(readElement(reader, "BugID"), BugID) Then
    BugID = Null.NullInteger
   End If
   If Not DateTime.TryParse(readElement(reader, "CreatedDate"), CreatedDate) Then
    CreatedDate = DateTime.MinValue
   End If
   readElement(reader, "CreatedUserName")
   FieldChanged = readElement(reader, "FieldChanged")
   NewValue = readElement(reader, "NewValue")
   OldValue = readElement(reader, "OldValue")
  Catch ex As Exception
   ' log exception as DNN import routine does not do that
   DotNetNuke.Services.Exceptions.LogException(ex)
   ' re-raise exception to make sure import routine displays a visible error to the user
   Throw New Exception("An error occured during import of an BugHistory", ex)
  End Try

 End Sub

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' WriteXml converts the object to Xml (serializes it) and writes it using the XmlWriter passed
 ''' </summary>
 ''' <remarks></remarks>
 ''' <param name="writer">The XmlWriter that contains the xml for the object</param>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub WriteXml(ByVal writer As XmlWriter) Implements IXmlSerializable.WriteXml
  writer.WriteStartElement("BugHistory")
  writer.WriteElementString("BugHistoryID", BugHistoryID.ToString())
  writer.WriteElementString("BugID", BugID.ToString())
  writer.WriteElementString("CreatedDate", CreatedDate.ToString())
  writer.WriteElementString("CreatedUserName", CreatedUserName.ToString())
  writer.WriteElementString("FieldChanged", FieldChanged)
  writer.WriteElementString("NewValue", NewValue)
  writer.WriteElementString("OldValue", OldValue)
  writer.WriteEndElement()
 End Sub

#End Region

#Region " ToXml Methods "
 Public Function ToXml() As String
  Return ToXml("BugHistory")
 End Function

 Public Function ToXml(ByVal elementName As String) As String
  Dim xml As New StringBuilder
  xml.Append("<")
  xml.Append(elementName)
  'Add Attribute(xml, "BugHistoryID", BugHistoryID.ToString())
  'Add Attribute(xml, "BugID", BugID.ToString())
  'Add Attribute(xml, "CreatedDate", CreatedDate.ToString())
  'Add Attribute(xml, "CreatedUserName", CreatedUserName.ToString())
  'Add Attribute(xml, "FieldChanged", FieldChanged)
  'Add Attribute(xml, "NewValue", NewValue)
  'Add Attribute(xml, "OldValue", OldValue)
  xml.Append(" />")
  Return xml.ToString
 End Function
#End Region

End Class
#End Region

#Region " BugHistoriesController "
Public Class BugHistoriesController

 Public Shared Function GetBugHistory(ByVal BugHistoryID As Integer) As BugHistoryInfo

  Return CType(CBO.FillObject(DataProvider.Instance().GetBugHistory(BugHistoryID), GetType(BugHistoryInfo)), BugHistoryInfo)

 End Function

 Public Shared Function AddBugHistory(ByVal objBugHistory As BugHistoryInfo) As Integer

  Return CType(DataProvider.Instance().AddBugHistory(objBugHistory.BugID, objBugHistory.CreatedDate, objBugHistory.CreatedUserName, objBugHistory.FieldChanged, objBugHistory.NewValue, objBugHistory.OldValue), Integer)

 End Function

 Public Shared Sub UpdateBugHistory(ByVal objBugHistory As BugHistoryInfo)

  DataProvider.Instance().UpdateBugHistory(objBugHistory.BugHistoryID, objBugHistory.BugID, objBugHistory.CreatedDate, objBugHistory.CreatedUserName, objBugHistory.FieldChanged, objBugHistory.NewValue, objBugHistory.OldValue)
	
 End Sub

 Public Shared Sub DeleteBugHistory(ByVal BugHistoryID As Integer)

  DataProvider.Instance().DeleteBugHistory(BugHistoryID)

 End Sub

End Class
#End Region


#Region " BugNotificationInfo "
<Serializable(), XmlRoot("BugNotification")> _
Public Class BugNotificationInfo
 Implements IHydratable
 Implements IPropertyAccess
 Implements IXmlSerializable

 ' local property declarations
 Private _BugNotificationID As Integer
 Private _BugID As Integer
 Private _CreatedUserName As String

#Region " Constructors "
 Public Sub New()
 End Sub

 Public Sub New(ByVal BugNotificationID As Integer, ByVal BugID As Integer, ByVal CreatedUserName As String)
  Me.BugID = BugID
  Me.BugNotificationID = BugNotificationID
  Me.CreatedUserName = CreatedUserName
 End Sub
#End Region

#Region " Public Properties "

 Public Property BugNotificationID() As Integer
  Get
   Return _BugNotificationID
  End Get
  Set(ByVal Value As Integer)
   _BugNotificationID = Value
  End Set
 End Property

 Public Property BugID() As Integer
  Get
   Return _BugID
  End Get
  Set(ByVal Value As Integer)
   _BugID = Value
  End Set
 End Property

 Public Property CreatedUserName() As String
  Get
   Return _CreatedUserName
  End Get
  Set(ByVal Value As String)
   _CreatedUserName = Value
  End Set
 End Property

#End Region

#Region " IHydratable Implementation "

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' Fill hydrates the object from a Datareader
 ''' </summary>
 ''' <remarks>The Fill method is used by the CBO method to hydrtae the object
 ''' rather than using the more expensive Refection  methods.</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub Fill(ByVal dr As IDataReader) Implements IHydratable.Fill

  BugID = Convert.ToInt32(Null.SetNull(dr.Item("BugID"), BugID))
  BugNotificationID = Convert.ToInt32(Null.SetNull(dr.Item("BugNotificationID"), BugNotificationID))
  CreatedUserName = Convert.ToString(Null.SetNull(dr.Item("CreatedUserName"), CreatedUserName))

 End Sub
 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' Gets and sets the Key ID
 ''' </summary>
 ''' <remarks>The KeyID property is part of the IHydratble interface.  It is used
 ''' as the key property when creating a Dictionary</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Property KeyID() As Integer Implements Entities.Modules.IHydratable.KeyID
  Get
   Return BugNotificationID
  End Get
  Set(ByVal value As Integer)
   BugNotificationID = value
  End Set
 End Property

#End Region

#Region " IPropertyAccess Implementation "

 Public Function GetProperty(ByVal strPropertyName As String, ByVal strFormat As String, ByVal formatProvider As System.Globalization.CultureInfo, ByVal AccessingUser As Entities.Users.UserInfo, ByVal AccessLevel As DotNetNuke.Services.Tokens.Scope, ByRef PropertyNotFound As Boolean) As String Implements DotNetNuke.Services.Tokens.IPropertyAccess.GetProperty
  Dim OutputFormat As String = String.Empty
  Dim portalSettings As PortalSettings = PortalController.GetCurrentPortalSettings()
  If strFormat = String.Empty Then
   OutputFormat = "D"
  Else
   OutputFormat = strFormat
  End If
  Select Case strPropertyName.ToLower
   Case "bugid"
    Return (Me.BugID.ToString(OutputFormat, formatProvider))
   Case "bugnotificationid"
    Return (Me.BugNotificationID.ToString(OutputFormat, formatProvider))
   Case "createdusername"
    Return PropertyAccess.FormatString(Me.CreatedUserName, strFormat)
   Case Else
    PropertyNotFound = True
  End Select

  Return Null.NullString
 End Function

 Public ReadOnly Property Cacheability() As DotNetNuke.Services.Tokens.CacheLevel Implements DotNetNuke.Services.Tokens.IPropertyAccess.Cacheability
  Get
   Return CacheLevel.fullyCacheable
  End Get
 End Property

#End Region

#Region " IXmlSerializable Implementation "

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' GetSchema returns the XmlSchema for this class
 ''' </summary>
 ''' <remarks>GetSchema is implemented as a stub method as it is not required</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Function GetSchema() As XmlSchema Implements IXmlSerializable.GetSchema
  Return Nothing
 End Function

 Private Function readElement(ByVal reader As XmlReader, ByVal ElementName As String) As String
  If (Not reader.NodeType = XmlNodeType.Element) OrElse reader.Name <> ElementName Then
   reader.ReadToFollowing(ElementName)
  End If
  If reader.NodeType = XmlNodeType.Element Then
   Return reader.ReadElementContentAsString
  Else
   Return ""
  End If
 End Function

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' ReadXml fills the object (de-serializes it) from the XmlReader passed
 ''' </summary>
 ''' <remarks></remarks>
 ''' <param name="reader">The XmlReader that contains the xml for the object</param>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub ReadXml(ByVal reader As XmlReader) Implements IXmlSerializable.ReadXml
  Try

   If Not Int32.TryParse(readElement(reader, "BugID"), BugID) Then
    BugID = Null.NullInteger
   End If
   readElement(reader, "CreatedUserName")
  Catch ex As Exception
   ' log exception as DNN import routine does not do that
   DotNetNuke.Services.Exceptions.LogException(ex)
   ' re-raise exception to make sure import routine displays a visible error to the user
   Throw New Exception("An error occured during import of an BugNotification", ex)
  End Try

 End Sub

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' WriteXml converts the object to Xml (serializes it) and writes it using the XmlWriter passed
 ''' </summary>
 ''' <remarks></remarks>
 ''' <param name="writer">The XmlWriter that contains the xml for the object</param>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub WriteXml(ByVal writer As XmlWriter) Implements IXmlSerializable.WriteXml
  writer.WriteStartElement("BugNotification")
  writer.WriteElementString("BugNotificationID", BugNotificationID.ToString())
  writer.WriteElementString("BugID", BugID.ToString())
  writer.WriteElementString("CreatedUserName", CreatedUserName.ToString())
  writer.WriteEndElement()
 End Sub

#End Region

#Region " ToXml Methods "
 Public Function ToXml() As String
  Return ToXml("BugNotification")
 End Function

 Public Function ToXml(ByVal elementName As String) As String
  Dim xml As New StringBuilder
  xml.Append("<")
  xml.Append(elementName)
  'Add Attribute(xml, "BugNotificationID", BugNotificationID.ToString())
  'Add Attribute(xml, "BugID", BugID.ToString())
  'Add Attribute(xml, "CreatedUserName", CreatedUserName.ToString())
  xml.Append(" />")
  Return xml.ToString
 End Function
#End Region

End Class
#End Region

#Region " BugNotificationsController "
 Public Class BugNotificationsController
	
 Public Shared Function GetBugNotification(ByVal BugNotificationID As Integer) As BugNotificationInfo
	
  Return CType(CBO.FillObject(DataProvider.Instance().GetBugNotification(BugNotificationID), GetType(BugNotificationInfo)), BugNotificationInfo)

 End Function

 Public Shared Function AddBugNotification(ByVal BugId As Integer, ByVal Username As String) As Integer

  Return CType(DataProvider.Instance().AddBugNotification(BugId, Username), Integer)

 End Function

 Public Shared Sub DeleteBugNotification(ByVal BugId As Integer, ByVal Username As String)

  DataProvider.Instance().DeleteBugNotification(BugId, Username)

 End Sub

 End Class
#End Region


#Region " BugTimeEntryInfo "
<Serializable(), XmlRoot("BugTimeEntry")> _
Public Class BugTimeEntryInfo
 Implements IHydratable
 Implements IPropertyAccess
 Implements IXmlSerializable

 ' local property declarations
 Private _BugTimeEntryId As Integer
 Private _BugCommentId As Integer
 Private _BugId As Integer
 Private _CreatedUserName As String
 Private _Duration As Decimal
 Private _WorkDate As Date

#Region " Constructors "
 Public Sub New()
 End Sub

 Public Sub New(ByVal BugTimeEntryId As Integer, ByVal BugCommentId As Integer, ByVal BugId As Integer, ByVal CreatedUserName As String, ByVal Duration As Decimal, ByVal WorkDate As Date)
  Me.BugCommentId = BugCommentId
  Me.BugId = BugId
  Me.BugTimeEntryId = BugTimeEntryId
  Me.CreatedUserName = CreatedUserName
  Me.Duration = Duration
  Me.WorkDate = WorkDate
 End Sub
#End Region

#Region " Public Properties "

 Public Property BugTimeEntryId() As Integer
  Get
   Return _BugTimeEntryId
  End Get
  Set(ByVal Value As Integer)
   _BugTimeEntryId = Value
  End Set
 End Property

 Public Property BugCommentId() As Integer
  Get
   Return _BugCommentId
  End Get
  Set(ByVal Value As Integer)
   _BugCommentId = Value
  End Set
 End Property

 Public Property BugId() As Integer
  Get
   Return _BugId
  End Get
  Set(ByVal Value As Integer)
   _BugId = Value
  End Set
 End Property

 Public Property CreatedUserName() As String
  Get
   Return _CreatedUserName
  End Get
  Set(ByVal Value As String)
   _CreatedUserName = Value
  End Set
 End Property

 Public Property Duration() As Decimal
  Get
   Return _Duration
  End Get
  Set(ByVal Value As Decimal)
   _Duration = Value
  End Set
 End Property

 Public Property WorkDate() As Date
  Get
   Return _WorkDate
  End Get
  Set(ByVal Value As Date)
   _WorkDate = Value
  End Set
 End Property

#End Region

#Region " IHydratable Implementation "

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' Fill hydrates the object from a Datareader
 ''' </summary>
 ''' <remarks>The Fill method is used by the CBO method to hydrtae the object
 ''' rather than using the more expensive Refection  methods.</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub Fill(ByVal dr As IDataReader) Implements IHydratable.Fill

  BugCommentId = Convert.ToInt32(Null.SetNull(dr.Item("BugCommentId"), BugCommentId))
  BugId = Convert.ToInt32(Null.SetNull(dr.Item("BugId"), BugId))
  BugTimeEntryId = Convert.ToInt32(Null.SetNull(dr.Item("BugTimeEntryId"), BugTimeEntryId))
  CreatedUserName = Convert.ToString(Null.SetNull(dr.Item("CreatedUserName"), CreatedUserName))
  Duration = Convert.ToDecimal(Null.SetNull(dr.Item("Duration"), Duration))
  WorkDate = Convert.ToDateTime(Null.SetNull(dr.Item("WorkDate"), WorkDate))

 End Sub
 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' Gets and sets the Key ID
 ''' </summary>
 ''' <remarks>The KeyID property is part of the IHydratble interface.  It is used
 ''' as the key property when creating a Dictionary</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Property KeyID() As Integer Implements Entities.Modules.IHydratable.KeyID
  Get
   Return BugTimeEntryId
  End Get
  Set(ByVal value As Integer)
   BugTimeEntryId = value
  End Set
 End Property

#End Region

#Region " IPropertyAccess Implementation "

 Public Function GetProperty(ByVal strPropertyName As String, ByVal strFormat As String, ByVal formatProvider As System.Globalization.CultureInfo, ByVal AccessingUser As Entities.Users.UserInfo, ByVal AccessLevel As DotNetNuke.Services.Tokens.Scope, ByRef PropertyNotFound As Boolean) As String Implements DotNetNuke.Services.Tokens.IPropertyAccess.GetProperty
  Dim OutputFormat As String = String.Empty
  Dim portalSettings As PortalSettings = PortalController.GetCurrentPortalSettings()
  If strFormat = String.Empty Then
   OutputFormat = "D"
  Else
   OutputFormat = strFormat
  End If
  Select Case strPropertyName.ToLower
   Case "bugcommentid"
    Return (Me.BugCommentId.ToString(OutputFormat, formatProvider))
   Case "bugid"
    Return (Me.BugId.ToString(OutputFormat, formatProvider))
   Case "bugtimeentryid"
    Return (Me.BugTimeEntryId.ToString(OutputFormat, formatProvider))
   Case "createdusername"
    Return PropertyAccess.FormatString(Me.CreatedUserName, strFormat)
   Case "duration"
    Return (Me.Duration.ToString(OutputFormat, formatProvider))
   Case "workdate"
    Return (Me.WorkDate.ToString(OutputFormat, formatProvider))
   Case Else
    PropertyNotFound = True
  End Select

  Return Null.NullString
 End Function

 Public ReadOnly Property Cacheability() As DotNetNuke.Services.Tokens.CacheLevel Implements DotNetNuke.Services.Tokens.IPropertyAccess.Cacheability
  Get
   Return CacheLevel.fullyCacheable
  End Get
 End Property

#End Region

#Region " IXmlSerializable Implementation "

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' GetSchema returns the XmlSchema for this class
 ''' </summary>
 ''' <remarks>GetSchema is implemented as a stub method as it is not required</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Function GetSchema() As XmlSchema Implements IXmlSerializable.GetSchema
  Return Nothing
 End Function

 Private Function readElement(ByVal reader As XmlReader, ByVal ElementName As String) As String
  If (Not reader.NodeType = XmlNodeType.Element) OrElse reader.Name <> ElementName Then
   reader.ReadToFollowing(ElementName)
  End If
  If reader.NodeType = XmlNodeType.Element Then
   Return reader.ReadElementContentAsString
  Else
   Return ""
  End If
 End Function

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' ReadXml fills the object (de-serializes it) from the XmlReader passed
 ''' </summary>
 ''' <remarks></remarks>
 ''' <param name="reader">The XmlReader that contains the xml for the object</param>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub ReadXml(ByVal reader As XmlReader) Implements IXmlSerializable.ReadXml
  Try

   If Not Int32.TryParse(readElement(reader, "BugCommentId"), BugCommentId) Then
    BugCommentId = Null.NullInteger
   End If
   If Not Int32.TryParse(readElement(reader, "BugId"), BugId) Then
    BugId = Null.NullInteger
   End If
   readElement(reader, "CreatedUserName")
   Decimal.TryParse(readElement(reader, "Duration"), Duration)
   If Not DateTime.TryParse(readElement(reader, "WorkDate"), WorkDate) Then
    WorkDate = DateTime.MinValue
   End If
  Catch ex As Exception
   ' log exception as DNN import routine does not do that
   DotNetNuke.Services.Exceptions.LogException(ex)
   ' re-raise exception to make sure import routine displays a visible error to the user
   Throw New Exception("An error occured during import of an BugTimeEntry", ex)
  End Try

 End Sub

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' WriteXml converts the object to Xml (serializes it) and writes it using the XmlWriter passed
 ''' </summary>
 ''' <remarks></remarks>
 ''' <param name="writer">The XmlWriter that contains the xml for the object</param>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub WriteXml(ByVal writer As XmlWriter) Implements IXmlSerializable.WriteXml
  writer.WriteStartElement("BugTimeEntry")
  writer.WriteElementString("BugTimeEntryId", BugTimeEntryId.ToString())
  writer.WriteElementString("BugCommentId", BugCommentId.ToString())
  writer.WriteElementString("BugId", BugId.ToString())
  writer.WriteElementString("CreatedUserName", CreatedUserName.ToString())
  writer.WriteElementString("Duration", Duration.ToString())
  writer.WriteElementString("WorkDate", WorkDate.ToString())
  writer.WriteEndElement()
 End Sub

#End Region

#Region " ToXml Methods "
 Public Function ToXml() As String
  Return ToXml("BugTimeEntry")
 End Function

 Public Function ToXml(ByVal elementName As String) As String
  Dim xml As New StringBuilder
  xml.Append("<")
  xml.Append(elementName)
  'Add Attribute(xml, "BugTimeEntryId", BugTimeEntryId.ToString())
  'Add Attribute(xml, "BugCommentId", BugCommentId.ToString())
  'Add Attribute(xml, "BugId", BugId.ToString())
  'Add Attribute(xml, "CreatedUserName", CreatedUserName.ToString())
  'Add Attribute(xml, "Duration", Duration.ToString())
  'Add Attribute(xml, "WorkDate", WorkDate.ToString())
  xml.Append(" />")
  Return xml.ToString
 End Function
#End Region

End Class
#End Region

#Region " BugTimeEntriesController "
Public Class BugTimeEntriesController

 Public Shared Function GetBugTimeEntry(ByVal BugTimeEntryId As Integer) As BugTimeEntryInfo

  Return CType(CBO.FillObject(DataProvider.Instance().GetBugTimeEntry(BugTimeEntryId), GetType(BugTimeEntryInfo)), BugTimeEntryInfo)

 End Function

 Public Shared Function AddBugTimeEntry(ByVal objBugTimeEntry As BugTimeEntryInfo) As Integer

  Return CType(DataProvider.Instance().AddBugTimeEntry(objBugTimeEntry.BugCommentId, objBugTimeEntry.BugId, objBugTimeEntry.CreatedUserName, objBugTimeEntry.Duration, objBugTimeEntry.WorkDate), Integer)

 End Function

 Public Shared Sub UpdateBugTimeEntry(ByVal objBugTimeEntry As BugTimeEntryInfo)

  DataProvider.Instance().UpdateBugTimeEntry(objBugTimeEntry.BugTimeEntryId, objBugTimeEntry.BugCommentId, objBugTimeEntry.BugId, objBugTimeEntry.CreatedUserName, objBugTimeEntry.Duration, objBugTimeEntry.WorkDate)

 End Sub

 Public Shared Sub DeleteBugTimeEntry(ByVal BugTimeEntryId As Integer)

  DataProvider.Instance().DeleteBugTimeEntry(BugTimeEntryId)

 End Sub

End Class
#End Region


#Region " ComponentInfo "
<Serializable(), XmlRoot("Component")> _
Public Class ComponentInfo
 Implements IHydratable
 Implements IPropertyAccess
 Implements IXmlSerializable

 ' local property declarations
 Private _ComponentID As Integer
 Private _Name As String
 Private _ParentComponentID As Integer
 Private _ProjectID As Integer

#Region " Constructors "
 Public Sub New()
 End Sub

 Public Sub New(ByVal ComponentID As Integer, ByVal Name As String, ByVal ParentComponentID As Integer, ByVal ProjectID As Integer)
  Me.ComponentID = ComponentID
  Me.Name = Name
  Me.ParentComponentID = ParentComponentID
  Me.ProjectID = ProjectID
 End Sub
#End Region

#Region " Public Properties "

 Public Property ComponentID() As Integer
  Get
   Return _ComponentID
  End Get
  Set(ByVal Value As Integer)
   _ComponentID = Value
  End Set
 End Property

 Public Property Name() As String
  Get
   Return _Name
  End Get
  Set(ByVal Value As String)
   _Name = Value
  End Set
 End Property

 Public Property ParentComponentID() As Integer
  Get
   Return _ParentComponentID
  End Get
  Set(ByVal Value As Integer)
   _ParentComponentID = Value
  End Set
 End Property

 Public Property ProjectID() As Integer
  Get
   Return _ProjectID
  End Get
  Set(ByVal Value As Integer)
   _ProjectID = Value
  End Set
 End Property

#End Region

#Region " IHydratable Implementation "

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' Fill hydrates the object from a Datareader
 ''' </summary>
 ''' <remarks>The Fill method is used by the CBO method to hydrtae the object
 ''' rather than using the more expensive Refection  methods.</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub Fill(ByVal dr As IDataReader) Implements IHydratable.Fill

  ComponentID = Convert.ToInt32(Null.SetNull(dr.Item("ComponentID"), ComponentID))
  Name = Convert.ToString(Null.SetNull(dr.Item("Name"), Name))
  ParentComponentID = Convert.ToInt32(Null.SetNull(dr.Item("ParentComponentID"), ParentComponentID))
  ProjectID = Convert.ToInt32(Null.SetNull(dr.Item("ProjectID"), ProjectID))

 End Sub
 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' Gets and sets the Key ID
 ''' </summary>
 ''' <remarks>The KeyID property is part of the IHydratble interface.  It is used
 ''' as the key property when creating a Dictionary</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Property KeyID() As Integer Implements Entities.Modules.IHydratable.KeyID
  Get
   Return ComponentID
  End Get
  Set(ByVal value As Integer)
   ComponentID = value
  End Set
 End Property

#End Region

#Region " IPropertyAccess Implementation "

 Public Function GetProperty(ByVal strPropertyName As String, ByVal strFormat As String, ByVal formatProvider As System.Globalization.CultureInfo, ByVal AccessingUser As Entities.Users.UserInfo, ByVal AccessLevel As DotNetNuke.Services.Tokens.Scope, ByRef PropertyNotFound As Boolean) As String Implements DotNetNuke.Services.Tokens.IPropertyAccess.GetProperty
  Dim OutputFormat As String = String.Empty
  Dim portalSettings As PortalSettings = PortalController.GetCurrentPortalSettings()
  If strFormat = String.Empty Then
   OutputFormat = "D"
  Else
   OutputFormat = strFormat
  End If
  Select Case strPropertyName.ToLower
   Case "componentid"
    Return (Me.ComponentID.ToString(OutputFormat, formatProvider))
   Case "name"
    Return PropertyAccess.FormatString(Me.Name, strFormat)
   Case "parentcomponentid"
    Return (Me.ParentComponentID.ToString(OutputFormat, formatProvider))
   Case "projectid"
    Return (Me.ProjectID.ToString(OutputFormat, formatProvider))
   Case Else
    PropertyNotFound = True
  End Select

  Return Null.NullString
 End Function

 Public ReadOnly Property Cacheability() As DotNetNuke.Services.Tokens.CacheLevel Implements DotNetNuke.Services.Tokens.IPropertyAccess.Cacheability
  Get
   Return CacheLevel.fullyCacheable
  End Get
 End Property

#End Region

#Region " IXmlSerializable Implementation "

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' GetSchema returns the XmlSchema for this class
 ''' </summary>
 ''' <remarks>GetSchema is implemented as a stub method as it is not required</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Function GetSchema() As XmlSchema Implements IXmlSerializable.GetSchema
  Return Nothing
 End Function

 Private Function readElement(ByVal reader As XmlReader, ByVal ElementName As String) As String
  If (Not reader.NodeType = XmlNodeType.Element) OrElse reader.Name <> ElementName Then
   reader.ReadToFollowing(ElementName)
  End If
  If reader.NodeType = XmlNodeType.Element Then
   Return reader.ReadElementContentAsString
  Else
   Return ""
  End If
 End Function

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' ReadXml fills the object (de-serializes it) from the XmlReader passed
 ''' </summary>
 ''' <remarks></remarks>
 ''' <param name="reader">The XmlReader that contains the xml for the object</param>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub ReadXml(ByVal reader As XmlReader) Implements IXmlSerializable.ReadXml
  Try

   Name = readElement(reader, "Name")
   If Not Int32.TryParse(readElement(reader, "ParentComponentID"), ParentComponentID) Then
    ParentComponentID = Null.NullInteger
   End If
   If Not Int32.TryParse(readElement(reader, "ProjectID"), ProjectID) Then
    ProjectID = Null.NullInteger
   End If
  Catch ex As Exception
   ' log exception as DNN import routine does not do that
   DotNetNuke.Services.Exceptions.LogException(ex)
   ' re-raise exception to make sure import routine displays a visible error to the user
   Throw New Exception("An error occured during import of an Component", ex)
  End Try

 End Sub

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' WriteXml converts the object to Xml (serializes it) and writes it using the XmlWriter passed
 ''' </summary>
 ''' <remarks></remarks>
 ''' <param name="writer">The XmlWriter that contains the xml for the object</param>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub WriteXml(ByVal writer As XmlWriter) Implements IXmlSerializable.WriteXml
  writer.WriteStartElement("Component")
  writer.WriteElementString("ComponentID", ComponentID.ToString())
  writer.WriteElementString("Name", Name)
  writer.WriteElementString("ParentComponentID", ParentComponentID.ToString())
  writer.WriteElementString("ProjectID", ProjectID.ToString())
  writer.WriteEndElement()
 End Sub

#End Region

#Region " ToXml Methods "
 Public Function ToXml() As String
  Return ToXml("Component")
 End Function

 Public Function ToXml(ByVal elementName As String) As String
  Dim xml As New StringBuilder
  xml.Append("<")
  xml.Append(elementName)
  'Add Attribute(xml, "ComponentID", ComponentID.ToString())
  'Add Attribute(xml, "Name", Name)
  'Add Attribute(xml, "ParentComponentID", ParentComponentID.ToString())
  'Add Attribute(xml, "ProjectID", ProjectID.ToString())
  xml.Append(" />")
  Return xml.ToString
 End Function
#End Region

End Class
#End Region

#Region " ComponentsController "
Public Class ComponentsController

 Public Shared Function GetComponent(ByVal ComponentID As Integer) As ComponentInfo

  Return CType(CBO.FillObject(DataProvider.Instance().GetComponent(ComponentID), GetType(ComponentInfo)), ComponentInfo)

 End Function

 Public Shared Function AddComponent(ByVal objComponent As ComponentInfo) As Integer

  Return CType(DataProvider.Instance().AddComponent(objComponent.Name, objComponent.ParentComponentID, objComponent.ProjectID), Integer)

 End Function

 Public Shared Sub UpdateComponent(ByVal objComponent As ComponentInfo)

  DataProvider.Instance().UpdateComponent(objComponent.ComponentID, objComponent.Name, objComponent.ParentComponentID, objComponent.ProjectID)

 End Sub

 Public Shared Sub DeleteComponent(ByVal ComponentID As Integer)

  DataProvider.Instance().DeleteComponent(ComponentID)

 End Sub

 Public Shared Function GetComponentsByProject(ByVal ProjectID As Integer) As IDictionary(Of Integer, ComponentInfo)

  Return CBO.FillDictionary(Of ComponentInfo)(DataProvider.Instance().GetComponentsByProject(ProjectID))

 End Function

End Class
#End Region


#Region " LogInfo "
<Serializable(), XmlRoot("Log")> _
Public Class LogInfo
 Implements IHydratable
 Implements IPropertyAccess
 Implements IXmlSerializable

 ' local property declarations
 Private _Id As Integer
 Private _Date As Date
 Private _Exception As String
 Private _Level As String
 Private _Logger As String
 Private _Message As String
 Private _Thread As String
 Private _User As String

#Region " Constructors "
 Public Sub New()
 End Sub

 Public Sub New(ByVal Id As Integer, ByVal [Date] As Date, ByVal Exception As String, ByVal Level As String, ByVal Logger As String, ByVal Message As String, ByVal Thread As String, ByVal User As String)
  Me.[Date] = [Date]
  Me.Exception = Exception
  Me.Id = Id
  Me.Level = Level
  Me.Logger = Logger
  Me.Message = Message
  Me.Thread = Thread
  Me.User = User
 End Sub
#End Region

#Region " Public Properties "

 Public Property Id() As Integer
  Get
   Return _Id
  End Get
  Set(ByVal Value As Integer)
   _Id = Value
  End Set
 End Property

 Public Property [Date]() As Date
  Get
   Return _Date
  End Get
  Set(ByVal Value As Date)
   _Date = Value
  End Set
 End Property

 Public Property Exception() As String
  Get
   Return _Exception
  End Get
  Set(ByVal Value As String)
   _Exception = Value
  End Set
 End Property

 Public Property Level() As String
  Get
   Return _Level
  End Get
  Set(ByVal Value As String)
   _Level = Value
  End Set
 End Property

 Public Property Logger() As String
  Get
   Return _Logger
  End Get
  Set(ByVal Value As String)
   _Logger = Value
  End Set
 End Property

 Public Property Message() As String
  Get
   Return _Message
  End Get
  Set(ByVal Value As String)
   _Message = Value
  End Set
 End Property

 Public Property Thread() As String
  Get
   Return _Thread
  End Get
  Set(ByVal Value As String)
   _Thread = Value
  End Set
 End Property

 Public Property User() As String
  Get
   Return _User
  End Get
  Set(ByVal Value As String)
   _User = Value
  End Set
 End Property

#End Region

#Region " IHydratable Implementation "

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' Fill hydrates the object from a Datareader
 ''' </summary>
 ''' <remarks>The Fill method is used by the CBO method to hydrtae the object
 ''' rather than using the more expensive Refection  methods.</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub Fill(ByVal dr As IDataReader) Implements IHydratable.Fill

  [Date] = Convert.ToDateTime(Null.SetNull(dr.Item("Date"), [Date]))
  Exception = Convert.ToString(Null.SetNull(dr.Item("Exception"), Exception))
  Id = Convert.ToInt32(Null.SetNull(dr.Item("Id"), Id))
  Level = Convert.ToString(Null.SetNull(dr.Item("Level"), Level))
  Logger = Convert.ToString(Null.SetNull(dr.Item("Logger"), Logger))
  Message = Convert.ToString(Null.SetNull(dr.Item("Message"), Message))
  Thread = Convert.ToString(Null.SetNull(dr.Item("Thread"), Thread))
  User = Convert.ToString(Null.SetNull(dr.Item("User"), User))

 End Sub
 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' Gets and sets the Key ID
 ''' </summary>
 ''' <remarks>The KeyID property is part of the IHydratble interface.  It is used
 ''' as the key property when creating a Dictionary</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Property KeyID() As Integer Implements Entities.Modules.IHydratable.KeyID
  Get
   Return Id
  End Get
  Set(ByVal value As Integer)
   Id = value
  End Set
 End Property

#End Region

#Region " IPropertyAccess Implementation "

 Public Function GetProperty(ByVal strPropertyName As String, ByVal strFormat As String, ByVal formatProvider As System.Globalization.CultureInfo, ByVal AccessingUser As Entities.Users.UserInfo, ByVal AccessLevel As DotNetNuke.Services.Tokens.Scope, ByRef PropertyNotFound As Boolean) As String Implements DotNetNuke.Services.Tokens.IPropertyAccess.GetProperty
  Dim OutputFormat As String = String.Empty
  Dim portalSettings As PortalSettings = PortalController.GetCurrentPortalSettings()
  If strFormat = String.Empty Then
   OutputFormat = "D"
  Else
   OutputFormat = strFormat
  End If
  Select Case strPropertyName.ToLower
   Case "date"
    Return (Me.Date.ToString(OutputFormat, formatProvider))
   Case "exception"
    Return PropertyAccess.FormatString(Me.Exception, strFormat)
   Case "id"
    Return (Me.Id.ToString(OutputFormat, formatProvider))
   Case "level"
    Return PropertyAccess.FormatString(Me.Level, strFormat)
   Case "logger"
    Return PropertyAccess.FormatString(Me.Logger, strFormat)
   Case "message"
    Return PropertyAccess.FormatString(Me.Message, strFormat)
   Case "thread"
    Return PropertyAccess.FormatString(Me.Thread, strFormat)
   Case "user"
    Return PropertyAccess.FormatString(Me.User, strFormat)
   Case Else
    PropertyNotFound = True
  End Select

  Return Null.NullString
 End Function

 Public ReadOnly Property Cacheability() As DotNetNuke.Services.Tokens.CacheLevel Implements DotNetNuke.Services.Tokens.IPropertyAccess.Cacheability
  Get
   Return CacheLevel.fullyCacheable
  End Get
 End Property

#End Region

#Region " IXmlSerializable Implementation "

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' GetSchema returns the XmlSchema for this class
 ''' </summary>
 ''' <remarks>GetSchema is implemented as a stub method as it is not required</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Function GetSchema() As XmlSchema Implements IXmlSerializable.GetSchema
  Return Nothing
 End Function

 Private Function readElement(ByVal reader As XmlReader, ByVal ElementName As String) As String
  If (Not reader.NodeType = XmlNodeType.Element) OrElse reader.Name <> ElementName Then
   reader.ReadToFollowing(ElementName)
  End If
  If reader.NodeType = XmlNodeType.Element Then
   Return reader.ReadElementContentAsString
  Else
   Return ""
  End If
 End Function

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' ReadXml fills the object (de-serializes it) from the XmlReader passed
 ''' </summary>
 ''' <remarks></remarks>
 ''' <param name="reader">The XmlReader that contains the xml for the object</param>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub ReadXml(ByVal reader As XmlReader) Implements IXmlSerializable.ReadXml
  Try

   If Not DateTime.TryParse(readElement(reader, "Date"), [Date]) Then
    [Date] = DateTime.MinValue
   End If
   Exception = readElement(reader, "Exception")
   Level = readElement(reader, "Level")
   Logger = readElement(reader, "Logger")
   Message = readElement(reader, "Message")
   Thread = readElement(reader, "Thread")
   User = readElement(reader, "User")
  Catch ex As Exception
   ' log exception as DNN import routine does not do that
   DotNetNuke.Services.Exceptions.LogException(ex)
   ' re-raise exception to make sure import routine displays a visible error to the user
   Throw New Exception("An error occured during import of an Log", ex)
  End Try

 End Sub

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' WriteXml converts the object to Xml (serializes it) and writes it using the XmlWriter passed
 ''' </summary>
 ''' <remarks></remarks>
 ''' <param name="writer">The XmlWriter that contains the xml for the object</param>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub WriteXml(ByVal writer As XmlWriter) Implements IXmlSerializable.WriteXml
  writer.WriteStartElement("Log")
  writer.WriteElementString("Id", Id.ToString())
  writer.WriteElementString("Date", [Date].ToString())
  writer.WriteElementString("Exception", Exception)
  writer.WriteElementString("Level", Level)
  writer.WriteElementString("Logger", Logger)
  writer.WriteElementString("Message", Message)
  writer.WriteElementString("Thread", Thread)
  writer.WriteElementString("User", User)
  writer.WriteEndElement()
 End Sub

#End Region

#Region " ToXml Methods "
 Public Function ToXml() As String
  Return ToXml("Log")
 End Function

 Public Function ToXml(ByVal elementName As String) As String
  Dim xml As New StringBuilder
  xml.Append("<")
  xml.Append(elementName)
  'Add Attribute(xml, "Id", Id.ToString())
  'Add Attribute(xml, "Date", Date.ToString())
  'Add Attribute(xml, "Exception", Exception)
  'Add Attribute(xml, "Level", Level)
  'Add Attribute(xml, "Logger", Logger)
  'Add Attribute(xml, "Message", Message)
  'Add Attribute(xml, "Thread", Thread)
  'Add Attribute(xml, "User", User)
  xml.Append(" />")
  Return xml.ToString
 End Function
#End Region

End Class
#End Region

#Region " LogsController "
Public Class LogsController

 Public Shared Function GetLog(ByVal Id As Integer) As LogInfo

  Return CType(CBO.FillObject(DataProvider.Instance().GetLog(Id), GetType(LogInfo)), LogInfo)

 End Function

 Public Shared Function AddLog(ByVal objLog As LogInfo) As Integer

  Return CType(DataProvider.Instance().AddLog(objLog.Date, objLog.Exception, objLog.Level, objLog.Logger, objLog.Message, objLog.Thread, objLog.User), Integer)

 End Function

 Public Shared Sub UpdateLog(ByVal objLog As LogInfo)

  DataProvider.Instance().UpdateLog(objLog.Id, objLog.Date, objLog.Exception, objLog.Level, objLog.Logger, objLog.Message, objLog.Thread, objLog.User)

 End Sub

 Public Shared Sub DeleteLog(ByVal Id As Integer)

  DataProvider.Instance().DeleteLog(Id)

 End Sub

End Class
#End Region


#Region " PermissionInfo "
<Serializable(), XmlRoot("Permission")> _
Public Class PermissionInfo
 Implements IHydratable
 Implements IPropertyAccess
 Implements IXmlSerializable

 ' local property declarations
 Private _PermissionId As Integer
 Private _Name As String
 Private _PermissionKey As String

#Region " Constructors "
 Public Sub New()
 End Sub

 Public Sub New(ByVal PermissionId As Integer, ByVal Name As String, ByVal PermissionKey As String)
  Me.Name = Name
  Me.PermissionId = PermissionId
  Me.PermissionKey = PermissionKey
 End Sub
#End Region

#Region " Public Properties "

 Public Property PermissionId() As Integer
  Get
   Return _PermissionId
  End Get
  Set(ByVal Value As Integer)
   _PermissionId = Value
  End Set
 End Property

 Public Property Name() As String
  Get
   Return _Name
  End Get
  Set(ByVal Value As String)
   _Name = Value
  End Set
 End Property

 Public Property PermissionKey() As String
  Get
   Return _PermissionKey
  End Get
  Set(ByVal Value As String)
   _PermissionKey = Value
  End Set
 End Property

#End Region

#Region " IHydratable Implementation "

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' Fill hydrates the object from a Datareader
 ''' </summary>
 ''' <remarks>The Fill method is used by the CBO method to hydrtae the object
 ''' rather than using the more expensive Refection  methods.</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub Fill(ByVal dr As IDataReader) Implements IHydratable.Fill

  Name = Convert.ToString(Null.SetNull(dr.Item("Name"), Name))
  PermissionId = Convert.ToInt32(Null.SetNull(dr.Item("PermissionId"), PermissionId))
  PermissionKey = Convert.ToString(Null.SetNull(dr.Item("PermissionKey"), PermissionKey))

 End Sub
 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' Gets and sets the Key ID
 ''' </summary>
 ''' <remarks>The KeyID property is part of the IHydratble interface.  It is used
 ''' as the key property when creating a Dictionary</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Property KeyID() As Integer Implements Entities.Modules.IHydratable.KeyID
  Get
   Return PermissionId
  End Get
  Set(ByVal value As Integer)
   PermissionId = value
  End Set
 End Property

#End Region

#Region " IPropertyAccess Implementation "

 Public Function GetProperty(ByVal strPropertyName As String, ByVal strFormat As String, ByVal formatProvider As System.Globalization.CultureInfo, ByVal AccessingUser As Entities.Users.UserInfo, ByVal AccessLevel As DotNetNuke.Services.Tokens.Scope, ByRef PropertyNotFound As Boolean) As String Implements DotNetNuke.Services.Tokens.IPropertyAccess.GetProperty
  Dim OutputFormat As String = String.Empty
  Dim portalSettings As PortalSettings = PortalController.GetCurrentPortalSettings()
  If strFormat = String.Empty Then
   OutputFormat = "D"
  Else
   OutputFormat = strFormat
  End If
  Select Case strPropertyName.ToLower
   Case "name"
    Return PropertyAccess.FormatString(Me.Name, strFormat)
   Case "permissionid"
    Return (Me.PermissionId.ToString(OutputFormat, formatProvider))
   Case "permissionkey"
    Return PropertyAccess.FormatString(Me.PermissionKey, strFormat)
   Case Else
    PropertyNotFound = True
  End Select

  Return Null.NullString
 End Function

 Public ReadOnly Property Cacheability() As DotNetNuke.Services.Tokens.CacheLevel Implements DotNetNuke.Services.Tokens.IPropertyAccess.Cacheability
  Get
   Return CacheLevel.fullyCacheable
  End Get
 End Property

#End Region

#Region " IXmlSerializable Implementation "

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' GetSchema returns the XmlSchema for this class
 ''' </summary>
 ''' <remarks>GetSchema is implemented as a stub method as it is not required</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Function GetSchema() As XmlSchema Implements IXmlSerializable.GetSchema
  Return Nothing
 End Function

 Private Function readElement(ByVal reader As XmlReader, ByVal ElementName As String) As String
  If (Not reader.NodeType = XmlNodeType.Element) OrElse reader.Name <> ElementName Then
   reader.ReadToFollowing(ElementName)
  End If
  If reader.NodeType = XmlNodeType.Element Then
   Return reader.ReadElementContentAsString
  Else
   Return ""
  End If
 End Function

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' ReadXml fills the object (de-serializes it) from the XmlReader passed
 ''' </summary>
 ''' <remarks></remarks>
 ''' <param name="reader">The XmlReader that contains the xml for the object</param>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub ReadXml(ByVal reader As XmlReader) Implements IXmlSerializable.ReadXml
  Try

   Name = readElement(reader, "Name")
   PermissionKey = readElement(reader, "PermissionKey")
  Catch ex As Exception
   ' log exception as DNN import routine does not do that
   DotNetNuke.Services.Exceptions.LogException(ex)
   ' re-raise exception to make sure import routine displays a visible error to the user
   Throw New Exception("An error occured during import of an Permission", ex)
  End Try

 End Sub

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' WriteXml converts the object to Xml (serializes it) and writes it using the XmlWriter passed
 ''' </summary>
 ''' <remarks></remarks>
 ''' <param name="writer">The XmlWriter that contains the xml for the object</param>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub WriteXml(ByVal writer As XmlWriter) Implements IXmlSerializable.WriteXml
  writer.WriteStartElement("Permission")
  writer.WriteElementString("PermissionId", PermissionId.ToString())
  writer.WriteElementString("Name", Name)
  writer.WriteElementString("PermissionKey", PermissionKey)
  writer.WriteEndElement()
 End Sub

#End Region

#Region " ToXml Methods "
 Public Function ToXml() As String
  Return ToXml("Permission")
 End Function

 Public Function ToXml(ByVal elementName As String) As String
  Dim xml As New StringBuilder
  xml.Append("<")
  xml.Append(elementName)
  'Add Attribute(xml, "PermissionId", PermissionId.ToString())
  'Add Attribute(xml, "Name", Name)
  'Add Attribute(xml, "PermissionKey", PermissionKey)
  xml.Append(" />")
  Return xml.ToString
 End Function
#End Region

End Class
#End Region

#Region " PermissionsController "
Public Class PermissionsController

 Public Shared Function GetPermission(ByVal PermissionId As Integer) As PermissionInfo

  Return CType(CBO.FillObject(DataProvider.Instance().GetPermission(PermissionId), GetType(PermissionInfo)), PermissionInfo)

 End Function

 Public Shared Function AddPermission(ByVal objPermission As PermissionInfo) As Integer

  Return CType(DataProvider.Instance().AddPermission(objPermission.Name, objPermission.PermissionKey), Integer)

 End Function

 Public Shared Sub UpdatePermission(ByVal objPermission As PermissionInfo)

  DataProvider.Instance().UpdatePermission(objPermission.PermissionId, objPermission.Name, objPermission.PermissionKey)

 End Sub

 Public Shared Sub DeletePermission(ByVal PermissionId As Integer)

  DataProvider.Instance().DeletePermission(PermissionId)

 End Sub

 Public Shared Function FindPermissionByName(ByVal Name As String) As PermissionInfo
	
  Return CType(CBO.FillObject(DataProvider.Instance().FindPermissionByName(Name), GetType(PermissionInfo)), PermissionInfo)

 End Function

End Class
#End Region


#Region " PriorityInfo "
<Serializable(), XmlRoot("Priority")> _
Public Class PriorityInfo
 Implements IHydratable
 Implements IPropertyAccess
 Implements IXmlSerializable

 ' local property declarations
 Private _PriorityID As Integer
 Private _ImageUrl As String
 Private _Name As String

#Region " Constructors "
 Public Sub New()
 End Sub

 Public Sub New(ByVal PriorityID As Integer, ByVal ImageUrl As String, ByVal Name As String)
  Me.ImageUrl = ImageUrl
  Me.Name = Name
  Me.PriorityID = PriorityID
 End Sub
#End Region

#Region " Public Properties "

 Public Property PriorityID() As Integer
  Get
   Return _PriorityID
  End Get
  Set(ByVal Value As Integer)
   _PriorityID = Value
  End Set
 End Property

 Public Property ImageUrl() As String
  Get
   Return _ImageUrl
  End Get
  Set(ByVal Value As String)
   _ImageUrl = Value
  End Set
 End Property

 Public Property Name() As String
  Get
   Return _Name
  End Get
  Set(ByVal Value As String)
   _Name = Value
  End Set
 End Property

#End Region

#Region " IHydratable Implementation "

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' Fill hydrates the object from a Datareader
 ''' </summary>
 ''' <remarks>The Fill method is used by the CBO method to hydrtae the object
 ''' rather than using the more expensive Refection  methods.</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub Fill(ByVal dr As IDataReader) Implements IHydratable.Fill

  ImageUrl = Convert.ToString(Null.SetNull(dr.Item("ImageUrl"), ImageUrl))
  Name = Convert.ToString(Null.SetNull(dr.Item("Name"), Name))
  PriorityID = Convert.ToInt32(Null.SetNull(dr.Item("PriorityID"), PriorityID))

 End Sub
 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' Gets and sets the Key ID
 ''' </summary>
 ''' <remarks>The KeyID property is part of the IHydratble interface.  It is used
 ''' as the key property when creating a Dictionary</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Property KeyID() As Integer Implements Entities.Modules.IHydratable.KeyID
  Get
   Return PriorityID
  End Get
  Set(ByVal value As Integer)
   PriorityID = value
  End Set
 End Property

#End Region

#Region " IPropertyAccess Implementation "

 Public Function GetProperty(ByVal strPropertyName As String, ByVal strFormat As String, ByVal formatProvider As System.Globalization.CultureInfo, ByVal AccessingUser As Entities.Users.UserInfo, ByVal AccessLevel As DotNetNuke.Services.Tokens.Scope, ByRef PropertyNotFound As Boolean) As String Implements DotNetNuke.Services.Tokens.IPropertyAccess.GetProperty
  Dim OutputFormat As String = String.Empty
  Dim portalSettings As PortalSettings = PortalController.GetCurrentPortalSettings()
  If strFormat = String.Empty Then
   OutputFormat = "D"
  Else
   OutputFormat = strFormat
  End If
  Select Case strPropertyName.ToLower
   Case "imageurl"
    Return PropertyAccess.FormatString(Me.ImageUrl, strFormat)
   Case "name"
    Return PropertyAccess.FormatString(Me.Name, strFormat)
   Case "priorityid"
    Return (Me.PriorityID.ToString(OutputFormat, formatProvider))
   Case Else
    PropertyNotFound = True
  End Select

  Return Null.NullString
 End Function

 Public ReadOnly Property Cacheability() As DotNetNuke.Services.Tokens.CacheLevel Implements DotNetNuke.Services.Tokens.IPropertyAccess.Cacheability
  Get
   Return CacheLevel.fullyCacheable
  End Get
 End Property

#End Region

#Region " IXmlSerializable Implementation "

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' GetSchema returns the XmlSchema for this class
 ''' </summary>
 ''' <remarks>GetSchema is implemented as a stub method as it is not required</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Function GetSchema() As XmlSchema Implements IXmlSerializable.GetSchema
  Return Nothing
 End Function

 Private Function readElement(ByVal reader As XmlReader, ByVal ElementName As String) As String
  If (Not reader.NodeType = XmlNodeType.Element) OrElse reader.Name <> ElementName Then
   reader.ReadToFollowing(ElementName)
  End If
  If reader.NodeType = XmlNodeType.Element Then
   Return reader.ReadElementContentAsString
  Else
   Return ""
  End If
 End Function

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' ReadXml fills the object (de-serializes it) from the XmlReader passed
 ''' </summary>
 ''' <remarks></remarks>
 ''' <param name="reader">The XmlReader that contains the xml for the object</param>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub ReadXml(ByVal reader As XmlReader) Implements IXmlSerializable.ReadXml
  Try

   ImageUrl = readElement(reader, "ImageUrl")
   Name = readElement(reader, "Name")
  Catch ex As Exception
   ' log exception as DNN import routine does not do that
   DotNetNuke.Services.Exceptions.LogException(ex)
   ' re-raise exception to make sure import routine displays a visible error to the user
   Throw New Exception("An error occured during import of an Priority", ex)
  End Try

 End Sub

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' WriteXml converts the object to Xml (serializes it) and writes it using the XmlWriter passed
 ''' </summary>
 ''' <remarks></remarks>
 ''' <param name="writer">The XmlWriter that contains the xml for the object</param>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub WriteXml(ByVal writer As XmlWriter) Implements IXmlSerializable.WriteXml
  writer.WriteStartElement("Priority")
  writer.WriteElementString("PriorityID", PriorityID.ToString())
  writer.WriteElementString("ImageUrl", ImageUrl)
  writer.WriteElementString("Name", Name)
  writer.WriteEndElement()
 End Sub

#End Region

#Region " ToXml Methods "
 Public Function ToXml() As String
  Return ToXml("Priority")
 End Function

 Public Function ToXml(ByVal elementName As String) As String
  Dim xml As New StringBuilder
  xml.Append("<")
  xml.Append(elementName)
  'Add Attribute(xml, "PriorityID", PriorityID.ToString())
  'Add Attribute(xml, "ImageUrl", ImageUrl)
  'Add Attribute(xml, "Name", Name)
  xml.Append(" />")
  Return xml.ToString
 End Function
#End Region

End Class
#End Region

#Region " PrioritiesController "
Public Class PrioritiesController
 Public Shared Function GetPriorities() As IDictionary(Of Integer, PriorityInfo)

  Return CBO.FillDictionary(Of PriorityInfo)(DataProvider.Instance().GetPriorities())

 End Function

 Public Shared Function GetPriority(ByVal PriorityID As Integer) As PriorityInfo

  Return CType(CBO.FillObject(DataProvider.Instance().GetPriority(PriorityID), GetType(PriorityInfo)), PriorityInfo)

 End Function

 Public Shared Function AddPriority(ByVal objPriority As PriorityInfo) As Integer

  Return CType(DataProvider.Instance().AddPriority(objPriority.ImageUrl, objPriority.Name), Integer)

 End Function

 Public Shared Sub UpdatePriority(ByVal objPriority As PriorityInfo)

  DataProvider.Instance().UpdatePriority(objPriority.PriorityID, objPriority.ImageUrl, objPriority.Name)

 End Sub

 Public Shared Sub DeletePriority(ByVal PriorityID As Integer)

  DataProvider.Instance().DeletePriority(PriorityID)

 End Sub

 Public Shared Function FindPriorityByName(ByVal Name As String) As PriorityInfo

  Return CType(CBO.FillObject(DataProvider.Instance().FindPriorityByName(Name), GetType(PriorityInfo)), PriorityInfo)

 End Function

End Class
#End Region


#Region " ProjectCustomFieldInfo "
<Serializable(), XmlRoot("ProjectCustomField")> _
Public Class ProjectCustomFieldInfo
 Implements IHydratable
 Implements IPropertyAccess
 Implements IXmlSerializable

 ' local property declarations
 Private _CustomFieldId As Integer
 Private _CustomFieldDataType As Integer
 Private _CustomFieldName As String
 Private _CustomFieldRequired As Boolean
 Private _CustomFieldTypeId As Integer
 Private _ProjectId As Integer

#Region " Constructors "
 Public Sub New()
 End Sub

 Public Sub New(ByVal CustomFieldId As Integer, ByVal CustomFieldDataType As Integer, ByVal CustomFieldName As String, ByVal CustomFieldRequired As Boolean, ByVal CustomFieldTypeId As Integer, ByVal ProjectId As Integer)
  Me.CustomFieldDataType = CustomFieldDataType
  Me.CustomFieldId = CustomFieldId
  Me.CustomFieldName = CustomFieldName
  Me.CustomFieldRequired = CustomFieldRequired
  Me.CustomFieldTypeId = CustomFieldTypeId
  Me.ProjectId = ProjectId
 End Sub
#End Region

#Region " Public Properties "

 Public Property CustomFieldId() As Integer
  Get
   Return _CustomFieldId
  End Get
  Set(ByVal Value As Integer)
   _CustomFieldId = Value
  End Set
 End Property

 Public Property CustomFieldDataType() As Integer
  Get
   Return _CustomFieldDataType
  End Get
  Set(ByVal Value As Integer)
   _CustomFieldDataType = Value
  End Set
 End Property

 Public Property CustomFieldName() As String
  Get
   Return _CustomFieldName
  End Get
  Set(ByVal Value As String)
   _CustomFieldName = Value
  End Set
 End Property

 Public Property CustomFieldRequired() As Boolean
  Get
   Return _CustomFieldRequired
  End Get
  Set(ByVal Value As Boolean)
   _CustomFieldRequired = Value
  End Set
 End Property

 Public Property CustomFieldTypeId() As Integer
  Get
   Return _CustomFieldTypeId
  End Get
  Set(ByVal Value As Integer)
   _CustomFieldTypeId = Value
  End Set
 End Property

 Public Property ProjectId() As Integer
  Get
   Return _ProjectId
  End Get
  Set(ByVal Value As Integer)
   _ProjectId = Value
  End Set
 End Property

#End Region

#Region " IHydratable Implementation "

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' Fill hydrates the object from a Datareader
 ''' </summary>
 ''' <remarks>The Fill method is used by the CBO method to hydrtae the object
 ''' rather than using the more expensive Refection  methods.</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub Fill(ByVal dr As IDataReader) Implements IHydratable.Fill

  CustomFieldDataType = Convert.ToInt32(Null.SetNull(dr.Item("CustomFieldDataType"), CustomFieldDataType))
  CustomFieldId = Convert.ToInt32(Null.SetNull(dr.Item("CustomFieldId"), CustomFieldId))
  CustomFieldName = Convert.ToString(Null.SetNull(dr.Item("CustomFieldName"), CustomFieldName))
  CustomFieldRequired = Convert.ToBoolean(Null.SetNull(dr.Item("CustomFieldRequired"), CustomFieldRequired))
  CustomFieldTypeId = Convert.ToInt32(Null.SetNull(dr.Item("CustomFieldTypeId"), CustomFieldTypeId))
  ProjectId = Convert.ToInt32(Null.SetNull(dr.Item("ProjectId"), ProjectId))

 End Sub
 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' Gets and sets the Key ID
 ''' </summary>
 ''' <remarks>The KeyID property is part of the IHydratble interface.  It is used
 ''' as the key property when creating a Dictionary</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Property KeyID() As Integer Implements Entities.Modules.IHydratable.KeyID
  Get
   Return CustomFieldId
  End Get
  Set(ByVal value As Integer)
   CustomFieldId = value
  End Set
 End Property

#End Region

#Region " IPropertyAccess Implementation "

 Public Function GetProperty(ByVal strPropertyName As String, ByVal strFormat As String, ByVal formatProvider As System.Globalization.CultureInfo, ByVal AccessingUser As Entities.Users.UserInfo, ByVal AccessLevel As DotNetNuke.Services.Tokens.Scope, ByRef PropertyNotFound As Boolean) As String Implements DotNetNuke.Services.Tokens.IPropertyAccess.GetProperty
  Dim OutputFormat As String = String.Empty
  Dim portalSettings As PortalSettings = PortalController.GetCurrentPortalSettings()
  If strFormat = String.Empty Then
   OutputFormat = "D"
  Else
   OutputFormat = strFormat
  End If
  Select Case strPropertyName.ToLower
   Case "customfielddatatype"
    Return (Me.CustomFieldDataType.ToString(OutputFormat, formatProvider))
   Case "customfieldid"
    Return (Me.CustomFieldId.ToString(OutputFormat, formatProvider))
   Case "customfieldname"
    Return PropertyAccess.FormatString(Me.CustomFieldName, strFormat)
   Case "customfieldrequired"
    Return PropertyAccess.Boolean2LocalizedYesNo(Me.CustomFieldRequired, formatProvider)
   Case "customfieldtypeid"
    Return (Me.CustomFieldTypeId.ToString(OutputFormat, formatProvider))
   Case "projectid"
    Return (Me.ProjectId.ToString(OutputFormat, formatProvider))
   Case Else
    PropertyNotFound = True
  End Select

  Return Null.NullString
 End Function

 Public ReadOnly Property Cacheability() As DotNetNuke.Services.Tokens.CacheLevel Implements DotNetNuke.Services.Tokens.IPropertyAccess.Cacheability
  Get
   Return CacheLevel.fullyCacheable
  End Get
 End Property

#End Region

#Region " IXmlSerializable Implementation "

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' GetSchema returns the XmlSchema for this class
 ''' </summary>
 ''' <remarks>GetSchema is implemented as a stub method as it is not required</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Function GetSchema() As XmlSchema Implements IXmlSerializable.GetSchema
  Return Nothing
 End Function

 Private Function readElement(ByVal reader As XmlReader, ByVal ElementName As String) As String
  If (Not reader.NodeType = XmlNodeType.Element) OrElse reader.Name <> ElementName Then
   reader.ReadToFollowing(ElementName)
  End If
  If reader.NodeType = XmlNodeType.Element Then
   Return reader.ReadElementContentAsString
  Else
   Return ""
  End If
 End Function

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' ReadXml fills the object (de-serializes it) from the XmlReader passed
 ''' </summary>
 ''' <remarks></remarks>
 ''' <param name="reader">The XmlReader that contains the xml for the object</param>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub ReadXml(ByVal reader As XmlReader) Implements IXmlSerializable.ReadXml
  Try

   If Not Int32.TryParse(readElement(reader, "CustomFieldDataType"), CustomFieldDataType) Then
    CustomFieldDataType = Null.NullInteger
   End If
   CustomFieldName = readElement(reader, "CustomFieldName")
   Boolean.TryParse(readElement(reader, "CustomFieldRequired"), CustomFieldRequired)
   If Not Int32.TryParse(readElement(reader, "CustomFieldTypeId"), CustomFieldTypeId) Then
    CustomFieldTypeId = Null.NullInteger
   End If
   If Not Int32.TryParse(readElement(reader, "ProjectId"), ProjectId) Then
    ProjectId = Null.NullInteger
   End If
  Catch ex As Exception
   ' log exception as DNN import routine does not do that
   DotNetNuke.Services.Exceptions.LogException(ex)
   ' re-raise exception to make sure import routine displays a visible error to the user
   Throw New Exception("An error occured during import of an ProjectCustomField", ex)
  End Try

 End Sub

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' WriteXml converts the object to Xml (serializes it) and writes it using the XmlWriter passed
 ''' </summary>
 ''' <remarks></remarks>
 ''' <param name="writer">The XmlWriter that contains the xml for the object</param>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub WriteXml(ByVal writer As XmlWriter) Implements IXmlSerializable.WriteXml
  writer.WriteStartElement("ProjectCustomField")
  writer.WriteElementString("CustomFieldId", CustomFieldId.ToString())
  writer.WriteElementString("CustomFieldDataType", CustomFieldDataType.ToString())
  writer.WriteElementString("CustomFieldName", CustomFieldName)
  writer.WriteElementString("CustomFieldRequired", CustomFieldRequired.ToString())
  writer.WriteElementString("CustomFieldTypeId", CustomFieldTypeId.ToString())
  writer.WriteElementString("ProjectId", ProjectId.ToString())
  writer.WriteEndElement()
 End Sub

#End Region

#Region " ToXml Methods "
 Public Function ToXml() As String
  Return ToXml("ProjectCustomField")
 End Function

 Public Function ToXml(ByVal elementName As String) As String
  Dim xml As New StringBuilder
  xml.Append("<")
  xml.Append(elementName)
  'Add Attribute(xml, "CustomFieldId", CustomFieldId.ToString())
  'Add Attribute(xml, "CustomFieldDataType", CustomFieldDataType.ToString())
  'Add Attribute(xml, "CustomFieldName", CustomFieldName)
  'Add Attribute(xml, "CustomFieldRequired", CustomFieldRequired.ToString())
  'Add Attribute(xml, "CustomFieldTypeId", CustomFieldTypeId.ToString())
  'Add Attribute(xml, "ProjectId", ProjectId.ToString())
  xml.Append(" />")
  Return xml.ToString
 End Function
#End Region

End Class
#End Region

#Region " ProjectCustomFieldsController "
Public Class ProjectCustomFieldsController

 Public Shared Function GetProjectCustomField(ByVal CustomFieldId As Integer) As ProjectCustomFieldInfo

  Return CType(CBO.FillObject(DataProvider.Instance().GetProjectCustomField(CustomFieldId), GetType(ProjectCustomFieldInfo)), ProjectCustomFieldInfo)

 End Function

 Public Shared Function AddProjectCustomField(ByVal objProjectCustomField As ProjectCustomFieldInfo) As Integer

  Return CType(DataProvider.Instance().AddProjectCustomField(objProjectCustomField.CustomFieldDataType, objProjectCustomField.CustomFieldName, objProjectCustomField.CustomFieldRequired, objProjectCustomField.CustomFieldTypeId, objProjectCustomField.ProjectId), Integer)

 End Function

 Public Shared Sub UpdateProjectCustomField(ByVal objProjectCustomField As ProjectCustomFieldInfo)

  DataProvider.Instance().UpdateProjectCustomField(objProjectCustomField.CustomFieldId, objProjectCustomField.CustomFieldDataType, objProjectCustomField.CustomFieldName, objProjectCustomField.CustomFieldRequired, objProjectCustomField.CustomFieldTypeId, objProjectCustomField.ProjectId)

 End Sub

 Public Shared Sub DeleteProjectCustomField(ByVal CustomFieldId As Integer)

  DataProvider.Instance().DeleteProjectCustomField(CustomFieldId)

 End Sub

End Class
#End Region


#Region " ProjectCustomFieldSelectionInfo "
<Serializable(), XmlRoot("ProjectCustomFieldSelection")> _
Public Class ProjectCustomFieldSelectionInfo
 Implements IHydratable
 Implements IPropertyAccess
 Implements IXmlSerializable

 ' local property declarations
 Private _CustomFieldSelectionId As Integer
 Private _CustomFieldId As Integer
 Private _CustomFieldSelectionName As String
 Private _CustomFieldSelectionSortOrder As Integer
 Private _CustomFieldSelectionValue As String

#Region " Constructors "
 Public Sub New()
 End Sub

 Public Sub New(ByVal CustomFieldSelectionId As Integer, ByVal CustomFieldId As Integer, ByVal CustomFieldSelectionName As String, ByVal CustomFieldSelectionSortOrder As Integer, ByVal CustomFieldSelectionValue As String)
  Me.CustomFieldId = CustomFieldId
  Me.CustomFieldSelectionId = CustomFieldSelectionId
  Me.CustomFieldSelectionName = CustomFieldSelectionName
  Me.CustomFieldSelectionSortOrder = CustomFieldSelectionSortOrder
  Me.CustomFieldSelectionValue = CustomFieldSelectionValue
 End Sub
#End Region

#Region " Public Properties "

 Public Property CustomFieldSelectionId() As Integer
  Get
   Return _CustomFieldSelectionId
  End Get
  Set(ByVal Value As Integer)
   _CustomFieldSelectionId = Value
  End Set
 End Property

 Public Property CustomFieldId() As Integer
  Get
   Return _CustomFieldId
  End Get
  Set(ByVal Value As Integer)
   _CustomFieldId = Value
  End Set
 End Property

 Public Property CustomFieldSelectionName() As String
  Get
   Return _CustomFieldSelectionName
  End Get
  Set(ByVal Value As String)
   _CustomFieldSelectionName = Value
  End Set
 End Property

 Public Property CustomFieldSelectionSortOrder() As Integer
  Get
   Return _CustomFieldSelectionSortOrder
  End Get
  Set(ByVal Value As Integer)
   _CustomFieldSelectionSortOrder = Value
  End Set
 End Property

 Public Property CustomFieldSelectionValue() As String
  Get
   Return _CustomFieldSelectionValue
  End Get
  Set(ByVal Value As String)
   _CustomFieldSelectionValue = Value
  End Set
 End Property

#End Region

#Region " IHydratable Implementation "

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' Fill hydrates the object from a Datareader
 ''' </summary>
 ''' <remarks>The Fill method is used by the CBO method to hydrtae the object
 ''' rather than using the more expensive Refection  methods.</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub Fill(ByVal dr As IDataReader) Implements IHydratable.Fill

  CustomFieldId = Convert.ToInt32(Null.SetNull(dr.Item("CustomFieldId"), CustomFieldId))
  CustomFieldSelectionId = Convert.ToInt32(Null.SetNull(dr.Item("CustomFieldSelectionId"), CustomFieldSelectionId))
  CustomFieldSelectionName = Convert.ToString(Null.SetNull(dr.Item("CustomFieldSelectionName"), CustomFieldSelectionName))
  CustomFieldSelectionSortOrder = Convert.ToInt32(Null.SetNull(dr.Item("CustomFieldSelectionSortOrder"), CustomFieldSelectionSortOrder))
  CustomFieldSelectionValue = Convert.ToString(Null.SetNull(dr.Item("CustomFieldSelectionValue"), CustomFieldSelectionValue))

 End Sub
 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' Gets and sets the Key ID
 ''' </summary>
 ''' <remarks>The KeyID property is part of the IHydratble interface.  It is used
 ''' as the key property when creating a Dictionary</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Property KeyID() As Integer Implements Entities.Modules.IHydratable.KeyID
  Get
   Return CustomFieldSelectionId
  End Get
  Set(ByVal value As Integer)
   CustomFieldSelectionId = value
  End Set
 End Property

#End Region

#Region " IPropertyAccess Implementation "

 Public Function GetProperty(ByVal strPropertyName As String, ByVal strFormat As String, ByVal formatProvider As System.Globalization.CultureInfo, ByVal AccessingUser As Entities.Users.UserInfo, ByVal AccessLevel As DotNetNuke.Services.Tokens.Scope, ByRef PropertyNotFound As Boolean) As String Implements DotNetNuke.Services.Tokens.IPropertyAccess.GetProperty
  Dim OutputFormat As String = String.Empty
  Dim portalSettings As PortalSettings = PortalController.GetCurrentPortalSettings()
  If strFormat = String.Empty Then
   OutputFormat = "D"
  Else
   OutputFormat = strFormat
  End If
  Select Case strPropertyName.ToLower
   Case "customfieldid"
    Return (Me.CustomFieldId.ToString(OutputFormat, formatProvider))
   Case "customfieldselectionid"
    Return (Me.CustomFieldSelectionId.ToString(OutputFormat, formatProvider))
   Case "customfieldselectionname"
    Return PropertyAccess.FormatString(Me.CustomFieldSelectionName, strFormat)
   Case "customfieldselectionsortorder"
    Return (Me.CustomFieldSelectionSortOrder.ToString(OutputFormat, formatProvider))
   Case "customfieldselectionvalue"
    Return PropertyAccess.FormatString(Me.CustomFieldSelectionValue, strFormat)
   Case Else
    PropertyNotFound = True
  End Select

  Return Null.NullString
 End Function

 Public ReadOnly Property Cacheability() As DotNetNuke.Services.Tokens.CacheLevel Implements DotNetNuke.Services.Tokens.IPropertyAccess.Cacheability
  Get
   Return CacheLevel.fullyCacheable
  End Get
 End Property

#End Region

#Region " IXmlSerializable Implementation "

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' GetSchema returns the XmlSchema for this class
 ''' </summary>
 ''' <remarks>GetSchema is implemented as a stub method as it is not required</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Function GetSchema() As XmlSchema Implements IXmlSerializable.GetSchema
  Return Nothing
 End Function

 Private Function readElement(ByVal reader As XmlReader, ByVal ElementName As String) As String
  If (Not reader.NodeType = XmlNodeType.Element) OrElse reader.Name <> ElementName Then
   reader.ReadToFollowing(ElementName)
  End If
  If reader.NodeType = XmlNodeType.Element Then
   Return reader.ReadElementContentAsString
  Else
   Return ""
  End If
 End Function

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' ReadXml fills the object (de-serializes it) from the XmlReader passed
 ''' </summary>
 ''' <remarks></remarks>
 ''' <param name="reader">The XmlReader that contains the xml for the object</param>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub ReadXml(ByVal reader As XmlReader) Implements IXmlSerializable.ReadXml
  Try

   If Not Int32.TryParse(readElement(reader, "CustomFieldId"), CustomFieldId) Then
    CustomFieldId = Null.NullInteger
   End If
   CustomFieldSelectionName = readElement(reader, "CustomFieldSelectionName")
   If Not Int32.TryParse(readElement(reader, "CustomFieldSelectionSortOrder"), CustomFieldSelectionSortOrder) Then
    CustomFieldSelectionSortOrder = Null.NullInteger
   End If
   CustomFieldSelectionValue = readElement(reader, "CustomFieldSelectionValue")
  Catch ex As Exception
   ' log exception as DNN import routine does not do that
   DotNetNuke.Services.Exceptions.LogException(ex)
   ' re-raise exception to make sure import routine displays a visible error to the user
   Throw New Exception("An error occured during import of an ProjectCustomFieldSelection", ex)
  End Try

 End Sub

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' WriteXml converts the object to Xml (serializes it) and writes it using the XmlWriter passed
 ''' </summary>
 ''' <remarks></remarks>
 ''' <param name="writer">The XmlWriter that contains the xml for the object</param>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub WriteXml(ByVal writer As XmlWriter) Implements IXmlSerializable.WriteXml
  writer.WriteStartElement("ProjectCustomFieldSelection")
  writer.WriteElementString("CustomFieldSelectionId", CustomFieldSelectionId.ToString())
  writer.WriteElementString("CustomFieldId", CustomFieldId.ToString())
  writer.WriteElementString("CustomFieldSelectionName", CustomFieldSelectionName)
  writer.WriteElementString("CustomFieldSelectionSortOrder", CustomFieldSelectionSortOrder.ToString())
  writer.WriteElementString("CustomFieldSelectionValue", CustomFieldSelectionValue)
  writer.WriteEndElement()
 End Sub

#End Region

#Region " ToXml Methods "
 Public Function ToXml() As String
  Return ToXml("ProjectCustomFieldSelection")
 End Function

 Public Function ToXml(ByVal elementName As String) As String
  Dim xml As New StringBuilder
  xml.Append("<")
  xml.Append(elementName)
  'Add Attribute(xml, "CustomFieldSelectionId", CustomFieldSelectionId.ToString())
  'Add Attribute(xml, "CustomFieldId", CustomFieldId.ToString())
  'Add Attribute(xml, "CustomFieldSelectionName", CustomFieldSelectionName)
  'Add Attribute(xml, "CustomFieldSelectionSortOrder", CustomFieldSelectionSortOrder.ToString())
  'Add Attribute(xml, "CustomFieldSelectionValue", CustomFieldSelectionValue)
  xml.Append(" />")
  Return xml.ToString
 End Function
#End Region

End Class
#End Region

#Region " ProjectCustomFieldSelectionsController "
Public Class ProjectCustomFieldSelectionsController

 Public Shared Function GetProjectCustomFieldSelection(ByVal CustomFieldSelectionId As Integer) As ProjectCustomFieldSelectionInfo

  Return CType(CBO.FillObject(DataProvider.Instance().GetProjectCustomFieldSelection(CustomFieldSelectionId), GetType(ProjectCustomFieldSelectionInfo)), ProjectCustomFieldSelectionInfo)

 End Function

 Public Shared Function AddProjectCustomFieldSelection(ByVal objProjectCustomFieldSelection As ProjectCustomFieldSelectionInfo) As Integer

  Return CType(DataProvider.Instance().AddProjectCustomFieldSelection(objProjectCustomFieldSelection.CustomFieldId, objProjectCustomFieldSelection.CustomFieldSelectionName, objProjectCustomFieldSelection.CustomFieldSelectionSortOrder, objProjectCustomFieldSelection.CustomFieldSelectionValue), Integer)

 End Function

 Public Shared Sub UpdateProjectCustomFieldSelection(ByVal objProjectCustomFieldSelection As ProjectCustomFieldSelectionInfo)

  DataProvider.Instance().UpdateProjectCustomFieldSelection(objProjectCustomFieldSelection.CustomFieldSelectionId, objProjectCustomFieldSelection.CustomFieldId, objProjectCustomFieldSelection.CustomFieldSelectionName, objProjectCustomFieldSelection.CustomFieldSelectionSortOrder, objProjectCustomFieldSelection.CustomFieldSelectionValue)

 End Sub

 Public Shared Sub DeleteProjectCustomFieldSelection(ByVal CustomFieldSelectionId As Integer)

  DataProvider.Instance().DeleteProjectCustomFieldSelection(CustomFieldSelectionId)

 End Sub

End Class
#End Region


#Region " ProjectCustomFieldTypeInfo "
<Serializable(), XmlRoot("ProjectCustomFieldType")> _
Public Class ProjectCustomFieldTypeInfo
 Implements IHydratable
 Implements IPropertyAccess
 Implements IXmlSerializable

 ' local property declarations
 Private _CustomFieldTypeId As Integer
 Private _CustomFieldTypeName As String

#Region " Constructors "
 Public Sub New()
 End Sub

 Public Sub New(ByVal CustomFieldTypeId As Integer, ByVal CustomFieldTypeName As String)
  Me.CustomFieldTypeId = CustomFieldTypeId
  Me.CustomFieldTypeName = CustomFieldTypeName
 End Sub
#End Region

#Region " Public Properties "

 Public Property CustomFieldTypeId() As Integer
  Get
   Return _CustomFieldTypeId
  End Get
  Set(ByVal Value As Integer)
   _CustomFieldTypeId = Value
  End Set
 End Property

 Public Property CustomFieldTypeName() As String
  Get
   Return _CustomFieldTypeName
  End Get
  Set(ByVal Value As String)
   _CustomFieldTypeName = Value
  End Set
 End Property

#End Region

#Region " IHydratable Implementation "

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' Fill hydrates the object from a Datareader
 ''' </summary>
 ''' <remarks>The Fill method is used by the CBO method to hydrtae the object
 ''' rather than using the more expensive Refection  methods.</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub Fill(ByVal dr As IDataReader) Implements IHydratable.Fill

  CustomFieldTypeId = Convert.ToInt32(Null.SetNull(dr.Item("CustomFieldTypeId"), CustomFieldTypeId))
  CustomFieldTypeName = Convert.ToString(Null.SetNull(dr.Item("CustomFieldTypeName"), CustomFieldTypeName))

 End Sub
 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' Gets and sets the Key ID
 ''' </summary>
 ''' <remarks>The KeyID property is part of the IHydratble interface.  It is used
 ''' as the key property when creating a Dictionary</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Property KeyID() As Integer Implements Entities.Modules.IHydratable.KeyID
  Get
   Return CustomFieldTypeId
  End Get
  Set(ByVal value As Integer)
   CustomFieldTypeId = value
  End Set
 End Property

#End Region

#Region " IPropertyAccess Implementation "

 Public Function GetProperty(ByVal strPropertyName As String, ByVal strFormat As String, ByVal formatProvider As System.Globalization.CultureInfo, ByVal AccessingUser As Entities.Users.UserInfo, ByVal AccessLevel As DotNetNuke.Services.Tokens.Scope, ByRef PropertyNotFound As Boolean) As String Implements DotNetNuke.Services.Tokens.IPropertyAccess.GetProperty
  Dim OutputFormat As String = String.Empty
  Dim portalSettings As PortalSettings = PortalController.GetCurrentPortalSettings()
  If strFormat = String.Empty Then
   OutputFormat = "D"
  Else
   OutputFormat = strFormat
  End If
  Select Case strPropertyName.ToLower
   Case "customfieldtypeid"
    Return (Me.CustomFieldTypeId.ToString(OutputFormat, formatProvider))
   Case "customfieldtypename"
    Return PropertyAccess.FormatString(Me.CustomFieldTypeName, strFormat)
   Case Else
    PropertyNotFound = True
  End Select

  Return Null.NullString
 End Function

 Public ReadOnly Property Cacheability() As DotNetNuke.Services.Tokens.CacheLevel Implements DotNetNuke.Services.Tokens.IPropertyAccess.Cacheability
  Get
   Return CacheLevel.fullyCacheable
  End Get
 End Property

#End Region

#Region " IXmlSerializable Implementation "

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' GetSchema returns the XmlSchema for this class
 ''' </summary>
 ''' <remarks>GetSchema is implemented as a stub method as it is not required</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Function GetSchema() As XmlSchema Implements IXmlSerializable.GetSchema
  Return Nothing
 End Function

 Private Function readElement(ByVal reader As XmlReader, ByVal ElementName As String) As String
  If (Not reader.NodeType = XmlNodeType.Element) OrElse reader.Name <> ElementName Then
   reader.ReadToFollowing(ElementName)
  End If
  If reader.NodeType = XmlNodeType.Element Then
   Return reader.ReadElementContentAsString
  Else
   Return ""
  End If
 End Function

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' ReadXml fills the object (de-serializes it) from the XmlReader passed
 ''' </summary>
 ''' <remarks></remarks>
 ''' <param name="reader">The XmlReader that contains the xml for the object</param>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub ReadXml(ByVal reader As XmlReader) Implements IXmlSerializable.ReadXml
  Try

   CustomFieldTypeName = readElement(reader, "CustomFieldTypeName")
  Catch ex As Exception
   ' log exception as DNN import routine does not do that
   DotNetNuke.Services.Exceptions.LogException(ex)
   ' re-raise exception to make sure import routine displays a visible error to the user
   Throw New Exception("An error occured during import of an ProjectCustomFieldType", ex)
  End Try

 End Sub

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' WriteXml converts the object to Xml (serializes it) and writes it using the XmlWriter passed
 ''' </summary>
 ''' <remarks></remarks>
 ''' <param name="writer">The XmlWriter that contains the xml for the object</param>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub WriteXml(ByVal writer As XmlWriter) Implements IXmlSerializable.WriteXml
  writer.WriteStartElement("ProjectCustomFieldType")
  writer.WriteElementString("CustomFieldTypeId", CustomFieldTypeId.ToString())
  writer.WriteElementString("CustomFieldTypeName", CustomFieldTypeName)
  writer.WriteEndElement()
 End Sub

#End Region

#Region " ToXml Methods "
 Public Function ToXml() As String
  Return ToXml("ProjectCustomFieldType")
 End Function

 Public Function ToXml(ByVal elementName As String) As String
  Dim xml As New StringBuilder
  xml.Append("<")
  xml.Append(elementName)
  'Add Attribute(xml, "CustomFieldTypeId", CustomFieldTypeId.ToString())
  'Add Attribute(xml, "CustomFieldTypeName", CustomFieldTypeName)
  xml.Append(" />")
  Return xml.ToString
 End Function
#End Region

End Class
#End Region

#Region " ProjectCustomFieldTypesController "
Public Class ProjectCustomFieldTypesController

 Public Shared Function GetProjectCustomFieldType(ByVal CustomFieldTypeId As Integer) As ProjectCustomFieldTypeInfo

  Return CType(CBO.FillObject(DataProvider.Instance().GetProjectCustomFieldType(CustomFieldTypeId), GetType(ProjectCustomFieldTypeInfo)), ProjectCustomFieldTypeInfo)

 End Function

 Public Shared Function AddProjectCustomFieldType(ByVal objProjectCustomFieldType As ProjectCustomFieldTypeInfo) As Integer

  Return CType(DataProvider.Instance().AddProjectCustomFieldType(objProjectCustomFieldType.CustomFieldTypeName), Integer)

 End Function

 Public Shared Sub UpdateProjectCustomFieldType(ByVal objProjectCustomFieldType As ProjectCustomFieldTypeInfo)

  DataProvider.Instance().UpdateProjectCustomFieldType(objProjectCustomFieldType.CustomFieldTypeId, objProjectCustomFieldType.CustomFieldTypeName)

 End Sub

 Public Shared Sub DeleteProjectCustomFieldType(ByVal CustomFieldTypeId As Integer)

  DataProvider.Instance().DeleteProjectCustomFieldType(CustomFieldTypeId)

 End Sub

End Class
#End Region


#Region " ProjectCustomFieldValueInfo "
<Serializable(), XmlRoot("ProjectCustomFieldValue")> _
Public Class ProjectCustomFieldValueInfo
 Implements IHydratable
 Implements IPropertyAccess
 Implements IXmlSerializable

 ' local property declarations
 Private _CustomFieldValueId As Integer
 Private _BugId As Integer
 Private _CustomFieldId As Integer
 Private _CustomFieldValue As String

#Region " Constructors "
 Public Sub New()
 End Sub

 Public Sub New(ByVal CustomFieldValueId As Integer, ByVal BugId As Integer, ByVal CustomFieldId As Integer, ByVal CustomFieldValue As String)
  Me.BugId = BugId
  Me.CustomFieldId = CustomFieldId
  Me.CustomFieldValue = CustomFieldValue
  Me.CustomFieldValueId = CustomFieldValueId
 End Sub
#End Region

#Region " Public Properties "

 Public Property CustomFieldValueId() As Integer
  Get
   Return _CustomFieldValueId
  End Get
  Set(ByVal Value As Integer)
   _CustomFieldValueId = Value
  End Set
 End Property

 Public Property BugId() As Integer
  Get
   Return _BugId
  End Get
  Set(ByVal Value As Integer)
   _BugId = Value
  End Set
 End Property

 Public Property CustomFieldId() As Integer
  Get
   Return _CustomFieldId
  End Get
  Set(ByVal Value As Integer)
   _CustomFieldId = Value
  End Set
 End Property

 Public Property CustomFieldValue() As String
  Get
   Return _CustomFieldValue
  End Get
  Set(ByVal Value As String)
   _CustomFieldValue = Value
  End Set
 End Property

#End Region

#Region " IHydratable Implementation "

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' Fill hydrates the object from a Datareader
 ''' </summary>
 ''' <remarks>The Fill method is used by the CBO method to hydrtae the object
 ''' rather than using the more expensive Refection  methods.</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub Fill(ByVal dr As IDataReader) Implements IHydratable.Fill

  BugId = Convert.ToInt32(Null.SetNull(dr.Item("BugId"), BugId))
  CustomFieldId = Convert.ToInt32(Null.SetNull(dr.Item("CustomFieldId"), CustomFieldId))
  CustomFieldValue = Convert.ToString(Null.SetNull(dr.Item("CustomFieldValue"), CustomFieldValue))
  CustomFieldValueId = Convert.ToInt32(Null.SetNull(dr.Item("CustomFieldValueId"), CustomFieldValueId))

 End Sub
 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' Gets and sets the Key ID
 ''' </summary>
 ''' <remarks>The KeyID property is part of the IHydratble interface.  It is used
 ''' as the key property when creating a Dictionary</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Property KeyID() As Integer Implements Entities.Modules.IHydratable.KeyID
  Get
   Return CustomFieldValueId
  End Get
  Set(ByVal value As Integer)
   CustomFieldValueId = value
  End Set
 End Property

#End Region

#Region " IPropertyAccess Implementation "

 Public Function GetProperty(ByVal strPropertyName As String, ByVal strFormat As String, ByVal formatProvider As System.Globalization.CultureInfo, ByVal AccessingUser As Entities.Users.UserInfo, ByVal AccessLevel As DotNetNuke.Services.Tokens.Scope, ByRef PropertyNotFound As Boolean) As String Implements DotNetNuke.Services.Tokens.IPropertyAccess.GetProperty
  Dim OutputFormat As String = String.Empty
  Dim portalSettings As PortalSettings = PortalController.GetCurrentPortalSettings()
  If strFormat = String.Empty Then
   OutputFormat = "D"
  Else
   OutputFormat = strFormat
  End If
  Select Case strPropertyName.ToLower
   Case "bugid"
    Return (Me.BugId.ToString(OutputFormat, formatProvider))
   Case "customfieldid"
    Return (Me.CustomFieldId.ToString(OutputFormat, formatProvider))
   Case "customfieldvalue"
    Return PropertyAccess.FormatString(Me.CustomFieldValue, strFormat)
   Case "customfieldvalueid"
    Return (Me.CustomFieldValueId.ToString(OutputFormat, formatProvider))
   Case Else
    PropertyNotFound = True
  End Select

  Return Null.NullString
 End Function

 Public ReadOnly Property Cacheability() As DotNetNuke.Services.Tokens.CacheLevel Implements DotNetNuke.Services.Tokens.IPropertyAccess.Cacheability
  Get
   Return CacheLevel.fullyCacheable
  End Get
 End Property

#End Region

#Region " IXmlSerializable Implementation "

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' GetSchema returns the XmlSchema for this class
 ''' </summary>
 ''' <remarks>GetSchema is implemented as a stub method as it is not required</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Function GetSchema() As XmlSchema Implements IXmlSerializable.GetSchema
  Return Nothing
 End Function

 Private Function readElement(ByVal reader As XmlReader, ByVal ElementName As String) As String
  If (Not reader.NodeType = XmlNodeType.Element) OrElse reader.Name <> ElementName Then
   reader.ReadToFollowing(ElementName)
  End If
  If reader.NodeType = XmlNodeType.Element Then
   Return reader.ReadElementContentAsString
  Else
   Return ""
  End If
 End Function

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' ReadXml fills the object (de-serializes it) from the XmlReader passed
 ''' </summary>
 ''' <remarks></remarks>
 ''' <param name="reader">The XmlReader that contains the xml for the object</param>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub ReadXml(ByVal reader As XmlReader) Implements IXmlSerializable.ReadXml
  Try

   If Not Int32.TryParse(readElement(reader, "BugId"), BugId) Then
    BugId = Null.NullInteger
   End If
   If Not Int32.TryParse(readElement(reader, "CustomFieldId"), CustomFieldId) Then
    CustomFieldId = Null.NullInteger
   End If
   CustomFieldValue = readElement(reader, "CustomFieldValue")
  Catch ex As Exception
   ' log exception as DNN import routine does not do that
   DotNetNuke.Services.Exceptions.LogException(ex)
   ' re-raise exception to make sure import routine displays a visible error to the user
   Throw New Exception("An error occured during import of an ProjectCustomFieldValue", ex)
  End Try

 End Sub

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' WriteXml converts the object to Xml (serializes it) and writes it using the XmlWriter passed
 ''' </summary>
 ''' <remarks></remarks>
 ''' <param name="writer">The XmlWriter that contains the xml for the object</param>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub WriteXml(ByVal writer As XmlWriter) Implements IXmlSerializable.WriteXml
  writer.WriteStartElement("ProjectCustomFieldValue")
  writer.WriteElementString("CustomFieldValueId", CustomFieldValueId.ToString())
  writer.WriteElementString("BugId", BugId.ToString())
  writer.WriteElementString("CustomFieldId", CustomFieldId.ToString())
  writer.WriteElementString("CustomFieldValue", CustomFieldValue)
  writer.WriteEndElement()
 End Sub

#End Region

#Region " ToXml Methods "
 Public Function ToXml() As String
  Return ToXml("ProjectCustomFieldValue")
 End Function

 Public Function ToXml(ByVal elementName As String) As String
  Dim xml As New StringBuilder
  xml.Append("<")
  xml.Append(elementName)
  'Add Attribute(xml, "CustomFieldValueId", CustomFieldValueId.ToString())
  'Add Attribute(xml, "BugId", BugId.ToString())
  'Add Attribute(xml, "CustomFieldId", CustomFieldId.ToString())
  'Add Attribute(xml, "CustomFieldValue", CustomFieldValue)
  xml.Append(" />")
  Return xml.ToString
 End Function
#End Region

End Class
#End Region

#Region " ProjectCustomFieldValuesController "
Public Class ProjectCustomFieldValuesController

 Public Shared Function GetProjectCustomFieldValue(ByVal CustomFieldValueId As Integer) As ProjectCustomFieldValueInfo

  Return CType(CBO.FillObject(DataProvider.Instance().GetProjectCustomFieldValue(CustomFieldValueId), GetType(ProjectCustomFieldValueInfo)), ProjectCustomFieldValueInfo)

 End Function

 Public Shared Function AddProjectCustomFieldValue(ByVal objProjectCustomFieldValue As ProjectCustomFieldValueInfo) As Integer

  Return CType(DataProvider.Instance().AddProjectCustomFieldValue(objProjectCustomFieldValue.BugId, objProjectCustomFieldValue.CustomFieldId, objProjectCustomFieldValue.CustomFieldValue), Integer)

 End Function

 Public Shared Sub UpdateProjectCustomFieldValue(ByVal objProjectCustomFieldValue As ProjectCustomFieldValueInfo)

  DataProvider.Instance().UpdateProjectCustomFieldValue(objProjectCustomFieldValue.CustomFieldValueId, objProjectCustomFieldValue.BugId, objProjectCustomFieldValue.CustomFieldId, objProjectCustomFieldValue.CustomFieldValue)

 End Sub

 Public Shared Sub DeleteProjectCustomFieldValue(ByVal CustomFieldValueId As Integer)

  DataProvider.Instance().DeleteProjectCustomFieldValue(CustomFieldValueId)

 End Sub

End Class
#End Region


#Region " ProjectMailBoxInfo "
<Serializable(), XmlRoot("ProjectMailBox")> _
Public Class ProjectMailBoxInfo
 Implements IHydratable
 Implements IPropertyAccess
 Implements IXmlSerializable

 ' local property declarations
 Private _ProjectMailboxId As Integer
 Private _AssignToUserName As String
 Private _IssueTypeId As Integer
 Private _MailBox As String
 Private _ProjectId As Integer

#Region " Constructors "
 Public Sub New()
 End Sub

 Public Sub New(ByVal ProjectMailboxId As Integer, ByVal AssignToUserName As String, ByVal IssueTypeId As Integer, ByVal MailBox As String, ByVal ProjectId As Integer)
  Me.AssignToUserName = AssignToUserName
  Me.IssueTypeId = IssueTypeId
  Me.MailBox = MailBox
  Me.ProjectId = ProjectId
  Me.ProjectMailboxId = ProjectMailboxId
 End Sub
#End Region

#Region " Public Properties "

 Public Property ProjectMailboxId() As Integer
  Get
   Return _ProjectMailboxId
  End Get
  Set(ByVal Value As Integer)
   _ProjectMailboxId = Value
  End Set
 End Property

 Public Property AssignToUserName() As String
  Get
   Return _AssignToUserName
  End Get
  Set(ByVal Value As String)
   _AssignToUserName = Value
  End Set
 End Property

 Public Property IssueTypeId() As Integer
  Get
   Return _IssueTypeId
  End Get
  Set(ByVal Value As Integer)
   _IssueTypeId = Value
  End Set
 End Property

 Public Property MailBox() As String
  Get
   Return _MailBox
  End Get
  Set(ByVal Value As String)
   _MailBox = Value
  End Set
 End Property

 Public Property ProjectId() As Integer
  Get
   Return _ProjectId
  End Get
  Set(ByVal Value As Integer)
   _ProjectId = Value
  End Set
 End Property

#End Region

#Region " IHydratable Implementation "

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' Fill hydrates the object from a Datareader
 ''' </summary>
 ''' <remarks>The Fill method is used by the CBO method to hydrtae the object
 ''' rather than using the more expensive Refection  methods.</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub Fill(ByVal dr As IDataReader) Implements IHydratable.Fill

  AssignToUserName = Convert.ToString(Null.SetNull(dr.Item("AssignToUserName"), AssignToUserName))
  IssueTypeId = Convert.ToInt32(Null.SetNull(dr.Item("IssueTypeId"), IssueTypeId))
  MailBox = Convert.ToString(Null.SetNull(dr.Item("MailBox"), MailBox))
  ProjectId = Convert.ToInt32(Null.SetNull(dr.Item("ProjectId"), ProjectId))
  ProjectMailboxId = Convert.ToInt32(Null.SetNull(dr.Item("ProjectMailboxId"), ProjectMailboxId))

 End Sub
 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' Gets and sets the Key ID
 ''' </summary>
 ''' <remarks>The KeyID property is part of the IHydratble interface.  It is used
 ''' as the key property when creating a Dictionary</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Property KeyID() As Integer Implements Entities.Modules.IHydratable.KeyID
  Get
   Return ProjectMailboxId
  End Get
  Set(ByVal value As Integer)
   ProjectMailboxId = value
  End Set
 End Property

#End Region

#Region " IPropertyAccess Implementation "

 Public Function GetProperty(ByVal strPropertyName As String, ByVal strFormat As String, ByVal formatProvider As System.Globalization.CultureInfo, ByVal AccessingUser As Entities.Users.UserInfo, ByVal AccessLevel As DotNetNuke.Services.Tokens.Scope, ByRef PropertyNotFound As Boolean) As String Implements DotNetNuke.Services.Tokens.IPropertyAccess.GetProperty
  Dim OutputFormat As String = String.Empty
  Dim portalSettings As PortalSettings = PortalController.GetCurrentPortalSettings()
  If strFormat = String.Empty Then
   OutputFormat = "D"
  Else
   OutputFormat = strFormat
  End If
  Select Case strPropertyName.ToLower
   Case "assigntousername"
    Return PropertyAccess.FormatString(Me.AssignToUserName, strFormat)
   Case "issuetypeid"
    Return (Me.IssueTypeId.ToString(OutputFormat, formatProvider))
   Case "mailbox"
    Return PropertyAccess.FormatString(Me.MailBox, strFormat)
   Case "projectid"
    Return (Me.ProjectId.ToString(OutputFormat, formatProvider))
   Case "projectmailboxid"
    Return (Me.ProjectMailboxId.ToString(OutputFormat, formatProvider))
   Case Else
    PropertyNotFound = True
  End Select

  Return Null.NullString
 End Function

 Public ReadOnly Property Cacheability() As DotNetNuke.Services.Tokens.CacheLevel Implements DotNetNuke.Services.Tokens.IPropertyAccess.Cacheability
  Get
   Return CacheLevel.fullyCacheable
  End Get
 End Property

#End Region

#Region " IXmlSerializable Implementation "

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' GetSchema returns the XmlSchema for this class
 ''' </summary>
 ''' <remarks>GetSchema is implemented as a stub method as it is not required</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Function GetSchema() As XmlSchema Implements IXmlSerializable.GetSchema
  Return Nothing
 End Function

 Private Function readElement(ByVal reader As XmlReader, ByVal ElementName As String) As String
  If (Not reader.NodeType = XmlNodeType.Element) OrElse reader.Name <> ElementName Then
   reader.ReadToFollowing(ElementName)
  End If
  If reader.NodeType = XmlNodeType.Element Then
   Return reader.ReadElementContentAsString
  Else
   Return ""
  End If
 End Function

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' ReadXml fills the object (de-serializes it) from the XmlReader passed
 ''' </summary>
 ''' <remarks></remarks>
 ''' <param name="reader">The XmlReader that contains the xml for the object</param>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub ReadXml(ByVal reader As XmlReader) Implements IXmlSerializable.ReadXml
  Try

   readElement(reader, "AssignToUserName")
   If Not Int32.TryParse(readElement(reader, "IssueTypeId"), IssueTypeId) Then
    IssueTypeId = Null.NullInteger
   End If
   MailBox = readElement(reader, "MailBox")
   If Not Int32.TryParse(readElement(reader, "ProjectId"), ProjectId) Then
    ProjectId = Null.NullInteger
   End If
  Catch ex As Exception
   ' log exception as DNN import routine does not do that
   DotNetNuke.Services.Exceptions.LogException(ex)
   ' re-raise exception to make sure import routine displays a visible error to the user
   Throw New Exception("An error occured during import of an ProjectMailBoxe", ex)
  End Try

 End Sub

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' WriteXml converts the object to Xml (serializes it) and writes it using the XmlWriter passed
 ''' </summary>
 ''' <remarks></remarks>
 ''' <param name="writer">The XmlWriter that contains the xml for the object</param>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub WriteXml(ByVal writer As XmlWriter) Implements IXmlSerializable.WriteXml
  writer.WriteStartElement("ProjectMailBoxe")
  writer.WriteElementString("ProjectMailboxId", ProjectMailboxId.ToString())
  writer.WriteElementString("AssignToUserName", AssignToUserName.ToString())
  writer.WriteElementString("IssueTypeId", IssueTypeId.ToString())
  writer.WriteElementString("MailBox", MailBox)
  writer.WriteElementString("ProjectId", ProjectId.ToString())
  writer.WriteEndElement()
 End Sub

#End Region

#Region " ToXml Methods "
 Public Function ToXml() As String
  Return ToXml("ProjectMailBoxe")
 End Function

 Public Function ToXml(ByVal elementName As String) As String
  Dim xml As New StringBuilder
  xml.Append("<")
  xml.Append(elementName)
  'Add Attribute(xml, "ProjectMailboxId", ProjectMailboxId.ToString())
  'Add Attribute(xml, "AssignToUserName", AssignToUserName.ToString())
  'Add Attribute(xml, "IssueTypeId", IssueTypeId.ToString())
  'Add Attribute(xml, "MailBox", MailBox)
  'Add Attribute(xml, "ProjectId", ProjectId.ToString())
  xml.Append(" />")
  Return xml.ToString
 End Function
#End Region

End Class
#End Region

#Region " ProjectMailBoxesController "
Public Class ProjectMailBoxesController

 Public Shared Function GetProjectMailBox(ByVal ProjectMailboxId As Integer) As ProjectMailBoxInfo

  Return CType(CBO.FillObject(DataProvider.Instance().GetProjectMailBox(ProjectMailboxId), GetType(ProjectMailBoxInfo)), ProjectMailBoxInfo)

 End Function

 Public Shared Function AddProjectMailBox(ByVal objProjectMailBox As ProjectMailBoxInfo) As Integer

  Return CType(DataProvider.Instance().AddProjectMailBox(objProjectMailBox.AssignToUserName, objProjectMailBox.IssueTypeId, objProjectMailBox.MailBox, objProjectMailBox.ProjectId), Integer)

 End Function

 Public Shared Sub UpdateProjectMailBox(ByVal objProjectMailBox As ProjectMailBoxInfo)

  DataProvider.Instance().UpdateProjectMailBox(objProjectMailBox.ProjectMailboxId, objProjectMailBox.AssignToUserName, objProjectMailBox.IssueTypeId, objProjectMailBox.MailBox, objProjectMailBox.ProjectId)

 End Sub

 Public Shared Sub DeleteProjectMailBox(ByVal ProjectMailboxId As Integer)

  DataProvider.Instance().DeleteProjectMailBox(ProjectMailboxId)

 End Sub

End Class
#End Region


#Region " RelatedBugInfo "
<Serializable(), XmlRoot("RelatedBug")> _
Public Class RelatedBugInfo
 Implements IHydratable
 Implements IPropertyAccess
 Implements IXmlSerializable

 ' local property declarations
 Private _RelatedBugID As Integer
 Private _BugID As Integer
 Private _LinkedBugID As Integer

#Region " Constructors "
 Public Sub New()
 End Sub

 Public Sub New(ByVal RelatedBugID As Integer, ByVal BugID As Integer, ByVal LinkedBugID As Integer)
  Me.BugID = BugID
  Me.LinkedBugID = LinkedBugID
  Me.RelatedBugID = RelatedBugID
 End Sub
#End Region

#Region " Public Properties "

 Public Property RelatedBugID() As Integer
  Get
   Return _RelatedBugID
  End Get
  Set(ByVal Value As Integer)
   _RelatedBugID = Value
  End Set
 End Property

 Public Property BugID() As Integer
  Get
   Return _BugID
  End Get
  Set(ByVal Value As Integer)
   _BugID = Value
  End Set
 End Property

 Public Property LinkedBugID() As Integer
  Get
   Return _LinkedBugID
  End Get
  Set(ByVal Value As Integer)
   _LinkedBugID = Value
  End Set
 End Property

#End Region

#Region " IHydratable Implementation "

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' Fill hydrates the object from a Datareader
 ''' </summary>
 ''' <remarks>The Fill method is used by the CBO method to hydrtae the object
 ''' rather than using the more expensive Refection  methods.</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub Fill(ByVal dr As IDataReader) Implements IHydratable.Fill

  BugID = Convert.ToInt32(Null.SetNull(dr.Item("BugID"), BugID))
  LinkedBugID = Convert.ToInt32(Null.SetNull(dr.Item("LinkedBugID"), LinkedBugID))
  RelatedBugID = Convert.ToInt32(Null.SetNull(dr.Item("RelatedBugID"), RelatedBugID))

 End Sub
 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' Gets and sets the Key ID
 ''' </summary>
 ''' <remarks>The KeyID property is part of the IHydratble interface.  It is used
 ''' as the key property when creating a Dictionary</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Property KeyID() As Integer Implements Entities.Modules.IHydratable.KeyID
  Get
   Return RelatedBugID
  End Get
  Set(ByVal value As Integer)
   RelatedBugID = value
  End Set
 End Property

#End Region

#Region " IPropertyAccess Implementation "

 Public Function GetProperty(ByVal strPropertyName As String, ByVal strFormat As String, ByVal formatProvider As System.Globalization.CultureInfo, ByVal AccessingUser As Entities.Users.UserInfo, ByVal AccessLevel As DotNetNuke.Services.Tokens.Scope, ByRef PropertyNotFound As Boolean) As String Implements DotNetNuke.Services.Tokens.IPropertyAccess.GetProperty
  Dim OutputFormat As String = String.Empty
  Dim portalSettings As PortalSettings = PortalController.GetCurrentPortalSettings()
  If strFormat = String.Empty Then
   OutputFormat = "D"
  Else
   OutputFormat = strFormat
  End If
  Select Case strPropertyName.ToLower
   Case "bugid"
    Return (Me.BugID.ToString(OutputFormat, formatProvider))
   Case "linkedbugid"
    Return (Me.LinkedBugID.ToString(OutputFormat, formatProvider))
   Case "relatedbugid"
    Return (Me.RelatedBugID.ToString(OutputFormat, formatProvider))
   Case Else
    PropertyNotFound = True
  End Select

  Return Null.NullString
 End Function

 Public ReadOnly Property Cacheability() As DotNetNuke.Services.Tokens.CacheLevel Implements DotNetNuke.Services.Tokens.IPropertyAccess.Cacheability
  Get
   Return CacheLevel.fullyCacheable
  End Get
 End Property

#End Region

#Region " IXmlSerializable Implementation "

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' GetSchema returns the XmlSchema for this class
 ''' </summary>
 ''' <remarks>GetSchema is implemented as a stub method as it is not required</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Function GetSchema() As XmlSchema Implements IXmlSerializable.GetSchema
  Return Nothing
 End Function

 Private Function readElement(ByVal reader As XmlReader, ByVal ElementName As String) As String
  If (Not reader.NodeType = XmlNodeType.Element) OrElse reader.Name <> ElementName Then
   reader.ReadToFollowing(ElementName)
  End If
  If reader.NodeType = XmlNodeType.Element Then
   Return reader.ReadElementContentAsString
  Else
   Return ""
  End If
 End Function

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' ReadXml fills the object (de-serializes it) from the XmlReader passed
 ''' </summary>
 ''' <remarks></remarks>
 ''' <param name="reader">The XmlReader that contains the xml for the object</param>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub ReadXml(ByVal reader As XmlReader) Implements IXmlSerializable.ReadXml
  Try

   If Not Int32.TryParse(readElement(reader, "BugID"), BugID) Then
    BugID = Null.NullInteger
   End If
   If Not Int32.TryParse(readElement(reader, "LinkedBugID"), LinkedBugID) Then
    LinkedBugID = Null.NullInteger
   End If
  Catch ex As Exception
   ' log exception as DNN import routine does not do that
   DotNetNuke.Services.Exceptions.LogException(ex)
   ' re-raise exception to make sure import routine displays a visible error to the user
   Throw New Exception("An error occured during import of an RelatedBug", ex)
  End Try

 End Sub

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' WriteXml converts the object to Xml (serializes it) and writes it using the XmlWriter passed
 ''' </summary>
 ''' <remarks></remarks>
 ''' <param name="writer">The XmlWriter that contains the xml for the object</param>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub WriteXml(ByVal writer As XmlWriter) Implements IXmlSerializable.WriteXml
  writer.WriteStartElement("RelatedBug")
  writer.WriteElementString("RelatedBugID", RelatedBugID.ToString())
  writer.WriteElementString("BugID", BugID.ToString())
  writer.WriteElementString("LinkedBugID", LinkedBugID.ToString())
  writer.WriteEndElement()
 End Sub

#End Region

#Region " ToXml Methods "
 Public Function ToXml() As String
  Return ToXml("RelatedBug")
 End Function

 Public Function ToXml(ByVal elementName As String) As String
  Dim xml As New StringBuilder
  xml.Append("<")
  xml.Append(elementName)
  'Add Attribute(xml, "RelatedBugID", RelatedBugID.ToString())
  'Add Attribute(xml, "BugID", BugID.ToString())
  'Add Attribute(xml, "LinkedBugID", LinkedBugID.ToString())
  xml.Append(" />")
  Return xml.ToString
 End Function
#End Region

End Class
#End Region

#Region " RelatedBugsController "
Public Class RelatedBugsController

 Public Shared Function GetRelatedBug(ByVal RelatedBugID As Integer) As RelatedBugInfo

  Return CType(CBO.FillObject(DataProvider.Instance().GetRelatedBug(RelatedBugID), GetType(RelatedBugInfo)), RelatedBugInfo)

 End Function

 Public Shared Function AddRelatedBug(ByVal objRelatedBug As RelatedBugInfo) As Integer

  Return CType(DataProvider.Instance().AddRelatedBug(objRelatedBug.BugID, objRelatedBug.LinkedBugID), Integer)

 End Function

 Public Shared Sub UpdateRelatedBug(ByVal objRelatedBug As RelatedBugInfo)

  DataProvider.Instance().UpdateRelatedBug(objRelatedBug.RelatedBugID, objRelatedBug.BugID, objRelatedBug.LinkedBugID)
	
 End Sub

 Public Shared Sub DeleteRelatedBug(ByVal RelatedBugID As Integer)

  DataProvider.Instance().DeleteRelatedBug(RelatedBugID)

 End Sub

End Class
#End Region


#Region " ResolutionInfo "
<Serializable(), XmlRoot("Resolution")> _
Public Class ResolutionInfo
 Implements IHydratable
 Implements IPropertyAccess
 Implements IXmlSerializable

 ' local property declarations
 Private _ResolutionID As Integer
 Private _Name As String

#Region " Constructors "
 Public Sub New()
 End Sub

 Public Sub New(ByVal ResolutionID As Integer, ByVal Name As String)
  Me.Name = Name
  Me.ResolutionID = ResolutionID
 End Sub
#End Region

#Region " Public Properties "

 Public Property ResolutionID() As Integer
  Get
   Return _ResolutionID
  End Get
  Set(ByVal Value As Integer)
   _ResolutionID = Value
  End Set
 End Property

 Public Property Name() As String
  Get
   Return _Name
  End Get
  Set(ByVal Value As String)
   _Name = Value
  End Set
 End Property

#End Region

#Region " IHydratable Implementation "

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' Fill hydrates the object from a Datareader
 ''' </summary>
 ''' <remarks>The Fill method is used by the CBO method to hydrtae the object
 ''' rather than using the more expensive Refection  methods.</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub Fill(ByVal dr As IDataReader) Implements IHydratable.Fill

  Name = Convert.ToString(Null.SetNull(dr.Item("Name"), Name))
  ResolutionID = Convert.ToInt32(Null.SetNull(dr.Item("ResolutionID"), ResolutionID))

 End Sub
 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' Gets and sets the Key ID
 ''' </summary>
 ''' <remarks>The KeyID property is part of the IHydratble interface.  It is used
 ''' as the key property when creating a Dictionary</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Property KeyID() As Integer Implements Entities.Modules.IHydratable.KeyID
  Get
   Return ResolutionID
  End Get
  Set(ByVal value As Integer)
   ResolutionID = value
  End Set
 End Property

#End Region

#Region " IPropertyAccess Implementation "

 Public Function GetProperty(ByVal strPropertyName As String, ByVal strFormat As String, ByVal formatProvider As System.Globalization.CultureInfo, ByVal AccessingUser As Entities.Users.UserInfo, ByVal AccessLevel As DotNetNuke.Services.Tokens.Scope, ByRef PropertyNotFound As Boolean) As String Implements DotNetNuke.Services.Tokens.IPropertyAccess.GetProperty
  Dim OutputFormat As String = String.Empty
  Dim portalSettings As PortalSettings = PortalController.GetCurrentPortalSettings()
  If strFormat = String.Empty Then
   OutputFormat = "D"
  Else
   OutputFormat = strFormat
  End If
  Select Case strPropertyName.ToLower
   Case "name"
    Return PropertyAccess.FormatString(Me.Name, strFormat)
   Case "resolutionid"
    Return (Me.ResolutionID.ToString(OutputFormat, formatProvider))
   Case Else
    PropertyNotFound = True
  End Select

  Return Null.NullString
 End Function

 Public ReadOnly Property Cacheability() As DotNetNuke.Services.Tokens.CacheLevel Implements DotNetNuke.Services.Tokens.IPropertyAccess.Cacheability
  Get
   Return CacheLevel.fullyCacheable
  End Get
 End Property

#End Region

#Region " IXmlSerializable Implementation "

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' GetSchema returns the XmlSchema for this class
 ''' </summary>
 ''' <remarks>GetSchema is implemented as a stub method as it is not required</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Function GetSchema() As XmlSchema Implements IXmlSerializable.GetSchema
  Return Nothing
 End Function

 Private Function readElement(ByVal reader As XmlReader, ByVal ElementName As String) As String
  If (Not reader.NodeType = XmlNodeType.Element) OrElse reader.Name <> ElementName Then
   reader.ReadToFollowing(ElementName)
  End If
  If reader.NodeType = XmlNodeType.Element Then
   Return reader.ReadElementContentAsString
  Else
   Return ""
  End If
 End Function

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' ReadXml fills the object (de-serializes it) from the XmlReader passed
 ''' </summary>
 ''' <remarks></remarks>
 ''' <param name="reader">The XmlReader that contains the xml for the object</param>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub ReadXml(ByVal reader As XmlReader) Implements IXmlSerializable.ReadXml
  Try

   Name = readElement(reader, "Name")
  Catch ex As Exception
   ' log exception as DNN import routine does not do that
   DotNetNuke.Services.Exceptions.LogException(ex)
   ' re-raise exception to make sure import routine displays a visible error to the user
   Throw New Exception("An error occured during import of an Resolution", ex)
  End Try

 End Sub

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' WriteXml converts the object to Xml (serializes it) and writes it using the XmlWriter passed
 ''' </summary>
 ''' <remarks></remarks>
 ''' <param name="writer">The XmlWriter that contains the xml for the object</param>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub WriteXml(ByVal writer As XmlWriter) Implements IXmlSerializable.WriteXml
  writer.WriteStartElement("Resolution")
  writer.WriteElementString("ResolutionID", ResolutionID.ToString())
  writer.WriteElementString("Name", Name)
  writer.WriteEndElement()
 End Sub

#End Region

#Region " ToXml Methods "
 Public Function ToXml() As String
  Return ToXml("Resolution")
 End Function

 Public Function ToXml(ByVal elementName As String) As String
  Dim xml As New StringBuilder
  xml.Append("<")
  xml.Append(elementName)
  'Add Attribute(xml, "ResolutionID", ResolutionID.ToString())
  'Add Attribute(xml, "Name", Name)
  xml.Append(" />")
  Return xml.ToString
 End Function
#End Region

End Class
#End Region

#Region " ResolutionsController "
Public Class ResolutionsController
 Public Shared Function GetResolutions() As IDictionary(Of Integer, ResolutionInfo)

  Return CBO.FillDictionary(Of ResolutionInfo)(DataProvider.Instance().GetResolutions())

 End Function

 Public Shared Function GetResolution(ByVal ResolutionID As Integer) As ResolutionInfo

  Return CType(CBO.FillObject(DataProvider.Instance().GetResolution(ResolutionID), GetType(ResolutionInfo)), ResolutionInfo)

 End Function

 Public Shared Function AddResolution(ByVal objResolution As ResolutionInfo) As Integer

  Return CType(DataProvider.Instance().AddResolution(objResolution.Name), Integer)

 End Function

 Public Shared Sub UpdateResolution(ByVal objResolution As ResolutionInfo)

  DataProvider.Instance().UpdateResolution(objResolution.ResolutionID, objResolution.Name)

 End Sub

 Public Shared Sub DeleteResolution(ByVal ResolutionID As Integer)

  DataProvider.Instance().DeleteResolution(ResolutionID)

 End Sub

 Public Shared Function FindResolutionByName(ByVal Name As String) As ResolutionInfo

  Return CType(CBO.FillObject(DataProvider.Instance().FindResolutionByName(Name), GetType(ResolutionInfo)), ResolutionInfo)

 End Function

End Class
#End Region


#Region " RolePermissionInfo "
<Serializable(), XmlRoot("RolePermission")> _
Public Class RolePermissionInfo
 Implements IHydratable
 Implements IPropertyAccess
 Implements IXmlSerializable

 ' local property declarations
 Private _RolePermissionId As Integer
 Private _PermissionId As Integer
 Private _RoleId As Integer

#Region " Constructors "
 Public Sub New()
 End Sub

 Public Sub New(ByVal RolePermissionId As Integer, ByVal PermissionId As Integer, ByVal RoleId As Integer)
  Me.PermissionId = PermissionId
  Me.RoleId = RoleId
  Me.RolePermissionId = RolePermissionId
 End Sub
#End Region

#Region " Public Properties "

 Public Property RolePermissionId() As Integer
  Get
   Return _RolePermissionId
  End Get
  Set(ByVal Value As Integer)
   _RolePermissionId = Value
  End Set
 End Property

 Public Property PermissionId() As Integer
  Get
   Return _PermissionId
  End Get
  Set(ByVal Value As Integer)
   _PermissionId = Value
  End Set
 End Property

 Public Property RoleId() As Integer
  Get
   Return _RoleId
  End Get
  Set(ByVal Value As Integer)
   _RoleId = Value
  End Set
 End Property

#End Region

#Region " IHydratable Implementation "

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' Fill hydrates the object from a Datareader
 ''' </summary>
 ''' <remarks>The Fill method is used by the CBO method to hydrtae the object
 ''' rather than using the more expensive Refection  methods.</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub Fill(ByVal dr As IDataReader) Implements IHydratable.Fill

  PermissionId = Convert.ToInt32(Null.SetNull(dr.Item("PermissionId"), PermissionId))
  RoleId = Convert.ToInt32(Null.SetNull(dr.Item("RoleId"), RoleId))
  RolePermissionId = Convert.ToInt32(Null.SetNull(dr.Item("RolePermissionId"), RolePermissionId))

 End Sub
 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' Gets and sets the Key ID
 ''' </summary>
 ''' <remarks>The KeyID property is part of the IHydratble interface.  It is used
 ''' as the key property when creating a Dictionary</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Property KeyID() As Integer Implements Entities.Modules.IHydratable.KeyID
  Get
   Return RolePermissionId
  End Get
  Set(ByVal value As Integer)
   RolePermissionId = value
  End Set
 End Property

#End Region

#Region " IPropertyAccess Implementation "

 Public Function GetProperty(ByVal strPropertyName As String, ByVal strFormat As String, ByVal formatProvider As System.Globalization.CultureInfo, ByVal AccessingUser As Entities.Users.UserInfo, ByVal AccessLevel As DotNetNuke.Services.Tokens.Scope, ByRef PropertyNotFound As Boolean) As String Implements DotNetNuke.Services.Tokens.IPropertyAccess.GetProperty
  Dim OutputFormat As String = String.Empty
  Dim portalSettings As PortalSettings = PortalController.GetCurrentPortalSettings()
  If strFormat = String.Empty Then
   OutputFormat = "D"
  Else
   OutputFormat = strFormat
  End If
  Select Case strPropertyName.ToLower
   Case "permissionid"
    Return (Me.PermissionId.ToString(OutputFormat, formatProvider))
   Case "roleid"
    Return (Me.RoleId.ToString(OutputFormat, formatProvider))
   Case "rolepermissionid"
    Return (Me.RolePermissionId.ToString(OutputFormat, formatProvider))
   Case Else
    PropertyNotFound = True
  End Select

  Return Null.NullString
 End Function

 Public ReadOnly Property Cacheability() As DotNetNuke.Services.Tokens.CacheLevel Implements DotNetNuke.Services.Tokens.IPropertyAccess.Cacheability
  Get
   Return CacheLevel.fullyCacheable
  End Get
 End Property

#End Region

#Region " IXmlSerializable Implementation "

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' GetSchema returns the XmlSchema for this class
 ''' </summary>
 ''' <remarks>GetSchema is implemented as a stub method as it is not required</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Function GetSchema() As XmlSchema Implements IXmlSerializable.GetSchema
  Return Nothing
 End Function

 Private Function readElement(ByVal reader As XmlReader, ByVal ElementName As String) As String
  If (Not reader.NodeType = XmlNodeType.Element) OrElse reader.Name <> ElementName Then
   reader.ReadToFollowing(ElementName)
  End If
  If reader.NodeType = XmlNodeType.Element Then
   Return reader.ReadElementContentAsString
  Else
   Return ""
  End If
 End Function

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' ReadXml fills the object (de-serializes it) from the XmlReader passed
 ''' </summary>
 ''' <remarks></remarks>
 ''' <param name="reader">The XmlReader that contains the xml for the object</param>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub ReadXml(ByVal reader As XmlReader) Implements IXmlSerializable.ReadXml
  Try

   If Not Int32.TryParse(readElement(reader, "PermissionId"), PermissionId) Then
    PermissionId = Null.NullInteger
   End If
   If Not Int32.TryParse(readElement(reader, "RoleId"), RoleId) Then
    RoleId = Null.NullInteger
   End If
  Catch ex As Exception
   ' log exception as DNN import routine does not do that
   DotNetNuke.Services.Exceptions.LogException(ex)
   ' re-raise exception to make sure import routine displays a visible error to the user
   Throw New Exception("An error occured during import of an RolePermission", ex)
  End Try

 End Sub

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' WriteXml converts the object to Xml (serializes it) and writes it using the XmlWriter passed
 ''' </summary>
 ''' <remarks></remarks>
 ''' <param name="writer">The XmlWriter that contains the xml for the object</param>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub WriteXml(ByVal writer As XmlWriter) Implements IXmlSerializable.WriteXml
  writer.WriteStartElement("RolePermission")
  writer.WriteElementString("RolePermissionId", RolePermissionId.ToString())
  writer.WriteElementString("PermissionId", PermissionId.ToString())
  writer.WriteElementString("RoleId", RoleId.ToString())
  writer.WriteEndElement()
 End Sub

#End Region

#Region " ToXml Methods "
 Public Function ToXml() As String
  Return ToXml("RolePermission")
 End Function

 Public Function ToXml(ByVal elementName As String) As String
  Dim xml As New StringBuilder
  xml.Append("<")
  xml.Append(elementName)
  'Add Attribute(xml, "RolePermissionId", RolePermissionId.ToString())
  'Add Attribute(xml, "PermissionId", PermissionId.ToString())
  'Add Attribute(xml, "RoleId", RoleId.ToString())
  xml.Append(" />")
  Return xml.ToString
 End Function
#End Region

End Class
#End Region

#Region " RolePermissionsController "
Public Class RolePermissionsController

 Public Shared Function GetRolePermission(ByVal RolePermissionId As Integer) As RolePermissionInfo

  Return CType(CBO.FillObject(DataProvider.Instance().GetRolePermission(RolePermissionId), GetType(RolePermissionInfo)), RolePermissionInfo)

 End Function

 Public Shared Function AddRolePermission(ByVal objRolePermission As RolePermissionInfo) As Integer

  Return CType(DataProvider.Instance().AddRolePermission(objRolePermission.PermissionId, objRolePermission.RoleId), Integer)

 End Function

 Public Shared Sub UpdateRolePermission(ByVal objRolePermission As RolePermissionInfo)

  DataProvider.Instance().UpdateRolePermission(objRolePermission.RolePermissionId, objRolePermission.PermissionId, objRolePermission.RoleId)
	
 End Sub

 Public Shared Sub DeleteRolePermission(ByVal RolePermissionId As Integer)

  DataProvider.Instance().DeleteRolePermission(RolePermissionId)

 End Sub

End Class
#End Region


#Region " RoleInfo "
<Serializable(), XmlRoot("Role")> _
Public Class RoleInfo
 Implements IHydratable
 Implements IPropertyAccess
 Implements IXmlSerializable

 ' local property declarations
 Private _RoleId As Integer
 Private _AutoAssign As Boolean
 Private _Description As String
 Private _ProjectId As Integer
 Private _RoleName As String

#Region " Constructors "
 Public Sub New()
 End Sub

 Public Sub New(ByVal RoleId As Integer, ByVal AutoAssign As Boolean, ByVal Description As String, ByVal ProjectId As Integer, ByVal RoleName As String)
  Me.AutoAssign = AutoAssign
  Me.Description = Description
  Me.ProjectId = ProjectId
  Me.RoleId = RoleId
  Me.RoleName = RoleName
 End Sub
#End Region

#Region " Public Properties "

 Public Property RoleId() As Integer
  Get
   Return _RoleId
  End Get
  Set(ByVal Value As Integer)
   _RoleId = Value
  End Set
 End Property

 Public Property AutoAssign() As Boolean
  Get
   Return _AutoAssign
  End Get
  Set(ByVal Value As Boolean)
   _AutoAssign = Value
  End Set
 End Property

 Public Property Description() As String
  Get
   Return _Description
  End Get
  Set(ByVal Value As String)
   _Description = Value
  End Set
 End Property

 Public Property ProjectId() As Integer
  Get
   Return _ProjectId
  End Get
  Set(ByVal Value As Integer)
   _ProjectId = Value
  End Set
 End Property

 Public Property RoleName() As String
  Get
   Return _RoleName
  End Get
  Set(ByVal Value As String)
   _RoleName = Value
  End Set
 End Property

#End Region

#Region " IHydratable Implementation "

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' Fill hydrates the object from a Datareader
 ''' </summary>
 ''' <remarks>The Fill method is used by the CBO method to hydrtae the object
 ''' rather than using the more expensive Refection  methods.</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub Fill(ByVal dr As IDataReader) Implements IHydratable.Fill

  AutoAssign = Convert.ToBoolean(Null.SetNull(dr.Item("AutoAssign"), AutoAssign))
  Description = Convert.ToString(Null.SetNull(dr.Item("Description"), Description))
  ProjectId = Convert.ToInt32(Null.SetNull(dr.Item("ProjectId"), ProjectId))
  RoleId = Convert.ToInt32(Null.SetNull(dr.Item("RoleId"), RoleId))
  RoleName = Convert.ToString(Null.SetNull(dr.Item("RoleName"), RoleName))

 End Sub
 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' Gets and sets the Key ID
 ''' </summary>
 ''' <remarks>The KeyID property is part of the IHydratble interface.  It is used
 ''' as the key property when creating a Dictionary</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Property KeyID() As Integer Implements Entities.Modules.IHydratable.KeyID
  Get
   Return RoleId
  End Get
  Set(ByVal value As Integer)
   RoleId = value
  End Set
 End Property

#End Region

#Region " IPropertyAccess Implementation "

 Public Function GetProperty(ByVal strPropertyName As String, ByVal strFormat As String, ByVal formatProvider As System.Globalization.CultureInfo, ByVal AccessingUser As Entities.Users.UserInfo, ByVal AccessLevel As DotNetNuke.Services.Tokens.Scope, ByRef PropertyNotFound As Boolean) As String Implements DotNetNuke.Services.Tokens.IPropertyAccess.GetProperty
  Dim OutputFormat As String = String.Empty
  Dim portalSettings As PortalSettings = PortalController.GetCurrentPortalSettings()
  If strFormat = String.Empty Then
   OutputFormat = "D"
  Else
   OutputFormat = strFormat
  End If
  Select Case strPropertyName.ToLower
   Case "autoassign"
    Return PropertyAccess.Boolean2LocalizedYesNo(Me.AutoAssign, formatProvider)
   Case "description"
    Return PropertyAccess.FormatString(Me.Description, strFormat)
   Case "projectid"
    Return (Me.ProjectId.ToString(OutputFormat, formatProvider))
   Case "roleid"
    Return (Me.RoleId.ToString(OutputFormat, formatProvider))
   Case "rolename"
    Return PropertyAccess.FormatString(Me.RoleName, strFormat)
   Case Else
    PropertyNotFound = True
  End Select

  Return Null.NullString
 End Function

 Public ReadOnly Property Cacheability() As DotNetNuke.Services.Tokens.CacheLevel Implements DotNetNuke.Services.Tokens.IPropertyAccess.Cacheability
  Get
   Return CacheLevel.fullyCacheable
  End Get
 End Property

#End Region

#Region " IXmlSerializable Implementation "

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' GetSchema returns the XmlSchema for this class
 ''' </summary>
 ''' <remarks>GetSchema is implemented as a stub method as it is not required</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Function GetSchema() As XmlSchema Implements IXmlSerializable.GetSchema
  Return Nothing
 End Function

 Private Function readElement(ByVal reader As XmlReader, ByVal ElementName As String) As String
  If (Not reader.NodeType = XmlNodeType.Element) OrElse reader.Name <> ElementName Then
   reader.ReadToFollowing(ElementName)
  End If
  If reader.NodeType = XmlNodeType.Element Then
   Return reader.ReadElementContentAsString
  Else
   Return ""
  End If
 End Function

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' ReadXml fills the object (de-serializes it) from the XmlReader passed
 ''' </summary>
 ''' <remarks></remarks>
 ''' <param name="reader">The XmlReader that contains the xml for the object</param>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub ReadXml(ByVal reader As XmlReader) Implements IXmlSerializable.ReadXml
  Try

   Boolean.TryParse(readElement(reader, "AutoAssign"), AutoAssign)
   Description = readElement(reader, "Description")
   If Not Int32.TryParse(readElement(reader, "ProjectId"), ProjectId) Then
    ProjectId = Null.NullInteger
   End If
   RoleName = readElement(reader, "RoleName")
  Catch ex As Exception
   ' log exception as DNN import routine does not do that
   DotNetNuke.Services.Exceptions.LogException(ex)
   ' re-raise exception to make sure import routine displays a visible error to the user
   Throw New Exception("An error occured during import of an Role", ex)
  End Try

 End Sub

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' WriteXml converts the object to Xml (serializes it) and writes it using the XmlWriter passed
 ''' </summary>
 ''' <remarks></remarks>
 ''' <param name="writer">The XmlWriter that contains the xml for the object</param>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub WriteXml(ByVal writer As XmlWriter) Implements IXmlSerializable.WriteXml
  writer.WriteStartElement("Role")
  writer.WriteElementString("RoleId", RoleId.ToString())
  writer.WriteElementString("AutoAssign", AutoAssign.ToString())
  writer.WriteElementString("Description", Description)
  writer.WriteElementString("ProjectId", ProjectId.ToString())
  writer.WriteElementString("RoleName", RoleName)
  writer.WriteEndElement()
 End Sub

#End Region

#Region " ToXml Methods "
 Public Function ToXml() As String
  Return ToXml("Role")
 End Function

 Public Function ToXml(ByVal elementName As String) As String
  Dim xml As New StringBuilder
  xml.Append("<")
  xml.Append(elementName)
  'Add Attribute(xml, "RoleId", RoleId.ToString())
  'Add Attribute(xml, "AutoAssign", AutoAssign.ToString())
  'Add Attribute(xml, "Description", Description)
  'Add Attribute(xml, "ProjectId", ProjectId.ToString())
  'Add Attribute(xml, "RoleName", RoleName)
  xml.Append(" />")
  Return xml.ToString
 End Function
#End Region

End Class
#End Region

#Region " RolesController "
Public Class RolesController

 Public Shared Function GetRole(ByVal RoleId As Integer) As RoleInfo

  Return CType(CBO.FillObject(DataProvider.Instance().GetRole(RoleId), GetType(RoleInfo)), RoleInfo)

 End Function

 Public Shared Function AddRole(ByVal objRole As RoleInfo) As Integer

  Return CType(DataProvider.Instance().AddRole(objRole.AutoAssign, objRole.Description, objRole.ProjectId, objRole.RoleName), Integer)

 End Function

 Public Shared Sub UpdateRole(ByVal objRole As RoleInfo)

  DataProvider.Instance().UpdateRole(objRole.RoleId, objRole.AutoAssign, objRole.Description, objRole.ProjectId, objRole.RoleName)
	
 End Sub

 Public Shared Sub DeleteRole(ByVal RoleId As Integer)

  DataProvider.Instance().DeleteRole(RoleId)

 End Sub

End Class
#End Region


#Region " StatusInfo "
<Serializable(), XmlRoot("Statuse")> _
Public Class StatusInfo
 Implements IHydratable
 Implements IPropertyAccess
 Implements IXmlSerializable

 ' local property declarations
 Private _StatusID As Integer
 Private _Name As String

#Region " Constructors "
 Public Sub New()
 End Sub

 Public Sub New(ByVal StatusID As Integer, ByVal Name As String)
  Me.Name = Name
  Me.StatusID = StatusID
 End Sub
#End Region

#Region " Public Properties "

 Public Property StatusID() As Integer
  Get
   Return _StatusID
  End Get
  Set(ByVal Value As Integer)
   _StatusID = Value
  End Set
 End Property

 Public Property Name() As String
  Get
   Return _Name
  End Get
  Set(ByVal Value As String)
   _Name = Value
  End Set
 End Property

#End Region

#Region " IHydratable Implementation "

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' Fill hydrates the object from a Datareader
 ''' </summary>
 ''' <remarks>The Fill method is used by the CBO method to hydrtae the object
 ''' rather than using the more expensive Refection  methods.</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub Fill(ByVal dr As IDataReader) Implements IHydratable.Fill

  Name = Convert.ToString(Null.SetNull(dr.Item("Name"), Name))
  StatusID = Convert.ToInt32(Null.SetNull(dr.Item("StatusID"), StatusID))

 End Sub
 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' Gets and sets the Key ID
 ''' </summary>
 ''' <remarks>The KeyID property is part of the IHydratble interface.  It is used
 ''' as the key property when creating a Dictionary</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Property KeyID() As Integer Implements Entities.Modules.IHydratable.KeyID
  Get
   Return StatusID
  End Get
  Set(ByVal value As Integer)
   StatusID = value
  End Set
 End Property

#End Region

#Region " IPropertyAccess Implementation "

 Public Function GetProperty(ByVal strPropertyName As String, ByVal strFormat As String, ByVal formatProvider As System.Globalization.CultureInfo, ByVal AccessingUser As Entities.Users.UserInfo, ByVal AccessLevel As DotNetNuke.Services.Tokens.Scope, ByRef PropertyNotFound As Boolean) As String Implements DotNetNuke.Services.Tokens.IPropertyAccess.GetProperty
  Dim OutputFormat As String = String.Empty
  Dim portalSettings As PortalSettings = PortalController.GetCurrentPortalSettings()
  If strFormat = String.Empty Then
   OutputFormat = "D"
  Else
   OutputFormat = strFormat
  End If
  Select Case strPropertyName.ToLower
   Case "name"
    Return PropertyAccess.FormatString(Me.Name, strFormat)
   Case "statusid"
    Return (Me.StatusID.ToString(OutputFormat, formatProvider))
   Case Else
    PropertyNotFound = True
  End Select

  Return Null.NullString
 End Function

 Public ReadOnly Property Cacheability() As DotNetNuke.Services.Tokens.CacheLevel Implements DotNetNuke.Services.Tokens.IPropertyAccess.Cacheability
  Get
   Return CacheLevel.fullyCacheable
  End Get
 End Property

#End Region

#Region " IXmlSerializable Implementation "

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' GetSchema returns the XmlSchema for this class
 ''' </summary>
 ''' <remarks>GetSchema is implemented as a stub method as it is not required</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Function GetSchema() As XmlSchema Implements IXmlSerializable.GetSchema
  Return Nothing
 End Function

 Private Function readElement(ByVal reader As XmlReader, ByVal ElementName As String) As String
  If (Not reader.NodeType = XmlNodeType.Element) OrElse reader.Name <> ElementName Then
   reader.ReadToFollowing(ElementName)
  End If
  If reader.NodeType = XmlNodeType.Element Then
   Return reader.ReadElementContentAsString
  Else
   Return ""
  End If
 End Function

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' ReadXml fills the object (de-serializes it) from the XmlReader passed
 ''' </summary>
 ''' <remarks></remarks>
 ''' <param name="reader">The XmlReader that contains the xml for the object</param>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub ReadXml(ByVal reader As XmlReader) Implements IXmlSerializable.ReadXml
  Try

   Name = readElement(reader, "Name")
  Catch ex As Exception
   ' log exception as DNN import routine does not do that
   DotNetNuke.Services.Exceptions.LogException(ex)
   ' re-raise exception to make sure import routine displays a visible error to the user
   Throw New Exception("An error occured during import of an Statuse", ex)
  End Try

 End Sub

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' WriteXml converts the object to Xml (serializes it) and writes it using the XmlWriter passed
 ''' </summary>
 ''' <remarks></remarks>
 ''' <param name="writer">The XmlWriter that contains the xml for the object</param>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub WriteXml(ByVal writer As XmlWriter) Implements IXmlSerializable.WriteXml
  writer.WriteStartElement("Statuse")
  writer.WriteElementString("StatusID", StatusID.ToString())
  writer.WriteElementString("Name", Name)
  writer.WriteEndElement()
 End Sub

#End Region

#Region " ToXml Methods "
 Public Function ToXml() As String
  Return ToXml("Statuse")
 End Function

 Public Function ToXml(ByVal elementName As String) As String
  Dim xml As New StringBuilder
  xml.Append("<")
  xml.Append(elementName)
  'Add Attribute(xml, "StatusID", StatusID.ToString())
  'Add Attribute(xml, "Name", Name)
  xml.Append(" />")
  Return xml.ToString
 End Function
#End Region

End Class
#End Region

#Region " StatusesController "
Public Class StatusesController

 Public Shared Function GetStatus(ByVal StatusID As Integer) As StatusInfo

  Return CType(CBO.FillObject(DataProvider.Instance().GetStatus(StatusID), GetType(StatusInfo)), StatusInfo)

 End Function

 Public Shared Function AddStatuse(ByVal objStatuse As StatusInfo) As Integer

  Return CType(DataProvider.Instance().AddStatus(objStatuse.Name), Integer)

 End Function

 Public Shared Sub UpdateStatus(ByVal objStatuse As StatusInfo)

  DataProvider.Instance().UpdateStatus(objStatuse.StatusID, objStatuse.Name)

 End Sub

 Public Shared Sub DeleteStatus(ByVal StatusID As Integer)

  DataProvider.Instance().DeleteStatus(StatusID)

 End Sub

 Public Shared Function GetStatuses() As IDictionary(Of Integer, StatusInfo)

  Return CBO.FillDictionary(Of StatusInfo)(DataProvider.Instance().GetStatuses())

 End Function

End Class
#End Region


#Region " TypeInfo "
<Serializable(), XmlRoot("Type")> _
Public Class TypeInfo
 Implements IHydratable
 Implements IPropertyAccess
 Implements IXmlSerializable

 ' local property declarations
 Private _TypeID As Integer
 Private _ImageUrl As String
 Private _Name As String

#Region " Constructors "
 Public Sub New()
 End Sub

 Public Sub New(ByVal TypeID As Integer, ByVal ImageUrl As String, ByVal Name As String)
  Me.ImageUrl = ImageUrl
  Me.Name = Name
  Me.TypeID = TypeID
 End Sub
#End Region

#Region " Public Properties "

 Public Property TypeID() As Integer
  Get
   Return _TypeID
  End Get
  Set(ByVal Value As Integer)
   _TypeID = Value
  End Set
 End Property

 Public Property ImageUrl() As String
  Get
   Return _ImageUrl
  End Get
  Set(ByVal Value As String)
   _ImageUrl = Value
  End Set
 End Property

 Public Property Name() As String
  Get
   Return _Name
  End Get
  Set(ByVal Value As String)
   _Name = Value
  End Set
 End Property

#End Region

#Region " IHydratable Implementation "

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' Fill hydrates the object from a Datareader
 ''' </summary>
 ''' <remarks>The Fill method is used by the CBO method to hydrtae the object
 ''' rather than using the more expensive Refection  methods.</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub Fill(ByVal dr As IDataReader) Implements IHydratable.Fill

  ImageUrl = Convert.ToString(Null.SetNull(dr.Item("ImageUrl"), ImageUrl))
  Name = Convert.ToString(Null.SetNull(dr.Item("Name"), Name))
  TypeID = Convert.ToInt32(Null.SetNull(dr.Item("TypeID"), TypeID))

 End Sub
 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' Gets and sets the Key ID
 ''' </summary>
 ''' <remarks>The KeyID property is part of the IHydratble interface.  It is used
 ''' as the key property when creating a Dictionary</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Property KeyID() As Integer Implements Entities.Modules.IHydratable.KeyID
  Get
   Return TypeID
  End Get
  Set(ByVal value As Integer)
   TypeID = value
  End Set
 End Property

#End Region

#Region " IPropertyAccess Implementation "

 Public Function GetProperty(ByVal strPropertyName As String, ByVal strFormat As String, ByVal formatProvider As System.Globalization.CultureInfo, ByVal AccessingUser As Entities.Users.UserInfo, ByVal AccessLevel As DotNetNuke.Services.Tokens.Scope, ByRef PropertyNotFound As Boolean) As String Implements DotNetNuke.Services.Tokens.IPropertyAccess.GetProperty
  Dim OutputFormat As String = String.Empty
  Dim portalSettings As PortalSettings = PortalController.GetCurrentPortalSettings()
  If strFormat = String.Empty Then
   OutputFormat = "D"
  Else
   OutputFormat = strFormat
  End If
  Select Case strPropertyName.ToLower
   Case "imageurl"
    Return PropertyAccess.FormatString(Me.ImageUrl, strFormat)
   Case "name"
    Return PropertyAccess.FormatString(Me.Name, strFormat)
   Case "typeid"
    Return (Me.TypeID.ToString(OutputFormat, formatProvider))
   Case Else
    PropertyNotFound = True
  End Select

  Return Null.NullString
 End Function

 Public ReadOnly Property Cacheability() As DotNetNuke.Services.Tokens.CacheLevel Implements DotNetNuke.Services.Tokens.IPropertyAccess.Cacheability
  Get
   Return CacheLevel.fullyCacheable
  End Get
 End Property

#End Region

#Region " IXmlSerializable Implementation "

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' GetSchema returns the XmlSchema for this class
 ''' </summary>
 ''' <remarks>GetSchema is implemented as a stub method as it is not required</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Function GetSchema() As XmlSchema Implements IXmlSerializable.GetSchema
  Return Nothing
 End Function

 Private Function readElement(ByVal reader As XmlReader, ByVal ElementName As String) As String
  If (Not reader.NodeType = XmlNodeType.Element) OrElse reader.Name <> ElementName Then
   reader.ReadToFollowing(ElementName)
  End If
  If reader.NodeType = XmlNodeType.Element Then
   Return reader.ReadElementContentAsString
  Else
   Return ""
  End If
 End Function

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' ReadXml fills the object (de-serializes it) from the XmlReader passed
 ''' </summary>
 ''' <remarks></remarks>
 ''' <param name="reader">The XmlReader that contains the xml for the object</param>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub ReadXml(ByVal reader As XmlReader) Implements IXmlSerializable.ReadXml
  Try

   ImageUrl = readElement(reader, "ImageUrl")
   Name = readElement(reader, "Name")
  Catch ex As Exception
   ' log exception as DNN import routine does not do that
   DotNetNuke.Services.Exceptions.LogException(ex)
   ' re-raise exception to make sure import routine displays a visible error to the user
   Throw New Exception("An error occured during import of an Type", ex)
  End Try

 End Sub

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' WriteXml converts the object to Xml (serializes it) and writes it using the XmlWriter passed
 ''' </summary>
 ''' <remarks></remarks>
 ''' <param name="writer">The XmlWriter that contains the xml for the object</param>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub WriteXml(ByVal writer As XmlWriter) Implements IXmlSerializable.WriteXml
  writer.WriteStartElement("Type")
  writer.WriteElementString("TypeID", TypeID.ToString())
  writer.WriteElementString("ImageUrl", ImageUrl)
  writer.WriteElementString("Name", Name)
  writer.WriteEndElement()
 End Sub

#End Region

#Region " ToXml Methods "
 Public Function ToXml() As String
  Return ToXml("Type")
 End Function

 Public Function ToXml(ByVal elementName As String) As String
  Dim xml As New StringBuilder
  xml.Append("<")
  xml.Append(elementName)
  'Add Attribute(xml, "TypeID", TypeID.ToString())
  'Add Attribute(xml, "ImageUrl", ImageUrl)
  'Add Attribute(xml, "Name", Name)
  xml.Append(" />")
  Return xml.ToString
 End Function
#End Region

End Class
#End Region

#Region " TypesController "
Public Class TypesController

 Public Shared Function GetBugType(ByVal TypeID As Integer) As TypeInfo

  Return CType(CBO.FillObject(DataProvider.Instance().GetBugType(TypeID), GetType(TypeInfo)), TypeInfo)

 End Function

 Public Shared Function AddType(ByVal objType As TypeInfo) As Integer

  Return CType(DataProvider.Instance().AddType(objType.ImageUrl, objType.Name), Integer)

 End Function

 Public Shared Sub UpdateType(ByVal objType As TypeInfo)

  DataProvider.Instance().UpdateType(objType.TypeID, objType.ImageUrl, objType.Name)

 End Sub

 Public Shared Sub DeleteType(ByVal TypeID As Integer)

  DataProvider.Instance().DeleteType(TypeID)

 End Sub

 Public Shared Function FindTypeByName(ByVal Name As String) As TypeInfo

  Return CType(CBO.FillObject(DataProvider.Instance().FindTypeByName(Name), GetType(TypeInfo)), TypeInfo)

 End Function

 Public Shared Function GetBugTypes() As IDictionary(Of Integer, TypeInfo)

  Return CBO.FillDictionary(Of TypeInfo)(DataProvider.Instance().GetBugTypes())

 End Function

End Class
#End Region


#Region " UserProjectInfo "
<Serializable(), XmlRoot("UserProject")> _
Public Class UserProjectInfo
 Implements IHydratable
 Implements IPropertyAccess
 Implements IXmlSerializable

 ' local property declarations
 Private _UserName As String
 Private _CreatedDate As Date
 Private _ProjectId As Integer
 Private _UserProjectId As Integer

#Region " Constructors "
 Public Sub New()
 End Sub

 Public Sub New(ByVal UserName As String, ByVal CreatedDate As Date, ByVal ProjectId As Integer, ByVal UserProjectId As Integer)
  Me.CreatedDate = CreatedDate
  Me.ProjectId = ProjectId
  Me.UserName = UserName
  Me.UserProjectId = UserProjectId
 End Sub
#End Region

#Region " Public Properties "

 Public Property UserName() As String
  Get
   Return _UserName
  End Get
  Set(ByVal Value As String)
   _UserName = Value
  End Set
 End Property

 Public Property CreatedDate() As Date
  Get
   Return _CreatedDate
  End Get
  Set(ByVal Value As Date)
   _CreatedDate = Value
  End Set
 End Property

 Public Property ProjectId() As Integer
  Get
   Return _ProjectId
  End Get
  Set(ByVal Value As Integer)
   _ProjectId = Value
  End Set
 End Property

 Public Property UserProjectId() As Integer
  Get
   Return _UserProjectId
  End Get
  Set(ByVal Value As Integer)
   _UserProjectId = Value
  End Set
 End Property

#End Region

#Region " IHydratable Implementation "

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' Fill hydrates the object from a Datareader
 ''' </summary>
 ''' <remarks>The Fill method is used by the CBO method to hydrtae the object
 ''' rather than using the more expensive Refection  methods.</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub Fill(ByVal dr As IDataReader) Implements IHydratable.Fill

  CreatedDate = Convert.ToDateTime(Null.SetNull(dr.Item("CreatedDate"), CreatedDate))
  ProjectId = Convert.ToInt32(Null.SetNull(dr.Item("ProjectId"), ProjectId))
  UserName = Convert.ToString(Null.SetNull(dr.Item("UserName"), UserName))
  UserProjectId = Convert.ToInt32(Null.SetNull(dr.Item("UserProjectId"), UserProjectId))

 End Sub
 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' Gets and sets the Key ID
 ''' </summary>
 ''' <remarks>The KeyID property is part of the IHydratble interface.  It is used
 ''' as the key property when creating a Dictionary</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Property KeyID() As Integer Implements Entities.Modules.IHydratable.KeyID
  Get
   Return UserProjectId
  End Get
  Set(ByVal value As Integer)
   UserProjectId = value
  End Set
 End Property

#End Region

#Region " IPropertyAccess Implementation "

 Public Function GetProperty(ByVal strPropertyName As String, ByVal strFormat As String, ByVal formatProvider As System.Globalization.CultureInfo, ByVal AccessingUser As Entities.Users.UserInfo, ByVal AccessLevel As DotNetNuke.Services.Tokens.Scope, ByRef PropertyNotFound As Boolean) As String Implements DotNetNuke.Services.Tokens.IPropertyAccess.GetProperty
  Dim OutputFormat As String = String.Empty
  Dim portalSettings As PortalSettings = PortalController.GetCurrentPortalSettings()
  If strFormat = String.Empty Then
   OutputFormat = "D"
  Else
   OutputFormat = strFormat
  End If
  Select Case strPropertyName.ToLower
   Case "createddate"
    Return (Me.CreatedDate.ToString(OutputFormat, formatProvider))
   Case "projectid"
    Return (Me.ProjectId.ToString(OutputFormat, formatProvider))
   Case "UserName"
    Return PropertyAccess.FormatString(Me.UserName, strFormat)
   Case "userprojectid"
    Return (Me.UserProjectId.ToString(OutputFormat, formatProvider))
   Case Else
    PropertyNotFound = True
  End Select

  Return Null.NullString
 End Function

 Public ReadOnly Property Cacheability() As DotNetNuke.Services.Tokens.CacheLevel Implements DotNetNuke.Services.Tokens.IPropertyAccess.Cacheability
  Get
   Return CacheLevel.fullyCacheable
  End Get
 End Property

#End Region

#Region " IXmlSerializable Implementation "

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' GetSchema returns the XmlSchema for this class
 ''' </summary>
 ''' <remarks>GetSchema is implemented as a stub method as it is not required</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Function GetSchema() As XmlSchema Implements IXmlSerializable.GetSchema
  Return Nothing
 End Function

 Private Function readElement(ByVal reader As XmlReader, ByVal ElementName As String) As String
  If (Not reader.NodeType = XmlNodeType.Element) OrElse reader.Name <> ElementName Then
   reader.ReadToFollowing(ElementName)
  End If
  If reader.NodeType = XmlNodeType.Element Then
   Return reader.ReadElementContentAsString
  Else
   Return ""
  End If
 End Function

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' ReadXml fills the object (de-serializes it) from the XmlReader passed
 ''' </summary>
 ''' <remarks></remarks>
 ''' <param name="reader">The XmlReader that contains the xml for the object</param>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub ReadXml(ByVal reader As XmlReader) Implements IXmlSerializable.ReadXml
  Try

   If Not DateTime.TryParse(readElement(reader, "CreatedDate"), CreatedDate) Then
    CreatedDate = DateTime.MinValue
   End If
   If Not Int32.TryParse(readElement(reader, "ProjectId"), ProjectId) Then
    ProjectId = Null.NullInteger
   End If
   If Not Int32.TryParse(readElement(reader, "UserProjectId"), UserProjectId) Then
    UserProjectId = Null.NullInteger
   End If
  Catch ex As Exception
   ' log exception as DNN import routine does not do that
   DotNetNuke.Services.Exceptions.LogException(ex)
   ' re-raise exception to make sure import routine displays a visible error to the user
   Throw New Exception("An error occured during import of an UserProject", ex)
  End Try

 End Sub

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' WriteXml converts the object to Xml (serializes it) and writes it using the XmlWriter passed
 ''' </summary>
 ''' <remarks></remarks>
 ''' <param name="writer">The XmlWriter that contains the xml for the object</param>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub WriteXml(ByVal writer As XmlWriter) Implements IXmlSerializable.WriteXml
  writer.WriteStartElement("UserProject")
  writer.WriteElementString("UserName", UserName.ToString())
  writer.WriteElementString("CreatedDate", CreatedDate.ToString())
  writer.WriteElementString("ProjectId", ProjectId.ToString())
  writer.WriteElementString("UserProjectId", UserProjectId.ToString())
  writer.WriteEndElement()
 End Sub

#End Region

#Region " ToXml Methods "
 Public Function ToXml() As String
  Return ToXml("UserProject")
 End Function

 Public Function ToXml(ByVal elementName As String) As String
  Dim xml As New StringBuilder
  xml.Append("<")
  xml.Append(elementName)
  'Add Attribute(xml, "UserName", UserName.ToString())
  'Add Attribute(xml, "CreatedDate", CreatedDate.ToString())
  'Add Attribute(xml, "ProjectId", ProjectId.ToString())
  'Add Attribute(xml, "UserProjectId", UserProjectId.ToString())
  xml.Append(" />")
  Return xml.ToString
 End Function
#End Region

End Class
#End Region

#Region " UserProjectsController "
Public Class UserProjectsController
 Public Shared Function AddUserProject(ByVal objUserProject As UserProjectInfo) As Integer

  DataProvider.Instance().AddUserProject(objUserProject.UserName, objUserProject.ProjectId)

 End Function

 Public Shared Sub DeleteUserProject(ByVal UserName As String, ByVal ProjectId As Integer)

  DataProvider.Instance().DeleteUserProject(UserName, ProjectId)

 End Sub
End Class
#End Region


#Region " UserRoleInfo "
<Serializable(), XmlRoot("UserRole")> _
Public Class UserRoleInfo
 Implements IHydratable
 Implements IPropertyAccess
 Implements IXmlSerializable

 ' local property declarations
 Private _UserName As String
 Private _RoleId As Integer

#Region " Constructors "
 Public Sub New()
 End Sub

 Public Sub New(ByVal UserName As String, ByVal RoleId As Integer)
  Me.RoleId = RoleId
  Me.UserName = UserName
 End Sub
#End Region

#Region " Public Properties "

 Public Property UserName() As String
  Get
   Return _UserName
  End Get
  Set(ByVal Value As String)
   _UserName = Value
  End Set
 End Property

 Public Property RoleId() As Integer
  Get
   Return _RoleId
  End Get
  Set(ByVal Value As Integer)
   _RoleId = Value
  End Set
 End Property

#End Region

#Region " IHydratable Implementation "

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' Fill hydrates the object from a Datareader
 ''' </summary>
 ''' <remarks>The Fill method is used by the CBO method to hydrtae the object
 ''' rather than using the more expensive Refection  methods.</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub Fill(ByVal dr As IDataReader) Implements IHydratable.Fill

  RoleId = Convert.ToInt32(Null.SetNull(dr.Item("RoleId"), RoleId))
  UserName = Convert.ToString(Null.SetNull(dr.Item("UserName"), UserName))

 End Sub
 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' Gets and sets the Key ID
 ''' </summary>
 ''' <remarks>The KeyID property is part of the IHydratble interface.  It is used
 ''' as the key property when creating a Dictionary</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Property KeyID() As Integer Implements Entities.Modules.IHydratable.KeyID
  Get
   Return -1
  End Get
  Set(ByVal value As Integer)

  End Set
 End Property

#End Region

#Region " IPropertyAccess Implementation "

 Public Function GetProperty(ByVal strPropertyName As String, ByVal strFormat As String, ByVal formatProvider As System.Globalization.CultureInfo, ByVal AccessingUser As Entities.Users.UserInfo, ByVal AccessLevel As DotNetNuke.Services.Tokens.Scope, ByRef PropertyNotFound As Boolean) As String Implements DotNetNuke.Services.Tokens.IPropertyAccess.GetProperty
  Dim OutputFormat As String = String.Empty
  Dim portalSettings As PortalSettings = PortalController.GetCurrentPortalSettings()
  If strFormat = String.Empty Then
   OutputFormat = "D"
  Else
   OutputFormat = strFormat
  End If
  Select Case strPropertyName.ToLower
   Case "roleid"
    Return (Me.RoleId.ToString(OutputFormat, formatProvider))
   Case "username"
    Return PropertyAccess.FormatString(Me.UserName, strFormat)
   Case Else
    PropertyNotFound = True
  End Select

  Return Null.NullString
 End Function

 Public ReadOnly Property Cacheability() As DotNetNuke.Services.Tokens.CacheLevel Implements DotNetNuke.Services.Tokens.IPropertyAccess.Cacheability
  Get
   Return CacheLevel.fullyCacheable
  End Get
 End Property

#End Region

#Region " IXmlSerializable Implementation "

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' GetSchema returns the XmlSchema for this class
 ''' </summary>
 ''' <remarks>GetSchema is implemented as a stub method as it is not required</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Function GetSchema() As XmlSchema Implements IXmlSerializable.GetSchema
  Return Nothing
 End Function

 Private Function readElement(ByVal reader As XmlReader, ByVal ElementName As String) As String
  If (Not reader.NodeType = XmlNodeType.Element) OrElse reader.Name <> ElementName Then
   reader.ReadToFollowing(ElementName)
  End If
  If reader.NodeType = XmlNodeType.Element Then
   Return reader.ReadElementContentAsString
  Else
   Return ""
  End If
 End Function

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' ReadXml fills the object (de-serializes it) from the XmlReader passed
 ''' </summary>
 ''' <remarks></remarks>
 ''' <param name="reader">The XmlReader that contains the xml for the object</param>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub ReadXml(ByVal reader As XmlReader) Implements IXmlSerializable.ReadXml
  Try

   If Not Int32.TryParse(readElement(reader, "RoleId"), RoleId) Then
    RoleId = Null.NullInteger
   End If
  Catch ex As Exception
   ' log exception as DNN import routine does not do that
   DotNetNuke.Services.Exceptions.LogException(ex)
   ' re-raise exception to make sure import routine displays a visible error to the user
   Throw New Exception("An error occured during import of an UserRole", ex)
  End Try

 End Sub

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' WriteXml converts the object to Xml (serializes it) and writes it using the XmlWriter passed
 ''' </summary>
 ''' <remarks></remarks>
 ''' <param name="writer">The XmlWriter that contains the xml for the object</param>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub WriteXml(ByVal writer As XmlWriter) Implements IXmlSerializable.WriteXml
  writer.WriteStartElement("UserRole")
  writer.WriteElementString("UserName", UserName.ToString())
  writer.WriteElementString("RoleId", RoleId.ToString())
  writer.WriteEndElement()
 End Sub

#End Region

#Region " ToXml Methods "
 Public Function ToXml() As String
  Return ToXml("UserRole")
 End Function

 Public Function ToXml(ByVal elementName As String) As String
  Dim xml As New StringBuilder
  xml.Append("<")
  xml.Append(elementName)
  'Add Attribute(xml, "UserName", UserName.ToString())
  'Add Attribute(xml, "RoleId", RoleId.ToString())
  xml.Append(" />")
  Return xml.ToString
 End Function
#End Region

End Class
#End Region

#Region " UserRolesController "
Public Class UserRolesController
 Public Shared Function AddUserRole(ByVal objUserRole As UserRoleInfo) As Integer

  DataProvider.Instance().AddUserRole(objUserRole.UserName, objUserRole.RoleId)

 End Function

 Public Shared Sub DeleteUserRole(ByVal UserName As String, ByVal RoleId As Integer)

  DataProvider.Instance().DeleteUserRole(UserName, RoleId)

 End Sub

End Class
#End Region


#Region " UserInfo "
<Serializable(), XmlRoot("User")> _
Public Class UserInfo
 'Implements IHydratable
 'Implements IPropertyAccess
 'Implements IXmlSerializable

 ' local property declarations
 Private _ApplicationId As Guid
 Private _IsAnonymous As Boolean
 Private _LastActivityDate As Date
 Private _LoweredUserName As String
 Private _MobileAlias As String
 Private _UserId As Guid
 Private _UserName As String

#Region " Constructors "
 Public Sub New()
 End Sub

 Public Sub New(ByVal ApplicationId As Guid, ByVal IsAnonymous As Boolean, ByVal LastActivityDate As Date, ByVal LoweredUserName As String, ByVal MobileAlias As String, ByVal UserId As Guid, ByVal UserName As String)
  Me.ApplicationId = ApplicationId
  Me.IsAnonymous = IsAnonymous
  Me.LastActivityDate = LastActivityDate
  Me.LoweredUserName = LoweredUserName
  Me.MobileAlias = MobileAlias
  Me.UserId = UserId
  Me.UserName = UserName
 End Sub
#End Region

#Region " Public Properties "

 Public Property ApplicationId() As Guid
  Get
   Return _ApplicationId
  End Get
  Set(ByVal Value As Guid)
   _ApplicationId = Value
  End Set
 End Property

 Public Property IsAnonymous() As Boolean
  Get
   Return _IsAnonymous
  End Get
  Set(ByVal Value As Boolean)
   _IsAnonymous = Value
  End Set
 End Property

 Public Property LastActivityDate() As Date
  Get
   Return _LastActivityDate
  End Get
  Set(ByVal Value As Date)
   _LastActivityDate = Value
  End Set
 End Property

 Public Property LoweredUserName() As String
  Get
   Return _LoweredUserName
  End Get
  Set(ByVal Value As String)
   _LoweredUserName = Value
  End Set
 End Property

 Public Property MobileAlias() As String
  Get
   Return _MobileAlias
  End Get
  Set(ByVal Value As String)
   _MobileAlias = Value
  End Set
 End Property

 Public Property UserId() As Guid
  Get
   Return _UserId
  End Get
  Set(ByVal Value As Guid)
   _UserId = Value
  End Set
 End Property

 Public Property UserName() As String
  Get
   Return _UserName
  End Get
  Set(ByVal Value As String)
   _UserName = Value
  End Set
 End Property

#End Region

 '#Region " IHydratable Implementation "

 ' ''' -----------------------------------------------------------------------------
 ' ''' <summary>
 ' ''' Fill hydrates the object from a Datareader
 ' ''' </summary>
 ' ''' <remarks>The Fill method is used by the CBO method to hydrtae the object
 ' ''' rather than using the more expensive Refection  methods.</remarks>
 ' ''' <history>
 ' ''' 	[]	05/11/2008  Created
 ' ''' </history>
 ' ''' -----------------------------------------------------------------------------
 ' Public Sub Fill(ByVal dr As IDataReader) Implements IHydratable.Fill

 '  ApplicationId = Convert.ToGuid(Null.SetNull(dr.Item("ApplicationId"), ApplicationId))
 '  IsAnonymous = Convert.ToBoolean(Null.SetNull(dr.Item("IsAnonymous"), IsAnonymous))
 '  LastActivityDate = Convert.ToDateTime(Null.SetNull(dr.Item("LastActivityDate"), LastActivityDate))
 '  LoweredUserName = Convert.ToString(Null.SetNull(dr.Item("LoweredUserName"), LoweredUserName))
 '  MobileAlias = Convert.ToString(Null.SetNull(dr.Item("MobileAlias"), MobileAlias))
 '  UserId = Convert.ToGuid(Null.SetNull(dr.Item("UserId"), UserId))
 '  UserName = Convert.ToString(Null.SetNull(dr.Item("UserName"), UserName))

 ' End Sub
 ' ''' -----------------------------------------------------------------------------
 ' ''' <summary>
 ' ''' Gets and sets the Key ID
 ' ''' </summary>
 ' ''' <remarks>The KeyID property is part of the IHydratble interface.  It is used
 ' ''' as the key property when creating a Dictionary</remarks>
 ' ''' <history>
 ' ''' 	[]	05/11/2008  Created
 ' ''' </history>
 ' ''' -----------------------------------------------------------------------------
 ' Public Property KeyID() As Integer Implements Entities.Modules.IHydratable.KeyID
 '  Get
 '   Return ApplicationId
 '  End Get
 '  Set(ByVal value As Integer)
 '   ApplicationId = value
 '  End Set
 ' End Property

 '#End Region

 '#Region " IPropertyAccess Implementation "

 ' Public Function GetProperty(ByVal strPropertyName As String, ByVal strFormat As String, ByVal formatProvider As System.Globalization.CultureInfo, ByVal AccessingUser As Entities.Users.UserInfo, ByVal AccessLevel As DotNetNuke.Services.Tokens.Scope, ByRef PropertyNotFound As Boolean) As String Implements DotNetNuke.Services.Tokens.IPropertyAccess.GetProperty
 '  Dim OutputFormat As String = String.Empty
 '  Dim portalSettings As PortalSettings = PortalController.GetCurrentPortalSettings()
 '  If strFormat = String.Empty Then
 '   OutputFormat = "D"
 '  Else
 '   OutputFormat = strFormat
 '  End If
 '  Select Case strPropertyName.ToLower
 '   Case "applicationid"
 '    Return (Me.ApplicationId.ToString(OutputFormat, formatProvider))
 '   Case "isanonymous"
 '    Return PropertyAccess.Boolean2LocalizedYesNo(Me.IsAnonymous, formatProvider)
 '   Case "lastactivitydate"
 '    Return (Me.LastActivityDate.ToString(OutputFormat, formatProvider))
 '   Case "loweredusername"
 '    Return PropertyAccess.FormatString(Me.LoweredUserName, strFormat)
 '   Case "mobilealias"
 '    Return PropertyAccess.FormatString(Me.MobileAlias, strFormat)
 '   Case "userid"
 '    Return (Me.UserId.ToString(OutputFormat, formatProvider))
 '   Case "username"
 '    Return PropertyAccess.FormatString(Me.UserName, strFormat)
 '   Case Else
 '    PropertyNotFound = True
 '  End Select

 '  Return Null.NullString
 ' End Function

 ' Public ReadOnly Property Cacheability() As DotNetNuke.Services.Tokens.CacheLevel Implements DotNetNuke.Services.Tokens.IPropertyAccess.Cacheability
 '  Get
 '   Return CacheLevel.fullyCacheable
 '  End Get
 ' End Property

 '#End Region

 '#Region " IXmlSerializable Implementation "

 ' ''' -----------------------------------------------------------------------------
 ' ''' <summary>
 ' ''' GetSchema returns the XmlSchema for this class
 ' ''' </summary>
 ' ''' <remarks>GetSchema is implemented as a stub method as it is not required</remarks>
 ' ''' <history>
 ' ''' 	[]	05/11/2008  Created
 ' ''' </history>
 ' ''' -----------------------------------------------------------------------------
 ' Public Function GetSchema() As XmlSchema Implements IXmlSerializable.GetSchema
 '  Return Nothing
 ' End Function

 ' Private Function readElement(ByVal reader As XmlReader, ByVal ElementName As String) As String
 '  If (Not reader.NodeType = XmlNodeType.Element) OrElse reader.Name <> ElementName Then
 '   reader.ReadToFollowing(ElementName)
 '  End If
 '  If reader.NodeType = XmlNodeType.Element Then
 '   Return reader.ReadElementContentAsString
 '  Else
 '   Return ""
 '  End If
 ' End Function

 ' ''' -----------------------------------------------------------------------------
 ' ''' <summary>
 ' ''' ReadXml fills the object (de-serializes it) from the XmlReader passed
 ' ''' </summary>
 ' ''' <remarks></remarks>
 ' ''' <param name="reader">The XmlReader that contains the xml for the object</param>
 ' ''' <history>
 ' ''' 	[]	05/11/2008  Created
 ' ''' </history>
 ' ''' -----------------------------------------------------------------------------
 ' Public Sub ReadXml(ByVal reader As XmlReader) Implements IXmlSerializable.ReadXml
 '  Try

 '   Boolean.TryParse(readElement(reader, "IsAnonymous"), IsAnonymous)
 '   If Not DateTime.TryParse(readElement(reader, "LastActivityDate"), LastActivityDate) Then
 '    LastActivityDate = DateTime.MinValue
 '   End If
 '   LoweredUserName = readElement(reader, "LoweredUserName")
 '   MobileAlias = readElement(reader, "MobileAlias")
 '   Guid.TryParse(readElement(reader, "UserId"), UserId)
 '   UserName = readElement(reader, "UserName")
 '  Catch ex As Exception
 '   ' log exception as DNN import routine does not do that
 '   DotNetNuke.Services.Exceptions.LogException(ex)
 '   ' re-raise exception to make sure import routine displays a visible error to the user
 '   Throw New Exception("An error occured during import of an User", ex)
 '  End Try

 ' End Sub

 ' ''' -----------------------------------------------------------------------------
 ' ''' <summary>
 ' ''' WriteXml converts the object to Xml (serializes it) and writes it using the XmlWriter passed
 ' ''' </summary>
 ' ''' <remarks></remarks>
 ' ''' <param name="writer">The XmlWriter that contains the xml for the object</param>
 ' ''' <history>
 ' ''' 	[]	05/11/2008  Created
 ' ''' </history>
 ' ''' -----------------------------------------------------------------------------
 ' Public Sub WriteXml(ByVal writer As XmlWriter) Implements IXmlSerializable.WriteXml
 '  writer.WriteStartElement("User")
 '  writer.WriteElementString("ApplicationId", ApplicationId.ToString())
 '  writer.WriteElementString("IsAnonymous", IsAnonymous.ToString())
 '  writer.WriteElementString("LastActivityDate", LastActivityDate.ToString())
 '  writer.WriteElementString("LoweredUserName", LoweredUserName)
 '  writer.WriteElementString("MobileAlias", MobileAlias)
 '  writer.WriteElementString("UserId", UserId.ToString())
 '  writer.WriteElementString("UserName", UserName)
 '  writer.WriteEndElement()
 ' End Sub

 '#End Region

 '#Region " ToXml Methods "
 ' Public Function ToXml() As String
 '  Return ToXml("User")
 ' End Function

 ' Public Function ToXml(ByVal elementName As String) As String
 '  Dim xml As New StringBuilder
 '  xml.Append("<")
 '  xml.Append(elementName)
 '  AddAttribute(xml, "ApplicationId", ApplicationId.ToString())
 '  AddAttribute(xml, "IsAnonymous", IsAnonymous.ToString())
 '  AddAttribute(xml, "LastActivityDate", LastActivityDate.ToString())
 '  AddAttribute(xml, "LoweredUserName", LoweredUserName)
 '  AddAttribute(xml, "MobileAlias", MobileAlias)
 '  AddAttribute(xml, "UserId", UserId.ToString())
 '  AddAttribute(xml, "UserName", UserName)
 '  xml.Append(" />")
 '  Return xml.ToString
 ' End Function
 '#End Region

End Class
#End Region

#Region " UsersController "
Public Class UsersController

 Public Shared Function GetUser(ByVal UserName As String) As UserInfo

  Return CType(CBO.FillObject(DataProvider.Instance().GetUser(UserName), GetType(UserInfo)), UserInfo)

 End Function

 Public Shared Function AddUser(ByVal objUser As UserInfo) As Integer

  Return CType(DataProvider.Instance().AddUser(objUser.IsAnonymous, objUser.LastActivityDate, objUser.MobileAlias, objUser.UserName), Integer)

 End Function

 Public Shared Sub UpdateUser(ByVal objUser As UserInfo)

  DataProvider.Instance().UpdateUser(objUser.IsAnonymous, objUser.LastActivityDate, objUser.MobileAlias, objUser.UserName)
	
 End Sub

 Public Shared Sub DeleteUser(ByVal UserName As String)

  DataProvider.Instance().DeleteUser(UserName)

 End Sub

 Public Shared Function GetProjectMembers(ByVal ProjectId As Integer) As ArrayList

  Return CBO.FillCollection(DataProvider.Instance().GetProjectMembers(ProjectId), GetType(UserInfo))

 End Function

End Class
#End Region


#Region " VersionInfo "
<Serializable(), XmlRoot("Version")> _
Public Class VersionInfo
 Implements IHydratable
 Implements IPropertyAccess
 Implements IXmlSerializable

 ' local property declarations
 Private _VersionID As Integer
 Private _Name As String
 Private _ProjectID As Integer
 Private _SortOrder As Integer

#Region " Constructors "
 Public Sub New()
 End Sub

 Public Sub New(ByVal VersionID As Integer, ByVal Name As String, ByVal ProjectID As Integer, ByVal SortOrder As Integer)
  Me.Name = Name
  Me.ProjectID = ProjectID
  Me.SortOrder = SortOrder
  Me.VersionID = VersionID
 End Sub
#End Region

#Region " Public Properties "

 Public Property VersionID() As Integer
  Get
   Return _VersionID
  End Get
  Set(ByVal Value As Integer)
   _VersionID = Value
  End Set
 End Property

 Public Property Name() As String
  Get
   Return _Name
  End Get
  Set(ByVal Value As String)
   _Name = Value
  End Set
 End Property

 Public Property ProjectID() As Integer
  Get
   Return _ProjectID
  End Get
  Set(ByVal Value As Integer)
   _ProjectID = Value
  End Set
 End Property

 Public Property SortOrder() As Integer
  Get
   Return _SortOrder
  End Get
  Set(ByVal Value As Integer)
   _SortOrder = Value
  End Set
 End Property

#End Region

#Region " IHydratable Implementation "

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' Fill hydrates the object from a Datareader
 ''' </summary>
 ''' <remarks>The Fill method is used by the CBO method to hydrtae the object
 ''' rather than using the more expensive Refection  methods.</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub Fill(ByVal dr As IDataReader) Implements IHydratable.Fill

  Name = Convert.ToString(Null.SetNull(dr.Item("Name"), Name))
  ProjectID = Convert.ToInt32(Null.SetNull(dr.Item("ProjectID"), ProjectID))
  SortOrder = Convert.ToInt32(Null.SetNull(dr.Item("SortOrder"), SortOrder))
  VersionID = Convert.ToInt32(Null.SetNull(dr.Item("VersionID"), VersionID))

 End Sub
 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' Gets and sets the Key ID
 ''' </summary>
 ''' <remarks>The KeyID property is part of the IHydratble interface.  It is used
 ''' as the key property when creating a Dictionary</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Property KeyID() As Integer Implements Entities.Modules.IHydratable.KeyID
  Get
   Return VersionID
  End Get
  Set(ByVal value As Integer)
   VersionID = value
  End Set
 End Property

#End Region

#Region " IPropertyAccess Implementation "

 Public Function GetProperty(ByVal strPropertyName As String, ByVal strFormat As String, ByVal formatProvider As System.Globalization.CultureInfo, ByVal AccessingUser As Entities.Users.UserInfo, ByVal AccessLevel As DotNetNuke.Services.Tokens.Scope, ByRef PropertyNotFound As Boolean) As String Implements DotNetNuke.Services.Tokens.IPropertyAccess.GetProperty
  Dim OutputFormat As String = String.Empty
  Dim portalSettings As PortalSettings = PortalController.GetCurrentPortalSettings()
  If strFormat = String.Empty Then
   OutputFormat = "D"
  Else
   OutputFormat = strFormat
  End If
  Select Case strPropertyName.ToLower
   Case "name"
    Return PropertyAccess.FormatString(Me.Name, strFormat)
   Case "projectid"
    Return (Me.ProjectID.ToString(OutputFormat, formatProvider))
   Case "sortorder"
    Return (Me.SortOrder.ToString(OutputFormat, formatProvider))
   Case "versionid"
    Return (Me.VersionID.ToString(OutputFormat, formatProvider))
   Case Else
    PropertyNotFound = True
  End Select

  Return Null.NullString
 End Function

 Public ReadOnly Property Cacheability() As DotNetNuke.Services.Tokens.CacheLevel Implements DotNetNuke.Services.Tokens.IPropertyAccess.Cacheability
  Get
   Return CacheLevel.fullyCacheable
  End Get
 End Property

#End Region

#Region " IXmlSerializable Implementation "

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' GetSchema returns the XmlSchema for this class
 ''' </summary>
 ''' <remarks>GetSchema is implemented as a stub method as it is not required</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Function GetSchema() As XmlSchema Implements IXmlSerializable.GetSchema
  Return Nothing
 End Function

 Private Function readElement(ByVal reader As XmlReader, ByVal ElementName As String) As String
  If (Not reader.NodeType = XmlNodeType.Element) OrElse reader.Name <> ElementName Then
   reader.ReadToFollowing(ElementName)
  End If
  If reader.NodeType = XmlNodeType.Element Then
   Return reader.ReadElementContentAsString
  Else
   Return ""
  End If
 End Function

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' ReadXml fills the object (de-serializes it) from the XmlReader passed
 ''' </summary>
 ''' <remarks></remarks>
 ''' <param name="reader">The XmlReader that contains the xml for the object</param>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub ReadXml(ByVal reader As XmlReader) Implements IXmlSerializable.ReadXml
  Try

   Name = readElement(reader, "Name")
   If Not Int32.TryParse(readElement(reader, "ProjectID"), ProjectID) Then
    ProjectID = Null.NullInteger
   End If
   If Not Int32.TryParse(readElement(reader, "SortOrder"), SortOrder) Then
    SortOrder = Null.NullInteger
   End If
  Catch ex As Exception
   ' log exception as DNN import routine does not do that
   DotNetNuke.Services.Exceptions.LogException(ex)
   ' re-raise exception to make sure import routine displays a visible error to the user
   Throw New Exception("An error occured during import of an Version", ex)
  End Try

 End Sub

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' WriteXml converts the object to Xml (serializes it) and writes it using the XmlWriter passed
 ''' </summary>
 ''' <remarks></remarks>
 ''' <param name="writer">The XmlWriter that contains the xml for the object</param>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub WriteXml(ByVal writer As XmlWriter) Implements IXmlSerializable.WriteXml
  writer.WriteStartElement("Version")
  writer.WriteElementString("VersionID", VersionID.ToString())
  writer.WriteElementString("Name", Name)
  writer.WriteElementString("ProjectID", ProjectID.ToString())
  writer.WriteElementString("SortOrder", SortOrder.ToString())
  writer.WriteEndElement()
 End Sub

#End Region

#Region " ToXml Methods "
 Public Function ToXml() As String
  Return ToXml("Version")
 End Function

 Public Function ToXml(ByVal elementName As String) As String
  Dim xml As New StringBuilder
  xml.Append("<")
  xml.Append(elementName)
  'Add Attribute(xml, "VersionID", VersionID.ToString())
  'Add Attribute(xml, "Name", Name)
  'Add Attribute(xml, "ProjectID", ProjectID.ToString())
  'Add Attribute(xml, "SortOrder", SortOrder.ToString())
  xml.Append(" />")
  Return xml.ToString
 End Function
#End Region

End Class
#End Region

#Region " VersionsController "
Public Class VersionsController

 Public Shared Function GetVersion(ByVal VersionID As Integer) As VersionInfo

  Return CType(CBO.FillObject(DataProvider.Instance().GetVersion(VersionID), GetType(VersionInfo)), VersionInfo)

 End Function

 Public Shared Function AddVersion(ByVal objVersion As VersionInfo) As Integer

  Return CType(DataProvider.Instance().AddVersion(objVersion.Name, objVersion.ProjectID, objVersion.SortOrder), Integer)

 End Function

 Public Shared Sub UpdateVersion(ByVal objVersion As VersionInfo)

  DataProvider.Instance().UpdateVersion(objVersion.VersionID, objVersion.Name, objVersion.ProjectID, objVersion.SortOrder)

 End Sub

 Public Shared Sub DeleteVersion(ByVal VersionID As Integer)

  DataProvider.Instance().DeleteVersion(VersionID)

 End Sub

 Public Shared Function GetVersionsByProject(ByVal ProjectID As Integer) As IDictionary(Of Integer, VersionInfo)

  Return CBO.FillDictionary(Of VersionInfo)(DataProvider.Instance().GetVersionsByProject(ProjectID))

 End Function

End Class
#End Region

