Imports System
Imports System.Data
Imports System.Xml
Imports System.Xml.Schema
Imports System.Xml.Serialization

Imports DotNetNuke
Imports DotNetNuke.Common.Utilities
Imports DotNetNuke.Entities.Modules
Imports DotNetNuke.Entities.Portals
Imports DotNetNuke.Services.Tokens

Imports System.Text


<Serializable(), XmlRoot("Project")> _
Public Class ProjectInfo
 Implements IHydratable
 Implements IPropertyAccess
 Implements IXmlSerializable

 ' local property declarations
 Private _ProjectID As Integer
 Private _AccessType As Integer
 Private _Active As Integer
 Private _AllowAttachments As Boolean
 Private _Code As String
 Private _CreateDate As Date
 Private _CreatorUserName As String
 Private _Description As String
 Private _ManagerUserName As String
 Private _Name As String
 Private _UploadPath As String

#Region " Constructors "
 Public Sub New()
 End Sub

 Public Sub New(ByVal ProjectID As Integer, ByVal AccessType As Integer, ByVal Active As Integer, ByVal AllowAttachments As Boolean, ByVal Code As String, ByVal CreateDate As Date, ByVal CreatorUserName As String, ByVal Description As String, ByVal ManagerUserName As String, ByVal Name As String, ByVal UploadPath As String)
  Me.AccessType = AccessType
  Me.Active = Active
  Me.AllowAttachments = AllowAttachments
  Me.Code = Code
  Me.CreateDate = CreateDate
  Me.CreatorUserName = CreatorUserName
  Me.Description = Description
  Me.ManagerUserName = ManagerUserName
  Me.Name = Name
  Me.ProjectID = ProjectID
  Me.UploadPath = UploadPath
 End Sub
#End Region

#Region " Public Properties "

 Public Property ProjectID() As Integer
  Get
   Return _ProjectID
  End Get
  Set(ByVal Value As Integer)
   _ProjectID = Value
  End Set
 End Property

 Public Property AccessType() As Integer
  Get
   Return _AccessType
  End Get
  Set(ByVal Value As Integer)
   _AccessType = Value
  End Set
 End Property

 Public Property Active() As Integer
  Get
   Return _Active
  End Get
  Set(ByVal Value As Integer)
   _Active = Value
  End Set
 End Property

 Public Property AllowAttachments() As Boolean
  Get
   Return _AllowAttachments
  End Get
  Set(ByVal Value As Boolean)
   _AllowAttachments = Value
  End Set
 End Property

 Public Property Code() As String
  Get
   Return _Code
  End Get
  Set(ByVal Value As String)
   _Code = Value
  End Set
 End Property

 Public Property CreateDate() As Date
  Get
   Return _CreateDate
  End Get
  Set(ByVal Value As Date)
   _CreateDate = Value
  End Set
 End Property

 Public Property CreatorUserName() As String
  Get
   Return _CreatorUserName
  End Get
  Set(ByVal Value As String)
   _CreatorUserName = Value
  End Set
 End Property

 Public Property Description() As String
  Get
   Return _Description
  End Get
  Set(ByVal Value As String)
   _Description = Value
  End Set
 End Property

 Public Property ManagerUserName() As String
  Get
   Return _ManagerUserName
  End Get
  Set(ByVal Value As String)
   _ManagerUserName = Value
  End Set
 End Property

 Public Property Name() As String
  Get
   Return _Name
  End Get
  Set(ByVal Value As String)
   _Name = Value
  End Set
 End Property

 Public Property UploadPath() As String
  Get
   Return _UploadPath
  End Get
  Set(ByVal Value As String)
   _UploadPath = Value
  End Set
 End Property

#End Region

#Region " IHydratable Implementation "

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' Fill hydrates the object from a Datareader
 ''' </summary>
 ''' <remarks>The Fill method is used by the CBO method to hydrtae the object
 ''' rather than using the more expensive Refection  methods.</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub Fill(ByVal dr As IDataReader) Implements IHydratable.Fill

  AccessType = Convert.ToInt32(Null.SetNull(dr.Item("AccessType"), AccessType))
  Active = Convert.ToInt32(Null.SetNull(dr.Item("Active"), Active))
  AllowAttachments = Convert.ToBoolean(Null.SetNull(dr.Item("AllowAttachments"), AllowAttachments))
  Code = Convert.ToString(Null.SetNull(dr.Item("Code"), Code))
  CreateDate = Convert.ToDateTime(Null.SetNull(dr.Item("CreateDate"), CreateDate))
  CreatorUserName = Convert.ToString(Null.SetNull(dr.Item("CreatorUserName"), CreatorUserName))
  Description = Convert.ToString(Null.SetNull(dr.Item("Description"), Description))
  ManagerUserName = Convert.ToString(Null.SetNull(dr.Item("ManagerUserName"), ManagerUserName))
  Name = Convert.ToString(Null.SetNull(dr.Item("Name"), Name))
  ProjectID = Convert.ToInt32(Null.SetNull(dr.Item("ProjectID"), ProjectID))
  UploadPath = Convert.ToString(Null.SetNull(dr.Item("UploadPath"), UploadPath))

 End Sub
 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' Gets and sets the Key ID
 ''' </summary>
 ''' <remarks>The KeyID property is part of the IHydratble interface.  It is used
 ''' as the key property when creating a Dictionary</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Property KeyID() As Integer Implements Entities.Modules.IHydratable.KeyID
  Get
   Return ProjectID
  End Get
  Set(ByVal value As Integer)
   ProjectID = value
  End Set
 End Property

#End Region

#Region " IPropertyAccess Implementation "

 Public Function GetProperty(ByVal strPropertyName As String, ByVal strFormat As String, ByVal formatProvider As System.Globalization.CultureInfo, ByVal AccessingUser As Entities.Users.UserInfo, ByVal AccessLevel As DotNetNuke.Services.Tokens.Scope, ByRef PropertyNotFound As Boolean) As String Implements DotNetNuke.Services.Tokens.IPropertyAccess.GetProperty
  Dim OutputFormat As String = String.Empty
  Dim portalSettings As PortalSettings = PortalController.GetCurrentPortalSettings()
  If strFormat = String.Empty Then
   OutputFormat = "D"
  Else
   OutputFormat = strFormat
  End If
  Select Case strPropertyName.ToLower
   Case "accesstype"
    Return (Me.AccessType.ToString(OutputFormat, formatProvider))
   Case "active"
    Return (Me.Active.ToString(OutputFormat, formatProvider))
   Case "allowattachments"
    Return PropertyAccess.Boolean2LocalizedYesNo(Me.AllowAttachments, formatProvider)
   Case "code"
    Return PropertyAccess.FormatString(Me.Code, strFormat)
   Case "createdate"
    Return (Me.CreateDate.ToString(OutputFormat, formatProvider))
   Case "creatorusername"
    Return PropertyAccess.FormatString(Me.CreatorUserName, strFormat)
   Case "description"
    Return PropertyAccess.FormatString(Me.Description, strFormat)
   Case "managerusername"
    Return PropertyAccess.FormatString(Me.ManagerUserName, strFormat)
   Case "name"
    Return PropertyAccess.FormatString(Me.Name, strFormat)
   Case "projectid"
    Return (Me.ProjectID.ToString(OutputFormat, formatProvider))
   Case "uploadpath"
    Return PropertyAccess.FormatString(Me.UploadPath, strFormat)
   Case Else
    PropertyNotFound = True
  End Select

  Return Null.NullString
 End Function

 Public ReadOnly Property Cacheability() As DotNetNuke.Services.Tokens.CacheLevel Implements DotNetNuke.Services.Tokens.IPropertyAccess.Cacheability
  Get
   Return CacheLevel.fullyCacheable
  End Get
 End Property

#End Region

#Region " IXmlSerializable Implementation "

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' GetSchema returns the XmlSchema for this class
 ''' </summary>
 ''' <remarks>GetSchema is implemented as a stub method as it is not required</remarks>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Function GetSchema() As XmlSchema Implements IXmlSerializable.GetSchema
  Return Nothing
 End Function

 Private Function readElement(ByVal reader As XmlReader, ByVal ElementName As String) As String
  If (Not reader.NodeType = XmlNodeType.Element) OrElse reader.Name <> ElementName Then
   reader.ReadToFollowing(ElementName)
  End If
  If reader.NodeType = XmlNodeType.Element Then
   Return reader.ReadElementContentAsString
  Else
   Return ""
  End If
 End Function

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' ReadXml fills the object (de-serializes it) from the XmlReader passed
 ''' </summary>
 ''' <remarks></remarks>
 ''' <param name="reader">The XmlReader that contains the xml for the object</param>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub ReadXml(ByVal reader As XmlReader) Implements IXmlSerializable.ReadXml
  Try

   If Not Int32.TryParse(readElement(reader, "AccessType"), AccessType) Then
    AccessType = Null.NullInteger
   End If
   If Not Int32.TryParse(readElement(reader, "Active"), Active) Then
    Active = Null.NullInteger
   End If
   Boolean.TryParse(readElement(reader, "AllowAttachments"), AllowAttachments)
   Code = readElement(reader, "Code")
   If Not DateTime.TryParse(readElement(reader, "CreateDate"), CreateDate) Then
    CreateDate = DateTime.MinValue
   End If
   readElement(reader, "CreatorUserName")
   Description = readElement(reader, "Description")
   readElement(reader, "ManagerUserName")
   Name = readElement(reader, "Name")
   UploadPath = readElement(reader, "UploadPath")
  Catch ex As Exception
   ' log exception as DNN import routine does not do that
   DotNetNuke.Services.Exceptions.LogException(ex)
   ' re-raise exception to make sure import routine displays a visible error to the user
   Throw New Exception("An error occured during import of an Project", ex)
  End Try

 End Sub

 ''' -----------------------------------------------------------------------------
 ''' <summary>
 ''' WriteXml converts the object to Xml (serializes it) and writes it using the XmlWriter passed
 ''' </summary>
 ''' <remarks></remarks>
 ''' <param name="writer">The XmlWriter that contains the xml for the object</param>
 ''' <history>
 ''' 	[pdonker]	05/11/2008  Created
 ''' </history>
 ''' -----------------------------------------------------------------------------
 Public Sub WriteXml(ByVal writer As XmlWriter) Implements IXmlSerializable.WriteXml
  writer.WriteStartElement("Project")
  writer.WriteElementString("ProjectID", ProjectID.ToString())
  writer.WriteElementString("AccessType", AccessType.ToString())
  writer.WriteElementString("Active", Active.ToString())
  writer.WriteElementString("AllowAttachments", AllowAttachments.ToString())
  writer.WriteElementString("Code", Code)
  writer.WriteElementString("CreateDate", CreateDate.ToString())
  writer.WriteElementString("CreatorUserName", CreatorUserName.ToString())
  writer.WriteElementString("Description", Description)
  writer.WriteElementString("ManagerUserName", ManagerUserName.ToString())
  writer.WriteElementString("Name", Name)
  writer.WriteElementString("UploadPath", UploadPath)
  writer.WriteEndElement()
 End Sub

#End Region

#Region " ToXml Methods "
 Public Function ToXml() As String
  Return ToXml("Project")
 End Function

 Public Function ToXml(ByVal elementName As String) As String
  Dim xml As New StringBuilder
  xml.Append("<")
  xml.Append(elementName)
  'Add Attribute(xml, "ProjectID", ProjectID.ToString())
  'Add Attribute(xml, "AccessType", AccessType.ToString())
  'Add Attribute(xml, "Active", Active.ToString())
  'Add Attribute(xml, "AllowAttachments", AllowAttachments.ToString())
  'Add Attribute(xml, "Code", Code)
  'Add Attribute(xml, "CreateDate", CreateDate.ToString())
  'Add Attribute(xml, "CreatorUserName", CreatorUserName.ToString())
  'Add Attribute(xml, "Description", Description)
  'Add Attribute(xml, "ManagerUserName", ManagerUserName.ToString())
  'Add Attribute(xml, "Name", Name)
  'Add Attribute(xml, "UploadPath", UploadPath)
  xml.Append(" />")
  Return xml.ToString
 End Function
#End Region

End Class
