Imports System

Imports DotNetNuke.Common.Utilities

Imports BugNET.DNN.Library.Data

Public Class ProjectsController

 Public Shared Function GetProjects() As ArrayList

  Return CBO.FillCollection(DataProvider.Instance().GetProjects, GetType(ProjectInfo))

 End Function

 Public Shared Function GetProject(ByVal ProjectID As Integer) As ProjectInfo

  Return CType(CBO.FillObject(DataProvider.Instance().GetProject(ProjectID), GetType(ProjectInfo)), ProjectInfo)

 End Function

 Public Shared Function AddProject(ByVal objProject As ProjectInfo) As Integer

  Return CType(DataProvider.Instance().AddProject(objProject.AccessType, objProject.Active, objProject.AllowAttachments, objProject.Code, objProject.CreateDate, objProject.CreatorUserName, objProject.Description, objProject.ManagerUserName, objProject.Name, objProject.UploadPath), Integer)

 End Function

 Public Shared Sub UpdateProject(ByVal objProject As ProjectInfo)

  DataProvider.Instance().UpdateProject(objProject.ProjectID, objProject.AccessType, objProject.Active, objProject.AllowAttachments, objProject.Code, objProject.CreateDate, objProject.CreatorUserName, objProject.Description, objProject.ManagerUserName, objProject.Name, objProject.UploadPath)

 End Sub

 Public Shared Sub DeleteProject(ByVal ProjectID As Integer)

  DataProvider.Instance().DeleteProject(ProjectID)

 End Sub

 Public Shared Function FindProjectByCode(ByVal Code As String) As ProjectInfo

  Return CType(CBO.FillObject(DataProvider.Instance().FindProjectByCode(Code), GetType(ProjectInfo)), ProjectInfo)

 End Function

 Public Shared Function FindProjectByName(ByVal Name As String) As ProjectInfo

  Return CType(CBO.FillObject(DataProvider.Instance().FindProjectByName(Name), GetType(ProjectInfo)), ProjectInfo)

 End Function

End Class
