﻿Public Class ModuleSettings

#Region " Private Members "
 Private _moduleId As Integer = -1
 Private _settings As Hashtable = Nothing
 Private _idField As String = ""
 Private _summarySQL As String = ""
 Private _reporterSQL As String = ""
 Private _descriptionSQL As String = ""
 Private _notConnectedMessage As String = "This item is not tracked in the bug tracker"
#End Region

#Region " Constructor "
 ''' <summary>
 ''' Gets settings from ModuleSettings table.
 ''' </summary>
 ''' <param name="ModuleId"></param>
 ''' <remarks>
 ''' </remarks>
 ''' <history>
 ''' 	[pdonker]	03/01/2008  Created
 ''' </history>
 Public Sub New(ByVal ModuleId As Integer)

  _moduleId = ModuleId
  _settings = (New DotNetNuke.Entities.Modules.ModuleController).GetModuleSettings(ModuleId)

  If Not _settings.Item("IdField") Is Nothing Then
   IdField = CType(_settings.Item("IdField"), String)
  End If

  If Not _settings.Item("SummarySQL") Is Nothing Then
   SummarySQL = CType(_settings.Item("SummarySQL"), String)
  End If

  If Not _settings.Item("ReporterSQL") Is Nothing Then
   ReporterSQL = CType(_settings.Item("ReporterSQL"), String)
  End If

  If Not _settings.Item("DescriptionSQL") Is Nothing Then
   DescriptionSQL = CType(_settings.Item("DescriptionSQL"), String)
  End If

  If Not _settings.Item("NotConnectedMessage") Is Nothing Then
   NotConnectedMessage = CType(_settings.Item("NotConnectedMessage"), String)
  End If

 End Sub
#End Region

#Region " Public Methods "
 ''' <summary>
 ''' Save settings to ModuleSettings table
 ''' </summary>
 ''' <remarks>
 ''' </remarks>
 ''' <history>
 ''' 	[pdonker]	03/01/2008  Created
 ''' </history>
 Public Sub Save()
  Dim objModules As New DotNetNuke.Entities.Modules.ModuleController
  objModules.UpdateModuleSetting(_moduleId, "IdField", Me.IdField)
  objModules.UpdateModuleSetting(_moduleId, "SummarySQL", Me.SummarySQL)
  objModules.UpdateModuleSetting(_moduleId, "ReporterSQL", Me.ReporterSQL)
  objModules.UpdateModuleSetting(_moduleId, "DescriptionSQL", Me.DescriptionSQL)
  objModules.UpdateModuleSetting(_moduleId, "NotConnectedMessage", Me.NotConnectedMessage)
  DotNetNuke.Common.Utilities.DataCache.RemoveCache(CacheKey(_moduleId))
 End Sub

#End Region

#Region " Properties "
 Public Property ReporterSQL() As String
  Get
   Return _reporterSQL
  End Get
  Set(ByVal value As String)
   _reporterSQL = value
  End Set
 End Property

 Public Property SummarySQL() As String
  Get
   Return _summarySQL
  End Get
  Set(ByVal value As String)
   _summarySQL = value
  End Set
 End Property

 Public Property IdField() As String
  Get
   Return _idField
  End Get
  Set(ByVal value As String)
   _idField = value
  End Set
 End Property

 Public Property DescriptionSQL() As String
  Get
   Return _descriptionSQL
  End Get
  Set(ByVal value As String)
   _descriptionSQL = value
  End Set
 End Property

 Public Property NotConnectedMessage() As String
  Get
   Return _notConnectedMessage
  End Get
  Set(ByVal value As String)
   _notConnectedMessage = value
  End Set
 End Property
#End Region

#Region " Static Methods "
 ''' <summary>
 ''' Gets the module's settings and caches them
 ''' </summary>
 ''' <param name="ModuleId">Module ID</param>
 ''' <returns>These settings</returns>
 ''' <remarks>
 ''' </remarks>
 ''' <history>
 ''' 	[pdonker]	04/27/2008  Created
 ''' </history>
 Public Shared Function GetModuleSettings(ByVal ModuleId As Integer) As ModuleSettings
  Dim modSettings As ModuleSettings = Nothing
  Try
   modSettings = CType(DotNetNuke.Common.Utilities.DataCache.GetCache(CacheKey(ModuleId)), ModuleSettings)
  Catch
  End Try
  If modSettings Is Nothing Then
   modSettings = New ModuleSettings(ModuleId)
   Dim CacheMins As Integer
   CacheMins = 3 * Convert.ToInt32(DotNetNuke.Common.Globals.PerformanceSetting)
   If CacheMins > 0 Then
    DotNetNuke.Common.Utilities.DataCache.SetCache(CacheKey(ModuleId), modSettings, Nothing, Date.MaxValue, New TimeSpan(0, CacheMins, 0))
   End If
  End If
  Return modSettings
 End Function

 ''' <summary>
 ''' Key to use for caching these settings.
 ''' </summary>
 ''' <param name="ModuleId"></param>
 ''' <returns>Key as string</returns>
 ''' <remarks>
 ''' </remarks>
 ''' <history>
 ''' 	[pdonker]	04/27/2008  Created
 ''' </history>
 Private Shared Function CacheKey(ByVal ModuleId As Integer) As String
  Return "BugNetSettings-" & ModuleId.ToString
 End Function
#End Region

End Class
