﻿Imports Bring2mind.DNN.Modules.BugnetLink.Data

Namespace Business
 Public Class BugInfo

#Region "Private Variables"
  Private changes As New ArrayList()
  Private _AssignedDisplayName As String
  Private _AssignedToUserId As Guid
  Private _ReporterDisplayName As String
  Private _ReporterUserName As String
  Private _ReporterUserId As Guid
  Private _LastUpdateDisplayName As String
  Private _LastUpdateUserName As String
  Private _LastUpdate As DateTime
  Private _ComponentId As Integer
  Private _ComponentName As String
  Private _DateCreated As DateTime
  Private _Id As Integer
  Private _VersionId As Integer
  Private _VersionName As String
  Private _PriorityId As Integer
  Private _PriorityName As String
  Private _StatusId As Integer
  Private _StatusName As String
  Private _TypeId As Integer
  Private _TypeName As String
  Private _ResolutionId As Integer
  Private _ResolutionName As String
  Private _ProjectName As String
  Private _ProjectId As Integer
  Private _Summary As String
  Private _Description As String
  Private _NewAssignee As Boolean
  Private _ProjectCode As String
  Private _DueDate As DateTime
  Private _FixedInVersionId As Integer
  Private _FixedInVersionName As String
  Private _Visibility As Integer
  Private _TimeLogged As Double
  Private _Estimation As Decimal
  Private _AssignedToUserName As String
  Private _AssignedToUserDisplayName As String
#End Region

#Region "Constructors"
  Public Sub New(ByVal id As Integer, ByVal projectId As Integer, ByVal projectName As String, ByVal projectCode As String, ByVal summary As String, ByVal description As String, _
   ByVal componentId As Integer, ByVal componentName As String, ByVal versionId As Integer, ByVal versionName As String, ByVal priorityId As Integer, ByVal priorityName As String, _
   ByVal statusId As Integer, ByVal statusName As String, ByVal typeId As Integer, ByVal typeName As String, ByVal resolutionId As Integer, ByVal resolutionName As String, _
   ByVal assignedDisplayName As String, ByVal assignedToUserId As Guid, ByVal reporterDisplayName As String, ByVal reporterUserId As Guid, ByVal reporterUsername As String, ByVal dateCreated As DateTime, _
   ByVal lastUpdateUserName As String, ByVal lastUpdateUserDisplayName As String, ByVal lastUpdate As DateTime, ByVal dueDate As DateTime, ByVal fixedInVersionid As Integer, ByVal fixedInVersionName As String, _
   ByVal visiblity As Integer, ByVal timeLogged As Double, ByVal estimation As Decimal)
   _Id = id
   _ProjectId = projectId
   _ProjectName = projectName
   _ProjectCode = projectCode
   _Summary = summary
   _Description = description
   _ComponentId = componentId
   _ComponentName = componentName
   _VersionId = versionId
   _VersionName = versionName
   _PriorityId = priorityId
   _PriorityName = priorityName
   _StatusId = statusId
   _StatusName = statusName
   _TypeId = typeId
   _TypeName = typeName
   _ResolutionId = resolutionId
   _ResolutionName = resolutionName
   _DateCreated = dateCreated
   _AssignedDisplayName = assignedDisplayName
   _AssignedToUserId = assignedToUserId
   _ReporterDisplayName = reporterDisplayName
   _ReporterUserName = reporterUsername
   _ReporterUserId = reporterUserId
   _LastUpdateDisplayName = lastUpdateUserDisplayName
   _LastUpdate = lastUpdate
   _LastUpdateUserName = lastUpdateUserName
   _DueDate = dueDate
   _FixedInVersionId = fixedInVersionid
   _FixedInVersionName = fixedInVersionName
   _Visibility = visiblity
   _TimeLogged = timeLogged
   '_AssignedToUserDisplayName = UserIT.GetUserDisplayName(assignedDisplayName);
   _Estimation = estimation
  End Sub


  ''' <summary>
  ''' Initializes a new instance of the <see cref="T:Bug"/> class.
  ''' </summary>
  ''' <param name="projectId">The project id.</param>
  ''' <param name="summary">The summary.</param>
  ''' <param name="description">The description.</param>
  ''' <param name="componentId">The component id.</param>
  ''' <param name="versionId">The version id.</param>
  ''' <param name="priorityId">The priority id.</param>
  ''' <param name="statusId">The status id.</param>
  ''' <param name="typeId">The type id.</param>
  ''' <param name="fixedInVersionId">The fixed in version id.</param>
  ''' <param name="assignedToUserName">Name of the assigned to user.</param>
  ''' <param name="reporterUsername">The reporter username.</param>
  ''' <param name="estimation">The estimation.</param>
  Public Sub New(ByVal projectId As Integer, ByVal summary As String, ByVal description As String, ByVal componentId As Integer, ByVal versionId As Integer, ByVal priorityId As Integer, _
   ByVal statusId As Integer, ByVal typeId As Integer, ByVal fixedInVersionId As Integer, ByVal assignedToUserName As String, ByVal reporterUsername As String, ByVal estimation As Decimal)
   Me.New(-1, projectId, [String].Empty, [String].Empty, summary, description, _
    componentId, [String].Empty, versionId, [String].Empty, priorityId, [String].Empty, _
    statusId, [String].Empty, typeId, [String].Empty, 1, [String].Empty, _
    assignedToUserName, Guid.Empty, [String].Empty, Guid.Empty, reporterUsername, DateTime.Now, _
    reporterUsername, [String].Empty, DateTime.Now, DateTime.MinValue, fixedInVersionId, [String].Empty, _
    -1, 0, estimation)
   If Not [String].IsNullOrEmpty(assignedToUserName) Then
    _NewAssignee = True
   End If
  End Sub

  Public Sub New()
  End Sub
#End Region

#Region "Properties"
  Public Property TimeLogged() As Double
   Get
    Return _TimeLogged
   End Get
   Set(ByVal value As Double)
    _TimeLogged = value
   End Set
  End Property

  Public Property AssignedToUserName() As String

   Get
    If [String].IsNullOrEmpty(_AssignedToUserName) Then
     Return String.Empty
    Else
     Return _AssignedToUserName
    End If
   End Get
   Set(ByVal value As String)
    'if changed create a new history record.
    If Not [String].IsNullOrEmpty(value) AndAlso value <> _AssignedToUserName Then
     Dim OldUserName As String = _AssignedToUserName
     Dim NewUserName As String = value

     If [String].IsNullOrEmpty(_AssignedToUserName) Then
      OldUserName = "Unassigned"
     End If

     If value = "-1" OrElse [String].IsNullOrEmpty(value) Then
      NewUserName = "Unassigned"
     End If

     'Attach(New History(Me.Id, Security.GetUserName(), "Assignee", OldUserName, NewUserName))

     'Do not send notification if bug has been set to unassigned
     If Not [String].IsNullOrEmpty(value) AndAlso value <> "-1" Then
      _NewAssignee = True
     End If
    End If
    _AssignedToUserName = value
   End Set
  End Property


  ''' <summary>
  ''' Gets or sets the display name of the assigned to user.
  ''' </summary>
  ''' <value>The display name of the assigned to user.</value>
  Public Property AssignedToUserDisplayName() As String
   Get
    If [String].IsNullOrEmpty(_AssignedToUserDisplayName) Then
     Return String.Empty
    Else
     Return _AssignedToUserDisplayName
    End If
   End Get
   Set(ByVal value As String)
    _AssignedToUserDisplayName = value
   End Set
  End Property

  ''' <summary>
  ''' Gets or sets the display name of the assigned.
  ''' </summary>
  ''' <value>The display name of the assigned.</value>
  Public Property AssignedDisplayName() As String
   Get
    If _AssignedDisplayName Is Nothing OrElse _AssignedDisplayName.Length = 0 Then
     Return String.Empty
    Else
     Return _AssignedDisplayName
    End If
   End Get
   Set(ByVal value As String)
    'if changed create a new history record.
    If Not [String].IsNullOrEmpty(value) AndAlso value <> _AssignedDisplayName Then
     Dim OldUserName As String = _AssignedDisplayName
     Dim NewUserName As String = value

     If [String].IsNullOrEmpty(_AssignedDisplayName) Then
      OldUserName = "Unassigned"
     End If

     If value = "-1" OrElse [String].IsNullOrEmpty(value) Then
      NewUserName = "Unassigned"
     End If

     'Attach(New History(Me.Id, Security.GetUserName(), "Assignee", OldUserName, NewUserName))

     'Do not send notification if bug has been set to unassigned
     If Not [String].IsNullOrEmpty(value) AndAlso value <> "-1" Then
      _NewAssignee = True
     End If
    End If
    '_AssignedToUserId = value;
    _AssignedDisplayName = value
   End Set
  End Property

  Public Property Visibility() As Integer
   Get
    Return _Visibility
   End Get
   Set(ByVal value As Integer)
    If value <> _Visibility Then
     'Attach(New History(Me.Id, Security.GetUserName(), "Visibility", IIf(_Visibility = 0, [Boolean].FalseString, [Boolean].TrueString), IIf(value = 0, [Boolean].FalseString, [Boolean].TrueString)))
    End If
    _Visibility = value
   End Set
  End Property

  Public Property FixedInVersionId() As Integer
   Get
    Return _FixedInVersionId
   End Get
   Set(ByVal value As Integer)
    'if changed create a new history record.
    If value <> _FixedInVersionId Then
     'Attach(New History(Me.Id, Security.GetUserName(), "Milestone", IIf(_FixedInVersionId = -1, String.Empty, Version.GetVersionById(_FixedInVersionId).Name), Version.GetVersionById(value).Name))
    End If
    _FixedInVersionId = value
   End Set
  End Property

  Public Property ComponentId() As Integer
   Get
    Return _ComponentId
   End Get
   Set(ByVal value As Integer)
    'If changed create a new history record.
    If value <> _ComponentId Then
     'Attach(New History(Me.Id, Security.GetUserName(), "Component", Component.GetComponentById(_ComponentId).Name, Component.GetComponentById(value).Name))
    End If
    _ComponentId = value
   End Set
  End Property

  Public Property ComponentName() As String
   Get
    Return _ComponentName
   End Get
   Set(ByVal value As String)
    _ComponentName = value
   End Set
  End Property

  Public Property ReporterDisplayName() As String
   Get
    Return _ReporterDisplayName
   End Get
   Set(ByVal value As String)
    _ReporterDisplayName = value
   End Set
  End Property

  Public Property ReporterUsername() As String
   Get
    Return _ReporterUserName
   End Get
   Set(ByVal value As String)
    _ReporterUserName = value
   End Set
  End Property

  Public Property ReporterUserId() As Guid
   Get
    Return _ReporterUserId
   End Get
   Set(ByVal value As Guid)
    _ReporterUserId = value
   End Set
  End Property

  Public Property AssignedToUserId() As Guid
   Get
    Return (_AssignedToUserId)
   End Get
   Set(ByVal value As Guid)
    'If changed create a new history record.
    If value <> _AssignedToUserId Then
     Dim DisplayName As String
     Dim NewDisplayName As String
     If _AssignedToUserId = Guid.Empty Then
      DisplayName = "Unassigned"
     Else
      DisplayName = GetUser(_AssignedToUserId).UserName
     End If
     If value = Guid.Empty Then
      NewDisplayName = "Unassigned"
     Else
      'TODO:Fix the display name
      NewDisplayName = GetUser(value).UserName
     End If
     'Attach(New History(Me.Id, Security.GetUserName(), "Assignee", DisplayName, NewDisplayName))

     'Do not send notification if bug has been set to unassigned
     If value <> Guid.Empty Then
      _NewAssignee = True
     End If
    End If
    _AssignedToUserId = value
   End Set
  End Property

  Public Property DateCreated() As DateTime
   Get
    Return _DateCreated
   End Get
   Set(ByVal value As DateTime)
    _DateCreated = value
   End Set
  End Property

  Public Property ReportedDate() As DateTime
   Get
    Return _DateCreated
   End Get
   Set(ByVal value As DateTime)
    _DateCreated = value
   End Set
  End Property

  Public Property Id() As Integer
   Get
    Return _Id
   End Get
   Set(ByVal value As Integer)
    _Id = value
   End Set
  End Property

  Public Property BugID() As Integer
   Get
    Return _Id
   End Get
   Set(ByVal value As Integer)
    _Id = value
   End Set
  End Property

  Public ReadOnly Property FullId() As String
   Get
    Return (String.Concat(_ProjectCode, "-", _Id))
   End Get
  End Property

  Public Property LastUpdate() As DateTime
   Get
    Return _LastUpdate
   End Get
   Set(ByVal value As DateTime)
    _LastUpdate = value
   End Set
  End Property

  Public Property DueDate() As DateTime
   Get
    Return (_DueDate)
   End Get
   Set(ByVal value As DateTime)
    'if value has changed create a new history record.
    If value <> _DueDate Then
     'Dim PreviousDate As String = IIf(_DueDate = DateTime.MinValue, String.Empty, _DueDate.ToShortDateString())
     'Attach(New History(Me.Id, Security.GetUserName(), "Due Date", PreviousDate, value.ToShortDateString()))
    End If
    _DueDate = value
   End Set
  End Property

  Public Property LastUpdateDisplayName() As String
   Get
    Return _LastUpdateDisplayName
   End Get
   Set(ByVal value As String)
    _LastUpdateDisplayName = value
   End Set
  End Property

  Public Property LastUpdateUserName() As String
   Get
    If _LastUpdateUserName Is Nothing OrElse _LastUpdateUserName.Length = 0 Then
     Return String.Empty
    Else
     Return _LastUpdateUserName
    End If
   End Get
   Set(ByVal value As String)
    _LastUpdateUserName = value
   End Set
  End Property

  Public Property VersionId() As Integer
   Get
    Return _VersionId
   End Get
   Set(ByVal value As Integer)
    'If changed create a new history record.
    If value <> _VersionId Then
     'Attach(New History(Me.Id, Security.GetUserName(), "Version", IIf(_VersionId <= -1, "(Unassigned)", Bugnet.BusinessLogicLayer.Version.GetVersionById(_VersionId).Name), Bugnet.BusinessLogicLayer.Version.GetVersionById(value).Name))
    End If
    _VersionId = value
   End Set
  End Property

  Public Property VersionName() As String
   Get
    Return _VersionName
   End Get
   Set(ByVal value As String)
    _VersionName = value
   End Set
  End Property

  Public Property FixedInVersionName() As String
   Get
    Return _FixedInVersionName
   End Get
   Set(ByVal value As String)
    _FixedInVersionName = value
   End Set
  End Property

  Public Property TypeId() As Integer
   Get
    Return _TypeId
   End Get
   Set(ByVal value As Integer)
    'If changed create a new history record.
    If value <> _TypeId Then
     'Attach(New History(Me.Id, Security.GetUserName(), "Type", Bugnet.BusinessLogicLayer.Type.GetTypeById(_TypeId).Name, Bugnet.BusinessLogicLayer.Type.GetTypeById(value).Name))
    End If
    _TypeId = value
   End Set
  End Property

  Public Property TypeName() As String
   Get
    Return _TypeName
   End Get
   Set(ByVal value As String)
    _TypeName = value
   End Set
  End Property

  Public Property ResolutionId() As Integer
   Get
    Return _ResolutionId
   End Get
   Set(ByVal value As Integer)
    'If changed create a new history record.
    If value <> _ResolutionId Then
     'Attach(New History(Me.Id, Security.GetUserName(), "Resolution", Resolution.GetResolutionById(_ResolutionId).Name, Resolution.GetResolutionById(value).Name))
    End If
    _ResolutionId = value
   End Set
  End Property

  Public Property ResolutionName() As String
   Get
    Return _ResolutionName
   End Get
   Set(ByVal value As String)
    _ResolutionName = value
   End Set
  End Property

  Public Property PriorityId() As Integer
   Get
    Return _PriorityId
   End Get
   Set(ByVal value As Integer)
    'If changed create a new history record.
    If value <> _PriorityId Then
     'Attach(New History(Me.Id, Security.GetUserName(), "Priority", Priority.GetPriorityById(_PriorityId).Name, Priority.GetPriorityById(value).Name))
    End If
    _PriorityId = value
   End Set
  End Property

  Public Property PriorityName() As String
   Get
    Return _PriorityName
   End Get
   Set(ByVal value As String)
    _PriorityName = value
   End Set
  End Property

  Public Property ProjectId() As Integer
   Get
    Return _ProjectId
   End Get
   Set(ByVal value As Integer)
    _ProjectId = value
   End Set
  End Property

  Public Property ProjectName() As String
   Get
    Return _ProjectName
   End Get
   Set(ByVal value As String)
    _ProjectName = value
   End Set
  End Property

  Public Property ProjectCode() As String
   Get
    Return _ProjectCode
   End Get
   Set(ByVal value As String)
    _ProjectCode = value
   End Set
  End Property

  Public Property StatusId() As Integer
   Get
    Return _StatusId
   End Get
   Set(ByVal value As Integer)
    'If changed create a new history record.
    If value <> _StatusId Then
     'Attach(New History(Me.Id, Security.GetUserName(), "Status", Status.GetStatusById(_StatusId).Name, Status.GetStatusById(value).Name))
    End If
    _StatusId = value

    'if status is open, inprogress or re-opened the resolution should be unresolved.
    'If _StatusId = Convert.ToInt32(Globals.StatusType.Open) OrElse _StatusId = Convert.ToInt32(Globals.StatusType.ReOpened) OrElse _StatusId = Convert.ToInt32(Globals.StatusType.InProgress) Then
    ' _ResolutionId = Convert.ToInt32(Globals.ResolutionType.Unresolved)
    'End If
   End Set
  End Property

  Public Property StatusName() As String
   Get
    Return _StatusName
   End Get
   Set(ByVal value As String)
    _StatusName = value
   End Set
  End Property

  Public Property Summary() As String
   Get
    If _Summary Is Nothing OrElse _Summary.Length = 0 Then
     Return String.Empty
    Else
     Return _Summary
    End If
   End Get
   Set(ByVal value As String)
    If value <> _Summary Then
     'Attach(New History(Me.Id, Security.GetUserName(), "Summary", [String].Empty, [String].Empty))
    End If
    _Summary = value
   End Set
  End Property

  Public Property Description() As String
   Get
    If _Description Is Nothing OrElse _Description.Length = 0 Then
     Return String.Empty
    Else
     Return _Description
    End If
   End Get
   Set(ByVal value As String)
    If _Description <> value Then
     'Attach(New History(Me.Id, Security.GetUserName(), "Description", [String].Empty, [String].Empty))
    End If

    _Description = value
   End Set
  End Property

#End Region

#Region "Instance Methods"
  Public Function Save(ByVal UpdatingUser As String) As Boolean

   If Id <= 0 Then
    Dim TempId As Integer = CType(Data.DataProvider.Instance().CreateNewBug(Summary, Description, StatusId, PriorityId, TypeId, ComponentId, ProjectId, ResolutionId, VersionId, ReporterDisplayName, AssignedToUserDisplayName, DueDate, FixedInVersionId, Visibility, 0), Integer)
    If TempId > 0 Then
     _Id = TempId
     Data.DataProvider.Instance.AddBugNotification(Id, Me.ReporterUsername)
     If Not [String].IsNullOrEmpty(AssignedDisplayName) AndAlso ReporterUsername <> AssignedDisplayName Then
      Data.DataProvider.Instance.AddBugNotification(Id, Me.AssignedDisplayName)
     End If
     ' Add project manager to email notification
     Dim mgr As String = ""
     Using dr As IDataReader = Data.DataProvider.Instance.GetProject(ProjectId)
      If dr IsNot Nothing Then
       If dr.Read Then
        mgr = CStr(dr.Item("ManagerDisplayName"))
       End If
      End If
     End Using
     If mgr <> "" Then
      Data.DataProvider.Instance.AddBugNotification(Id, mgr)
     End If
     Return True
    Else
     Return False
    End If
   Else
    If changes.Count > 0 Then
     Data.DataProvider.Instance().UpdateBug(Id, Summary, Description, StatusId, PriorityId, TypeId, ComponentId, ProjectId, ResolutionId, VersionId, AssignedDisplayName, UpdatingUser, DueDate, FixedInVersionId, Visibility, 0)
    End If
    Return True
   End If

  End Function
#End Region

#Region "Static Methods"
  Public Shared Function GetBugById(ByVal bugId As Integer) As BugInfo
   Return CType(CBO.FillObject(DataProvider.Instance().GetBugById(bugId), GetType(BugInfo)), BugInfo)
  End Function

  Public Shared Function GetBugsByProjectId(ByVal projectId As Integer) As ArrayList
   Return DotNetNuke.Common.Utilities.CBO.FillCollection(DataProvider.Instance().GetBugsByProjectId(projectId), GetType(BugInfo))
  End Function

  Public Shared Function GetUser(ByVal userName As Object) As MembershipUser
   If userName Is Nothing Then
    Throw (New ArgumentOutOfRangeException("userName"))
   End If
   Return Membership.GetUser(userName)
  End Function
#End Region

 End Class
End Namespace
