Imports System
Imports System.Data
Imports System.Xml
Imports System.Xml.Schema
Imports System.Xml.Serialization

Imports DotNetNuke
Imports DotNetNuke.Common
Imports DotNetNuke.Common.Utilities
Imports DotNetNuke.Entities.Modules
Imports DotNetNuke.Entities.Portals
Imports DotNetNuke.Services.Tokens

Imports Bring2mind.DNN.Modules.BugnetLink.Data

Namespace Business

 Public Class BugNetController
  Public Shared Function IsSubscribed(ByVal BugId As Integer, ByVal Username As String) As Boolean
   Using ir As IDataReader = Data.DataProvider.Instance.GetBugNotification(BugId, Username)
    If ir.Read Then
     Return True
    End If
   End Using
   Return False
  End Function

  Public Shared Function GetText(ByVal SQL As String, ByVal ItemId As Integer) As String
   Dim res As String = ""
   Using ir As IDataReader = Data.DataProvider.Instance.GetText(SQL, ItemId)
    If ir IsNot Nothing Then
     If ir.Read Then
      Try
       res = CStr(ir.Item(0))
      Catch
      End Try
     End If
    End If
   End Using
   Return res
  End Function
 End Class


#Region " ItemIssueInfo "
 <Serializable(), XmlRoot("ItemIssue")> _
 Public Class ItemIssueInfo
  Implements IHydratable
  Implements IPropertyAccess
  Implements IXmlSerializable

  ' local property declarations
  Private _ModuleId As Integer
  Private _ItemId As Integer
  Private _BugId As Integer
  Private _Created As Date
  Private _CreatedBy As Integer

#Region " Constructors "
  Public Sub New()
  End Sub

  Public Sub New(ByVal ModuleId As Integer, ByVal ItemId As Integer, ByVal BugId As Integer, ByVal Created As Date, ByVal CreatedBy As Integer)
   Me.BugId = BugId
   Me.Created = Created
   Me.CreatedBy = CreatedBy
   Me.ItemId = ItemId
   Me.ModuleId = ModuleId
  End Sub
#End Region

#Region " Public Properties "

  Public Property ModuleId() As Integer
   Get
    Return _ModuleId
   End Get
   Set(ByVal Value As Integer)
    _ModuleId = Value
   End Set
  End Property

  Public Property ItemId() As Integer
   Get
    Return _ItemId
   End Get
   Set(ByVal Value As Integer)
    _ItemId = Value
   End Set
  End Property

  Public Property BugId() As Integer
   Get
    Return _BugId
   End Get
   Set(ByVal Value As Integer)
    _BugId = Value
   End Set
  End Property

  Public Property Created() As Date
   Get
    Return _Created
   End Get
   Set(ByVal Value As Date)
    _Created = Value
   End Set
  End Property

  Public Property CreatedBy() As Integer
   Get
    Return _CreatedBy
   End Get
   Set(ByVal Value As Integer)
    _CreatedBy = Value
   End Set
  End Property

#End Region

#Region " IHydratable Implementation "

  ''' -----------------------------------------------------------------------------
  ''' <summary>
  ''' Fill hydrates the object from a Datareader
  ''' </summary>
  ''' <remarks>The Fill method is used by the CBO method to hydrtae the object
  ''' rather than using the more expensive Refection  methods.</remarks>
  ''' <history>
  ''' 	[]	04/27/2008  Created
  ''' </history>
  ''' -----------------------------------------------------------------------------
  Public Sub Fill(ByVal dr As IDataReader) Implements IHydratable.Fill

   BugId = Convert.ToInt32(Null.SetNull(dr.Item("BugId"), BugId))
   Created = Convert.ToDateTime(Null.SetNull(dr.Item("Created"), Created))
   CreatedBy = Convert.ToInt32(Null.SetNull(dr.Item("CreatedBy"), CreatedBy))
   ItemId = Convert.ToInt32(Null.SetNull(dr.Item("ItemId"), ItemId))
   ModuleId = Convert.ToInt32(Null.SetNull(dr.Item("ModuleId"), ModuleId))

  End Sub
  ''' -----------------------------------------------------------------------------
  ''' <summary>
  ''' Gets and sets the Key ID
  ''' </summary>
  ''' <remarks>The KeyID property is part of the IHydratble interface.  It is used
  ''' as the key property when creating a Dictionary</remarks>
  ''' <history>
  ''' 	[]	04/27/2008  Created
  ''' </history>
  ''' -----------------------------------------------------------------------------
  Public Property KeyID() As Integer Implements Entities.Modules.IHydratable.KeyID
   Get
    Return Nothing
   End Get
   Set(ByVal value As Integer)
   End Set
  End Property

#End Region

#Region " IPropertyAccess Implementation "

  Public Function GetProperty(ByVal strPropertyName As String, ByVal strFormat As String, ByVal formatProvider As System.Globalization.CultureInfo, ByVal AccessingUser As Entities.Users.UserInfo, ByVal AccessLevel As DotNetNuke.Services.Tokens.Scope, ByRef PropertyNotFound As Boolean) As String Implements DotNetNuke.Services.Tokens.IPropertyAccess.GetProperty
   Dim OutputFormat As String = String.Empty
   Dim portalSettings As PortalSettings = PortalController.GetCurrentPortalSettings()
   If strFormat = String.Empty Then
    OutputFormat = "D"
   Else
    OutputFormat = strFormat
   End If
   Select Case strPropertyName.ToLower
    Case "bugid"
     Return (Me.BugId.ToString(OutputFormat, formatProvider))
    Case "created"
     Return (Me.Created.ToString(OutputFormat, formatProvider))
    Case "createdby"
     Return (Me.CreatedBy.ToString(OutputFormat, formatProvider))
    Case "itemid"
     Return (Me.ItemId.ToString(OutputFormat, formatProvider))
    Case "moduleid"
     Return (Me.ModuleId.ToString(OutputFormat, formatProvider))
    Case Else
     PropertyNotFound = True
   End Select

   Return Null.NullString
  End Function

  Public ReadOnly Property Cacheability() As DotNetNuke.Services.Tokens.CacheLevel Implements DotNetNuke.Services.Tokens.IPropertyAccess.Cacheability
   Get
    Return CacheLevel.fullyCacheable
   End Get
  End Property

#End Region

#Region " IXmlSerializable Implementation "

  ''' -----------------------------------------------------------------------------
  ''' <summary>
  ''' GetSchema returns the XmlSchema for this class
  ''' </summary>
  ''' <remarks>GetSchema is implemented as a stub method as it is not required</remarks>
  ''' <history>
  ''' 	[]	04/27/2008  Created
  ''' </history>
  ''' -----------------------------------------------------------------------------
  Public Function GetSchema() As XmlSchema Implements IXmlSerializable.GetSchema
   Return Nothing
  End Function

  Private Function readElement(ByVal reader As XmlReader, ByVal ElementName As String) As String
   If (Not reader.NodeType = XmlNodeType.Element) OrElse reader.Name <> ElementName Then
    reader.ReadToFollowing(ElementName)
   End If
   If reader.NodeType = XmlNodeType.Element Then
    Return reader.ReadElementContentAsString
   Else
    Return ""
   End If
  End Function

  ''' -----------------------------------------------------------------------------
  ''' <summary>
  ''' ReadXml fills the object (de-serializes it) from the XmlReader passed
  ''' </summary>
  ''' <remarks></remarks>
  ''' <param name="reader">The XmlReader that contains the xml for the object</param>
  ''' <history>
  ''' 	[]	04/27/2008  Created
  ''' </history>
  ''' -----------------------------------------------------------------------------
  Public Sub ReadXml(ByVal reader As XmlReader) Implements IXmlSerializable.ReadXml
   Try

    If Not Int32.TryParse(readElement(reader, "BugId"), BugId) Then
     BugId = Null.NullInteger
    End If
    If Not DateTime.TryParse(readElement(reader, "Created"), Created) Then
     Created = DateTime.MinValue
    End If
    If Not Int32.TryParse(readElement(reader, "CreatedBy"), CreatedBy) Then
     CreatedBy = Null.NullInteger
    End If
   Catch ex As Exception
    ' log exception as DNN import routine does not do that
    DotNetNuke.Services.Exceptions.LogException(ex)
    ' re-raise exception to make sure import routine displays a visible error to the user
    Throw New Exception("An error occured during import of an ItemIssue", ex)
   End Try

  End Sub

  ''' -----------------------------------------------------------------------------
  ''' <summary>
  ''' WriteXml converts the object to Xml (serializes it) and writes it using the XmlWriter passed
  ''' </summary>
  ''' <remarks></remarks>
  ''' <param name="writer">The XmlWriter that contains the xml for the object</param>
  ''' <history>
  ''' 	[]	04/27/2008  Created
  ''' </history>
  ''' -----------------------------------------------------------------------------
  Public Sub WriteXml(ByVal writer As XmlWriter) Implements IXmlSerializable.WriteXml
   writer.WriteStartElement("ItemIssue")
   writer.WriteElementString("ModuleId", ModuleId.ToString())
   writer.WriteElementString("ItemId", ItemId.ToString())
   writer.WriteElementString("BugId", BugId.ToString())
   writer.WriteElementString("Created", Created.ToString())
   writer.WriteElementString("CreatedBy", CreatedBy.ToString())
   writer.WriteEndElement()
  End Sub

#End Region

#Region " ToXml Methods "
  Public Function ToXml() As String
   Return ToXml("ItemIssue")
  End Function

  Public Function ToXml(ByVal elementName As String) As String
   Dim xml As New StringBuilder
   xml.Append("<")
   xml.Append(elementName)
   'AddAttribute(xml, "ModuleId", ModuleId.ToString())
   'AddAttribute(xml, "ItemId", ItemId.ToString())
   'AddAttribute(xml, "BugId", BugId.ToString())
   'AddAttribute(xml, "Created", Created.ToString())
   'AddAttribute(xml, "CreatedBy", CreatedBy.ToString())
   xml.Append(" />")
   Return xml.ToString
  End Function
#End Region

 End Class
#End Region

#Region " ItemIssuesController "
 Public Class ItemIssuesController

  Public Shared Function GetItemIssue(ByVal ModuleId As Integer, ByVal ItemId As Integer) As ItemIssueInfo

   Return CType(CBO.FillObject(DataProvider.Instance().GetItemIssue(ModuleId, ItemId), GetType(ItemIssueInfo)), ItemIssueInfo)

  End Function

  Public Shared Sub AddItemIssue(ByVal objItemIssue As ItemIssueInfo)

   DataProvider.Instance().AddItemIssue(objItemIssue.ModuleId, objItemIssue.ItemId, objItemIssue.BugId, objItemIssue.Created, objItemIssue.CreatedBy)

  End Sub

  Public Shared Sub UpdateItemIssue(ByVal objItemIssue As ItemIssueInfo)

   DataProvider.Instance().UpdateItemIssue(objItemIssue.ModuleId, objItemIssue.ItemId, objItemIssue.BugId, objItemIssue.Created, objItemIssue.CreatedBy)

  End Sub

  Public Shared Sub DeleteItemIssue(ByVal ModuleId As Integer, ByVal ItemId As Integer)

   DataProvider.Instance().DeleteItemIssue(ModuleId, ItemId)

  End Sub

  Public Shared Function GetItemIssuesByBugNet_Bug(ByVal BugId As Integer) As ArrayList

   Return DotNetNuke.Common.Utilities.CBO.FillCollection(DataProvider.Instance().GetItemIssuesByBugNet_Bug(BugId), GetType(ItemIssueInfo))

  End Function

  Public Shared Function GetItemIssuesByModule(ByVal ModuleID As Integer) As ArrayList

   Return DotNetNuke.Common.Utilities.CBO.FillCollection(DataProvider.Instance().GetItemIssuesByModule(ModuleID), GetType(ItemIssueInfo))

  End Function

 End Class
#End Region

End Namespace
