Imports System
Imports System.Data
Imports System.Data.SqlClient
Imports Microsoft.ApplicationBlocks.Data

Imports DotNetNuke
Imports DotNetNuke.Common.Utilities
Imports DotNetNuke.Framework.Providers
Imports DotNetNuke.Entities.Users

Namespace Data

 Public Class SqlDataProvider
  Inherits DataProvider

#Region "Private Members"

  Private Const ProviderType As String = "data"

  Private _providerConfiguration As DotNetNuke.Framework.Providers.ProviderConfiguration = DotNetNuke.Framework.Providers.ProviderConfiguration.GetProviderConfiguration(ProviderType)
  Private _connectionString As String
  Private _providerPath As String
  Private _objectQualifier As String
  Private _databaseOwner As String

#End Region

#Region "Constructors"

  Public Sub New()

   ' Read the configuration specific information for this provider
   Dim objProvider As DotNetNuke.Framework.Providers.Provider = CType(_providerConfiguration.Providers(_providerConfiguration.DefaultProvider), DotNetNuke.Framework.Providers.Provider)

   'Get Connection string from web.config
   _connectionString = Config.GetConnectionString()
   If _connectionString = "" Then
    ' Use connection string specified in provider
    _connectionString = objProvider.Attributes("connectionString")
   End If

   _providerPath = objProvider.Attributes("providerPath")

   _objectQualifier = objProvider.Attributes("objectQualifier")
   If _objectQualifier <> "" And _objectQualifier.EndsWith("_") = False Then
    _objectQualifier += "_"
   End If

   _databaseOwner = objProvider.Attributes("databaseOwner")
   If _databaseOwner <> "" And _databaseOwner.EndsWith(".") = False Then
    _databaseOwner += "."
   End If

  End Sub

#End Region

#Region "Properties"

  Public ReadOnly Property ConnectionString() As String
   Get
    Return _connectionString
   End Get
  End Property

  Public ReadOnly Property ProviderPath() As String
   Get
    Return _providerPath
   End Get
  End Property

  Public ReadOnly Property ObjectQualifier() As String
   Get
    Return _objectQualifier
   End Get
  End Property

  Public ReadOnly Property DatabaseOwner() As String
   Get
    Return _databaseOwner
   End Get
  End Property

#End Region

#Region "General Methods"
  Public Overrides Function GetNull(ByVal Field As Object) As Object
   Return DotNetNuke.Common.Utilities.Null.GetNull(Field, DBNull.Value)
  End Function

  Public Function ReplaceParameters(ByVal sql As String) As String
   Return sql.Replace("{databaseOwner}", DatabaseOwner).Replace("{objectQualifier}", ObjectQualifier)
  End Function
#End Region


#Region " BugNet Methods "
  'Public Overrides Function GetProjects() As System.Data.IDataReader
  ' Return CType(SqlHelper.ExecuteReader(ConnectionString, "BugNET_Project_GetAllProjects"), IDataReader)
  'End Function

  'Public Overrides Sub AddUserToRole(ByVal userName As String, ByVal roleId As Integer)
  ' SqlHelper.ExecuteNonQuery(ConnectionString, "BugNet_Role_AddUserToRole", userName, roleId)
  'End Sub

  'Public Overrides Sub RemoveUserFromRole(ByVal userName As String, ByVal roleId As Integer)
  ' SqlHelper.ExecuteNonQuery(ConnectionString, "BugNet_Role_RemoveUserFromRole", userName, roleId)
  'End Sub

  'Public Overrides Sub AddUserToProject(ByVal userName As String, ByVal projectId As Integer)
  ' SqlHelper.ExecuteNonQuery(ConnectionString, "BugNET_Project_AddUserToProject", userName, projectId)
  'End Sub

  'Public Overrides Sub RemoveUserFromProject(ByVal userName As String, ByVal projectId As Integer)
  ' SqlHelper.ExecuteNonQuery(ConnectionString, "BugNET_Project_RemoveUserFromProject", userName, projectId)
  'End Sub

  'Public Overrides Function GetProjectsByUserName(ByVal UserName As String, ByVal activeOnly As Boolean) As System.Data.IDataReader
  ' Return CType(SqlHelper.ExecuteReader(ConnectionString, "BugNET_Project_GetProjectsByUserName", UserName, activeOnly), IDataReader)
  'End Function

  'Public Overrides Function GetComponentsByProjectID(ByVal projectId As Integer) As System.Data.IDataReader
  ' Return CType(SqlHelper.ExecuteReader(ConnectionString, "BugNET_Component_GetComponentsByProjectId", projectId), IDataReader)
  'End Function

  'Public Overrides Function GetAllPriorities() As System.Data.IDataReader
  ' Return CType(SqlHelper.ExecuteReader(ConnectionString, "BugNET_Priority_GetAllPriorities"), IDataReader)
  'End Function

  'Public Overrides Function GetAllResolutions() As System.Data.IDataReader
  ' Return CType(SqlHelper.ExecuteReader(ConnectionString, "BugNET_Resolution_GetAllResolutions"), IDataReader)
  'End Function

  'Public Overrides Function GetAllStatus() As System.Data.IDataReader
  ' Return CType(SqlHelper.ExecuteReader(ConnectionString, "BugNET_Status_GetAllStatus"), IDataReader)
  'End Function
  'Public Overrides Function GetAllTypes() As System.Data.IDataReader
  ' Return CType(SqlHelper.ExecuteReader(ConnectionString, "BugNET_Type_GetAllTypes"), IDataReader)
  'End Function

  'Public Overrides Function GetProjectMembers(ByVal projectId As Integer) As System.Data.IDataReader
  ' Return CType(SqlHelper.ExecuteReader(ConnectionString, "BugNET_Project_GetProjectMembers", projectId), IDataReader)
  'End Function

  'Public Overrides Function GetVersionByProjectId(ByVal projectId As Integer) As System.Data.IDataReader
  ' Return CType(SqlHelper.ExecuteReader(ConnectionString, "BugNET_Version_GetVersionByProjectId", projectId), IDataReader)
  'End Function

  'Public Overloads Overrides Function CreateNewBug(ByVal summary As String, ByVal description As String, ByVal statusID As Integer, ByVal priorityID As Integer, ByVal typeID As Integer, ByVal componentID As Integer, ByVal projectID As Integer, ByVal resolutionID As Integer, ByVal versionID As Integer, ByVal reporterUserId As String, ByVal assignedToUserId As String, ByVal dueDate As Date, ByVal fixedInVersionId As Integer, ByVal visibility As Integer, ByVal estimation As Decimal) As Integer
  ' Return CType(SqlHelper.ExecuteScalar(ConnectionString, DatabaseOwner & "BugNet_Bug_CreateNewBug", summary, description, projectID, componentID, statusID, priorityID, versionID, typeID, resolutionID, assignedToUserId, reporterUserId, GetNull(dueDate), fixedInVersionId, visibility, GetNull(estimation)), Integer)
  'End Function

  'Public Overloads Overrides Sub UpdateBug(ByVal BugId As Integer, ByVal summary As String, ByVal description As String, ByVal statusID As Integer, ByVal priorityID As Integer, ByVal typeID As Integer, ByVal componentID As Integer, ByVal projectID As Integer, ByVal resolutionID As Integer, ByVal versionID As Integer, ByVal assignedToUserId As String, ByVal lastUpdateUserId As String, ByVal dueDate As Date, ByVal fixedInVersionId As Integer, ByVal visibility As Integer, ByVal estimation As Decimal)
  ' SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & "BugNET_Bug_UpdateBug", BugId, summary, description, projectID, componentID, statusID, priorityID, versionID, typeID, resolutionID, assignedToUserId, lastUpdateUserId, dueDate, fixedInVersionId, visibility, estimation)
  'End Sub

  'Public Overrides Sub AddBugNotification(ByVal BugId As Integer, ByVal userName As String)
  ' SqlHelper.ExecuteNonQuery(ConnectionString, "BugNET_BugNotification_CreateNewBugNotification", BugId, userName)
  'End Sub

  'Public Overrides Sub DeleteBugNotification(ByVal BugId As Integer, ByVal userName As String)
  ' SqlHelper.ExecuteNonQuery(ConnectionString, "BugNET_BugNotification_DeleteBugNotification", BugId, userName)
  'End Sub

  'Public Overrides Function GetBugById(ByVal bugId As Integer) As System.Data.IDataReader
  ' Return CType(SqlHelper.ExecuteReader(ConnectionString, "BugNET_Bug_GetBugById", bugId), IDataReader)
  'End Function

  'Public Overrides Function GetBugsByProjectId(ByVal projectId As Integer) As System.Data.IDataReader
  ' Return CType(SqlHelper.ExecuteReader(ConnectionString, "BugNET_Bug_GetBugsByProjectId", projectId), IDataReader)
  'End Function

  'Public Overrides Function GetBugsByProject(ByVal projectId As Integer) As System.Data.IDataReader
  ' Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & "BugNet_GetBugsByProject", projectId), IDataReader)
  'End Function

  'Public Overrides Function GetProject(ByVal projectId As Integer) As System.Data.IDataReader
  ' Return CType(SqlHelper.ExecuteReader(ConnectionString, "BugNET_Project_GetProjectById", projectId), IDataReader)
  'End Function
#End Region

#Region " ItemIssues Methods "

  Public Overrides Function GetItemIssue(ByVal ModuleId As Integer, ByVal ItemId As Integer) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & "BugNet_GetItemIssue", ModuleId, ItemId), IDataReader)
  End Function

  Public Overrides Sub AddItemIssue(ByVal ModuleId As Integer, ByVal ItemId As Integer, ByVal BugId As Integer, ByVal Created As Date, ByVal CreatedBy As Integer)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & "BugNet_AddItemIssue", ModuleId, ItemId, BugId, GetNull(Created), CreatedBy)
  End Sub

  Public Overrides Sub UpdateItemIssue(ByVal ModuleId As Integer, ByVal ItemId As Integer, ByVal BugId As Integer, ByVal Created As Date, ByVal CreatedBy As Integer)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & "BugNet_UpdateItemIssue", ModuleId, ItemId, BugId, GetNull(Created), CreatedBy)
  End Sub

  Public Overrides Sub DeleteItemIssue(ByVal ModuleId As Integer, ByVal ItemId As Integer)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & "BugNet_DeleteItemIssue", ModuleId, ItemId)
  End Sub

  Public Overrides Function GetItemIssuesByBugNet_Bug(ByVal BugId As Integer) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & "BugNet_GetItemIssuesByBugNet_Bug", BugId), IDataReader)
  End Function

  Public Overrides Function GetItemIssuesByModule(ByVal ModuleID As Integer) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & "BugNet_GetItemIssuesByModule", ModuleID), IDataReader)
  End Function

#End Region

#Region " Other Methods "
  Public Overrides Function GetUserRoleMembership(ByVal UserName As String) As System.Data.IDataReader
   Dim Sql As String = "DECLARE @UserId UNIQUEIDENTIFIER" & vbCrLf
   Sql &= "SELECT @UserId = u.UserId FROM aspnet_users u INNER JOIN aspnet_applications a on u.ApplicationId=a.ApplicationId WHERE a.LoweredApplicationName='dotnetnuke' AND u.Username = '" & UserName & "'" & vbCrLf
   'Sql &= "SELECT r.*, (SELECT COUNT(*) FROM BugNet_UserRoles ur WHERE ur.UserId=@UserId AND ur.RoleId=r.RoleId) AS IsMember, p.* FROM BugNet_Roles r INNER JOIN BugNet_Project p ON r.ProjectId=p.ProjectId"
   Sql &= "SELECT r.*, (SELECT COUNT(*) FROM BugNet_UserRoles ur WHERE ur.UserId=@UserId AND ur.RoleId=r.RoleId) AS IsMember FROM BugNet_Roles r"
   Return CType(SqlHelper.ExecuteReader(ConnectionString, CommandType.Text, Sql), IDataReader)
  End Function

  Public Overrides Function GetText(ByVal SQL As String, ByVal ItemId As Integer) As System.Data.IDataReader
   SQL = Replace(SQL, "@ItemId", ItemId.ToString, 1, -1, CompareMethod.Text)
   Return DotNetNuke.Data.DataProvider.Instance.ExecuteSQL(SQL)
  End Function

  Public Overrides Function GetBugNotification(ByVal bugId As Integer, ByVal Username As String) As System.Data.IDataReader
   Dim Sql As String = "DECLARE @UserId UNIQUEIDENTIFIER" & vbCrLf
   Sql &= "SELECT @UserId = u.UserId FROM aspnet_users u INNER JOIN aspnet_applications a on u.ApplicationId=a.ApplicationId WHERE a.LoweredApplicationName='dotnetnuke' AND u.Username = '" & Username & "'" & vbCrLf
   Sql &= "SELECT * FROM BugNet_BugNotification WHERE CreatedUserId=@UserId AND BugId=" & bugId.ToString
   Return CType(SqlHelper.ExecuteReader(ConnectionString, CommandType.Text, Sql), IDataReader)
  End Function
#End Region

 End Class
End Namespace
