﻿Imports System.Web.UI
Imports System.Collections.Generic
Imports System.Reflection

Imports DotNetNuke
Imports DotNetNuke.Services.Exceptions
Imports DotNetNuke.Services.Localization.Localization

Imports Bring2mind.DNN.Modules.BugnetLink.Business
Imports BugNET.DNN.Library

Partial Public Class IssueEdit
 Inherits ModuleBase

#Region " Private Members "
 Private _itemId As Integer = -1
 Private _referrerUrl As String = ""
 Public SelectTabOnload As String = "1"
#End Region

#Region " Event Handlers "
 Private Sub Page_Init(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Init
  If Not Me.IsPostBack Then
   _referrerUrl = Me.Request.UrlReferrer.OriginalString
  End If
 End Sub

 Private Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load

  _itemId = CInt(Me.Request.Params("ItemID"))
  If Not Me.IsPostBack Then
   ddProject.DataSource = ProjectsController.GetProjects
   ddProject.DataBind()
   Dim ii As ItemIssueInfo = ItemIssuesController.GetItemIssue(ModuleId, _itemId)
   If ii Is Nothing Then ' New connection
    ddProject.Items.Insert(0, New ListItem(GetString("Select", Me.LocalResourceFile), "-1"))
    lstIssue.Enabled = False
    tblNewBug.Visible = False
    ctlBugDetails.Visible = False
   Else ' Existing connection
    Dim thisBug As BugInfo = BugsController.GetBug(ii.BugId)
    If thisBug IsNot Nothing Then
     ddProject.ClearSelection()
     Try
      ddProject.Items.FindByValue(thisBug.ProjectId.ToString).Selected = True
     Catch ex As Exception
     End Try
     lstIssue.DataSource = BugsController.GetBugsByProject(thisBug.ProjectID).Values
     lstIssue.DataBind()
     lstIssue.Items.Insert(0, New ListItem(GetString("NewBug", Me.LocalResourceFile), "-1"))
     Try
      lstIssue.Items.FindByValue(thisBug.BugID.ToString).Selected = True
     Catch ex As Exception
     End Try
    End If
    tblNewBug.Visible = False
    ctlBugDetails.CurrentBug = thisBug
    ctlBugDetails.Visible = True
   End If
  End If

 End Sub

 Private Sub wzdLink_CancelButtonClick(ByVal sender As Object, ByVal e As System.EventArgs) Handles wzdLink.CancelButtonClick

  Me.Response.Redirect(_referrerUrl, False)

 End Sub

 Private Sub wzdLink_FinishButtonClick(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.WizardNavigationEventArgs) Handles wzdLink.FinishButtonClick

  Dim ii As ItemIssueInfo = ItemIssuesController.GetItemIssue(ModuleId, _itemId)
  Dim BugId As Integer = CInt(lstIssue.SelectedValue)
  If BugId = -1 Then
   Dim body As String = BugNetController.GetText(Me.Settings.DescriptionSQL, _itemId)
   body &= "<p><a href=""" & _referrerUrl & """ target=""_blank"">" & _referrerUrl & "</a></p>"
   Dim title As String = BugNetController.GetText(Me.Settings.SummarySQL, _itemId)
   If title = "" Then
    title = "New bug imported from " & Me.ModuleConfiguration.ModuleTitle
   End If
   Dim bugToCreate As New BugInfo
   With bugToCreate
    .AssignedToUserName = ddAssignedTo.SelectedValue
    .ComponentID = CInt(ddCategory.SelectedValue)
    .Description = body
    .PriorityID = CInt(ddPriority.SelectedValue)
    .ProjectID = CInt(ddProject.SelectedValue)
    .ResolutionID = CInt(ddResolution.SelectedValue)
    .StatusID = CInt(ddStatus.SelectedValue)
    .Summary = title
    .TypeID = CInt(ddType.SelectedValue)
    .VersionID = CInt(ddVersion.SelectedValue)
   End With
   BugId = BugsController.AddBug(bugToCreate)
  End If

  If BugId > -1 Then
   If ii Is Nothing Then ' New connection
    ii = New ItemIssueInfo
    With ii
     .BugId = BugId
     .Created = Now
     .CreatedBy = UserInfo.UserID
     .ItemId = _itemId
     .ModuleId = ModuleId
    End With
    ItemIssuesController.AddItemIssue(ii)
   Else ' Existing connection
    ii.BugId = BugId
    ItemIssuesController.UpdateItemIssue(ii)
   End If
  End If
  ctlBugDetails.Visible = False
  Me.Response.Redirect(_referrerUrl, False)

 End Sub

 Private Sub wzdLink_NextButtonClick(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.WizardNavigationEventArgs) Handles wzdLink.NextButtonClick

  If e.CurrentStepIndex = 0 Then
   Dim ProjectId As Integer = -1
   Dim BugId As Integer = -1
   If txtIssueId.Text.Trim <> "" Then
    Dim issueId As String = txtIssueId.Text.Trim
    If Not IsNumeric(issueId) Then
     issueId = Mid(issueId, issueId.IndexOf("-") + 2)
    End If
    If IsNumeric(issueId) Then
     Dim selectedBug As BugInfo = BugsController.GetBug(CInt(issueId))
     If selectedBug IsNot Nothing Then
      ProjectId = selectedBug.ProjectId
      BugId = selectedBug.BugID
     End If
     tblNewBug.Visible = False
     ctlBugDetails.CurrentBug = selectedBug
     ctlBugDetails.Visible = True
     wzdLink.ActiveStepIndex = 2
    End If
   Else
   End If
   If ProjectId < 0 Then
    ProjectId = CInt(ddProject.SelectedValue)
   End If
   If ProjectId > -1 Then
    BindData(ProjectId)
    lstIssue.Items.Clear()
    lstIssue.DataSource = BugsController.GetBugsByProject(ProjectId).Values
    lstIssue.DataBind()
    lstIssue.Items.Insert(0, New ListItem(GetString("NewBug", Me.LocalResourceFile), "-1"))
    lstIssue.Enabled = True
    Try
     lstIssue.Items.FindByValue(BugId.ToString).Selected = True
     If BugId > -1 Then
      tblNewBug.Visible = False
      ctlBugDetails.CurrentBugId = BugId
      ctlBugDetails.Visible = True
     Else
      tblNewBug.Visible = True
      ctlBugDetails.Visible = False
     End If
    Catch
    End Try
    'tblNewBug.Visible = True
    'ctlBugDetails.Visible = False
   End If
  End If

  If e.CurrentStepIndex = 1 Then
   Dim BugId As Integer = CInt(lstIssue.SelectedValue)
   If BugId > -1 Then
    tblNewBug.Visible = False
    ctlBugDetails.CurrentBugId = BugId
    ctlBugDetails.Visible = True
   Else
    tblNewBug.Visible = True
    ctlBugDetails.Visible = False
   End If
  End If

 End Sub
#End Region

#Region " Private Methods "
 Private Sub BindData(ByVal ProjectId As Integer)

  'Get Reporters
  ddReporter.Items.Clear()
  ddReporter.DataSource = Data.DataProvider.Instance.GetText(Me.Settings.ReporterSQL, _itemId)
  ddReporter.DataBind()

  'Get AssignedTo
  ddAssignedTo.Items.Clear()
  ddAssignedTo.DataSource = UsersController.GetProjectMembers(ProjectId)
  ddAssignedTo.DataBind()

  'Get Status
  ddStatus.Items.Clear()
  ddStatus.DataSource = StatusesController.GetStatuses.Values
  ddStatus.DataBind()

  'Get Priority
  ddPriority.Items.Clear()
  ddPriority.DataSource = PrioritiesController.GetPriorities.Values
  ddPriority.DataBind()

  'Get Type
  ddType.Items.Clear()
  ddType.DataSource = TypesController.GetBugTypes.Values
  ddType.DataBind()

  'Get Components			
  ddCategory.Items.Clear()
  ddCategory.DataSource = ComponentsController.GetComponentsByProject(ProjectId).Values
  ddCategory.DataBind()

  'Get Resolution
  ddResolution.Items.Clear()
  ddResolution.DataSource = ResolutionsController.GetResolutions.Values
  ddResolution.DataBind()

  'Get Version
  ddVersion.Items.Clear()
  ddVersion.DataSource = VersionsController.GetVersionsByProject(ProjectId).Values
  ddVersion.DataBind()

 End Sub
#End Region

#Region " ViewState Handling "
 Protected Overrides Sub LoadViewState(ByVal savedState As Object)

  If Not (savedState Is Nothing) Then
   Dim myState As Object() = CType(savedState, Object())
   If Not (myState(0) Is Nothing) Then
    MyBase.LoadViewState(myState(0))
   End If
   If Not (myState(1) Is Nothing) Then
    _referrerUrl = CType(myState(1), String)
   End If
  End If

  Me.EnsureChildControls()

 End Sub

 Protected Overrides Function SaveViewState() As Object

  Dim allStates(2) As Object
  allStates(0) = MyBase.SaveViewState()
  allStates(1) = _referrerUrl
  Return allStates

 End Function
#End Region

End Class