<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:date="http://www.ora.com/XSLTCookbook/namespaces/date" extension-element-prefixes="date" id="date:date-time">
 <xsl:output method="html" cdata-section-elements="qnames"/>
 <xsl:include href="date.xslt"/>
 <xsl:template match="Report">
  <div class="SR_Title">
   <xsl:value-of select="@Title"/>
  </div>
  <p><xsl:value-of select="Summary" disable-output-escaping="yes"/></p>
  <div class="SR_Subtitle">
   Period: From 
   <xsl:call-template name="date:format-universal-date">
    <xsl:with-param name="universal-date" select="@StartDate"/>
    <xsl:with-param name="format" select="'%A %d %B %H:%M'"/>
   </xsl:call-template>
   to
   <xsl:call-template name="date:format-universal-date">
    <xsl:with-param name="universal-date" select="@EndDate"/>
    <xsl:with-param name="format" select="'%A %d %B %H:%M'"/>
   </xsl:call-template>
   <br/>
   Portal: <xsl:value-of select="@PortalName"/>
  </div>
  <table class="SR_MainTable">
   <xsl:for-each select="Measure">
    <xsl:choose>
     <xsl:when test="@Type='Single'">
      <tr>
       <td class="SR_Single">
        <div class="SR_SingleTitle">
         <xsl:value-of select="@Name"/>
        </div>
        <div class="SR_SingleDescription">
         <xsl:value-of select="Description" disable-output-escaping="yes"/>
        </div>
       </td>
       <xsl:element name="td">
        <xsl:attribute name="class">SR_Single</xsl:attribute>
        <xsl:attribute name="style"><xsl:value-of select="Value/@Style"/></xsl:attribute>
        <xsl:choose>
         <xsl:when test="substring(Value/@Format,1,7)='number:'">
          <div class="SR_SingleValue">
           <xsl:value-of select="format-number(Value, substring-after(Value/@Format,':'))"/>
          </div>
         </xsl:when>
         <xsl:when test="substring(Value/@Format,1,5)='date:'">
          <div class="SR_SingleValue">
           <xsl:call-template name="date:format-universal-date">
            <xsl:with-param name="universal-date" select="."/>
            <xsl:with-param name="format" select="substring-after(Value/@Format,':')"/>
           </xsl:call-template>
          </div>
         </xsl:when>
         <xsl:otherwise>
          <div class="SR_SingleValue">
           <xsl:value-of select="Value"/>
          </div>
         </xsl:otherwise>
        </xsl:choose>
       </xsl:element>
      </tr>
     </xsl:when>
     <xsl:otherwise>
      <tr>
       <td colspan="2" class="SR_RowsetTitle">
        <div class="SR_RowsetTitle">
         <xsl:value-of select="@Name"/>
        </div>
        <div class="SR_RowsetDescription">
         <xsl:value-of select="Description" disable-output-escaping="yes"/>
        </div>
       </td>
      </tr>
      <tr>
       <td colspan="2" class="SR_RowsetValue">
        <table class="SR_RowsetTable">
         <tr>
          <xsl:for-each select="Value/Table/Row[position()=1]/Column">
           <th>
            <xsl:value-of select="@Name"/>
           </th>
          </xsl:for-each>
         </tr>
         <xsl:for-each select="Value/Table/Row">
          <tr>
           <xsl:for-each select="Column">
            <xsl:element name="td">
             <xsl:attribute name="style"><xsl:value-of select="@Style"/></xsl:attribute>
             <xsl:choose>
              <xsl:when test="substring(@Format,1,7)='number:'">
               <xsl:value-of select="format-number(., substring-after(@Format,':'))"/>
              </xsl:when>
              <xsl:when test="substring(@Format,1,5)='date:'">
               <xsl:call-template name="date:format-universal-date">
                <xsl:with-param name="universal-date" select="."/>
                <xsl:with-param name="format" select="substring-after(@Format,':')"/>
               </xsl:call-template>
              </xsl:when>
              <xsl:otherwise>
               <xsl:value-of select="."/>
              </xsl:otherwise>
             </xsl:choose>
            </xsl:element>
           </xsl:for-each>
          </tr>
         </xsl:for-each>
        </table>
       </td>
      </tr>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:for-each>
  </table>
  <xsl:if test="count(Error)&gt;0">
   <h1>Errors</h1>
   <table class="SR_ErrorTable">
    <tr>
     <th>Key</th>
     <th>Name</th>
     <th>Code</th>
     <th>Message</th>
    </tr>
    <xsl:for-each select="Error">
     <tr>
      <td>
       <xsl:value-of select="@Key"/>
      </td>
      <td>
       <xsl:value-of select="@Name"/>
      </td>
      <td>
       <xsl:value-of select="Code"/>
      </td>
      <td>
       <xsl:value-of select="Message"/>
      </td>
     </tr>
    </xsl:for-each>
   </table>
  </xsl:if>
 </xsl:template>
</xsl:stylesheet>
