Imports System
Imports DotNetNuke

Namespace Data

 Public MustInherit Class DataProvider

#Region " Shared/Static Methods "

  ' singleton reference to the instantiated object 
  Private Shared objProvider As DataProvider = Nothing

  ' constructor
  Shared Sub New()
   CreateProvider()
  End Sub

  ' dynamically create provider
  Private Shared Sub CreateProvider()
   objProvider = CType(Framework.Reflection.CreateObject("data", "Bring2mind.DNN.Modules.SiteReport.Data", ""), DataProvider)
  End Sub

  ' return the provider
  Public Shared Shadows Function Instance() As DataProvider
   Return objProvider
  End Function

#End Region

#Region " General Methods "
  Public MustOverride Function GetNull(ByVal Field As Object) As Object
#End Region

#Region " Measures Methods "

  Public MustOverride Function GetMeasure(ByVal MeasureID As Integer) As IDataReader

  Public MustOverride Function AddMeasure(ByVal Code As String, ByVal ColumnFormatting As String, ByVal Description As String, ByVal ExtraColumns As String, ByVal Key As String, ByVal Name As String, ByVal Order As Integer, ByVal ReportId As Integer, ByVal RowFilter As String, ByVal SortExpression As String, ByVal Type As Integer) As Integer

  Public MustOverride Sub UpdateMeasure(ByVal MeasureID As Integer, ByVal Code As String, ByVal ColumnFormatting As String, ByVal Description As String, ByVal ExtraColumns As String, ByVal Key As String, ByVal Name As String, ByVal Order As Integer, ByVal ReportId As Integer, ByVal RowFilter As String, ByVal SortExpression As String, ByVal Type As Integer)

  Public MustOverride Sub DeleteMeasure(ByVal MeasureID As Integer)

  Public MustOverride Function GetMeasuresByReport(ByVal ReportId As Integer) As IDataReader

#End Region

#Region " Report Methods "

  Public MustOverride Function GetReport(ByVal ReportId As Integer, ByVal ModuleId As Integer) As IDataReader

  Public MustOverride Function AddReport(ByVal LastModified As Date, ByVal LastModifiedBy As Integer, ByVal ModuleId As Integer, ByVal Summary As String, ByVal Title As String) As Integer

  Public MustOverride Sub UpdateReport(ByVal ReportId As Integer, ByVal LastModified As Date, ByVal LastModifiedBy As Integer, ByVal ModuleId As Integer, ByVal Summary As String, ByVal Title As String)

  Public MustOverride Sub DeleteReport(ByVal ReportId As Integer)

  Public MustOverride Function GetReportsByModule(ByVal ModuleID As Integer) As IDataReader

#End Region

#Region " Generic Methods "
  Public MustOverride Function GetRowSet(ByVal CommandText As String) As IDataReader
  Public MustOverride Function GetScalar(ByVal CommandText As String) As Object
#End Region

#Region " Other Methods "

  Public MustOverride Function GetUsersByModulePermission(ByVal ModuleId As Integer, ByVal PermissionKey As String) As IDataReader

#End Region

 End Class

End Namespace

