Imports system.io

Public Class TextLogger

 Dim LogStream As IO.StreamWriter

 Public Sub New(ByVal Directory As String, Optional ByVal File As String = "Log.txt")
  If Right(Directory, 1) <> "\" Then Directory &= "\"
  LogStream = New IO.StreamWriter(Directory & File, True)
  'LogStream.WriteLine("Log Starting " & Now.ToLongDateString & " " & Now.ToLongTimeString)
 End Sub

 Public Sub Log(ByVal Text As String)
  LogStream.WriteLine(Now.ToUniversalTime.ToString("u") & ": " & Text)
 End Sub

 Public Sub Close()
  LogStream.Close()
 End Sub

 Protected Overrides Sub Finalize()
  LogStream.Close()
  MyBase.Finalize()
 End Sub
End Class
