Imports Bring2mind.DNN.Modules.SiteReport.Business
Imports Microsoft.ApplicationBlocks.Data
Imports System.Text.RegularExpressions
Imports DotNetNuke

Public Class Report

#Region " Private Members "
 Private _moduleId As Integer
 Private _portalId As Integer
 Private _report As ReportInfo
 Private _startDate As Date
 Private _endDate As Date
 Private _additionalParameters As Hashtable
 Private _xmlReport As XmlReport
#End Region

#Region " Event Handlers "
 Public Sub New(ByRef ModInfo As Entities.Modules.ModuleInfo, ByVal Report As ReportInfo, ByVal StartDate As Date, ByVal EndDate As Date, ByVal ParamArray AdditionalParameters() As String)
  _moduleId = ModInfo.ModuleID
  _portalId = ModInfo.PortalID
  _report = Report
  _startDate = StartDate
  _endDate = EndDate
  _additionalParameters = New Hashtable

  Dim _p As String, _n As String, _v As String
  For Each _p In AdditionalParameters
   Try
    _n = Left(_p, InStr(_p, "=") - 1)
    _v = Mid(_p, InStr(_p, "=") + 1)
    _additionalParameters.Add(_n, _v)
   Catch ex As Exception
   End Try
  Next

  Dim Settings As New ModuleSettings(_moduleId)
  _xmlReport = New XmlReport(_portalId, _moduleId, _report, Settings, _startDate, _endDate)

  ' Get the data from the database
  Dim objMeasure As MeasureInfo = Nothing
  Dim objGeneric As New GenericController
  Dim RowSets As New Hashtable, Scalars As New Hashtable
  For Each objMeasure In MeasuresController.GetMeasuresByReport(_report.ReportId)
   Try
    Select Case objMeasure.Type
     Case MeasureType.SqlRowset
      Dim dt As DataTable = objGeneric.GetRowSet(ParametrizeCode(objMeasure.Code))
      Dim ecs() As String = objMeasure.ExtraColumns.Split(New Char() {"|"c})
      Dim ec As String
      For Each ec In ecs
       If ec.IndexOf(";") > -1 Then
        Dim cName As String = Left(ec, InStr(ec, ";") - 1)
        Dim cDef As String = Mid(ec, InStr(ec, ";") + 1)
        Dim cColType As String = Left(cDef, InStr(cDef, ";") - 1)
        cDef = Mid(cDef, InStr(cDef, ";") + 1)
        dt.Columns.Add(cName, Type.GetType(cColType), cDef)
       End If
      Next
      RowSets.Add(objMeasure.Key, dt)
     Case MeasureType.SqlScalar
      Dim x As Object = objGeneric.GetScalar(ParametrizeCode(objMeasure.Code))
      Scalars.Add(objMeasure.Key, x)
      _additionalParameters.Add(objMeasure.Key, x)
     Case MeasureType.MathExpression
    End Select
   Catch ex As Exception
    _xmlReport.AddError(objMeasure, ParametrizeCode(objMeasure.Code), ex.Message & vbCrLf & ex.StackTrace)
   End Try
  Next


  For Each objMeasure In MeasuresController.GetMeasuresByReport(_report.ReportId)
   Try
    Select Case objMeasure.Type
     Case MeasureType.SqlRowset
      Dim dv As New DataView(CType(RowSets(objMeasure.Key), DataTable))
      With dv
       .RowFilter = objMeasure.RowFilter
       .Sort = objMeasure.SortExpression
      End With
      _xmlReport.AddRowSet(objMeasure, dv)
     Case MeasureType.SqlScalar
      _xmlReport.AddValue(objMeasure, CType(Scalars(objMeasure.Key), String))
     Case MeasureType.MathExpression
      Dim m As New Maths
      _xmlReport.AddValue(objMeasure, CType(m.EvaluateExpression(ParametrizeCode(objMeasure.Code)), String))
    End Select
   Catch ex As Exception
    _xmlReport.AddError(objMeasure, ParametrizeCode(objMeasure.Code), ex.Message & vbCrLf & ex.StackTrace)
   End Try
  Next

 End Sub
#End Region

#Region " Private Methods "
 Private Function ParametrizeCode(ByVal CodeString As String) As String
  CodeString = Regex.Replace(CodeString, "@[\w]+\b", AddressOf ReplaceParameter)
  Return CodeString
 End Function

 Private Function ReplaceParameter(ByVal m As Match) As String
  Dim Lookup As String = Mid(m.ToString, 2)
  Select Case Lookup.ToLower
   Case "portalid"
    Return _portalId.ToString
   Case "moduleid"
    Return _moduleId.ToString
   Case "startdate"
    Return "'" & _startDate.ToString("s") & "'"
   Case "enddate"
    Return "'" & _endDate.ToString("s") & "'"
   Case Else
    Try
     Return Globals.GetStringValue(_additionalParameters(Lookup))
    Catch ex As Exception
     Return Lookup ' This should not happen
    End Try
  End Select
 End Function
#End Region

#Region " Properties "
 Public ReadOnly Property Report() As System.Xml.XmlDocument
  Get

   Return _xmlReport

  End Get
 End Property

 Public ReadOnly Property ToXml() As String
  Get

   Return _xmlReport.InnerXml

  End Get
 End Property
#End Region

End Class
