Imports System
Imports System.Data
Imports Bring2mind.DNN.Modules.SiteReport.Data
Imports System.Xml
Imports System.Xml.Xsl
Imports DotNetNuke
Imports DotNetNuke.Common.Utilities
Imports DotNetNuke.Entities.Modules
Imports DotNetNuke.Entities.Modules.Definitions

Namespace Business

 Public Class SiteReportController
  Implements Entities.Modules.IPortable
  Implements DotNetNuke.Entities.Modules.IUpgradeable

#Region " IUpgradeable Implementation "
  Public Function UpgradeModule(ByVal Version As String) As String Implements DotNetNuke.Entities.Modules.IUpgradeable.UpgradeModule
   Dim strResults As String = ""
   Try
    Select Case Version
     Case "03.00.00"
      Dim dm As DesktopModuleInfo = (New DesktopModuleController).GetDesktopModuleByModuleName("Bring2mind\SiteReport")
      Dim md As ModuleDefinitionInfo = CType((New ModuleDefinitionController).GetModuleDefinitions(dm.DesktopModuleID)(0), ModuleDefinitionInfo)
      Dim objPermissionController As New DotNetNuke.Security.Permissions.PermissionController
      Dim objPermission As New DotNetNuke.Security.Permissions.PermissionInfo
      objPermission.PermissionCode = "MODULE_SITEREPORT"
      objPermission.PermissionKey = EmailPermissionKey
      objPermission.PermissionName = "Send Email"
      objPermission.ModuleDefID = md.ModuleDefID
      Dim res As Integer = objPermissionController.AddPermission(objPermission)
    End Select
   Catch ex As Exception
    strResults += "Error: " & ex.Message & vbCrLf
    Try
     DotNetNuke.Services.Exceptions.LogException(ex)
    Catch
     ' ignore
    End Try
   End Try
   Return strResults
  End Function
#End Region

#Region " Optional Interfaces: Import / Export "
  Public Function ExportModule(ByVal ModuleID As Integer) As String Implements Entities.Modules.IPortable.ExportModule

   Dim strXml As String = "<SiteReport>"

   Dim Settings As New ModuleSettings(ModuleID)
   strXml += "<Modulesettings>"
   strXml += "<Interval>" + CType(Settings.Interval, Integer).ToString + "</Interval>"
   strXml += "<Processing>" + DotNetNuke.Common.Utilities.XmlUtils.XMLEncode(Settings.Processing) + "</Processing>"
   strXml += "</Modulesettings>"

   strXml += "<Reports>"
   For Each r As ReportInfo In ReportsController.GetReportsByModule(ModuleID)
    strXml += "<Report>"
    strXml += "<Title>"
    strXml += XmlUtils.XMLEncode(r.Title)
    strXml += "</Title>"
    strXml += "<Summary>"
    strXml += XmlUtils.XMLEncode(r.Summary)
    strXml += "</Summary>"
    strXml += "<Measures>"
    For Each m As MeasureInfo In MeasuresController.GetMeasuresByReport(r.ReportId)
     strXml += "<Measure>"
     strXml += "<Code>" + DotNetNuke.Common.Utilities.XmlUtils.XMLEncode(m.Code) + "</Code>"
     strXml += "<ColumnFormatting>" + DotNetNuke.Common.Utilities.XmlUtils.XMLEncode(m.ColumnFormatting) + "</ColumnFormatting>"
     strXml += "<Description>" + DotNetNuke.Common.Utilities.XmlUtils.XMLEncode(m.Description) + "</Description>"
     strXml += "<ExtraColumns>" + DotNetNuke.Common.Utilities.XmlUtils.XMLEncode(m.ExtraColumns) + "</ExtraColumns>"
     strXml += "<Key>" + m.Key + "</Key>"
     strXml += "<RowFilter>" + DotNetNuke.Common.Utilities.XmlUtils.XMLEncode(m.RowFilter) + "</RowFilter>"
     strXml += "<SortExpression>" + DotNetNuke.Common.Utilities.XmlUtils.XMLEncode(m.SortExpression) + "</SortExpression>"
     strXml += "<Name>" + m.Name + "</Name>"
     strXml += "<Order>" + m.Order.ToString + "</Order>"
     strXml += "<Type>" + m.Type.ToString + "</Type>"
     strXml += "</Measure>"
    Next
    strXml += "</Measures>"
    strXml += "</Report>"
   Next
   strXml += "</Reports>"

   strXml += "</SiteReport>"
   Return strXml

  End Function

  Public Sub ImportModule(ByVal ModuleID As Integer, ByVal Content As String, ByVal Version As String, ByVal UserId As Integer) Implements Entities.Modules.IPortable.ImportModule

   Dim xmlSettings As XmlNode = DotNetNuke.Common.GetContent(Content, "SiteReport")
   Dim Settings As New ModuleSettings(ModuleID)
   With Settings
    .Interval = CType(xmlSettings.SelectSingleNode("Modulesettings/Interval").InnerText, Interval)
    .Processing = xmlSettings.SelectSingleNode("Modulesettings/Processing").InnerText
    .NextSend = Now
    .SaveSettings(ModuleID)
   End With

   Dim m As MeasureInfo

   ' Clear out current content
   For Each r As ReportInfo In ReportsController.GetReportsByModule(ModuleID)
    ReportsController.DeleteReport(r.ReportId)
   Next

   ' Add new content
   'xmlSettings = GetContent(Content, "SiteReport/Measures")
   For Each xmlR As XmlNode In xmlSettings.SelectNodes("Reports/Report")
    Dim r As New ReportInfo
    With r
     .ModuleId = ModuleID
     .Summary = xmlR.SelectSingleNode("Summary").InnerText
     .Title = xmlR.SelectSingleNode("Title").InnerText
     .LastModifiedBy = 0
     .LastModified = Now
    End With
    Dim reportId As Integer = ReportsController.AddReport(r)
    Dim xmlM As XmlNode
    For Each xmlM In xmlR.SelectNodes("Measures/Measure")
     m = New MeasureInfo
     With m
      .Code = xmlM.SelectSingleNode("Code").InnerText
      .ColumnFormatting = xmlM.SelectSingleNode("ColumnFormatting").InnerText
      .Description = xmlM.SelectSingleNode("Description").InnerText
      .ExtraColumns = xmlM.SelectSingleNode("ExtraColumns").InnerText
      .Key = xmlM.SelectSingleNode("Key").InnerText
      .ReportId = reportId
      .Name = xmlM.SelectSingleNode("Name").InnerText
      .Order = Integer.Parse(xmlM.SelectSingleNode("Order").InnerText)
      .RowFilter = xmlM.SelectSingleNode("RowFilter").InnerText
      .SortExpression = xmlM.SelectSingleNode("SortExpression").InnerText
      .Type = Integer.Parse(xmlM.SelectSingleNode("Type").InnerText)
     End With
     MeasuresController.AddMeasure(m)
    Next
   Next

  End Sub
#End Region

 End Class

End Namespace
