Imports System.Xml
Imports Bring2mind.DNN.Modules.SiteReport.Business

Public Class XmlReport
 Inherits XmlDocument

#Region " Private Members "
 Private _root As XmlNode
 Private _specialFormats As String
#End Region

#Region " Event Handlers: Creating the document "
 Public Sub New(ByVal PortalId As Integer, ByVal ModuleId As Integer, ByVal Report As ReportInfo, ByRef Settings As ModuleSettings, ByVal StartDate As Date, ByVal EndDate As Date)
  Dim xA As XmlAttribute

  Try
   Me.LoadXml("<?xml version=""1.0"" encoding=""utf-8"" ?>" & Settings.Processing & "<Report></Report>")
  Catch ex As Exception
   Me.LoadXml("<?xml version=""1.0"" encoding=""utf-8"" ?><Report></Report>")
  End Try
  _root = Me.DocumentElement
  xA = Me.CreateAttribute("StartDate")
  xA.InnerText = StartDate.ToUniversalTime.ToString("u")
  _root.Attributes.Append(xA)
  xA = Me.CreateAttribute("EndDate")
  xA.InnerText = EndDate.ToUniversalTime.ToString("u")
  _root.Attributes.Append(xA)
  xA = Me.CreateAttribute("ModuleId")
  xA.InnerText = ModuleId.ToString
  _root.Attributes.Append(xA)
  xA = Me.CreateAttribute("ReportId")
  xA.InnerText = Report.ReportId.ToString
  _root.Attributes.Append(xA)
  xA = Me.CreateAttribute("Title")
  xA.InnerText = Report.Title
  _root.Attributes.Append(xA)

  Dim pc As New DotNetNuke.Entities.Portals.PortalController
  Dim pi As DotNetNuke.Entities.Portals.PortalInfo = pc.GetPortal(PortalId)
  xA = Me.CreateAttribute("PortalId")
  xA.InnerText = PortalId.ToString
  _root.Attributes.Append(xA)
  xA = Me.CreateAttribute("PortalName")
  xA.InnerText = pi.PortalName
  _root.Attributes.Append(xA)

  Dim xE As XmlElement = Me.CreateElement("Summary")
  'xE.InnerText = DotNetNuke.Common.Utilities.XmlUtils.XMLEncode(Report.Summary)
  xE.InnerText = Report.Summary
  _root.AppendChild(xE)

  '_specialFormats = ";" & DotNetNuke.Services.Localization.Localization.GetString("SpecialFormats", Globals.SharedResourceFile) & ";"
  Dim HostSettings As New CustomSettings(DotNetNuke.Common.ApplicationMapPath & "\DesktopModules\Bring2mind\SiteReport\Host.Config", "SiteReportHostSettings")
  If HostSettings.Item("SpecialFormats") Is Nothing Then
   HostSettings.Item("SpecialFormats") = "date;number;"
   HostSettings.Save()
  ElseIf HostSettings.Item("SpecialFormats") = "" Then
   HostSettings.Item("SpecialFormats") = "date;number;"
   HostSettings.Save()
  End If
  _specialFormats = HostSettings.Item("SpecialFormats")

 End Sub
#End Region

#Region " Public Methods: Adding content "
 Public Sub AddValue(ByVal Measure As Business.MeasureInfo, ByVal Value As String)
  Dim xE As XmlElement = Me.CreateElement("Measure")
  Dim xA As XmlAttribute

  xA = Me.CreateAttribute("Type")
  xA.InnerText = "Single"
  xE.Attributes.Append(xA)
  xA = Me.CreateAttribute("Order")
  xA.InnerText = Measure.Order.ToString
  xE.Attributes.Append(xA)
  xA = Me.CreateAttribute("Key")
  xA.InnerText = Measure.Key
  xE.Attributes.Append(xA)
  xA = Me.CreateAttribute("Name")
  xA.InnerText = Measure.Name
  xE.Attributes.Append(xA)

  Dim xD As XmlElement = Me.CreateElement("Description")
  xD.InnerXml = DotNetNuke.Common.Utilities.XmlUtils.XMLEncode(Measure.Description)
  xE.AppendChild(xD)

  Dim xV As XmlElement = Me.CreateElement("Value")
  AddFormatting(xV, Measure.ColumnFormatting)
  xV.InnerText = Value
  xE.AppendChild(xV)

  Me.DocumentElement.AppendChild(xE)
 End Sub

 Public Sub AddRowSet(ByVal Measure As Business.MeasureInfo, ByRef dv As DataView)
  Dim xE As XmlElement = Me.CreateElement("Measure")
  Dim xA As XmlAttribute

  xA = Me.CreateAttribute("Type")
  xA.InnerText = "Rowset"
  xE.Attributes.Append(xA)
  xA = Me.CreateAttribute("Order")
  xA.InnerText = Measure.Order.ToString
  xE.Attributes.Append(xA)
  xA = Me.CreateAttribute("Key")
  xA.InnerText = Measure.Key
  xE.Attributes.Append(xA)
  xA = Me.CreateAttribute("Name")
  xA.InnerText = Measure.Name
  xE.Attributes.Append(xA)

  Dim xD As XmlElement = Me.CreateElement("Description")
  xD.InnerXml = DotNetNuke.Common.Utilities.XmlUtils.XMLEncode(Measure.Description)
  xE.AppendChild(xD)

  Dim xV As XmlElement = Me.CreateElement("Value")
  Dim xT As XmlElement = Me.CreateElement("Table")

  Dim dc As DataColumn, cols(dv.Table.Columns.Count - 1) As String, i As Integer
  i = 0
  For Each dc In dv.Table.Columns
   cols(i) = dc.ColumnName
   i += 1
  Next
  Dim colFormats() As String = Nothing
  If Globals.GetStringValue(Measure.ColumnFormatting) <> "" Then
   colFormats = Measure.ColumnFormatting.Split(New Char() {"|"c})
  End If

  Dim drv As DataRowView, col As String
  For Each drv In dv
   Dim xR As XmlElement = Me.CreateElement("Row")
   i = 0
   For Each col In cols
    Dim xC As XmlElement = Me.CreateElement("Column")
    xA = Me.CreateAttribute("Name")
    xA.InnerText = col
    xC.Attributes.Append(xA)
    If Not colFormats Is Nothing AndAlso colFormats.Length > i Then
     Try
      AddFormatting(xC, colFormats(i))
     Catch ex As Exception
      AddFormatting(xC, "")
     End Try
    Else
     AddFormatting(xC, "")
    End If
    xC.Attributes.Append(xA)
    xC.InnerText = Globals.GetStringValue(drv.Item(col))
    xR.AppendChild(xC)
    i += 1
   Next
   xT.AppendChild(xR)
  Next

  xV.AppendChild(xT)
  xE.AppendChild(xV)

  Me.DocumentElement.AppendChild(xE)
 End Sub

 Public Sub AddError(ByVal Measure As Business.MeasureInfo, ByVal TranslatedCode As String, ByVal ErrorMessage As String)
  Dim xE As XmlElement = Me.CreateElement("Error")
  Dim xA As XmlAttribute

  xA = Me.CreateAttribute("Key")
  xA.InnerText = Measure.Key
  xE.Attributes.Append(xA)
  xA = Me.CreateAttribute("Name")
  xA.InnerText = Measure.Name
  xE.Attributes.Append(xA)
  Dim xC As XmlElement = Me.CreateElement("Code")
  xC.InnerXml = DotNetNuke.Common.Utilities.XmlUtils.XMLEncode(TranslatedCode)
  xE.AppendChild(xC)
  Dim xV As XmlElement = Me.CreateElement("Message")
  xV.InnerXml = DotNetNuke.Common.Utilities.XmlUtils.XMLEncode(ErrorMessage.Replace(vbCrLf, "<br/>"))
  xE.AppendChild(xV)

  Me.DocumentElement.AppendChild(xE)
 End Sub
#End Region

#Region " Private Methods "
 Private Sub AddFormatting(ByRef xNode As XmlElement, ByVal FormatString As String)
  Dim xStyle As String = ""
  Dim xFormat As String = ""
  Dim format As String, xA As XmlAttribute
  If FormatString.Trim <> "" Then
   Dim formats() As String = FormatString.Trim(New Char() {";"c}).Split(New Char() {";"c})
   For Each format In formats
    Try
     If _specialFormats.IndexOf(Left(format, format.IndexOf(":")) & ";") > -1 Then
      xFormat = format
     Else
      xStyle &= format & ";"
     End If
    Catch ex As Exception
    End Try
   Next
  End If
  xA = Me.CreateAttribute("Format")
  xA.InnerText = xFormat
  xNode.Attributes.Append(xA)
  xA = Me.CreateAttribute("Style")
  xA.InnerText = xStyle
  xNode.Attributes.Append(xA)
 End Sub
#End Region

End Class
