Imports System
Imports System.Collections
Imports System.IO
Imports System.Xml

Public Class CustomSettings

 Private _configFile As String = ""
 Private _cacheKey As String = ""
 Private _ht As Hashtable

 Public Sub New(ByVal ConfigFile As String, ByVal CacheKey As String)
  _configFile = ConfigFile
  _cacheKey = CacheKey
  LoadData()
 End Sub

 Private Sub LoadData()
  _ht = CType(DotNetNuke.Common.Utilities.DataCache.GetCache(_cacheKey), Hashtable)
  If _ht Is Nothing Then
   _ht = New Hashtable
   Try
    Dim xmlDoc As New XmlDocument
    xmlDoc.Load(_configFile)
    Me.FromXml(xmlDoc.DocumentElement)
    'Dim entries As XmlNodeList = xmlDoc.DocumentElement.GetElementsByTagName("Setting")
    'Dim entry As XmlElement
    'For Each entry In entries
    ' _ht.Add(entry.GetElementsByTagName("Key")(0).InnerText, entry.GetElementsByTagName("Value")(0).InnerText)
    'Next
    'DotNetNuke.Common.Utilities.DataCache.SetCache(_cacheKey, _ht)
   Catch ex As Exception
   End Try
  End If
 End Sub

 Public Sub FromXml(ByVal Settings As XmlElement)

  _ht = New Hashtable
  Dim entries As XmlNodeList = Settings.GetElementsByTagName("Setting")
  Dim entry As XmlElement
  For Each entry In entries
   _ht.Add(entry.GetElementsByTagName("Key")(0).InnerText, entry.GetElementsByTagName("Value")(0).InnerText)
  Next
  DotNetNuke.Common.Utilities.DataCache.SetCache(_cacheKey, _ht)

 End Sub

 Public Sub Save()
  Try
   Dim xmlDoc As New XmlDocument
   Dim xmldecl As XmlDeclaration
   xmldecl = xmlDoc.CreateXmlDeclaration("1.0", Nothing, Nothing)
   xmlDoc.AppendChild(xmldecl)
   ToXml(xmlDoc)
   xmlDoc.Save(_configFile)
   DotNetNuke.Common.Utilities.DataCache.SetCache(_cacheKey, _ht)
  Catch ex As Exception
  End Try
 End Sub

 Public Sub ToXml(ByRef XmlDoc As XmlDocument)
  Dim key As String
  Dim root As XmlNode = XmlDoc.CreateElement("Settings")
  XmlDoc.AppendChild(root)
  For Each key In _ht.Keys
   Dim setting As XmlNode = XmlDoc.CreateElement("Setting")
   Dim settingkey As XmlNode = XmlDoc.CreateElement("Key")
   settingkey.InnerText = key
   setting.AppendChild(settingkey)
   Dim settingvalue As XmlNode = XmlDoc.CreateElement("Value")
   settingvalue.InnerText = CType(_ht(key), String)
   setting.AppendChild(settingvalue)
   root.AppendChild(setting)
  Next
 End Sub

 Default Public Property Item(ByVal Key As String, Optional ByVal Save As Boolean = True) As String
  Get
   If _ht.ContainsKey(Key) Then
    Return CType(_ht(Key), String)
   Else
    Return Nothing
   End If
  End Get
  Set(ByVal Value As String)
   If _ht.ContainsKey(Key) Then
    _ht.Item(Key) = Value
   Else
    _ht.Add(Key, Value)
   End If
   If Save Then
    Me.Save()
   End If
  End Set
 End Property
End Class

