'
' Copyright (c) 2004
' by Peter Donker ( info@bring2mind.net )
'
' Permission is hereby granted to use and/or modify this software. It is not permitted to publish, distribute, 
' sublicense, and/or sell copies of the software in its original or modified form.
'
' THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED 
' TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
' THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF 
' CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
' DEALINGS IN THE SOFTWARE.
'
Imports DotNetNuke
Imports DotNetNuke.Entities.Modules.Communications
Imports DotNetNuke.Services.Localization.Localization
Imports Bring2mind.DNN.Modules.IWork.Business

Namespace Bring2mind.DNN.Modules.IWork.Controls

 Public Class Account
  Inherits Bring2mind.DNN.Modules.IWork.PortalModuleBase
  Implements IModuleCommunicator

  Public Event ModuleCommunication(ByVal sender As Object, ByVal e As ModuleCommunicationEventArgs) Implements IModuleCommunicator.ModuleCommunication

#Region " Web Form Designer Generated Code "

  'This call is required by the Web Form Designer.
  <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()

  End Sub

  'NOTE: The following placeholder declaration is required by the Web Form Designer.
  'Do not delete or move it.
  Private designerPlaceholderDeclaration As System.Object

  Private Sub Page_Init(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Init
   'CODEGEN: This method call is required by the Web Form Designer
   'Do not modify it using the code editor.
   InitializeComponent()
   MyInitialize()
  End Sub

#End Region

#Region " Controls "
  Protected WithEvents lblAccountsTitle As System.Web.UI.WebControls.Label
  Protected WithEvents dgAccounts As System.Web.UI.WebControls.DataGrid
  Protected WithEvents pnlAccounts As System.Web.UI.WebControls.Panel
  Protected WithEvents lblAccountName As System.Web.UI.WebControls.Label
  Protected WithEvents lblContactHead As System.Web.UI.WebControls.Label
  Protected WithEvents lblBillingHead As System.Web.UI.WebControls.Label
  Protected WithEvents lblNameTitle As System.Web.UI.WebControls.Label
  Protected WithEvents lblContactName As System.Web.UI.WebControls.Label
  Protected WithEvents lblPhoneTitle As System.Web.UI.WebControls.Label
  Protected WithEvents lblPhone As System.Web.UI.WebControls.Label
  Protected WithEvents lblMobileTitle As System.Web.UI.WebControls.Label
  Protected WithEvents lblMobile As System.Web.UI.WebControls.Label
  Protected WithEvents lblEmailTitle As System.Web.UI.WebControls.Label
  Protected WithEvents lblEmail As System.Web.UI.WebControls.Label
  Protected WithEvents lblDefaultCurrencyTitle As System.Web.UI.WebControls.Label
  Protected WithEvents lblCurrency As System.Web.UI.WebControls.Label
  Protected WithEvents lblDefaultTariffTitle As System.Web.UI.WebControls.Label
  Protected WithEvents lblTariff As System.Web.UI.WebControls.Label
  Protected WithEvents lblBillingTitle As System.Web.UI.WebControls.Label
  Protected WithEvents lblBilling As System.Web.UI.WebControls.Label
  Protected WithEvents lblAddressTitle As System.Web.UI.WebControls.Label
  Protected WithEvents lblAddress As System.Web.UI.WebControls.Label
  Protected WithEvents cmdEdit As System.Web.UI.WebControls.HyperLink
  Protected WithEvents pnlAccount As System.Web.UI.WebControls.Panel
#End Region

#Region " Page Events "

  Private Sub MyInitialize()
   MyBase.Actions.Add(GetNextActionID, "IWork Options", "", URL:=EditUrl("", "", "IWorkOptions"), secure:=DotNetNuke.Security.SecurityAccessLevel.Admin, Visible:=True)
   If Security.IsAdmin Then
    MyBase.Actions.Add(GetNextActionID, "Add Account", "", URL:=EditUrl("PortalId", PortalId.ToString, "EditAccount"), secure:=DotNetNuke.Security.SecurityAccessLevel.Edit, Visible:=True)
   End If

   Query = New Query(Me.Request, Me.PortalId, Me.Security)

   'try to speed up things by only instantiating Query once
   Dim _e As New ModuleCommunicationEventArgs
   _e.Sender = "Account"
   _e.Target = "IWork"
   _e.Text = "Query"
   _e.Value = Query
   _e.Type = "Query"
   RaiseEvent ModuleCommunication(Me, _e)

  End Sub

  Private Sub Page_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

   If Not Page.IsPostBack Then

    If Me.Query.AccountId > -1 Then
     pnlAccounts.Visible = False
     pnlAccount.Visible = True
     With Me.Query.RequestedAccount
      lblAccountName.Text = .AccountName & IIf(.Deleted, " (DELETED)", "")
      lblContactName.Text = .ContactName
      lblPhone.Text = .ContactPhone
      lblMobile.Text = .ContactMobile
      lblEmail.Text = .ContactEmail
      lblTariff.Text = .DefaultTariff.ToString("0.00")
      lblCurrency.Text = .DefaultCurrency
      lblBilling.Text = IIf(.BilledThrough > 0, GetString("Indirect", Me.LocalResourceFile), GetString("Direct", Me.LocalResourceFile))
      lblAddress.Text = .BillingStreet & "<br/>" & .BillingPostalCode & "&nbsp;" & .BillingCity & "<br/>" & .BillingCountry
      cmdEdit.NavigateUrl = Me.Query.IWorkUrl(TabId, "EditAccount", Me.Query.AccountId)
     End With
    Else
     pnlAccounts.Visible = True
     pnlAccount.Visible = False
     If Security.IsEmployee Then
      pnlAccounts.Visible = True
      Dim dv As New DataView(DotNetNuke.Common.Globals.ConvertDataReaderToDataTable(Bring2mind.DNN.Modules.IWork.Data.DataProvider.Instance().GetAccountsByPortal(PortalId, False)))
      dv.Sort = "AccountName"
      With dgAccounts
       .DataSource = dv
       .DataBind()
      End With
     Else
      pnlAccounts.Visible = True
      Dim dv As New DataView(DotNetNuke.Common.Globals.ConvertDataReaderToDataTable(Bring2mind.DNN.Modules.IWork.Data.DataProvider.Instance().GetAccountsByClient(UserInfo.UserID)))
      dv.Sort = "AccountName"
      With dgAccounts
       .DataSource = dv
       .DataBind()
      End With
     End If
    End If
   End If


  End Sub

#End Region


 End Class

End Namespace
