'
' Copyright (c) 2004
' by Peter Donker ( info@bring2mind.net )
'
' Permission is hereby granted to use and/or modify this software. It is not permitted to publish, distribute, 
' sublicense, and/or sell copies of the software in its original or modified form.
'
' THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED 
' TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
' THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF 
' CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
' DEALINGS IN THE SOFTWARE.
'
Imports DotNetNuke
Imports Bring2mind.DNN.Modules.IWork.Business

Namespace Bring2mind.DNN.Modules.IWork

 Public Class AddIssue
  Inherits Bring2mind.DNN.Modules.IWork.PortalModulebase

#Region " Web Form Designer Generated Code "

  'This call is required by the Web Form Designer.
  <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()

  End Sub
  Protected WithEvents lblAccountName As System.Web.UI.WebControls.Label
  Protected WithEvents txtIssueHeading As System.Web.UI.WebControls.TextBox
  Protected WithEvents Requiredfieldvalidator2 As System.Web.UI.WebControls.RequiredFieldValidator
  Protected WithEvents txtDiscourse As System.Web.UI.WebControls.TextBox
  Protected WithEvents cmdUpdate As System.Web.UI.WebControls.LinkButton
  Protected WithEvents cmdCancel As System.Web.UI.WebControls.LinkButton
  Protected WithEvents txtUrgency As System.Web.UI.WebControls.TextBox
  Protected WithEvents CompareValidator1 As System.Web.UI.WebControls.CompareValidator

  'NOTE: The following placeholder declaration is required by the Web Form Designer.
  'Do not delete or move it.
  Private designerPlaceholderDeclaration As System.Object

  Private Sub Page_Init(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Init
   'CODEGEN: This method call is required by the Web Form Designer
   'Do not modify it using the code editor.
   InitializeComponent()
  End Sub

#End Region

  Dim IssueId As Integer = -1
  Private AccountId As Integer = -1
  Private ProjectId As Integer = -1

  Private Sub Page_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
   ' Determine ProjectId
   If Not (Request.Params("ProjectId") Is Nothing) Then
    ProjectId = Int32.Parse(Request.Params("ProjectId"))
   Else
    ProjectId = -1
   End If

   If Not Page.IsPostBack Then
    Dim objProjects As New ProjectsController
    Dim objAccounts As New AccountsController
    Dim objProject As ProjectsInfo = objProjects.GetProjects(ProjectId)
    AccountId = objProject.AccountId
    Me.ViewState.Item("ProjectId") = ProjectId
    Me.ViewState.Item("AccountId") = ProjectId

    'security check
    If Not Security.OK2View(AccountId) Then
     UI.Skins.Skin.AddModuleMessage(Me, "Unauthorized", "You are either not logged in correctly, or you do not have access to this resource. Please check your login status", UI.Skins.Controls.ModuleMessage.ModuleMessageType.YellowWarning)
     Exit Sub
    End If

    lblAccountName.Text = objAccounts.GetAccounts(AccountId, PortalId).AccountName
    'Dim objUsers As New DotNetNuke.Entities.Users.UserController
    'new record
    txtUrgency.Text = "5"
   End If

  End Sub

  Private Sub cmdUpdate_Click(ByVal sender As Object, ByVal e As EventArgs) Handles cmdUpdate.Click
   Try
    ' Only Update if the Entered Data is Valid

    If Page.IsValid = True Then
     Dim objIssues As New IssuesInfo

     'bind text values to object
     With objIssues
      .ResolvedByTask = 0
      .IssueId = IssueId
      .Discourse = txtDiscourse.Text
      .IssueHeading = txtIssueHeading.Text
      .Resolved = False
      .ProjectId = Me.ViewState.Item("ProjectId")
      .IssueUrgency = CType(txtUrgency.Text, Integer)
      .IssueDate = Now
      .ResolvedDate = Now
     End With

     Dim objCtlIssues As New IssuesController
     If IssueId = -1 Then
      IssueId = objCtlIssues.AddIssues(objIssues)
     Else
      objCtlIssues.UpdateIssues(objIssues)
     End If

     ' Redirect back to the portal home page
     Response.Redirect(EditUrl("IssueId", IssueId.ToString, "ViewIssue"), True)

    End If
   Catch exc As Exception 'Module failed to load
    DotNetNuke.Services.Exceptions.ProcessModuleLoadException(Me, exc)
   End Try
  End Sub

  Private Sub cmdCancel_Click(ByVal sender As Object, ByVal e As EventArgs) Handles cmdCancel.Click
   Try
    If IssueId = -1 Then
     If Me.ViewState.Item("ProjectId") = -1 Then
      Response.Redirect(DotNetNuke.Common.Globals.NavigateURL(), True)
     Else
      Response.Redirect(EditUrl("ProjectId", Me.ViewState.Item("ProjectId").ToString, "ViewProject"), True)
     End If
    Else
     Response.Redirect(EditUrl("IssueId", IssueId.ToString, "ViewIssue"), True)
    End If
   Catch exc As Exception 'Module failed to load
    DotNetNuke.Services.Exceptions.ProcessModuleLoadException(Me, exc)
   End Try
  End Sub
 End Class
End Namespace
