'
' Copyright (c) 2004
' by Peter Donker ( info@bring2mind.net )
'
' Permission is hereby granted to use and/or modify this software. It is not permitted to publish, distribute, 
' sublicense, and/or sell copies of the software in its original or modified form.
'
' THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED 
' TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
' THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF 
' CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
' DEALINGS IN THE SOFTWARE.
'
Imports DotNetNuke
Imports Bring2mind.DNN.Modules.IWork.Business

Namespace Bring2mind.DNN.Modules.IWork

 Public Class EditTask
  Inherits Bring2mind.DNN.Modules.IWork.PortalModulebase

#Region " Web Form Designer Generated Code "

  'This call is required by the Web Form Designer.
  <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()

  End Sub
  Protected WithEvents Requiredfieldvalidator2 As System.Web.UI.WebControls.RequiredFieldValidator
  Protected WithEvents lblAccountName As System.Web.UI.WebControls.Label
  Protected WithEvents ddlProject As System.Web.UI.WebControls.DropDownList
  Protected WithEvents txtDescription As System.Web.UI.WebControls.TextBox
  Protected WithEvents txtComments As System.Web.UI.WebControls.TextBox
  Protected WithEvents cmdUpdate As System.Web.UI.WebControls.LinkButton
  Protected WithEvents cmdCancel As System.Web.UI.WebControls.LinkButton
  Protected WithEvents cmdDelete As System.Web.UI.WebControls.LinkButton
  Protected WithEvents txtTaskHeading As System.Web.UI.WebControls.TextBox
  Protected WithEvents lblEmployeeName As System.Web.UI.WebControls.Label
  Protected WithEvents ddlEmployee As System.Web.UI.WebControls.DropDownList
  Protected WithEvents hlInvoice As System.Web.UI.WebControls.HyperLink
  Protected WithEvents txtTime As System.Web.UI.WebControls.TextBox
  Protected WithEvents RegularExpressionValidator1 As System.Web.UI.WebControls.RegularExpressionValidator
  Protected WithEvents txtTimeBilled As System.Web.UI.WebControls.TextBox
  Protected WithEvents Regularexpressionvalidator2 As System.Web.UI.WebControls.RegularExpressionValidator
  Protected WithEvents chkIssues As System.Web.UI.WebControls.CheckBoxList
  Protected WithEvents txtTariff As System.Web.UI.WebControls.TextBox
  Protected WithEvents Regularexpressionvalidator3 As System.Web.UI.WebControls.RegularExpressionValidator
  Protected WithEvents Requiredfieldvalidator1 As System.Web.UI.WebControls.RequiredFieldValidator
  Protected WithEvents Requiredfieldvalidator3 As System.Web.UI.WebControls.RequiredFieldValidator
  Protected WithEvents Requiredfieldvalidator4 As System.Web.UI.WebControls.RequiredFieldValidator
  Protected WithEvents txtDate As System.Web.UI.WebControls.TextBox
  Protected WithEvents cmdDateCalendar As System.Web.UI.WebControls.HyperLink
  Protected WithEvents valDate As System.Web.UI.WebControls.RequiredFieldValidator
  Protected WithEvents valDate2 As System.Web.UI.WebControls.CompareValidator
  Protected WithEvents imgDate As System.Web.UI.HtmlControls.HtmlImage

  'NOTE: The following placeholder declaration is required by the Web Form Designer.
  'Do not delete or move it.
  Private designerPlaceholderDeclaration As System.Object

  Private Sub Page_Init(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Init
   'CODEGEN: This method call is required by the Web Form Designer
   'Do not modify it using the code editor.
   InitializeComponent()
  End Sub

#End Region

  Private TaskId As Integer = -1
  Private AccountId As Integer = -1
  Private ProjectId As Integer = -1
  Private EmployeeId As Integer
  'Private dtIssues As DataTable
  Private objIssues As New IssuesController

  Private Sub Page_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
   Dim objCtlTasks As New TasksController
   Dim objTask As New TasksInfo

   ' Determine TaskId
   If Not (Request.Params("TaskId") Is Nothing) Then
    TaskId = Int32.Parse(Request.Params("TaskId"))
   Else
    TaskId = -1
   End If
   ' Determine AccountId
   If Not (Request.Params("AccountId") Is Nothing) Then
    AccountId = Int32.Parse(Request.Params("AccountId"))
   Else
    AccountId = -1
   End If
   ' Determine ProjectId
   If Not (Request.Params("ProjectId") Is Nothing) Then
    ProjectId = Int32.Parse(Request.Params("ProjectId"))
   Else
    ProjectId = -1
   End If

   If Not Page.IsPostBack Then
    Dim objProjects As New ProjectsController
    Dim objAccounts As New AccountsController
    If TaskId <> -1 Then
     objTask = objCtlTasks.GetTasks(TaskId)
     ProjectId = objTask.ProjectId
     AccountId = objProjects.GetProjects(ProjectId).AccountId
    Else
     If ProjectId <> -1 Then
      AccountId = objProjects.GetProjects(ProjectId).AccountId
     Else
      If AccountId = -1 Then
       UI.Skins.Skin.AddModuleMessage(Me, "No ID(s)", "You are trying to access a resource without supplying proper information in the URL.", UI.Skins.Controls.ModuleMessage.ModuleMessageType.YellowWarning)
       Exit Sub
      End If
     End If
    End If
    Me.ViewState.Item("AccountId") = AccountId
    Me.ViewState.Item("ProjectId") = ProjectId

    'security check
    If Not Security.OK2View(AccountId) Then
     UI.Skins.Skin.AddModuleMessage(Me, "Unauthorized", "You are either not logged in correctly, or you do not have access to this resource. Please check your login status", UI.Skins.Controls.ModuleMessage.ModuleMessageType.YellowWarning)
     Exit Sub
    End If
    If Not Security.IsEmployee Then
     UI.Skins.Skin.AddModuleMessage(Me, "Unauthorized", "You are either not logged in correctly, or you do not have access to this resource. Please check your login status", UI.Skins.Controls.ModuleMessage.ModuleMessageType.YellowWarning)
     Exit Sub
    End If

    imgDate.Attributes.Add("onclick", "popUpCalendar(this, " & txtDate.ClientID & ",'" & System.Globalization.CultureInfo.CurrentCulture.DateTimeFormat.ShortDatePattern & "');return false;")
    imgDate.Src = IWorkPath & "ew_calendar.gif"
    Dim objAccount As AccountsInfo = objAccounts.GetAccounts(AccountId, PortalId)
    lblAccountName.Text = objAccount.AccountName
    cmdDelete.Attributes.Add("onClick", "javascript:return confirm('Are You Sure You Wish To Delete This Item ?');")
    ddlProject.DataSource = objProjects.GetProjectsByAccounts(AccountId, False)
    ddlProject.DataBind()
    Dim objUsers As New DotNetNuke.Entities.Users.UserController
    EmployeeId = UserInfo.UserID
    If TaskId <> -1 Then
     If Not objTask Is Nothing Then
      'Load data
      hlInvoice.Text = "Has not yet been invoiced"
      With objTask
       txtComments.Text = .Comments
       txtDescription.Text = .Description
       If Security.IsAdmin Then
        lblEmployeeName.Visible = False
        ddlEmployee.DataSource = objUsers.GetUsers(PortalId, False)
        ddlEmployee.DataBind()
        ddlEmployee.SelectedValue = .EmployeeId
       Else
        EmployeeId = .EmployeeId
        lblEmployeeName.Text = objUsers.GetUser(PortalId, EmployeeId).FullName
        ddlEmployee.Visible = False
       End If
       ddlProject.SelectedValue = .ProjectId
       txtDate.Text = .TaskDate.ToShortDateString
       txtTaskHeading.Text = .TaskHeading
       txtTime.Text = .TaskTime.ToString("0.0")
       txtTimeBilled.Text = .TaskTimeBilled.ToString("0.0")
       txtTariff.Text = .Tariff.ToString("0.00")
      End With
      'check if it has been billed already (we can't change something which has already been billed)
      Dim objInvoices As New InvoicesController
      If objTask.InvoiceId > 0 Then
       hlInvoice.Text = "Has been invoiced"
       hlInvoice.NavigateUrl = EditUrl("InvoiceId", objTask.InvoiceId.ToString, "ViewInvoice")
       Dim objInvoice As InvoicesInfo = objInvoices.GetInvoices(objTask.InvoiceId)
       If Not objInvoice Is Nothing Then
        If objInvoice.Sent Then
         ddlEmployee.Enabled = False
         ddlProject.Enabled = False
         txtTaskHeading.Enabled = False
         txtDate.Enabled = False
         txtTime.Enabled = False
         txtTimeBilled.Enabled = False
         'txtDescription.Enabled = False
         'txtComments.Enabled = False
         txtTariff.Enabled = False
         chkIssues.Enabled = False
         cmdDelete.Visible = False
        End If
       End If
      End If
      If Security.IsAdmin Then
       cmdDelete.Visible = True
       If objTask.Deleted Then
        cmdDelete.Text = "Undelete"
        cmdDelete.Attributes.Add("onClick", "javascript:return confirm('Are You Sure You Wish To Undelete This Item ?');")
       Else
        cmdDelete.Attributes.Add("onClick", "javascript:return confirm('Are You Sure You Wish To Delete This Item ?');")
       End If
      End If
     Else ' security violation attempt to access item not related to this Module
      UI.Skins.Skin.AddModuleMessage(Me, "Unauthorized", "You are either not logged in correctly, or you do not have access to this resource. Please check your login status", UI.Skins.Controls.ModuleMessage.ModuleMessageType.YellowWarning)
      Exit Sub
     End If
    Else
     'new record
     txtTariff.Text = objAccount.DefaultTariff.ToString("0.00")
     txtTime.Text = "0"
     txtTimeBilled.Text = "0"
     lblEmployeeName.Text = objUsers.GetUser(PortalId, EmployeeId).FullName
     ddlEmployee.Visible = False
     If ProjectId <> -1 Then
      ddlProject.SelectedValue = ProjectId
     End If
     hlInvoice.Text = "Not yet billed"
     txtDate.Text = Now.ToShortDateString
    End If
    Me.ViewState.Item("EmployeeId") = EmployeeId
    SetIssueList()
   End If
  End Sub

  Private Sub SetIssueList()
   'Dim lstIssues As ArrayList = objIssues.GetIssuesByProjects(6)
   Dim lstIssues As ArrayList = objIssues.GetIssuesByProjects(ddlProject.SelectedValue)
   Dim objIssue As IssuesInfo, li As ListItem
   chkIssues.Items.Clear()
   For Each objIssue In lstIssues
    If objIssue.Resolved Then
     If objIssue.ResolvedByTask = TaskId Then
      li = New ListItem
      li.Text = objIssue.IssueHeading
      li.Value = objIssue.IssueId
      li.Selected = True
      chkIssues.Items.Add(li)
     Else
      'resolved by other task
     End If
    Else
     li = New ListItem
     li.Text = objIssue.IssueHeading
     li.Value = objIssue.IssueId
     li.Selected = False
     chkIssues.Items.Add(li)
    End If
   Next
  End Sub

  Private Sub cmdUpdate_Click(ByVal sender As Object, ByVal e As EventArgs) Handles cmdUpdate.Click
   Try
    ' Only Update if the Entered Data is Valid

    If Page.IsValid = True Then
     Dim objTasks As New TasksInfo

     'objTasks = CType(CBO.InitializeObject(objTasks, GetType(TasksInfo)), TasksInfo)
     EmployeeId = Me.ViewState.Item("EmployeeId")
     'bind text values to object
     With objTasks
      .TaskId = TaskId
      .Comments = txtComments.Text
      .Description = txtDescription.Text
      If Security.IsAdmin And Not TaskId = -1 Then
       .EmployeeId = ddlEmployee.SelectedValue
      Else
       .EmployeeId = EmployeeId
      End If
      '.InvoiceId
      .ProjectId = ddlProject.SelectedValue
      .TaskDate = Convert.ToDateTime(txtDate.Text)
      .TaskHeading = txtTaskHeading.Text
      .TaskTime = CType(txtTime.Text, Decimal)
      .TaskTimeBilled = CType(txtTimeBilled.Text, Decimal)
      .Tariff = CType(txtTariff.Text, Decimal)
     End With

     If objTasks.InvoiceId > 0 Then
      RecalcInvoice(objTasks.InvoiceId)
     End If

     Dim objCtlTasks As New TasksController
     If TaskId = -1 Then
      TaskId = objCtlTasks.AddTasks(objTasks)
     Else
      objCtlTasks.UpdateTasks(objTasks)
     End If

     Dim objIssue As IssuesInfo
     For Each objIssue In objIssues.GetIssuesByProjects(objTasks.ProjectId)
      If Not chkIssues.Items.FindByValue(objIssue.IssueId) Is Nothing Then
       If chkIssues.Items.FindByValue(objIssue.IssueId).Selected Then
        objIssue.Resolved = True
        objIssue.ResolvedByTask = TaskId
        objIssue.ResolvedDate = Convert.ToDateTime(txtDate.Text)
       Else
        objIssue.Resolved = False
        'objIssue.ResolvedByTask = 0
       End If
       objIssues.UpdateIssues(objIssue)
      End If
     Next

     ' Redirect back to the portal home page
     Response.Redirect(EditUrl("ProjectId", ddlProject.SelectedValue, "ViewProject"), True)

    End If
   Catch exc As Exception 'Module failed to load
    DotNetNuke.Services.Exceptions.ProcessModuleLoadException(Me, exc)
   End Try
  End Sub

  Private Sub cmdCancel_Click(ByVal sender As Object, ByVal e As EventArgs) Handles cmdCancel.Click
   Try
    If TaskId = -1 Then
     Response.Redirect(DotNetNuke.Common.Globals.NavigateURL(), True)
    Else
     Response.Redirect(EditUrl("ProjectId", Me.ViewState.Item("ProjectId").ToString, "ViewProject"), True)
    End If
   Catch exc As Exception 'Module failed to load
    DotNetNuke.Services.Exceptions.ProcessModuleLoadException(Me, exc)
   End Try
  End Sub

  Private Sub cmdDelete_Click(ByVal sender As Object, ByVal e As EventArgs) Handles cmdDelete.Click
   Try
    If Not TaskId = -1 Then
     Dim objTasks As New TasksController
     Dim objTask As TasksInfo = objTasks.GetTasks(TaskId)
     If objTask.Deleted Then
      objTask.Deleted = False
     Else
      objTask.Deleted = True
     End If
     objTasks.UpdateTasks(objTask)
    End If

    Response.Redirect(EditUrl("ProjectId", Me.ViewState.Item("ProjectId").ToString, "ViewProject"), True)
   Catch exc As Exception 'Module failed to load
    DotNetNuke.Services.Exceptions.ProcessModuleLoadException(Me, exc)
   End Try
  End Sub

  Private Sub ddlProject_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles ddlProject.SelectedIndexChanged
   SetIssueList()
  End Sub

  Private Sub Page_PreRender(ByVal sender As Object, ByVal e As System.EventArgs) Handles MyBase.PreRender

   If Not Me.Page.IsClientScriptBlockRegistered("PopCalendar") Then
    Dim sr As New IO.StreamReader(Server.MapPath(IWorkPath & "popcalendar.js"))
    Dim CalScript As String = sr.ReadToEnd
    CalScript = CalScript.Replace("[IMAGEDIRECTORY]", IWorkPath)
    sr.Close()
    Page.RegisterClientScriptBlock("PopCalendar", "<script language='javascript'>" & CalScript & "</script>")
   End If

  End Sub
 End Class

End Namespace
