'
' Copyright (c) 2004
' by Peter Donker ( info@bring2mind.net )
'
' Permission is hereby granted to use and/or modify this software. It is not permitted to publish, distribute, 
' sublicense, and/or sell copies of the software in its original or modified form.
'
' THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED 
' TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
' THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF 
' CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
' DEALINGS IN THE SOFTWARE.
'
Imports DotNetNuke
Imports Bring2mind.DNN.Modules.IWork.Business

Namespace Bring2mind.DNN.Modules.IWork

 Public Class ViewInvoiceXML
  Inherits Bring2mind.DNN.Modules.IWork.PortalModulebase

#Region " Web Form Designer Generated Code "

  'This call is required by the Web Form Designer.
  <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()

  End Sub
  Protected WithEvents rpInvoice As System.Web.UI.WebControls.Repeater
  Protected WithEvents rpAccount As System.Web.UI.WebControls.Repeater
  Protected WithEvents rpProducts As System.Web.UI.WebControls.Repeater
  Protected WithEvents rpTasks As System.Web.UI.WebControls.Repeater

  'NOTE: The following placeholder declaration is required by the Web Form Designer.
  'Do not delete or move it.
  Private designerPlaceholderDeclaration As System.Object

  Private Sub Page_Init(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Init
   'CODEGEN: This method call is required by the Web Form Designer
   'Do not modify it using the code editor.
   InitializeComponent()
  End Sub

#End Region

  Dim dvProjects As DataView

  Private Sub Page_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
   Try

    If Not Security.IsEmployee Then 'no authorization
     UI.Skins.Skin.AddModuleMessage(Me, "Unauthorized", "You are either not logged in correctly, or you do not have access to this resource. Please check your login status", UI.Skins.Controls.ModuleMessage.ModuleMessageType.YellowWarning)
     Exit Sub
    End If

    Dim InvoiceId As Integer = -1
    If Not (Request.QueryString("InvoiceId") Is Nothing) Then
     InvoiceId = Int32.Parse(Request.QueryString("InvoiceId"))
    Else 'no id supplied
     UI.Skins.Skin.AddModuleMessage(Me, "No Id", "You did not request a valid Invoice", UI.Skins.Controls.ModuleMessage.ModuleMessageType.YellowWarning)
     Exit Sub
    End If

    Dim objInvoices As New InvoicesController
    Dim objInvoice As InvoicesInfo = objInvoices.GetInvoices(InvoiceId)
    If objInvoice Is Nothing Then 'not a valid invoice
     UI.Skins.Skin.AddModuleMessage(Me, "No Id", "You did not request a valid Invoice", UI.Skins.Controls.ModuleMessage.ModuleMessageType.YellowWarning)
     Exit Sub
    End If

    Dim AccountId As Integer = objInvoice.AccountId


    Response.ClearHeaders()
    Response.ClearContent()
    Response.ContentType = "text/xml"
    Response.AddHeader("Content-Disposition", "attachment; filename=invoice.xml")
    Response.Charset = "UTF-8"

    'Response.Clear()
    'Response.ContentType = "text/xml"
    'Response.ContentEncoding = System.Text.Encoding.UTF8

    dvProjects = New DataView(DotNetNuke.Common.Globals.ConvertDataReaderToDataTable(Bring2mind.DNN.Modules.IWork.Data.DataProvider.Instance().GetProjectsByAccounts(AccountId, True)))
    dvProjects.Sort = "ProjectId"

    rpInvoice.DataSource = New InvoicesInfo() {objInvoice}
    rpInvoice.DataBind()

    Dim objProducts As New ProductsController
    Dim dv As New DataView(DotNetNuke.Common.Globals.ConvertDataReaderToDataTable(Bring2mind.DNN.Modules.IWork.Data.DataProvider.Instance().GetProductsByInvoices(InvoiceId, True)))
    dv.Sort = "DateDelivered"
    rpProducts.DataSource = dv
    rpProducts.DataBind()
    Dim objTasks As New TasksController
    dv = New DataView(DotNetNuke.Common.Globals.ConvertDataReaderToDataTable(Bring2mind.DNN.Modules.IWork.Data.DataProvider.Instance().GetTasksByInvoices(InvoiceId, True)))
    dv.Sort = "TaskDate"
    rpTasks.DataSource = dv
    rpTasks.DataBind()

    Dim objAccounts As New AccountsController
    Dim objAccount As AccountsInfo = objAccounts.GetAccounts(AccountId, PortalId)
    Do While objAccount.BilledThrough > 0
     objAccount = objAccounts.GetAccounts(objAccount.BilledThrough, PortalId)
    Loop

    rpAccount.DataSource = New AccountsInfo() {objAccount}
    rpAccount.DataBind()

    'Response.Flush()
    Response.End()

   Catch exc As Exception
    DotNetNuke.Services.Exceptions.ProcessModuleLoadException(Me, exc)
   End Try
  End Sub

  Public Function GetXMLDate(ByVal xDate As Date) As String
   Return Year(xDate) & "-" & Month(xDate).ToString("00") & "-" & Day(xDate).ToString("00")
  End Function

  Public Function GetProjectName(ByVal ProjectId As Integer) As String
   Return dvProjects(dvProjects.Find(ProjectId)).Item("ProjectName")
  End Function

 End Class

End Namespace
