Imports Bring2mind.DNN.Modules.IWork

Namespace Bring2mind.DNN.Modules.IWork
 Public Class PortalModuleBase
  Inherits DotNetNuke.Entities.Modules.PortalModuleBase

  Private _moduleSettings As ModuleSettings
  Private _security As IWork.Security
  Private _iWorkPath As String
  Public Query As Query

  Public Property IWorkPath() As String
   Get
    If _iWorkPath Is Nothing Then
     _iWorkPath = DotNetNuke.Common.ResolveUrl("~/DesktopModules/Bring2mind/IWork") & "/"
    End If
    Return _iWorkPath
   End Get
   Set(ByVal value As String)
    _iWorkPath = value
   End Set
  End Property

  Public Function ModuleSettings() As ModuleSettings

   If _moduleSettings Is Nothing Then
    Dim CacheKey As String = "Settings4Module" & Me.ModuleId & "inPortal" & Me.PortalId
    Try
     _moduleSettings = CType(Me.Cache.Item(CacheKey), ModuleSettings)
    Catch ex As Exception
    End Try
    If _moduleSettings Is Nothing Then
     _moduleSettings = New ModuleSettings(ModuleId)
     Me.Cache.Insert(CacheKey, _moduleSettings)
    End If
   End If
   Return _moduleSettings

  End Function

  Friend Function Security() As Security

   If _security Is Nothing Then
    Dim SessionVarKey As String = "IWorkSecurityUser" & UserInfo.UserID.ToString & "AndPortal" & PortalId
    Try
     _security = CType(Context.Session(SessionVarKey), Security)
    Catch ex As Exception
    End Try
    If _security Is Nothing Then
     _security = New Security(Me)
     Context.Session(SessionVarKey) = _security
    End If
    If Context.User.Identity.IsAuthenticated Then
     If _security.UserId <> UserInfo.UserID Then
      _security = New Security(Me)
      Context.Session(SessionVarKey) = _security
     End If
    Else 'make sure we didn't just log out
     If _security.IsKnownUser Then
      _security = New Security(Me)
      Context.Session(SessionVarKey) = _security
     End If
    End If
   End If
   Return _security

  End Function

 End Class
End Namespace