Imports DotNetNuke
Imports Bring2mind.DNN.Modules.IWork.Business
Imports Bring2mind.DNN.Modules.IWork

Namespace Bring2mind.DNN.Modules.IWork

 Public Class Security

  'general
  Friend IsKnownUser As Boolean
  Private OurPortalId As Integer
  Public UserId As Integer

  'module specific
  Friend IsAdmin As Boolean
  Friend IsEmployee As Boolean
  Friend IsClient As Boolean

  Public Sub New(ByRef OurModule As PortalModuleBase)

   OurPortalId = OurModule.PortalId
   UserId = OurModule.UserInfo.UserID
   Dim objRoles As New DotNetNuke.Security.Roles.RoleController
   Dim objUR As DotNetNuke.Entities.Users.UserRoleInfo

   objUR = objRoles.GetUserRole(OurPortalId, UserId, DotNetNuke.Common.glbRoleUnauthUser)
   IsKnownUser = Not (objUR Is Nothing)
   IsAdmin = OurModule.UserInfo.IsSuperUser
   If Not IsAdmin Then
    objUR = objRoles.GetUserRole(OurPortalId, UserId, OurModule.PortalSettings.AdministratorRoleId)
    IsAdmin = (Not objUR Is Nothing)
    If Not IsAdmin Then
     objUR = objRoles.GetUserRole(OurPortalId, UserId, OurModule.ModuleSettings.AdminRole)
     IsAdmin = (Not objUR Is Nothing)
    End If
   End If
   objUR = objRoles.GetUserRole(OurPortalId, UserId, OurModule.ModuleSettings.UserRole)
   IsEmployee = Not (objUR Is Nothing)
   objUR = objRoles.GetUserRole(OurPortalId, UserId, OurModule.ModuleSettings.ClientRole)
   IsClient = Not (objUR Is Nothing)

   IsEmployee = IsEmployee Or IsAdmin

  End Sub

  Public Function OK2View(ByVal AccountId As Integer) As Boolean

   Dim ObjAccounts As New AccountsController
   Dim objAccount As AccountsInfo = ObjAccounts.GetAccounts(AccountId, OurPortalId)

   If objAccount Is Nothing Then
    Return False 'someone is trying to access an account outside the portal
   End If

   If IsAdmin Then
    Return True
   ElseIf IsEmployee Then
    Return True
   ElseIf IsClient Then
    If objAccount.UserId = UserId Then 'regular client
     Return True
    ElseIf objAccount.BilledThrough > 0 Then
     Dim oA As AccountsInfo = ObjAccounts.GetAccounts(objAccount.BilledThrough, OurPortalId)
     If oA.UserId = UserId Then 'superclient
      Return True
     Else 'wrong client
      Return False
     End If
    Else 'wrong client
     Return False
    End If
   Else 'no proper authorization
    Return False
   End If

  End Function
 End Class
End Namespace