'
' Copyright (c) 2004
' by Peter Donker ( info@bring2mind.net )
'
' Permission is hereby granted to use and/or modify this software. It is not permitted to publish, distribute, 
' sublicense, and/or sell copies of the software in its original or modified form.
'
' THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED 
' TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
' THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF 
' CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
' DEALINGS IN THE SOFTWARE.
'
Imports System
Imports System.Data
Imports System.Data.SqlClient
Imports Microsoft.ApplicationBlocks.Data

Namespace Bring2mind.DNN.Modules.IWork.Data

 Public Class SqlDataProvider

  Inherits DataProvider

#Region "Private Members"

  Private Const ProviderType As String = "data"

  Private _providerConfiguration As DotNetNuke.Framework.Providers.ProviderConfiguration = DotNetNuke.Framework.Providers.ProviderConfiguration.GetProviderConfiguration(ProviderType)
  Private _connectionString As String
  Private _providerPath As String
  Private _objectQualifier As String
  Private _databaseOwner As String

#End Region

#Region "Constructors"

  Public Sub New()

   ' Read the configuration specific information for this provider
   Dim objProvider As DotNetNuke.Framework.Providers.Provider = CType(_providerConfiguration.Providers(_providerConfiguration.DefaultProvider), DotNetNuke.Framework.Providers.Provider)

   ' Read the attributes for this provider
   If objProvider.Attributes("connectionStringName") <> "" AndAlso _
   System.Configuration.ConfigurationSettings.AppSettings(objProvider.Attributes("connectionStringName")) <> "" Then
    _connectionString = System.Configuration.ConfigurationSettings.AppSettings(objProvider.Attributes("connectionStringName"))
   Else
    _connectionString = objProvider.Attributes("connectionString")
   End If

   _providerPath = objProvider.Attributes("providerPath")

   _objectQualifier = objProvider.Attributes("objectQualifier")
   If _objectQualifier <> "" And _objectQualifier.EndsWith("_") = False Then
    _objectQualifier += "_"
   End If

   _databaseOwner = objProvider.Attributes("databaseOwner")
   If _databaseOwner <> "" And _databaseOwner.EndsWith(".") = False Then
    _databaseOwner += "."
   End If

  End Sub

#End Region

#Region "Properties"

  Public ReadOnly Property ConnectionString() As String
   Get
    Return _connectionString
   End Get
  End Property

  Public ReadOnly Property ProviderPath() As String
   Get
    Return _providerPath
   End Get
  End Property

  Public ReadOnly Property ObjectQualifier() As String
   Get
    Return _objectQualifier
   End Get
  End Property

  Public ReadOnly Property DatabaseOwner() As String
   Get
    Return _databaseOwner
   End Get
  End Property

#End Region

  Private Function GetNull(ByVal Field As Object) As Object
   Return DotNetNuke.Common.Utilities.Null.GetNull(Field, DBNull.Value)
  End Function

#Region "Accounts Methods"
  Public Overrides Function GetAccounts(ByVal accountId As Integer, ByVal portalId As Integer) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & "IW_GetAccounts", accountId, portalId), IDataReader)
  End Function


  Public Overrides Function GetAccountsByPortal(ByVal PortalId As Integer, ByVal IncludeDeleted As Boolean) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & "IW_GetAccountsByPortal", PortalId, IncludeDeleted), IDataReader)
  End Function

  Public Overrides Function GetAccountsByUser(ByVal UserId As Integer, ByVal IncludeDeleted As Boolean) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & "IW_GetAccountsByUser", UserId, IncludeDeleted), IDataReader)
  End Function

  Public Overrides Function AddAccounts(ByVal accountName As String, ByVal accountType As String, ByVal billedThrough As Integer, ByVal billingCity As String, ByVal billingCountry As String, ByVal billingPostalCode As String, ByVal billingStreet As String, ByVal contactEmail As String, ByVal contactMobile As String, ByVal contactName As String, ByVal contactPhone As String, ByVal defaultCurrency As String, ByVal defaultTariff As Decimal, ByVal deleted As Boolean, ByVal portalId As Integer, ByVal userId As Integer) As Integer
   Return CType(SqlHelper.ExecuteScalar(ConnectionString, DatabaseOwner & ObjectQualifier & "IW_AddAccounts", accountName, accountType, billedThrough, billingCity, billingCountry, billingPostalCode, billingStreet, contactEmail, contactMobile, contactName, contactPhone, defaultCurrency, defaultTariff, deleted, portalId, userId), Integer)
  End Function

  Public Overrides Sub UpdateAccounts(ByVal accountId As Integer, ByVal accountName As String, ByVal accountType As String, ByVal billedThrough As Integer, ByVal billingCity As String, ByVal billingCountry As String, ByVal billingPostalCode As String, ByVal billingStreet As String, ByVal contactEmail As String, ByVal contactMobile As String, ByVal contactName As String, ByVal contactPhone As String, ByVal defaultCurrency As String, ByVal defaultTariff As Decimal, ByVal deleted As Boolean, ByVal portalId As Integer, ByVal userId As Integer)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & "IW_UpdateAccounts", accountId, accountName, accountType, billedThrough, billingCity, billingCountry, billingPostalCode, billingStreet, contactEmail, contactMobile, contactName, contactPhone, defaultCurrency, defaultTariff, deleted, portalId, userId)
  End Sub

  Public Overrides Sub DeleteAccounts(ByVal accountId As Integer)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & "IW_DeleteAccounts", accountId)
  End Sub
#End Region

#Region "Invoices Methods"
  Public Overrides Function GetInvoices(ByVal invoiceId As Integer) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & "IW_GetInvoices", invoiceId), IDataReader)
  End Function


  Public Overrides Function GetInvoicesByAccounts(ByVal accountId As Integer) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & "IW_GetInvoicesByAccounts", accountId), IDataReader)
  End Function

  Public Overrides Function GetInvoicesByPortal(ByVal PortalId As Integer) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & "IW_GetInvoicesByPortal", PortalId), IDataReader)
  End Function

  Public Overrides Function GetInvoicesByUser(ByVal UserId As Integer) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & "IW_GetInvoicesByUser", UserId), IDataReader)
  End Function

  Public Overrides Function AddInvoices(ByVal accountId As Integer, ByVal currency As String, ByVal datePaid As Date, ByVal dateSent As Date, ByVal invoiceCode As String, ByVal paid As Boolean, ByVal reference As String, ByVal sent As Boolean, ByVal subject As String, ByVal subtotal As Decimal, ByVal total As Decimal, ByVal vAT As Decimal) As Integer
   Return CType(SqlHelper.ExecuteScalar(ConnectionString, DatabaseOwner & ObjectQualifier & "IW_AddInvoices", accountId, currency, GetNull(datePaid), GetNull(dateSent), invoiceCode, paid, reference, sent, subject, subtotal, total, vAT), Integer)
  End Function

  Public Overrides Sub UpdateInvoices(ByVal invoiceId As Integer, ByVal accountId As Integer, ByVal currency As String, ByVal datePaid As Date, ByVal dateSent As Date, ByVal invoiceCode As String, ByVal paid As Boolean, ByVal reference As String, ByVal sent As Boolean, ByVal subject As String, ByVal subtotal As Decimal, ByVal total As Decimal, ByVal vAT As Decimal)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & "IW_UpdateInvoices", invoiceId, accountId, currency, GetNull(datePaid), GetNull(dateSent), invoiceCode, paid, reference, sent, subject, subtotal, total, vAT)
  End Sub

  Public Overrides Sub DeleteInvoices(ByVal invoiceId As Integer)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & "IW_DeleteInvoices", invoiceId)
  End Sub
#End Region

#Region "Issues Methods"
  Public Overrides Function GetIssues(ByVal issueId As Integer) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & "IW_GetIssues", issueId), IDataReader)
  End Function


  Public Overrides Function GetIssuesByProjects(ByVal projectId As Integer) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & "IW_GetIssuesByProjects", projectId), IDataReader)
  End Function

  Public Overrides Function GetIssuesByAccounts(ByVal accountId As Integer) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & "IW_GetIssuesByAccounts", accountId), IDataReader)
  End Function

  Public Overrides Function GetIssuesByPortal(ByVal PortalId As Integer) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & "IW_GetIssuesByPortal", PortalId), IDataReader)
  End Function

  Public Overrides Function GetIssuesByUser(ByVal UserId As Integer) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & "IW_GetIssuesByUser", UserId), IDataReader)
  End Function

  Public Overrides Function GetIssuesByTasks(ByVal taskId As Integer) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & "IW_GetIssuesByTasks", taskId), IDataReader)
  End Function

  Public Overrides Function AddIssues(ByVal discourse As String, ByVal issueDate As Date, ByVal issueHeading As String, ByVal issueUrgency As Integer, ByVal projectId As Integer, ByVal resolved As Boolean, ByVal resolvedByTask As Integer, ByVal resolvedDate As Date) As Integer
   Return CType(SqlHelper.ExecuteScalar(ConnectionString, DatabaseOwner & ObjectQualifier & "IW_AddIssues", discourse, issueDate, issueHeading, issueUrgency, projectId, resolved, resolvedByTask, resolvedDate), Integer)
  End Function

  Public Overrides Sub UpdateIssues(ByVal issueId As Integer, ByVal discourse As String, ByVal issueDate As Date, ByVal issueHeading As String, ByVal issueUrgency As Integer, ByVal projectId As Integer, ByVal resolved As Boolean, ByVal resolvedByTask As Integer, ByVal resolvedDate As Date)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & "IW_UpdateIssues", issueId, discourse, issueDate, issueHeading, issueUrgency, projectId, resolved, resolvedByTask, resolvedDate)
  End Sub

  Public Overrides Sub DeleteIssues(ByVal issueId As Integer)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & "IW_DeleteIssues", issueId)
  End Sub
#End Region

#Region "Products Methods"
  Public Overrides Function GetProducts(ByVal productsId As Integer) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & "IW_GetProducts", productsId), IDataReader)
  End Function


  Public Overrides Function GetProductsByInvoices(ByVal invoiceId As Integer, ByVal IncludeDeleted As Boolean) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & "IW_GetProductsByInvoices", invoiceId, IncludeDeleted), IDataReader)
  End Function

  Public Overrides Function GetProductsByProjects(ByVal projectId As Integer, ByVal IncludeDeleted As Boolean) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & "IW_GetProductsByProjects", projectId, IncludeDeleted), IDataReader)
  End Function

  Public Overrides Function GetProductsByAccounts(ByVal accountId As Integer, ByVal IncludeDeleted As Boolean) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & "IW_GetProductsByAccounts", accountId, IncludeDeleted), IDataReader)
  End Function

  Public Overrides Function GetProductsByPortal(ByVal PortalId As Integer, ByVal IncludeDeleted As Boolean) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & "IW_GetProductsByPortal", PortalId, IncludeDeleted), IDataReader)
  End Function

  Public Overrides Function GetProductsByUser(ByVal UserId As Integer, ByVal IncludeDeleted As Boolean) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & "IW_GetProductsByUser", UserId, IncludeDeleted), IDataReader)
  End Function

  Public Overrides Function AddProducts(ByVal category As String, ByVal comments As String, ByVal dateDelivered As Date, ByVal deleted As Boolean, ByVal description As String, ByVal invoiceId As Integer, ByVal priceBuy As Decimal, ByVal priceSell As Decimal, ByVal projectId As Integer, ByVal quantity As Decimal) As Integer
   Return CType(SqlHelper.ExecuteScalar(ConnectionString, DatabaseOwner & ObjectQualifier & "IW_AddProducts", category, comments, dateDelivered, deleted, description, invoiceId, priceBuy, priceSell, projectId, quantity), Integer)
  End Function

  Public Overrides Sub UpdateProducts(ByVal productsId As Integer, ByVal category As String, ByVal comments As String, ByVal dateDelivered As Date, ByVal deleted As Boolean, ByVal description As String, ByVal invoiceId As Integer, ByVal priceBuy As Decimal, ByVal priceSell As Decimal, ByVal projectId As Integer, ByVal quantity As Decimal)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & "IW_UpdateProducts", productsId, category, comments, dateDelivered, deleted, description, invoiceId, priceBuy, priceSell, projectId, quantity)
  End Sub

  Public Overrides Sub DeleteProducts(ByVal productsId As Integer)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & "IW_DeleteProducts", productsId)
  End Sub
#End Region

#Region "Projects Methods"
  Public Overrides Function GetProjects(ByVal projectId As Integer) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & "IW_GetProjects", projectId), IDataReader)
  End Function


  Public Overrides Function GetProjectsByAccounts(ByVal accountId As Integer, ByVal IncludeDeleted As Boolean) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & "IW_GetProjectsByAccounts", accountId, IncludeDeleted), IDataReader)
  End Function

  Public Overrides Function GetProjectsByPortal(ByVal PortalId As Integer, ByVal IncludeDeleted As Boolean) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & "IW_GetProjectsByPortal", PortalId, IncludeDeleted), IDataReader)
  End Function

  Public Overrides Function GetProjectsByUser(ByVal UserId As Integer, ByVal IncludeDeleted As Boolean) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & "IW_GetProjectsByUser", UserId, IncludeDeleted), IDataReader)
  End Function

  Public Overrides Function AddProjects(ByVal accountId As Integer, ByVal budget As Decimal, ByVal deleted As Boolean, ByVal description As String, ByVal projectName As String, ByVal projectType As String) As Integer
   Return CType(SqlHelper.ExecuteScalar(ConnectionString, DatabaseOwner & ObjectQualifier & "IW_AddProjects", accountId, budget, deleted, description, projectName, projectType), Integer)
  End Function

  Public Overrides Sub UpdateProjects(ByVal projectId As Integer, ByVal accountId As Integer, ByVal budget As Decimal, ByVal deleted As Boolean, ByVal description As String, ByVal projectName As String, ByVal projectType As String)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & "IW_UpdateProjects", projectId, accountId, budget, deleted, description, projectName, projectType)
  End Sub

  Public Overrides Sub DeleteProjects(ByVal projectId As Integer)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & "IW_DeleteProjects", projectId)
  End Sub
#End Region

#Region "Tasks Methods"
  Public Overrides Function GetTasks(ByVal taskId As Integer) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & "IW_GetTasks", taskId), IDataReader)
  End Function


  Public Overrides Function GetTasksByInvoices(ByVal invoiceId As Integer, ByVal IncludeDeleted As Boolean) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & "IW_GetTasksByInvoices", invoiceId, IncludeDeleted), IDataReader)
  End Function

  Public Overrides Function GetTasksByProjects(ByVal projectId As Integer, ByVal IncludeDeleted As Boolean) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & "IW_GetTasksByProjects", projectId, IncludeDeleted), IDataReader)
  End Function

  Public Overrides Function GetTasksByAccounts(ByVal accountId As Integer, ByVal IncludeDeleted As Boolean) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & "IW_GetTasksByAccounts", accountId, IncludeDeleted), IDataReader)
  End Function

  Public Overrides Function GetTasksByPortal(ByVal PortalId As Integer, ByVal IncludeDeleted As Boolean) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & "IW_GetTasksByPortal", PortalId, IncludeDeleted), IDataReader)
  End Function

  Public Overrides Function GetTasksByUser(ByVal UserId As Integer, ByVal IncludeDeleted As Boolean) As IDataReader
   Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & "IW_GetTasksByUser", UserId, IncludeDeleted), IDataReader)
  End Function

  Public Overrides Function AddTasks(ByVal comments As String, ByVal deleted As Boolean, ByVal description As String, ByVal employeeId As Integer, ByVal invoiceId As Integer, ByVal projectId As Integer, ByVal tariff As Decimal, ByVal taskDate As Date, ByVal taskHeading As String, ByVal taskTime As Decimal, ByVal taskTimeBilled As Decimal) As Integer
   Return CType(SqlHelper.ExecuteScalar(ConnectionString, DatabaseOwner & ObjectQualifier & "IW_AddTasks", comments, deleted, description, employeeId, invoiceId, projectId, tariff, taskDate, taskHeading, taskTime, taskTimeBilled), Integer)
  End Function

  Public Overrides Sub UpdateTasks(ByVal taskId As Integer, ByVal comments As String, ByVal deleted As Boolean, ByVal description As String, ByVal employeeId As Integer, ByVal invoiceId As Integer, ByVal projectId As Integer, ByVal tariff As Decimal, ByVal taskDate As Date, ByVal taskHeading As String, ByVal taskTime As Decimal, ByVal taskTimeBilled As Decimal)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & "IW_UpdateTasks", taskId, comments, deleted, description, employeeId, invoiceId, projectId, tariff, taskDate, taskHeading, taskTime, taskTimeBilled)
  End Sub

  Public Overrides Sub DeleteTasks(ByVal taskId As Integer)
   SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & "IW_DeleteTasks", taskId)
  End Sub
#End Region

#Region "Documents Methods"

        Public Overrides Function AddDocument(ByVal AccountId As Integer, ByVal ModuleId As Integer, ByVal Title As String, ByVal URL As String, ByVal UserName As String, ByVal Category As String) As Integer
            Return CType(SqlHelper.ExecuteScalar(ConnectionString, DatabaseOwner & ObjectQualifier & "IW_AddDocument", AccountId, ModuleId, Title, URL, UserName, Category), Integer)
        End Function

        Public Overrides Sub DeleteDocument(ByVal ItemId As Integer)
            SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & "IW_DeleteDocument", ItemId)
        End Sub

        Public Overrides Function GetDocument(ByVal ItemId As Integer, ByVal ModuleId As Integer) As IDataReader
            Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & "IW_GetDocument", ItemId, ModuleId), IDataReader)
        End Function

        Public Overrides Function GetDocuments(ByVal AccountId As Integer, ByVal ModuleId As Integer) As IDataReader
            Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & "IW_GetDocuments", AccountId, ModuleId), IDataReader)
        End Function

        Public Overrides Sub UpdateDocument(ByVal ItemId As Integer, ByVal Title As String, ByVal URL As String, ByVal UserName As String, ByVal Category As String)
            SqlHelper.ExecuteNonQuery(ConnectionString, DatabaseOwner & ObjectQualifier & "IW_UpdateDocument", ItemId, Title, URL, UserName, Category)
        End Sub


#End Region

#Region "Other Procedures"
        Public Overrides Function GetAccountsByClient(ByVal ClientUserID As Integer) As IDataReader
            Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & "IW_GetAccountsByClient", ClientUserID), IDataReader)
        End Function

        Public Overrides Function GetProjectsByClient(ByVal ClientUserID As Integer) As IDataReader
            Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & "IW_GetProjectsByClient", ClientUserID), IDataReader)
        End Function

        Public Overrides Function GetTopIssues(ByVal PortalID As Integer) As IDataReader
            Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & "IW_GetTopIssues", PortalID), IDataReader)
        End Function

        Public Overrides Function GetUnpaidInvoices(ByVal PortalID As Integer) As IDataReader
            Return CType(SqlHelper.ExecuteReader(ConnectionString, DatabaseOwner & ObjectQualifier & "IW_GetUnpaidInvoices", PortalID), IDataReader)
        End Function

#End Region

    End Class

End Namespace
