<%@ Control Language="vb" AutoEventWireup="false" Codebehind="ListProducts.ascx.vb" Inherits="Bring2mind.DNN.Modules.IWork.ListProducts" %>
<asp:Panel ID="pnlProducts" Runat="server" CssClass="iw_gridpanel">
 <P class="iw_title">
  <asp:Label id="lblAccountName" Runat="server">Account</asp:Label></P>
 <asp:DataGrid id="dgProducts" CssClass="iw_gridtable" GridLines="None" CellPadding="2" BorderWidth="0px"
  Width="600px" AutoGenerateColumns="False" runat="server" AllowPaging="True">
  <ItemStyle CssClass="iw_gridrow" VerticalAlign="Top"></ItemStyle>
  <HeaderStyle CssClass="iw_gridheader"></HeaderStyle>
  <Columns>
   <asp:BoundColumn DataField="DateDelivered" HeaderText="Delivered" DataFormatString="{0:MMM-dd}"></asp:BoundColumn>
   <asp:TemplateColumn HeaderText="Description">
    <ItemTemplate>
     <%# DataBinder.Eval(Container, "DataItem.Description") %>
     <br />
     <%# DataBinder.Eval(Container, "DataItem.Comments") %>
     </asp:Label>
    </ItemTemplate>
   </asp:TemplateColumn>
   <asp:BoundColumn DataField="Quantity" HeaderText="Qty" DataFormatString="{0:0.0}">
    <HeaderStyle HorizontalAlign="Right"></HeaderStyle>
    <ItemStyle HorizontalAlign="Right"></ItemStyle>
   </asp:BoundColumn>
   <asp:BoundColumn DataField="PriceSell" HeaderText="Price" DataFormatString="{0:0.00}">
    <HeaderStyle HorizontalAlign="Right"></HeaderStyle>
    <ItemStyle HorizontalAlign="Right"></ItemStyle>
   </asp:BoundColumn>
   <asp:TemplateColumn HeaderText="Invoiced">
    <ItemTemplate>
     <%# IIF(DataBinder.Eval(Container, "DataItem.InvoiceId")=0, "no", "yes") %>
     </asp:Label>
    </ItemTemplate>
   </asp:TemplateColumn>
   <asp:TemplateColumn HeaderText="Actions">
    <ItemTemplate>
     <asp:HyperLink runat="server" Text="Edit" NavigateURL='<%# EditURL("ProductId", DataBinder.Eval(Container.DataItem, "ProductsId").ToString, "EditProduct") %>' ID="Hyperlink1" NAME="Hyperlink1" Visible='<%# IIF(IsAnEmployee, "true", "false") %>'>
     </asp:HyperLink>
    </ItemTemplate>
   </asp:TemplateColumn>
  </Columns>
  <PagerStyle PageButtonCount="20" CssClass="iw_gridpager" Mode="NumericPages"></PagerStyle>
 </asp:DataGrid>
</asp:Panel>
<p><asp:HyperLink ID="hlBack" Runat="server" CssClass="CommandButton">Back</asp:HyperLink></p>
