'
' Copyright (c) 2004
' by Peter Donker ( info@bring2mind.net )
'
' Permission is hereby granted to use and/or modify this software. It is not permitted to publish, distribute, 
' sublicense, and/or sell copies of the software in its original or modified form.
'
' THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED 
' TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
' THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF 
' CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
' DEALINGS IN THE SOFTWARE.
'
Imports System
Imports DotNetNuke

Namespace Bring2mind.DNN.Modules.IWork.Data

 Public MustInherit Class DataProvider

#Region "Shared/Static Methods"

  ' singleton reference to the instantiated object 
  Private Shared objProvider As DataProvider = Nothing

  ' constructor
  Shared Sub New()
   CreateProvider()
  End Sub

  ' dynamically create provider
  Private Shared Sub CreateProvider()
   objProvider = CType(Framework.Reflection.CreateObject("data", "Bring2mind.DNN.Modules.IWork.Data", "Bring2mind.DNN.Modules.IWork"), DataProvider)
  End Sub

  ' return the provider
  Public Shared Shadows Function Instance() As DataProvider
   Return objProvider
  End Function

#End Region


#Region "Accounts Methods"
  Public MustOverride Function GetAccounts(ByVal accountId As Integer, ByVal portalId As Integer) As IDataReader
  Public MustOverride Function GetAccountsByPortal(ByVal PortalId As Integer, ByVal IncludeDeleted As Boolean) As IDataReader
  Public MustOverride Function GetAccountsByUser(ByVal UserId As Integer, ByVal IncludeDeleted As Boolean) As IDataReader
  Public MustOverride Function AddAccounts(ByVal accountName As String, ByVal accountType As String, ByVal billedThrough As Integer, ByVal billingCity As String, ByVal billingCountry As String, ByVal billingPostalCode As String, ByVal billingStreet As String, ByVal contactEmail As String, ByVal contactMobile As String, ByVal contactName As String, ByVal contactPhone As String, ByVal defaultCurrency As String, ByVal defaultTariff As Decimal, ByVal deleted As Boolean, ByVal portalId As Integer, ByVal userId As Integer) As Integer
  Public MustOverride Sub UpdateAccounts(ByVal accountId As Integer, ByVal accountName As String, ByVal accountType As String, ByVal billedThrough As Integer, ByVal billingCity As String, ByVal billingCountry As String, ByVal billingPostalCode As String, ByVal billingStreet As String, ByVal contactEmail As String, ByVal contactMobile As String, ByVal contactName As String, ByVal contactPhone As String, ByVal defaultCurrency As String, ByVal defaultTariff As Decimal, ByVal deleted As Boolean, ByVal portalId As Integer, ByVal userId As Integer)
  Public MustOverride Sub DeleteAccounts(ByVal accountId As Integer)
#End Region


#Region "Invoices Methods"
  Public MustOverride Function GetInvoices(ByVal invoiceId As Integer) As IDataReader
  Public MustOverride Function GetInvoicesByAccounts(ByVal accountId As Integer) As IDataReader
  Public MustOverride Function GetInvoicesByPortal(ByVal PortalId As Integer) As IDataReader
  Public MustOverride Function GetInvoicesByUser(ByVal UserId As Integer) As IDataReader
  Public MustOverride Function AddInvoices(ByVal accountId As Integer, ByVal currency As String, ByVal datePaid As Date, ByVal dateSent As Date, ByVal invoiceCode As String, ByVal paid As Boolean, ByVal reference As String, ByVal sent As Boolean, ByVal subject As String, ByVal subtotal As Decimal, ByVal total As Decimal, ByVal vAT As Decimal) As Integer
  Public MustOverride Sub UpdateInvoices(ByVal invoiceId As Integer, ByVal accountId As Integer, ByVal currency As String, ByVal datePaid As Date, ByVal dateSent As Date, ByVal invoiceCode As String, ByVal paid As Boolean, ByVal reference As String, ByVal sent As Boolean, ByVal subject As String, ByVal subtotal As Decimal, ByVal total As Decimal, ByVal vAT As Decimal)
  Public MustOverride Sub DeleteInvoices(ByVal invoiceId As Integer)
#End Region


#Region "Issues Methods"
  Public MustOverride Function GetIssues(ByVal issueId As Integer) As IDataReader
  Public MustOverride Function GetIssuesByProjects(ByVal projectId As Integer) As IDataReader
  Public MustOverride Function GetIssuesByAccounts(ByVal accountId As Integer) As IDataReader
  Public MustOverride Function GetIssuesByPortal(ByVal PortalId As Integer) As IDataReader
  Public MustOverride Function GetIssuesByUser(ByVal UserId As Integer) As IDataReader
  Public MustOverride Function GetIssuesByTasks(ByVal taskId As Integer) As IDataReader
  Public MustOverride Function AddIssues(ByVal discourse As String, ByVal issueDate As Date, ByVal issueHeading As String, ByVal issueUrgency As Integer, ByVal projectId As Integer, ByVal resolved As Boolean, ByVal resolvedByTask As Integer, ByVal resolvedDate As Date) As Integer
  Public MustOverride Sub UpdateIssues(ByVal issueId As Integer, ByVal discourse As String, ByVal issueDate As Date, ByVal issueHeading As String, ByVal issueUrgency As Integer, ByVal projectId As Integer, ByVal resolved As Boolean, ByVal resolvedByTask As Integer, ByVal resolvedDate As Date)
  Public MustOverride Sub DeleteIssues(ByVal issueId As Integer)
#End Region


#Region "Products Methods"
  Public MustOverride Function GetProducts(ByVal productsId As Integer) As IDataReader
  Public MustOverride Function GetProductsByInvoices(ByVal invoiceId As Integer, ByVal IncludeDeleted As Boolean) As IDataReader
  Public MustOverride Function GetProductsByProjects(ByVal projectId As Integer, ByVal IncludeDeleted As Boolean) As IDataReader
  Public MustOverride Function GetProductsByAccounts(ByVal accountId As Integer, ByVal IncludeDeleted As Boolean) As IDataReader
  Public MustOverride Function GetProductsByPortal(ByVal PortalId As Integer, ByVal IncludeDeleted As Boolean) As IDataReader
  Public MustOverride Function GetProductsByUser(ByVal UserId As Integer, ByVal IncludeDeleted As Boolean) As IDataReader
  Public MustOverride Function AddProducts(ByVal category As String, ByVal comments As String, ByVal dateDelivered As Date, ByVal deleted As Boolean, ByVal description As String, ByVal invoiceId As Integer, ByVal priceBuy As Decimal, ByVal priceSell As Decimal, ByVal projectId As Integer, ByVal quantity As Decimal) As Integer
  Public MustOverride Sub UpdateProducts(ByVal productsId As Integer, ByVal category As String, ByVal comments As String, ByVal dateDelivered As Date, ByVal deleted As Boolean, ByVal description As String, ByVal invoiceId As Integer, ByVal priceBuy As Decimal, ByVal priceSell As Decimal, ByVal projectId As Integer, ByVal quantity As Decimal)
  Public MustOverride Sub DeleteProducts(ByVal productsId As Integer)
#End Region


#Region "Projects Methods"
  Public MustOverride Function GetProjects(ByVal projectId As Integer) As IDataReader
  Public MustOverride Function GetProjectsByAccounts(ByVal accountId As Integer, ByVal IncludeDeleted As Boolean) As IDataReader
  Public MustOverride Function GetProjectsByPortal(ByVal PortalId As Integer, ByVal IncludeDeleted As Boolean) As IDataReader
  Public MustOverride Function GetProjectsByUser(ByVal UserId As Integer, ByVal IncludeDeleted As Boolean) As IDataReader
  Public MustOverride Function AddProjects(ByVal accountId As Integer, ByVal budget As Decimal, ByVal deleted As Boolean, ByVal description As String, ByVal projectName As String, ByVal projectType As String) As Integer
  Public MustOverride Sub UpdateProjects(ByVal projectId As Integer, ByVal accountId As Integer, ByVal budget As Decimal, ByVal deleted As Boolean, ByVal description As String, ByVal projectName As String, ByVal projectType As String)
  Public MustOverride Sub DeleteProjects(ByVal projectId As Integer)
#End Region


#Region "Tasks Methods"
  Public MustOverride Function GetTasks(ByVal taskId As Integer) As IDataReader
  Public MustOverride Function GetTasksByInvoices(ByVal invoiceId As Integer, ByVal IncludeDeleted As Boolean) As IDataReader
  Public MustOverride Function GetTasksByProjects(ByVal projectId As Integer, ByVal IncludeDeleted As Boolean) As IDataReader
  Public MustOverride Function GetTasksByAccounts(ByVal accountId As Integer, ByVal IncludeDeleted As Boolean) As IDataReader
  Public MustOverride Function GetTasksByPortal(ByVal PortalId As Integer, ByVal IncludeDeleted As Boolean) As IDataReader
  Public MustOverride Function GetTasksByUser(ByVal UserId As Integer, ByVal IncludeDeleted As Boolean) As IDataReader
  Public MustOverride Function AddTasks(ByVal comments As String, ByVal deleted As Boolean, ByVal description As String, ByVal employeeId As Integer, ByVal invoiceId As Integer, ByVal projectId As Integer, ByVal tariff As Decimal, ByVal taskDate As Date, ByVal taskHeading As String, ByVal taskTime As Decimal, ByVal taskTimeBilled As Decimal) As Integer
  Public MustOverride Sub UpdateTasks(ByVal taskId As Integer, ByVal comments As String, ByVal deleted As Boolean, ByVal description As String, ByVal employeeId As Integer, ByVal invoiceId As Integer, ByVal projectId As Integer, ByVal tariff As Decimal, ByVal taskDate As Date, ByVal taskHeading As String, ByVal taskTime As Decimal, ByVal taskTimeBilled As Decimal)
  Public MustOverride Sub DeleteTasks(ByVal taskId As Integer)
#End Region

#Region "Documents Methods"
        'Module enhancement (document functionalities) added 8/2006
        Public MustOverride Function AddDocument(ByVal AccountId As Integer, ByVal ModuleId As Integer, ByVal Title As String, ByVal URL As String, ByVal UserName As String, ByVal Category As String) As Integer
        Public MustOverride Sub DeleteDocument(ByVal ItemID As Integer)
        Public MustOverride Function GetDocument(ByVal ItemId As Integer, ByVal ModuleId As Integer) As IDataReader
        Public MustOverride Function GetDocuments(ByVal AccountId As Integer, ByVal ModuleId As Integer) As IDataReader
        Public MustOverride Sub UpdateDocument(ByVal ItemId As Integer, ByVal Title As String, ByVal URL As String, ByVal UserName As String, ByVal Category As String)

#End Region


#Region "Other Procedures"
        Public MustOverride Function GetProjectsByClient(ByVal ClientUserID As Integer) As IDataReader
        Public MustOverride Function GetAccountsByClient(ByVal ClientUserID As Integer) As IDataReader
        Public MustOverride Function GetTopIssues(ByVal PortalID As Integer) As IDataReader
        Public MustOverride Function GetUnpaidInvoices(ByVal PortalID As Integer) As IDataReader
#End Region

    End Class

End Namespace

