Imports DotNetNuke.Entities.Modules

Namespace Bring2mind.DNN.Modules.IWork

 Public Class ModuleSettings

  Private _ClientRole As Integer = -1
  Private _UserRole As Integer = -1
  Private _AdminRole As Integer = -1
  Private _NrRowsAccounts As Integer = -1
  Private _NrRowsInvoices As Integer = -1
  Private _NrRowsServices As Integer = -1
  Private _NrRowsProducts As Integer = -1
  Private _NrRowsIssues1 As Integer = -1
  Private _NrRowsIssues2 As Integer = -1
  Private _moduleId As Integer

  Friend Sub New(ByVal ModuleId As Integer)

   _moduleId = ModuleId
   Dim mc As New ModuleController
   Dim ms As Hashtable = mc.GetModuleSettings(_moduleId)

   If Not ms.Item("ClientRole") Is Nothing Then
    ClientRole = CType(ms.Item("ClientRole"), Integer)
   End If

   If Not ms.Item("UserRole") Is Nothing Then
    UserRole = CType(ms.Item("UserRole"), Integer)
   End If

   If Not ms.Item("AdminRole") Is Nothing Then
    AdminRole = CType(ms.Item("AdminRole"), Integer)
   End If

   If Not ms.Item("NrRowsAccounts") Is Nothing Then
    NrRowsAccounts = CType(ms.Item("NrRowsAccounts"), Integer)
   End If

   If Not ms.Item("NrRowsInvoices") Is Nothing Then
    NrRowsInvoices = CType(ms.Item("NrRowsInvoices"), Integer)
   End If

   If Not ms.Item("NrRowsServices") Is Nothing Then
    NrRowsServices = CType(ms.Item("NrRowsServices"), Integer)
   End If

   If Not ms.Item("NrRowsProducts") Is Nothing Then
    NrRowsProducts = CType(ms.Item("NrRowsProducts"), Integer)
   End If

   If Not ms.Item("NrRowsIssues1") Is Nothing Then
    NrRowsIssues1 = CType(ms.Item("NrRowsIssues1"), Integer)
   End If

   If Not ms.Item("NrRowsIssues2") Is Nothing Then
    NrRowsIssues2 = CType(ms.Item("NrRowsIssues2"), Integer)
   End If

  End Sub

  Friend Sub SaveSettings()

   Dim objModules As New DotNetNuke.Entities.Modules.ModuleController
   objModules.UpdateModuleSetting(_moduleId, "ClientRole", Me.ClientRole.ToString)
   objModules.UpdateModuleSetting(_moduleId, "UserRole", Me.UserRole.ToString)
   objModules.UpdateModuleSetting(_moduleId, "AdminRole", Me.AdminRole.ToString)
   objModules.UpdateModuleSetting(_moduleId, "NrRowsAccounts", Me.NrRowsAccounts.ToString)
   objModules.UpdateModuleSetting(_moduleId, "NrRowsInvoices", Me.NrRowsInvoices.ToString)
   objModules.UpdateModuleSetting(_moduleId, "NrRowsServices", Me.NrRowsServices.ToString)
   objModules.UpdateModuleSetting(_moduleId, "NrRowsProducts", Me.NrRowsProducts.ToString)
   objModules.UpdateModuleSetting(_moduleId, "NrRowsIssues1", Me.NrRowsIssues1.ToString)
   objModules.UpdateModuleSetting(_moduleId, "NrRowsIssues2", Me.NrRowsIssues2.ToString)

  End Sub

#Region "Properties"

  Friend Property ClientRole() As Integer
   Get
    Return _ClientRole
   End Get
   Set(ByVal Value As Integer)
    _ClientRole = Value
   End Set
  End Property

  Friend Property UserRole() As Integer
   Get
    Return _UserRole
   End Get
   Set(ByVal Value As Integer)
    _UserRole = Value
   End Set
  End Property

  Friend Property AdminRole() As Integer
   Get
    Return _AdminRole
   End Get
   Set(ByVal Value As Integer)
    _AdminRole = Value
   End Set
  End Property

  Friend Property NrRowsAccounts() As Integer
   Get
    Return _NrRowsAccounts
   End Get
   Set(ByVal Value As Integer)
    _NrRowsAccounts = Value
   End Set
  End Property

  Friend Property NrRowsInvoices() As Integer
   Get
    Return _NrRowsInvoices
   End Get
   Set(ByVal Value As Integer)
    _NrRowsInvoices = Value
   End Set
  End Property

  Friend Property NrRowsServices() As Integer
   Get
    Return _NrRowsServices
   End Get
   Set(ByVal Value As Integer)
    _NrRowsServices = Value
   End Set
  End Property

  Friend Property NrRowsProducts() As Integer
   Get
    Return _NrRowsProducts
   End Get
   Set(ByVal Value As Integer)
    _NrRowsProducts = Value
   End Set
  End Property

  Friend Property NrRowsIssues1() As Integer
   Get
    Return _NrRowsIssues1
   End Get
   Set(ByVal Value As Integer)
    _NrRowsIssues1 = Value
   End Set
  End Property

  Friend Property NrRowsIssues2() As Integer
   Get
    Return _NrRowsIssues2
   End Get
   Set(ByVal Value As Integer)
    _NrRowsIssues2 = Value
   End Set
  End Property

#End Region

 End Class
End Namespace