<%@ Page Language="vb" AutoEventWireup="false" Codebehind="InvoiceXML.aspx.vb" Inherits="Bring2mind.DNN.Modules.IWork.InvoiceXML" contentType="text/xml"%><?xml version="1.0" encoding="UTF-8" ?>
<invoice>
 <asp:repeater id="rpInvoice" runat="server">
  <ItemTemplate>
   <code><%# MyEncode(DataBinder.Eval(Container.DataItem,"InvoiceCode")) %></code>
   <reference><%# MyEncode(DataBinder.Eval(Container.DataItem,"Reference")) %></reference>
   <subject><%# MyEncode(DataBinder.Eval(Container.DataItem,"Subject")) %></subject>
   <currency><%# MyEncode(DataBinder.Eval(Container.DataItem,"Currency")) %></currency>
   <taxrate><%# CType(DataBinder.Eval(Container.DataItem,"VAT"), Decimal).ToString("0.0") %></taxrate>
   <tax><%# CType(DataBinder.Eval(Container.DataItem,"Total") - DataBinder.Eval(Container.DataItem,"Subtotal"), Decimal).ToString("0.00") %></tax>
   <subtotal><%# CType(DataBinder.Eval(Container.DataItem,"Subtotal"), Decimal).ToString("0.00") %></subtotal>
   <total><%# CType(DataBinder.Eval(Container.DataItem,"total"), Decimal).ToString("0.00") %></total>
   <status>
    <sent><%# IIF(Bring2mind.DNN.Modules.IWork.IWorkGlobals.GetABoolean(DataBinder.Eval(Container.DataItem,"Sent")), "true", "false") %></sent>
    <datesent><%# IIF(Bring2mind.DNN.Modules.IWork.IWorkGlobals.GetABoolean(DataBinder.Eval(Container.DataItem,"Sent")), GetXMLDate(Bring2mind.DNN.Modules.IWork.IWorkGlobals.GetADate(DataBinder.Eval(Container.DataItem,"DateSent"))), "") %></datesent>
    <paid><%# IIF(Bring2mind.DNN.Modules.IWork.IWorkGlobals.GetABoolean(DataBinder.Eval(Container.DataItem,"Paid")), "true", "false") %></paid>
    <datepaid><%# IIF(Bring2mind.DNN.Modules.IWork.IWorkGlobals.GetABoolean(DataBinder.Eval(Container.DataItem,"Paid")), GetXMLDate(Bring2mind.DNN.Modules.IWork.IWorkGlobals.GetADate(DataBinder.Eval(Container.DataItem,"DatePaid"))), "") %></datepaid>
   </status>
  </ItemTemplate>
 </asp:repeater>
 <asp:repeater id="rpAccount" runat="server">
  <ItemTemplate>
   <to>
    <contact>
     <name><%# MyEncode(DataBinder.Eval(Container.DataItem,"ContactName")) %></name>
    </contact>
    <company>
     <name><%# MyEncode(DataBinder.Eval(Container.DataItem,"AccountName")) %></name>
     <address>
      <street><%# MyEncode(DataBinder.Eval(Container.DataItem,"BillingStreet")) %></street>
      <postalcode><%# MyEncode(DataBinder.Eval(Container.DataItem,"BillingPostalCode")) %></postalcode>
      <city><%# MyEncode(DataBinder.Eval(Container.DataItem,"BillingCity")) %></city>
      <country><%# MyEncode(DataBinder.Eval(Container.DataItem,"BillingCountry")) %></country>
     </address>
    </company>
   </to>
  </ItemTemplate>
 </asp:repeater>
 <goods>
  <asp:repeater id="rpProducts" runat="server">
   <ItemTemplate>
    <article>
     <quantity><%# CType(DataBinder.Eval(Container.DataItem,"Quantity"), Decimal).ToString("0.0") %></quantity>
     <description><%# MyEncode(DataBinder.Eval(Container.DataItem,"Description")) %></description>
     <project><%# MyEncode(GetProjectName(DataBinder.Eval(Container.DataItem,"ProjectId"))) %></project>
     <price><%# CType(DataBinder.Eval(Container.DataItem,"PriceSell"), Decimal).ToString("0.00") %></price>
     <total><%# CType(DataBinder.Eval(Container.DataItem,"Quantity") * DataBinder.Eval(Container.DataItem,"PriceSell"), Decimal).ToString("0.00") %></total>
     <delivered><%# GetXMLDate(DataBinder.Eval(Container.DataItem,"DateDelivered")) %></delivered>
    </article>
   </ItemTemplate>
  </asp:repeater>
 </goods>
 <services>
  <asp:repeater id="rpTasks" runat="server">
   <ItemTemplate>
    <service>
     <heading><%# MyEncode(DataBinder.Eval(Container.DataItem,"TaskHeading")) %></heading>
     <description><%# MyEncode(DataBinder.Eval(Container.DataItem,"Description")) %></description>
     <project><%# MyEncode(GetProjectName(DataBinder.Eval(Container.DataItem,"ProjectId"))) %></project>
     <date><%# GetXMLDate(DataBinder.Eval(Container.DataItem,"TaskDate")) %></date>
     <hours><%# CType(DataBinder.Eval(Container.DataItem,"TaskTimeBilled"), Decimal).ToString("0.0") %></hours>
     <tariff><%# CType(DataBinder.Eval(Container.DataItem,"Tariff"), Decimal).ToString("0.00") %></tariff>
     <total><%# CType(DataBinder.Eval(Container.DataItem,"TaskTimeBilled") * DataBinder.Eval(Container.DataItem,"Tariff"), Decimal).ToString("0.00") %></total>
     <employee><%# GetUserName(DataBinder.Eval(Container.DataItem,"EmployeeId")) %></employee>
    </service>
   </ItemTemplate>
  </asp:repeater>
 </services>
</invoice>
