'
' Copyright (c) 2004
' by Peter Donker ( info@bring2mind.net )
'
' Permission is hereby granted to use and/or modify this software. It is not permitted to publish, distribute, 
' sublicense, and/or sell copies of the software in its original or modified form.
'
' THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED 
' TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
' THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF 
' CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
' DEALINGS IN THE SOFTWARE.
'
Imports DotNetNuke
Imports Bring2mind.DNN.Modules.IWork.Business

Namespace Bring2mind.DNN.Modules.IWork

 Public Class EditAccount
  Inherits Bring2mind.DNN.Modules.IWork.PortalModulebase

#Region " Web Form Designer Generated Code "

  'This call is required by the Web Form Designer.
  <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()

  End Sub
  Protected WithEvents txtAccountName As System.Web.UI.WebControls.TextBox
  Protected WithEvents cmdUpdate As System.Web.UI.WebControls.LinkButton
  Protected WithEvents cmdCancel As System.Web.UI.WebControls.LinkButton
  Protected WithEvents cmdDelete As System.Web.UI.WebControls.LinkButton
  Protected WithEvents txtContactName As System.Web.UI.WebControls.TextBox
  Protected WithEvents txtDefaultTariff As System.Web.UI.WebControls.TextBox
  Protected WithEvents cboUser As System.Web.UI.WebControls.DropDownList
  Protected WithEvents txtContactPhone As System.Web.UI.WebControls.TextBox
  Protected WithEvents txtContactMobile As System.Web.UI.WebControls.TextBox
  Protected WithEvents txtContactEmail As System.Web.UI.WebControls.TextBox
  Protected WithEvents cboBilledThrough As System.Web.UI.WebControls.DropDownList
  Protected WithEvents Address1 As DotNetNuke.UI.UserControls.Address
  Protected WithEvents RequiredFieldValidator1 As System.Web.UI.WebControls.RequiredFieldValidator
  Protected WithEvents pnlBillingAddress As System.Web.UI.WebControls.Panel
  Protected WithEvents txtDefaultCurrency As System.Web.UI.WebControls.TextBox
  Protected WithEvents CompareValidator1 As System.Web.UI.WebControls.CompareValidator

  'NOTE: The following placeholder declaration is required by the Web Form Designer.
  'Do not delete or move it.
  Private designerPlaceholderDeclaration As System.Object

  Private Sub Page_Init(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Init
   'CODEGEN: This method call is required by the Web Form Designer
   'Do not modify it using the code editor.
   InitializeComponent()
  End Sub

#End Region

  Dim AccountId As Integer = -1

  Private Sub Page_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

   ' get parameter
   If Not (Request.Params("AccountId") Is Nothing) Then
    AccountId = Integer.Parse(Request.Params("AccountId"))
   Else
    AccountId = -1
   End If

   If Not Security.IsEmployee Then
    UI.Skins.Skin.AddModuleMessage(Me, "Unauthorized", "You are either not logged in correctly, or you do not have access to this resource. Please check your login status", UI.Skins.Controls.ModuleMessage.ModuleMessageType.YellowWarning)
    Exit Sub
   End If

   If Page.IsPostBack = False Then

    Dim uc As New DotNetNuke.Entities.Users.UserController
    Dim userslist As ArrayList = uc.GetUsers(PortalId, False)
    cboUser.DataSource = userslist
    cboUser.DataBind()
    cboUser.Items.Insert(0, New Web.UI.WebControls.ListItem("<None Specified>", "0"))
    Dim ac As New AccountsController
    Dim accountlist As ArrayList = ac.GetAccountsByPortal(PortalId, False)
    cboBilledThrough.DataSource = accountlist
    cboBilledThrough.DataBind()
    cboBilledThrough.Items.Insert(0, New Web.UI.WebControls.ListItem("<None Specified>", "0"))

    If AccountId <> -1 Then
     If Not Security.OK2View(AccountId) Then
      UI.Skins.Skin.AddModuleMessage(Me, "Unauthorized", "You are either not logged in correctly, or you do not have access to this resource. Please check your login status", UI.Skins.Controls.ModuleMessage.ModuleMessageType.YellowWarning)
      Exit Sub
     End If

     Dim objAccounts As New AccountsController
     Dim objAccount As AccountsInfo = objAccounts.GetAccounts(AccountId, PortalId)
     If Not objAccount Is Nothing Then
      txtAccountName.Text = objAccount.AccountName
      txtContactName.Text = objAccount.ContactName
      txtContactPhone.Text = objAccount.ContactPhone
      txtContactMobile.Text = objAccount.ContactMobile
      txtContactEmail.Text = objAccount.ContactEmail
      txtDefaultTariff.Text = objAccount.DefaultTariff.ToString("0.00")
      txtDefaultCurrency.Text = objAccount.DefaultCurrency
      If IsNumeric(objAccount.UserId) Then
       cboUser.Items.FindByValue(objAccount.UserId).Selected = True
      End If
      If IsNumeric(objAccount.BilledThrough) Then
       cboBilledThrough.Items.FindByValue(objAccount.BilledThrough).Selected = True
       If objAccount.BilledThrough > 0 Then
        Address1.Visible = False
       End If
      End If
      With Address1
       .ModuleId = ModuleId
       .Street = objAccount.BillingStreet
       .Postal = objAccount.BillingPostalCode
       .City = objAccount.BillingCity
       .Country = objAccount.BillingCountry
       .ShowTelephone = False
       .ShowUnit = False
       '.ShowRegion = False
       .StartTabIndex = 8
      End With
      If Security.IsAdmin Then
       cmdDelete.Visible = True
       If objAccount.Deleted Then
        cmdDelete.Text = "Undelete"
        cmdDelete.Attributes.Add("onClick", "javascript:return confirm('Are You Sure You Wish To Undelete This Item ?');")
       Else
        cmdDelete.Attributes.Add("onClick", "javascript:return confirm('Are You Sure You Wish To Delete This Item ?');")
       End If
      End If

     Else ' security violation attempt to access item not related to this Module

      UI.Skins.Skin.AddModuleMessage(Me, "Unauthorized", "You are either not logged in correctly, or you do not have access to this resource. Please check your login status", UI.Skins.Controls.ModuleMessage.ModuleMessageType.YellowWarning)
      Exit Sub

     End If

    Else ' new item

     cmdDelete.Visible = False
     txtDefaultTariff.Text = "35"

    End If

   End If

  End Sub

  Private Sub cmdUpdate_Click(ByVal sender As Object, ByVal e As EventArgs) Handles cmdUpdate.Click
   Try
    ' Only Update if the Entered Data is Valid

    If Page.IsValid = True Then
     Dim objAccounts As New AccountsInfo

     'objAccounts = CType(CBO.InitializeObject(objAccounts, GetType(AccountsInfo)), AccountsInfo)

     'bind text values to object
     With objAccounts
      .AccountId = AccountId
      .PortalId = PortalId
      .AccountName = txtAccountName.Text
      .ContactName = txtContactName.Text
      .ContactPhone = txtContactPhone.Text
      .ContactMobile = txtContactMobile.Text
      .ContactEmail = txtContactEmail.Text
      .Deleted = False
      .UserId = CType(cboUser.SelectedValue, Integer)
      .BilledThrough = CType(cboBilledThrough.SelectedValue, Integer)
      If cboBilledThrough.SelectedValue = "0" Then
       .BillingCity = Address1.City
       .BillingCountry = Address1.Country
       .BillingPostalCode = Address1.Postal
       .BillingStreet = Address1.Street
      End If
      If txtDefaultTariff.Text <> "" Then
       .DefaultTariff = CType(txtDefaultTariff.Text, Single)
      End If
      .DefaultCurrency = txtDefaultCurrency.Text
     End With

     Dim objCtlAccount As New AccountsController
     If AccountId = -1 Then
      AccountId = objCtlAccount.AddAccounts(objAccounts)
     Else
      objCtlAccount.UpdateAccounts(objAccounts)
     End If

     ' Redirect back to the portal home page
     Response.Redirect(EditUrl("AccountId", AccountId.ToString, "ViewAccount"), True)

    End If
   Catch exc As Exception 'Module failed to load
    DotNetNuke.Services.Exceptions.ProcessModuleLoadException(Me, exc)
   End Try
  End Sub


  Private Sub cmdCancel_Click(ByVal sender As Object, ByVal e As EventArgs) Handles cmdCancel.Click
   Try
    If AccountId = -1 Then
     Response.Redirect(DotNetNuke.Common.Globals.NavigateURL(), True)
    Else
     Response.Redirect(EditUrl("AccountId", AccountId.ToString, "ViewAccount"), True)
    End If
   Catch exc As Exception 'Module failed to load
    DotNetNuke.Services.Exceptions.ProcessModuleLoadException(Me, exc)
   End Try
  End Sub

  Private Sub cmdDelete_Click(ByVal sender As Object, ByVal e As EventArgs) Handles cmdDelete.Click
   Try
    If Not AccountId = -1 Then
     'make sure we get rid of open things
     Dim objIssues As New IssuesController
     Dim objIssue As IssuesInfo
     For Each objIssue In objIssues.GetIssuesByAccounts(AccountId)
      If Not objIssue.Resolved Then
       objIssue.Resolved = True
       objIssue.ResolvedDate = Now
       objIssues.UpdateIssues(objIssue)
      End If
     Next
     Dim objInvoices As New InvoicesController
     Dim objInvoice As InvoicesInfo
     For Each objInvoice In objInvoices.GetInvoicesByAccounts(AccountId)
      If Not objInvoice.Paid Then
       If Not objInvoice.Sent Then
        objInvoice.Sent = True
        objInvoice.DateSent = Now
       End If
       objInvoice.Paid = True
       objInvoice.DatePaid = Now
       objInvoices.UpdateInvoices(objInvoice)
      End If
     Next
     'then delete the account
     Dim objCtlAccount As New AccountsController
     Dim objAccount As AccountsInfo = objCtlAccount.GetAccounts(AccountId, PortalId)
     If objAccount.Deleted Then
      objAccount.Deleted = False
     Else
      objAccount.Deleted = True
     End If
     objCtlAccount.UpdateAccounts(objAccount)
    End If

    ' Redirect back to the portal home page
    Response.Redirect(DotNetNuke.Common.Globals.NavigateURL(), True)
   Catch exc As Exception 'Module failed to load
    DotNetNuke.Services.Exceptions.ProcessModuleLoadException(Me, exc)
   End Try
  End Sub

  Private Sub cboBilledThrough_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cboBilledThrough.SelectedIndexChanged
   If cboBilledThrough.SelectedValue = "0" Or cboBilledThrough.SelectedValue = AccountId.ToString Then
    pnlBillingAddress.Visible = True
   Else
    pnlBillingAddress.Visible = False
   End If
  End Sub
 End Class

End Namespace
