Imports Bring2mind.DNN.Modules.IWork.Business
Imports System.IO
Imports System.Web
Imports DotNetNuke
Imports DotNetNuke.Services.Exceptions
Imports DotNetNuke.Services.Localization
Imports DotNetNuke.Common
Imports DotNetNuke.Common.Utilities

Namespace Bring2mind.DNN.Modules.IWork

    'Module enhancement (document functionalities) added 8/2006
    'based on the EditDocument control from the core
    Public Class EditDocument
        Inherits Bring2mind.DNN.Modules.IWork.PortalModuleBase

#Region "Controls"

        Protected WithEvents plName As DotNetNuke.UI.UserControls.LabelControl
        Protected WithEvents txtName As System.Web.UI.WebControls.TextBox
        Protected WithEvents valName As System.Web.UI.WebControls.RequiredFieldValidator
        Protected WithEvents plUrl As DotNetNuke.UI.UserControls.LabelControl
        Protected WithEvents ctlUrl As DotNetNuke.UI.UserControls.UrlControl
        Protected WithEvents plCategory As DotNetNuke.UI.UserControls.LabelControl
        Protected WithEvents txtCategory As System.Web.UI.WebControls.TextBox

        'tasks
        Protected WithEvents cmdUpdate As System.Web.UI.WebControls.LinkButton
        Protected WithEvents cmdCancel As System.Web.UI.WebControls.LinkButton
        Protected WithEvents cmdDelete As System.Web.UI.WebControls.LinkButton

        'footer
        Protected WithEvents ctlAudit As DotNetNuke.UI.UserControls.ModuleAuditControl
        Protected WithEvents ctlTracking As DotNetNuke.UI.UserControls.URLTrackingControl

#End Region

#Region "Private Members"

        Private itemId As Integer
        Private accountId As Integer

#End Region

#Region "Event Handlers"

        Private Sub Page_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

            Try

                Dim objModules As New Entities.Modules.ModuleController

                ' Determine ItemId of Document to Update
                If Not (Request.QueryString("ItemId") Is Nothing) Then
                    itemId = Int32.Parse(Request.QueryString("ItemId"))
                Else
                    itemId = Convert.ToInt32(Common.Utilities.Null.NullInteger)
                End If

                ' Determine AccountId of the Document to Add
                If Not (Request.QueryString("AccountId") Is Nothing) Then
                    accountId = Int32.Parse(Request.QueryString("AccountId"))
                Else
                    accountId = Convert.ToInt32(Common.Utilities.Null.NullInteger)
                End If

                ' If the page is being requested the first time, determine if an
                ' document itemId value is specified, and if so populate page
                ' contents with the document details
                If Page.IsPostBack = False Then

                    If Not Security.IsEmployee Then
                        DotNetNuke.UI.Skins.Skin.AddModuleMessage(Me, "Unauthorized", "You are either not logged in correctly, or you do not have access to this resource. Please check your login status", DotNetNuke.UI.Skins.Controls.ModuleMessage.ModuleMessageType.YellowWarning)
                        Exit Sub
                    End If

                    cmdDelete.Attributes.Add("onClick", "javascript:return confirm('" & Localization.GetString("DeleteItem") & "');")

                    If Not Common.Utilities.Null.IsNull(itemId) Then

                        ' Obtain a single row of document information
                        Dim objDocuments As New DocumentController
                        Dim objDocument As DocumentInfo = objDocuments.GetDocument(itemId, ModuleId)



                        ' Load first row into Datareader
                        If Not objDocument Is Nothing Then

                            accountId = objDocument.AccountId

                            txtName.Text = objDocument.Title
                            ctlUrl.Url = objDocument.Url
                            txtCategory.Text = objDocument.Category

                            ctlAudit.CreatedByUser = objDocument.CreatedByUser
                            ctlAudit.CreatedDate = objDocument.CreatedDate.ToString

                            ctlTracking.URL = objDocument.Url
                            ctlTracking.ModuleID = ModuleId



                        Else       ' security violation attempt to access item not related to this Module
                            Response.Redirect(NavigateURL(), True)
                        End If
                    Else
                        cmdDelete.Visible = False
                        ctlAudit.Visible = False
                        ctlTracking.Visible = False
                    End If
                Else
                    If Not Common.Utilities.Null.IsNull(itemId) Then
                        Dim objDocuments As New DocumentController
                        Dim objDocument As DocumentInfo = objDocuments.GetDocument(itemId, ModuleId)
                        accountId = objDocument.AccountId

                    End If
                End If
            Catch exc As Exception    'Module failed to load
                ProcessModuleLoadException(Me, exc)
            End Try

        End Sub

        Private Sub cmdUpdate_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles cmdUpdate.Click
            If Not Security.IsEmployee Then
                DotNetNuke.UI.Skins.Skin.AddModuleMessage(Me, "Unauthorized", "You are either not logged in correctly, or you do not have access to this resource. Please check your login status", DotNetNuke.UI.Skins.Controls.ModuleMessage.ModuleMessageType.YellowWarning)
                Exit Sub
            End If

            Try
                Dim strDocument As String

                ' Only Update if Input Data is Valid
                If Page.IsValid = True Then

                    Dim objDocument As New DocumentInfo
                    objDocument.ItemId = itemId
                    objDocument.ModuleId = ModuleId
                    objDocument.Title = txtName.Text
                    objDocument.Url = ctlUrl.Url
                    objDocument.Category = txtCategory.Text
                    objDocument.CreatedByUser = UserInfo.UserID.ToString

                    ' Create an instance of the Document DB component
                    Dim objDocuments As New DocumentController

                    If Common.Utilities.Null.IsNull(itemId) Then
                        objDocument.AccountId = accountId
                        objDocuments.AddDocument(objDocument)
                    Else
                        objDocuments.UpdateDocument(objDocument)
                    End If

                    ' url tracking
                    Dim objUrls As New UrlController
                    objUrls.UpdateUrl(PortalId, ctlUrl.Url, ctlUrl.UrlType, ctlUrl.Log, ctlUrl.Track, ModuleId, ctlUrl.NewWindow)

                    ' Redirect back to the documents list for the selected account
                    Response.Redirect(EditUrl("AccountId", accountId.ToString, "ListDocuments"), True)

                End If
            Catch exc As Exception    'Module failed to load
                ProcessModuleLoadException(Me, exc)
            End Try
        End Sub

        Private Sub cmdCancel_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles cmdCancel.Click
            Try
                ' Redirect back to the documents list for the selected account
                Response.Redirect(EditUrl("AccountId", accountId.ToString, "ListDocuments"), True)
            Catch exc As Exception    'Module failed to load
                ProcessModuleLoadException(Me, exc)
            End Try
        End Sub
        Private Sub cmdDelete_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles cmdDelete.Click
            If Not Security.IsEmployee Then
                DotNetNuke.UI.Skins.Skin.AddModuleMessage(Me, "Unauthorized", "You are either not logged in correctly, or you do not have access to this resource. Please check your login status", DotNetNuke.UI.Skins.Controls.ModuleMessage.ModuleMessageType.YellowWarning)
                Exit Sub
            End If
            Try
                If Not Common.Utilities.Null.IsNull(itemId) Then

                    Dim objdocuments As New DocumentController
                    objdocuments.DeleteDocument(itemId)

                End If
                ' Redirect back to the documents list for the selected account
                Response.Redirect(EditUrl("AccountId", accountId.ToString, "ListDocuments"), True)
            Catch exc As Exception    'Module failed to load
                ProcessModuleLoadException(Me, exc)
            End Try
        End Sub

#End Region

#Region " Code gnr par le Concepteur Web Form "

        <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()

        End Sub

        Private designerPlaceholderDeclaration As System.Object

        Private Sub Page_Init(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Init
            InitializeComponent()
        End Sub

#End Region





    End Class

End Namespace
