'
' Copyright (c) 2004
' by Peter Donker ( info@bring2mind.net )
'
' Permission is hereby granted to use and/or modify this software. It is not permitted to publish, distribute, 
' sublicense, and/or sell copies of the software in its original or modified form.
'
' THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED 
' TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
' THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF 
' CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
' DEALINGS IN THE SOFTWARE.
'
Imports DotNetNuke
Imports Bring2mind.DNN.Modules.IWork.Business
Imports System.Web.UI.HtmlControls
Imports System.io
Imports System.Xml

Namespace Bring2mind.DNN.Modules.IWork
 Public Class InvoiceXML
  Inherits System.Web.UI.Page

#Region " Web Form Designer Generated Code "

  'This call is required by the Web Form Designer.
  <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()

  End Sub
  Protected WithEvents rpProducts As System.Web.UI.WebControls.Repeater
  Protected WithEvents rpTasks As System.Web.UI.WebControls.Repeater
  Protected WithEvents rpInvoice As System.Web.UI.WebControls.Repeater
  Protected WithEvents rpAccount As System.Web.UI.WebControls.Repeater

  'NOTE: The following placeholder declaration is required by the Web Form Designer.
  'Do not delete or move it.
  Private designerPlaceholderDeclaration As System.Object

  Private Sub Page_Init(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Init
   'CODEGEN: This method call is required by the Web Form Designer
   'Do not modify it using the code editor.
   InitializeComponent()
  End Sub

#End Region

  Dim dvProjects As DataView
  Dim PortalId As Integer = -1

  'Dim dvEmployees As DataView

  Private Sub Page_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
   Dim InvoiceId As Integer = -1
   Dim ModuleId As Integer = -1

   'Dim ps As DotNetNuke.Entities.Portals.PortalSettings = CType(HttpContext.Current.Items("PortalSettings"), DotNetNuke.Entities.Portals.PortalSettings)

   HttpContext.Current.Response.ContentType = "text/xml"
   HttpContext.Current.Response.ContentEncoding = System.Text.Encoding.UTF8

   If Not (Request.QueryString("InvoiceId") Is Nothing) Then
    InvoiceId = Int32.Parse(Request.QueryString("InvoiceId"))
   Else
    Exit Sub
   End If
   If Not (Request.QueryString("PortalId") Is Nothing) Then
    PortalId = Int32.Parse(Request.QueryString("PortalId"))
   Else
    Exit Sub
   End If
   If Not (Request.QueryString("ModuleId") Is Nothing) Then
    ModuleId = Int32.Parse(Request.QueryString("ModuleId"))
   Else
    Exit Sub
   End If

   Dim UserName As String = HttpContext.Current.User.Identity.Name
   Dim uc As New DotNetNuke.Entities.Users.UserController
   Dim User As DotNetNuke.Entities.Users.UserInfo = uc.GetUserByUsername(PortalId, UserName)
   Dim mc As New DotNetNuke.Entities.Modules.ModuleController
   Dim ms As Hashtable = mc.GetModuleSettings(ModuleId)
   Dim AdminRole As Integer = CType(ms.Item("AdminRole"), Integer)
   Dim urc As New DotNetNuke.Security.Roles.RoleController
   Dim ur As DotNetNuke.Entities.Users.UserRoleInfo = urc.GetUserRole(PortalId, User.UserID, AdminRole)
   If ur Is Nothing Then Exit Sub

   Dim objInvoices As New InvoicesController
   Dim objInvoice As InvoicesInfo = objInvoices.GetInvoices(InvoiceId)
   If objInvoice Is Nothing Then
    Exit Sub
   End If
   Dim AccountId As Integer = objInvoice.AccountId

   dvProjects = New DataView(DotNetNuke.Common.Globals.ConvertDataReaderToDataTable(Bring2mind.DNN.Modules.IWork.Data.DataProvider.Instance().GetProjectsByAccounts(AccountId, True)))
   dvProjects.Sort = "ProjectId"

   'dvEmployees = New DataView(DotNetNuke.Common.Globals.ConvertDataReaderToDataTable(DotNetNuke.Data.DataProvider.Instance.GetUsers(PortalId)))
   'dvEmployees.Sort = "UserId"

   rpInvoice.DataSource = New InvoicesInfo() {objInvoice}
   rpInvoice.DataBind()

   Dim objProducts As New ProductsController
   Dim dv As New DataView(DotNetNuke.Common.Globals.ConvertDataReaderToDataTable(Bring2mind.DNN.Modules.IWork.Data.DataProvider.Instance().GetProductsByInvoices(InvoiceId, True)))
   dv.Sort = "DateDelivered"
   rpProducts.DataSource = dv
   rpProducts.DataBind()
   Dim objTasks As New TasksController
   dv = New DataView(DotNetNuke.Common.Globals.ConvertDataReaderToDataTable(Bring2mind.DNN.Modules.IWork.Data.DataProvider.Instance().GetTasksByInvoices(InvoiceId, True)))
   dv.Sort = "TaskDate"
   rpTasks.DataSource = dv
   rpTasks.DataBind()

   Dim objAccounts As New AccountsController
   Dim objAccount As AccountsInfo = objAccounts.GetAccounts(AccountId, PortalId)
   Do While objAccount.BilledThrough > 0
    objAccount = objAccounts.GetAccounts(objAccount.BilledThrough, PortalId)
   Loop

   rpAccount.DataSource = New AccountsInfo() {objAccount}
   rpAccount.DataBind()

  End Sub

  Public Function GetXMLDate(ByVal xDate As Date) As String
   Return Year(xDate) & "-" & Month(xDate).ToString("00") & "-" & Day(xDate).ToString("00")
  End Function

  Public Function MyEncode(ByVal StringToEncode) As String
   If StringToEncode Is Nothing Then
    Return ""
   ElseIf StringToEncode Is DBNull.Value Then
    Return ""
   Else
    Return Me.Server.HtmlEncode(StringToEncode)
   End If
  End Function

  Public Function GetProjectName(ByVal ProjectId As Integer) As String
   Return dvProjects(dvProjects.Find(ProjectId)).Item("ProjectName")
  End Function

  Public Function GetUserName(ByVal UserId As Integer) As String
   Try
    Return DotNetNuke.Entities.Users.UserController.GetUser(PortalId, UserId, False).DisplayName
   Catch ex As Exception
    Return ""
   End Try
  End Function
 End Class
End Namespace
