'
' Copyright (c) 2004
' by Peter Donker ( info@bring2mind.net )
'
' Permission is hereby granted to use and/or modify this software. It is not permitted to publish, distribute, 
' sublicense, and/or sell copies of the software in its original or modified form.
'
' THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED 
' TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
' THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF 
' CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
' DEALINGS IN THE SOFTWARE.
'
Imports DotNetNuke
Imports DotNetNuke.Services.Localization.Localization
Imports Bring2mind.DNN.Modules.IWork.Business

Namespace Bring2mind.DNN.Modules.IWork

 Public Class Overview
  Inherits Bring2mind.DNN.Modules.IWork.PortalModuleBase
  Implements DotNetNuke.Entities.Modules.IActionable

#Region " Web Form Designer Generated Code "

  'This call is required by the Web Form Designer.
  <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()

  End Sub
  Protected WithEvents dgAccounts As System.Web.UI.WebControls.DataGrid
  Protected WithEvents dgIssues As System.Web.UI.WebControls.DataGrid
  Protected WithEvents dgInvoices As System.Web.UI.WebControls.DataGrid
  Protected WithEvents pnlAccounts As System.Web.UI.WebControls.Panel
  Protected WithEvents pnlInvoices As System.Web.UI.WebControls.Panel
  Protected WithEvents pnlTodo As System.Web.UI.WebControls.Panel

  'NOTE: The following placeholder declaration is required by the Web Form Designer.
  'Do not delete or move it.
  Private designerPlaceholderDeclaration As System.Object

  Private Sub Page_Init(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Init
   'CODEGEN: This method call is required by the Web Form Designer
   'Do not modify it using the code editor.
   InitializeComponent()

  End Sub

#End Region

#Region " Optional Interfaces "
  Public ReadOnly Property ModuleActions() As DotNetNuke.Entities.Modules.Actions.ModuleActionCollection Implements DotNetNuke.Entities.Modules.IActionable.ModuleActions
   Get

    Dim Actions As New DotNetNuke.Entities.Modules.Actions.ModuleActionCollection
    Actions.Add(GetNextActionID, GetString(Entities.Modules.Actions.ModuleActionType.AddContent, LocalResourceFile), DotNetNuke.Entities.Modules.Actions.ModuleActionType.AddContent, "", "", EditUrl("PortalId", PortalId.ToString, "EditAccount"), False, DotNetNuke.Security.SecurityAccessLevel.Edit, True, False)
    Return Actions

   End Get
  End Property
#End Region

#Region " Page Events "
  Private Sub Page_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
   If UserInfo.UserID < 0 Then
    'DotNetNuke.Services.Exceptions.ProcessModuleLoadException("IWork Error", Me, New System.Exception("Not Logged In"), True)
    UI.Skins.Skin.AddModuleMessage(Me, "Unauthorized", "You are either not logged in correctly, or you do not have access to this resource. Please check your login status", UI.Skins.Controls.ModuleMessage.ModuleMessageType.YellowWarning)
    Exit Sub
   End If

   If Not Page.IsPostBack Then
    If Security.IsEmployee Then
     pnlTodo.Visible = True
     pnlAccounts.Visible = True
     Dim dv As New DataView(DotNetNuke.Common.Globals.ConvertDataReaderToDataTable(Bring2mind.DNN.Modules.IWork.Data.DataProvider.Instance().GetAccountsByPortal(PortalId, False)))
     dv.Sort = "AccountName"
     With dgAccounts
      .DataSource = dv
      .DataBind()
     End With
     Dim dvi As New DataView(DotNetNuke.Common.Globals.ConvertDataReaderToDataTable(Bring2mind.DNN.Modules.IWork.Data.DataProvider.Instance().GetTopIssues(PortalId)))
     With dgIssues
      .DataSource = dvi
      .DataBind()
     End With
     If Security.IsAdmin Then
      pnlInvoices.Visible = True
      Dim dvin As New DataView(DotNetNuke.Common.Globals.ConvertDataReaderToDataTable(Bring2mind.DNN.Modules.IWork.Data.DataProvider.Instance().GetUnpaidInvoices(PortalId)))
      With dgInvoices
       .DataSource = dvin
       .DataBind()
      End With
     End If
    Else
     pnlAccounts.Visible = True
     Dim dv As New DataView(DotNetNuke.Common.Globals.ConvertDataReaderToDataTable(Bring2mind.DNN.Modules.IWork.Data.DataProvider.Instance().GetAccountsByClient(UserInfo.UserID)))
     dv.Sort = "AccountName"
     With dgAccounts
      .DataSource = dv
      .DataBind()
     End With
    End If

   End If

  End Sub
#End Region


 End Class

End Namespace
