'
' Copyright (c) 2004
' by Peter Donker ( info@bring2mind.net )
'
' Permission is hereby granted to use and/or modify this software. It is not permitted to publish, distribute, 
' sublicense, and/or sell copies of the software in its original or modified form.
'
' THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED 
' TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
' THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF 
' CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
' DEALINGS IN THE SOFTWARE.
'
Imports DotNetNuke
Imports Bring2mind.DNN.Modules.IWork.Business
Imports DotNetNuke.Services.Localization
Imports DotNetNuke.Services.Exceptions


Namespace Bring2mind.DNN.Modules.IWork

 Public Class ViewAccount
  Inherits Bring2mind.DNN.Modules.IWork.PortalModuleBase

#Region " Web Form Designer Generated Code "

  'This call is required by the Web Form Designer.
  <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()

  End Sub
  Protected WithEvents hlProjects As System.Web.UI.WebControls.HyperLink
  Protected WithEvents dgProjects As System.Web.UI.WebControls.DataGrid
  Protected WithEvents hlInvoices As System.Web.UI.WebControls.HyperLink
  Protected WithEvents dgInvoices As System.Web.UI.WebControls.DataGrid
  Protected WithEvents hlIssues As System.Web.UI.WebControls.HyperLink
  Protected WithEvents dgIssues As System.Web.UI.WebControls.DataGrid
  Protected WithEvents dgDocuments As System.Web.UI.WebControls.DataGrid
  Protected WithEvents hlEdit As System.Web.UI.WebControls.HyperLink
  Protected WithEvents hlBack As System.Web.UI.WebControls.HyperLink
  Protected WithEvents pnlAccount As System.Web.UI.WebControls.Panel
  Protected WithEvents pnlProjects As System.Web.UI.WebControls.Panel
  Protected WithEvents pnlInvoices As System.Web.UI.WebControls.Panel
  Protected WithEvents pnlIssues As System.Web.UI.WebControls.Panel
  Protected WithEvents pnlDocuments As System.Web.UI.WebControls.Panel
  Protected WithEvents hlAddProject As System.Web.UI.WebControls.HyperLink
  Protected WithEvents hlAddInvoice As System.Web.UI.WebControls.HyperLink
  Protected WithEvents lblAccountName As System.Web.UI.WebControls.Label
  Protected WithEvents lblContactName As System.Web.UI.WebControls.Label
  Protected WithEvents lblPhone As System.Web.UI.WebControls.Label
  Protected WithEvents lblMobile As System.Web.UI.WebControls.Label
  Protected WithEvents lblEmail As System.Web.UI.WebControls.Label
  Protected WithEvents lblTariff As System.Web.UI.WebControls.Label
  Protected WithEvents lblBilling As System.Web.UI.WebControls.Label
  Protected WithEvents lblAddress As System.Web.UI.WebControls.Label
  Protected WithEvents lblCurrency As System.Web.UI.WebControls.Label
  Protected WithEvents hlDocuments As System.Web.UI.WebControls.HyperLink
  Protected WithEvents hlAddDocument As System.Web.UI.WebControls.HyperLink
  Protected WithEvents docLink As System.Web.UI.WebControls.HyperLink

  'NOTE: The following placeholder declaration is required by the Web Form Designer.
  'Do not delete or move it.
  Private designerPlaceholderDeclaration As System.Object

  Private Sub Page_Init(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Init
   'CODEGEN: This method call is required by the Web Form Designer
   'Do not modify it using the code editor.
   InitializeComponent()


   'If IsEmployee(Me.Settings, Me.Context) Then
   ' MyBase.Actions.Add(GetNextActionID, "Add Project", "", URL:=EditURL("AccountId", Request.Params("AccountId"), "EditProject"), secure:=SecurityAccessLevel.Edit, Visible:=True)
   ' If IsAdmin(Me.Settings, Me.Context) Then
   '  MyBase.Actions.Add(GetNextActionID, "Add Invoice", "", URL:=EditURL("AccountId", Request.Params("AccountId"), "EditInvoice"), secure:=SecurityAccessLevel.Edit, Visible:=True)
   ' End If
   'End If
  End Sub

#End Region

  Dim AccountId As Integer = -1
  Dim Account As AccountsInfo


#Region "Public Methods"

  ''' -----------------------------------------------------------------------------
  ''' <summary>
  ''' FormatSize formats the size of a document correctly
  ''' </summary>
  ''' <remarks>
  ''' </remarks>
  ''' <param name="Size">The Size to format</param>
  ''' <returns>The formatted Size</returns>
  ''' <history>
  ''' 	[cnurse]	9/22/2004	Moved Documents to a separate Project
  ''' </history>
  ''' -----------------------------------------------------------------------------
  Function FormatSize(ByVal Size As Integer) As String
   Try
    If Not Common.Utilities.Null.IsNull(Size) Then
     FormatSize = Format(Size / 1000, "#,##0.00")
    Else
     FormatSize = Localization.GetString("Unknown")
    End If
   Catch exc As Exception    'Module failed to load
    ProcessModuleLoadException(Me, exc)
   End Try
  End Function

  ''' -----------------------------------------------------------------------------
  ''' <summary>
  ''' FormatURL formats the url of a document correctly
  ''' </summary>
  ''' <remarks>
  ''' </remarks>
  ''' <param name="Link">The Link to format</param>
  ''' <returns>The formatted Url</returns>
  ''' <history>
  ''' 	[cnurse]	9/22/2004	Moved Documents to a separate Project
  ''' </history>
  ''' -----------------------------------------------------------------------------
  Function FormatURL(ByVal Link As String, ByVal TrackClicks As Boolean) As String

   Return Common.Globals.LinkClick(Link, TabId, ModuleId, TrackClicks)

  End Function

#End Region

  Private Sub Page_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

   'first get id
   If Not (Request.Params("AccountId") Is Nothing) Then
    AccountId = Integer.Parse(Request.Params("AccountId"))
   Else
    UI.Skins.Skin.AddModuleMessage(Me, "No ID(s)", "You are trying to access a resource without supplying proper information in the URL.", UI.Skins.Controls.ModuleMessage.ModuleMessageType.YellowWarning)
    Exit Sub
   End If

   Dim objAccounts As New AccountsController
   Account = objAccounts.GetAccounts(AccountId, PortalId)
   If Account Is Nothing Then
    UI.Skins.Skin.AddModuleMessage(Me, "Unauthorized", "You do not have access to this resource. Please check your login status", UI.Skins.Controls.ModuleMessage.ModuleMessageType.YellowWarning)
    Exit Sub
   End If


   'check security (from module Global functions)
   If Not Security.OK2View(AccountId) Then
    UI.Skins.Skin.AddModuleMessage(Me, "Unauthorized", "You are either not logged in correctly, or you do not have access to this resource. Please check your login status", UI.Skins.Controls.ModuleMessage.ModuleMessageType.YellowWarning)
    Exit Sub
   End If

   If Not Page.IsPostBack Then
    hlEdit.NavigateUrl = EditUrl("AccountId", AccountId.ToString, "EditAccount")
    hlInvoices.NavigateUrl = EditUrl("AccountId", AccountId.ToString, "ListInvoices")
    'hlProjects.NavigateUrl = EditURL("AccountId", AccountId, "Invoices")
    hlIssues.NavigateUrl = EditUrl("AccountId", AccountId.ToString, "ListIssues")
    hlAddProject.NavigateUrl = EditUrl("AccountId", Request.Params("AccountId"), "EditProject")
    hlAddInvoice.NavigateUrl = EditUrl("AccountId", Request.Params("AccountId"), "EditInvoice")
    hlDocuments.Visible = (Security.IsEmployee Or Security.IsClient)
    hlDocuments.NavigateUrl = EditUrl("AccountId", Request.Params("AccountId"), "ListDocuments")
    hlAddDocument.Visible = Security.IsEmployee
    hlAddDocument.NavigateUrl = EditUrl("AccountId", Request.Params("AccountId"), "EditDocument")
    If Security.IsEmployee Then
     hlAddProject.Visible = True
     If Security.IsAdmin Then
      hlAddInvoice.Visible = True
     End If
    End If
    hlEdit.Visible = Security.IsEmployee

    hlBack.NavigateUrl = DotNetNuke.Common.Globals.NavigateURL()


    With Account
     lblAccountName.Text = .AccountName & IIf(.Deleted, " (DELETED)", "")
     lblContactName.Text = .ContactName
     lblPhone.Text = .ContactPhone
     lblMobile.Text = .ContactMobile
     lblEmail.Text = .ContactEmail
     lblTariff.Text = .DefaultTariff.ToString("0.00")
     lblCurrency.Text = .DefaultCurrency
     lblBilling.Text = IIf(.BilledThrough > 0, "indirect", "direct")
     lblAddress.Text = .BillingStreet & "<br/>" & .BillingPostalCode & "&nbsp;" & .BillingCity & "<br/>" & .BillingCountry
    End With

    Dim objInvoices As New InvoicesController
    Dim objProjects As New ProjectsController
    Dim objIssues As New IssuesController
    Dim objDocuments As New DocumentController
    dgProjects.DataSource = objProjects.GetProjectsByAccounts(AccountId, False)
    dgProjects.DataBind()
    Dim dv As New DataView(DotNetNuke.Common.Globals.ConvertDataReaderToDataTable(Bring2mind.DNN.Modules.IWork.Data.DataProvider.Instance().GetIssuesByAccounts(AccountId)))
    dv.Sort = "Resolved, IssueUrgency, IssueDate"
    If dv.Count > 10 Then
     hlIssues.Text &= " ..."
    Else
     dgIssues.DataSource = dv
     dgIssues.DataBind()
    End If
    dv = New DataView(DotNetNuke.Common.Globals.ConvertDataReaderToDataTable(Bring2mind.DNN.Modules.IWork.Data.DataProvider.Instance().GetInvoicesByAccounts(AccountId)))
    dv.Sort = "Paid, DateSent"
    If dv.Count > 10 Then
     hlInvoices.Text &= " ..."
    Else
     dgInvoices.DataSource = dv
     dgInvoices.DataBind()
    End If

    'Module enhancement (document functionalities) added 8/2006
    Dim arDocuments As New ArrayList
    arDocuments = objDocuments.GetDocuments(AccountId, ModuleId)
    If arDocuments.Count > 10 Then
     hlDocuments.Text &= " ..."
    Else
     dgDocuments.DataSource = arDocuments
     dgDocuments.DataBind()
    End If

   End If

  End Sub

 End Class

End Namespace
