'
' Copyright (c) 2004
' by Peter Donker ( info@bring2mind.net )
'
' Permission is hereby granted to use and/or modify this software. It is not permitted to publish, distribute, 
' sublicense, and/or sell copies of the software in its original or modified form.
'
' THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED 
' TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
' THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF 
' CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
' DEALINGS IN THE SOFTWARE.
'
Imports DotNetNuke
Imports Bring2mind.DNN.Modules.IWork.Business

Namespace Bring2mind.DNN.Modules.IWork

 Public Class ViewInvoice
  Inherits PortalModuleBase

#Region " Web Form Designer Generated Code "

  'This call is required by the Web Form Designer.
  <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()

  End Sub
  Protected WithEvents rpInvoice As System.Web.UI.WebControls.Repeater
  Protected WithEvents lblAddress As System.Web.UI.WebControls.Label
  Protected WithEvents dgProducts As System.Web.UI.WebControls.DataGrid
  Protected WithEvents dgTasks As System.Web.UI.WebControls.DataGrid
  Protected WithEvents txtDateSent As System.Web.UI.WebControls.Label
  Protected WithEvents txtSubject As System.Web.UI.WebControls.Label
  Protected WithEvents txtReference As System.Web.UI.WebControls.Label
  Protected WithEvents txtDatePaid As System.Web.UI.WebControls.Label
  Protected WithEvents lblHeading As System.Web.UI.WebControls.Label
  Protected WithEvents txtSubtotal As System.Web.UI.WebControls.Label
  Protected WithEvents txtTaxRate As System.Web.UI.WebControls.Label
  Protected WithEvents txtTax As System.Web.UI.WebControls.Label
  Protected WithEvents txtTotal As System.Web.UI.WebControls.Label
  Protected WithEvents hlEdit As System.Web.UI.WebControls.HyperLink
  Protected WithEvents hlExport As System.Web.UI.WebControls.HyperLink
  Protected WithEvents hlBack As System.Web.UI.WebControls.HyperLink
  Protected WithEvents pnlInvoice As System.Web.UI.WebControls.Panel
  Protected WithEvents pnlProducts As System.Web.UI.WebControls.Panel
  Protected WithEvents pnlTasks As System.Web.UI.WebControls.Panel

  'NOTE: The following placeholder declaration is required by the Web Form Designer.
  'Do not delete or move it.
  Private designerPlaceholderDeclaration As System.Object

  Private Sub Page_Init(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Init
   'CODEGEN: This method call is required by the Web Form Designer
   'Do not modify it using the code editor.
   InitializeComponent()
  End Sub

#End Region

  Dim InvoiceId As Integer = -1
  Dim AccountId As Integer = -1
  Public IsAnEmployee As Boolean

  Private Sub Page_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

   If Not (Request.Params("InvoiceId") Is Nothing) Then
    InvoiceId = Int32.Parse(Request.Params("InvoiceId"))
   Else
    UI.Skins.Skin.AddModuleMessage(Me, "No ID(s)", "You are trying to access a resource without supplying proper information in the URL.", UI.Skins.Controls.ModuleMessage.ModuleMessageType.YellowWarning)
    Exit Sub
   End If

   Dim objInvoices As New InvoicesController
   Dim objInvoice As InvoicesInfo = objInvoices.GetInvoices(InvoiceId)
   If Not Security.OK2View(objInvoice.AccountId) Then
    UI.Skins.Skin.AddModuleMessage(Me, "Unauthorized", "You are either not logged in correctly, or you do not have access to this resource. Please check your login status", UI.Skins.Controls.ModuleMessage.ModuleMessageType.YellowWarning)
    Exit Sub
   End If
   If Security.IsEmployee Then
    IsAnEmployee = True
    hlEdit.Visible = True
    hlExport.Visible = True
   Else
    IsAnEmployee = False
    hlEdit.Visible = False
    hlExport.Visible = False
   End If

   hlEdit.NavigateUrl = EditUrl("InvoiceId", InvoiceId.ToString, "EditInvoice")
   'hlExport.NavigateUrl = EditUrl("InvoiceId", InvoiceId.ToString, "ViewInvoiceXML")
   hlExport.NavigateUrl = Me.TemplateSourceDirectory & "/InvoiceXML.aspx?PortalId=" & PortalId.ToString & "&ModuleId=" & ModuleId.ToString & "&InvoiceId=" & InvoiceId.ToString
   hlBack.NavigateUrl = EditUrl("AccountId", objInvoice.AccountId.ToString, "ViewAccount")

   txtDateSent.Text = IIf(Bring2mind.DNN.Modules.IWork.IWorkGlobals.GetABoolean(objInvoice.Sent), Bring2mind.DNN.Modules.IWork.IWorkGlobals.GetADate(objInvoice.DateSent).ToString("MMM-dd"), "Not Sent")
   txtDatePaid.Text = IIf(Bring2mind.DNN.Modules.IWork.IWorkGlobals.GetABoolean(objInvoice.Paid), Bring2mind.DNN.Modules.IWork.IWorkGlobals.GetADate(objInvoice.DatePaid).ToString("MMM-dd"), "Not Paid")
   lblHeading.Text = objInvoice.InvoiceCode
   txtSubject.Text = objInvoice.Subject
   txtReference.Text = objInvoice.Reference
   txtSubtotal.Text = objInvoice.Subtotal.ToString("0.00")
   txtTotal.Text = objInvoice.Total.ToString("0.00")
   txtTaxRate.Text = objInvoice.VAT.ToString("0.0")
   txtTax.Text = (objInvoice.Total - objInvoice.Subtotal).ToString("0.00")

   Dim objAccounts As New AccountsController
   Dim objAccount As AccountsInfo = objAccounts.GetAccounts(objInvoice.AccountId, PortalId)
   If objAccount.BilledThrough > 0 Then
    objAccount = objAccounts.GetAccounts(objAccount.BilledThrough, PortalId)
   End If
   Dim sAddress As String = objAccount.AccountName & "<br/>" & objAccount.ContactName & "<br/>"
   sAddress &= objAccount.BillingStreet & "<br/>"
   sAddress &= objAccount.BillingPostalCode & "&nbsp;"
   sAddress &= objAccount.BillingCity & "<br/>"
   sAddress &= objAccount.BillingCountry
   lblAddress.Text = sAddress

   Dim dv As New DataView(DotNetNuke.Common.Globals.ConvertDataReaderToDataTable(Bring2mind.DNN.Modules.IWork.Data.DataProvider.Instance().GetProductsByInvoices(InvoiceId, True)))
   With dv
    .Sort = "DateDelivered"
   End With
   If dv.Count > 0 Then
    dgProducts.DataSource = dv
    dgProducts.DataBind()
   Else
    pnlProducts.Visible = False
   End If

   dv = New DataView(DotNetNuke.Common.Globals.ConvertDataReaderToDataTable(Bring2mind.DNN.Modules.IWork.Data.DataProvider.Instance().GetTasksByInvoices(InvoiceId, True)))
   With dv
    .Sort = "TaskDate"
   End With
   If dv.Count > 0 Then
    dgTasks.DataSource = dv
    dgTasks.DataBind()
   Else
    pnlTasks.Visible = False
   End If

  End Sub

 End Class

End Namespace
